/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNode;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.ThreadLocalObject;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;

@CoreClass(name="Binding")
public abstract class BindingNodes {

    @CoreMethod(names={"local_variables"})
    public static abstract class LocalVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public LocalVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject localVariables(RubyBinding binding) {
            RubyBasicObject array = this.createEmptyArray();
            MaterializedFrame frame = binding.getFrame();
            while (frame != null) {
                for (Object name : frame.getFrameDescriptor().getIdentifiers()) {
                    if (!(name instanceof String)) continue;
                    ArrayNodes.slowPush(array, this.getContext().getSymbol((String)name));
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            return array;
        }
    }

    @CoreMethod(names={"local_variable_set"}, required=2)
    public static abstract class LocalVariableSetNode
    extends CoreMethodArrayArgumentsNode {
        private final RubySymbol dollarUnderscore = this.getContext().getSymbol("$_");

        public LocalVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isLastLine(symbol)", "getFrameDescriptor(binding) == cachedFrameDescriptor", "symbol == cachedSymbol"})
        public Object localVariableSetCached(RubyBinding binding, RubySymbol symbol, Object value, @Cached(value="symbol") RubySymbol cachedSymbol, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor cachedFrameDescriptor, @Cached(value="createWriteNode(findFrameSlot(binding, symbol))") WriteFrameSlotNode writeLocalVariableNode) {
            return writeLocalVariableNode.executeWrite((Frame)binding.getFrame(), value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isLastLine(symbol)"})
        public Object localVariableSetUncached(RubyBinding binding, RubySymbol symbol, Object value) {
            MaterializedFrame frame = binding.getFrame();
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)symbol.toString());
            frame.setObject(frameSlot, value);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isLastLine(symbol)"})
        public Object localVariableSetLastLine(RubyBinding binding, RubySymbol symbol, Object value) {
            MaterializedFrame frame = binding.getFrame();
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)symbol.toString());
            frame.setObject(frameSlot, (Object)ThreadLocalObject.wrap(this.getContext(), value));
            return value;
        }

        protected FrameDescriptor getFrameDescriptor(RubyBinding binding) {
            return binding.getFrame().getFrameDescriptor();
        }

        protected FrameSlot findFrameSlot(RubyBinding binding, RubySymbol symbol) {
            String symbolString = symbol.toString();
            MaterializedFrame frame = binding.getFrame();
            while (frame != null) {
                FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)symbolString);
                if (frameSlot != null) {
                    return frameSlot;
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            return binding.getFrame().getFrameDescriptor().addFrameSlot((Object)symbolString);
        }

        protected WriteFrameSlotNode createWriteNode(FrameSlot frameSlot) {
            return WriteFrameSlotNodeGen.create(frameSlot);
        }

        protected boolean isLastLine(RubySymbol symbol) {
            return symbol == this.dollarUnderscore;
        }
    }

    @CoreMethod(names={"local_variable_get"}, required=1)
    public static abstract class LocalVariableGetNode
    extends CoreMethodArrayArgumentsNode {
        private final RubySymbol dollarUnderscore = this.getContext().getSymbol("$_");

        public LocalVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"symbol == cachedSymbol", "!isLastLine(cachedSymbol)", "getFrameDescriptor(binding) == cachedFrameDescriptor"})
        public Object localVariableGetCached(RubyBinding binding, RubySymbol symbol, @Cached(value="symbol") RubySymbol cachedSymbol, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor cachedFrameDescriptor, @Cached(value="findFrameSlot(binding, symbol)") FrameSlot cachedFrameSlot, @Cached(value="createReadNode(cachedFrameSlot)") ReadFrameSlotNode readLocalVariableNode) {
            if (cachedFrameSlot == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorLocalVariableNotDefined(symbol.toString(), binding, this));
            }
            return readLocalVariableNode.executeRead((Frame)binding.getFrame());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isLastLine(symbol)"})
        public Object localVariableGetUncached(RubyBinding binding, RubySymbol symbol) {
            MaterializedFrame frame = binding.getFrame();
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)symbol.toString());
            if (frameSlot == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorLocalVariableNotDefined(symbol.toString(), binding, this));
            }
            return frame.getValue(frameSlot);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isLastLine(symbol)"})
        public Object localVariableGetLastLine(RubyBinding binding, RubySymbol symbol) {
            MaterializedFrame frame = binding.getFrame();
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)symbol.toString());
            if (frameSlot == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorLocalVariableNotDefined(symbol.toString(), binding, this));
            }
            Object value = frame.getValue(frameSlot);
            if (value instanceof ThreadLocalObject) {
                return ((ThreadLocalObject)value).get();
            }
            return value;
        }

        protected FrameDescriptor getFrameDescriptor(RubyBinding binding) {
            return binding.getFrame().getFrameDescriptor();
        }

        protected FrameSlot findFrameSlot(RubyBinding binding, RubySymbol symbol) {
            String symbolString = symbol.toString();
            MaterializedFrame frame = binding.getFrame();
            while (frame != null) {
                FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)symbolString);
                if (frameSlot != null) {
                    return frameSlot;
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            return null;
        }

        protected ReadFrameSlotNode createReadNode(FrameSlot frameSlot) {
            if (frameSlot == null) {
                return null;
            }
            return ReadFrameSlotNodeGen.create(frameSlot);
        }

        protected boolean isLastLine(RubySymbol symbol) {
            return symbol == this.dollarUnderscore;
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object initializeCopy(RubyBinding self, RubyBinding from) {
            if (self == from) {
                return self;
            }
            Object[] arguments = from.getFrame().getArguments();
            InternalMethod method = RubyArguments.getMethod(arguments);
            Object boundSelf = RubyArguments.getSelf(arguments);
            RubyProc boundBlock = RubyArguments.getBlock(arguments);
            Object[] userArguments = RubyArguments.extractUserArguments(arguments);
            Object[] copiedArguments = RubyArguments.pack(method, from.getFrame(), boundSelf, boundBlock, userArguments);
            MaterializedFrame copiedFrame = Truffle.getRuntime().createMaterializedFrame(copiedArguments);
            self.initialize(from.getSelf(), copiedFrame);
            return self;
        }
    }
}

