/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.constants.LookupConstantNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.util.IdUtil;

@NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name"), @NodeChild(value="lookupConstantNode", type=LookupConstantNode.class, executeWith={"module", "name"})})
public abstract class GetConstantNode
extends RubyNode {
    public GetConstantNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract RubyNode getModule();

    public abstract LookupConstantNode getLookupConstantNode();

    public abstract Object executeGetConstant(VirtualFrame var1, Object var2, String var3);

    @Specialization(guards={"constant != null", "!constant.isAutoload()"})
    protected Object getConstant(RubyModule module, String name, RubyConstant constant) {
        return constant.getValue();
    }

    @Specialization(guards={"constant != null", "constant.isAutoload()"})
    protected Object autoloadConstant(VirtualFrame frame, RubyModule module, String name, RubyConstant constant, @Cached(value="createRequireNode()") KernelNodes.RequireNode requireNode) {
        requireNode.require((RubyString)constant.getValue());
        return this.executeGetConstant(frame, module, name);
    }

    @Specialization(guards={"constant == null"})
    protected Object missingConstant(VirtualFrame frame, RubyModule module, String name, Object constant, @Cached(value="isValidConstantName(name)") boolean isValidConstantName, @Cached(value="createConstMissingNode()") CallDispatchHeadNode constMissingNode, @Cached(value="getContext().getSymbol(name)") RubySymbol symbolName) {
        if (!isValidConstantName) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().nameError(String.format("wrong constant name %s", name), name, this));
        }
        return constMissingNode.call(frame, module, "const_missing", null, symbolName);
    }

    protected KernelNodes.RequireNode createRequireNode() {
        return KernelNodesFactory.RequireNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]);
    }

    protected boolean isValidConstantName(String name) {
        return IdUtil.isValidConstantName19((String)name);
    }

    protected CallDispatchHeadNode createConstMissingNode() {
        return DispatchHeadNodeFactory.createMethodCall(this.getContext());
    }
}

