/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.ast.AliasNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.literal.ObjectLiteralNode;
import org.jruby.truffle.nodes.methods.AliasNodeFactory;
import org.jruby.truffle.nodes.methods.CatchReturnPlaceholderNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.nodes.methods.SetMethodDeclarationContext;
import org.jruby.truffle.nodes.objects.SelfNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.TranslatorEnvironment;

class ModuleTranslator
extends BodyTranslator {
    public ModuleTranslator(Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, Source source) {
        super(currentNode, context, parent, environment, source, false);
        this.useClassVariablesAsIfInClass = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodDefinitionNode compileClassNode(SourceSection sourceSection, String name, org.jruby.ast.Node bodyNode) {
        RubyNode body;
        if (bodyNode != null) {
            this.parentSourceSection.push(sourceSection);
            try {
                body = (RubyNode)((Object)bodyNode.accept((NodeVisitor)this));
            }
            finally {
                this.parentSourceSection.pop();
            }
        } else {
            body = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
        }
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = SequenceNode.sequence(this.context, sourceSection, this.initFlipFlopStates(sourceSection), body);
        }
        body = new CatchReturnPlaceholderNode(this.context, sourceSection, body, this.environment.getReturnID());
        body = new SetMethodDeclarationContext(this.context, sourceSection, Visibility.PUBLIC, name, body);
        RubyRootNode rootNode = new RubyRootNode(this.context, sourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body);
        return new MethodDefinitionNode(this.context, sourceSection, this.environment.getSharedMethodInfo().getName(), this.environment.getSharedMethodInfo(), this.environment.needsDeclarationFrame(), (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNode));
    }

    @Override
    public RubyNode visitDefnNode(DefnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition(), node.getName());
        SelfNode classNode = new SelfNode(this.context, sourceSection);
        return this.translateMethodDefinition(sourceSection, classNode, node.getName(), (org.jruby.ast.Node)node, node.getArgsNode(), node.getBodyNode());
    }

    @Override
    public RubyNode visitAliasNode(AliasNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        LiteralNode oldName = (LiteralNode)node.getOldName();
        LiteralNode newName = (LiteralNode)node.getNewName();
        return AliasNodeFactory.create(this.context, sourceSection, newName.getName(), oldName.getName(), new SelfNode(this.context, sourceSection));
    }
}

