/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.OutputStream;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.SuperNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.cast.ArrayCastNode;
import org.jruby.truffle.nodes.cast.ArrayCastNodeFactory;
import org.jruby.truffle.nodes.control.IfNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.literal.ObjectLiteralNode;
import org.jruby.truffle.nodes.methods.BlockDefinitionNode;
import org.jruby.truffle.nodes.methods.CatchBreakAsProcErrorNode;
import org.jruby.truffle.nodes.methods.CatchBreakAsReturnNode;
import org.jruby.truffle.nodes.methods.CatchNextNode;
import org.jruby.truffle.nodes.methods.CatchRetryAsErrorNode;
import org.jruby.truffle.nodes.methods.CatchReturnNode;
import org.jruby.truffle.nodes.methods.CatchReturnPlaceholderNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.nodes.methods.RedoableNode;
import org.jruby.truffle.nodes.methods.arguments.CheckArityNode;
import org.jruby.truffle.nodes.methods.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.methods.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.methods.arguments.ShouldDestructureNode;
import org.jruby.truffle.nodes.methods.locals.FlipFlopStateNode;
import org.jruby.truffle.nodes.methods.locals.WriteLocalVariableNode;
import org.jruby.truffle.nodes.methods.locals.WriteLocalVariableNodeFactory;
import org.jruby.truffle.nodes.respondto.RespondToNode;
import org.jruby.truffle.nodes.supercall.GeneralSuperCallNode;
import org.jruby.truffle.nodes.supercall.GeneralSuperReCallNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.BehaveAsBlockNode;
import org.jruby.truffle.translator.BehaveAsProcNode;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.LoadArgumentsTranslator;
import org.jruby.truffle.translator.ParameterCollector;
import org.jruby.truffle.translator.TranslatorEnvironment;

class MethodTranslator
extends BodyTranslator {
    private boolean isBlock;

    public MethodTranslator(com.oracle.truffle.api.nodes.Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, boolean isBlock, Source source) {
        super(currentNode, context, parent, environment, source, false);
        this.isBlock = isBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode compileFunctionNode(SourceSection sourceSection, String methodName, ArgsNode argsNode, Node bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode prelude;
        RubyNode body;
        if (PRINT_PARSE_TREE_METHOD_NAMES.contains(methodName)) {
            System.err.println(sourceSection + " " + methodName);
            System.err.println(sharedMethodInfo.getParseTree().toString(true, 0));
        }
        ParameterCollector parameterCollector = new ParameterCollector();
        argsNode.accept((NodeVisitor)parameterCollector);
        for (String parameter : parameterCollector.getParameters()) {
            this.environment.declareVar(parameter);
        }
        Arity arity = MethodTranslator.getArity(argsNode);
        Arity arityForCheck = this.isBlock && argsNode.childNodes().size() == 2 && argsNode.getRestArgNode() instanceof UnnamedRestArgNode ? new Arity(arity.getRequired(), 0, false, false, false, 0) : arity;
        if (bodyNode != null) {
            this.parentSourceSection.push(sourceSection);
            try {
                body = (RubyNode)((Object)bodyNode.accept((NodeVisitor)this));
            }
            finally {
                this.parentSourceSection.pop();
            }
        } else {
            body = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
        }
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, this.isBlock, this);
        RubyNode loadArguments = (RubyNode)((Object)argsNode.accept((NodeVisitor)loadArgumentsTranslator));
        if (this.isBlock) {
            RubyNode preludeBuilder;
            boolean shouldConsiderDestructuringArrayArg = true;
            if (argsNode.getPreCount() == 0 && argsNode.getOptionalArgsCount() == 0 && argsNode.getPostCount() == 0 && argsNode.getRestArgNode() == null) {
                shouldConsiderDestructuringArrayArg = false;
            }
            if (argsNode.getPreCount() + argsNode.getPostCount() == 1 && argsNode.getOptionalArgsCount() == 0 && argsNode.getRestArgNode() == null) {
                shouldConsiderDestructuringArrayArg = false;
            }
            if (argsNode.getPreCount() == 0 && argsNode.getRestArgNode() != null) {
                shouldConsiderDestructuringArrayArg = false;
            }
            if (shouldConsiderDestructuringArrayArg) {
                ReadPreArgumentNode readArrayNode = new ReadPreArgumentNode(this.context, sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR);
                ArrayCastNode castArrayNode = ArrayCastNodeFactory.create(this.context, sourceSection, readArrayNode);
                FrameSlot arraySlot = this.environment.declareVar(this.environment.allocateLocalTemp("destructure"));
                WriteLocalVariableNode writeArrayNode = WriteLocalVariableNodeFactory.create(this.context, sourceSection, arraySlot, castArrayNode);
                LoadArgumentsTranslator destructureArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, this.isBlock, this);
                destructureArgumentsTranslator.pushArraySlot(arraySlot);
                RubyNode newDestructureArguments = (RubyNode)((Object)argsNode.accept((NodeVisitor)destructureArgumentsTranslator));
                preludeBuilder = new BehaveAsBlockNode(this.context, sourceSection, new IfNode(this.context, sourceSection, new ShouldDestructureNode(this.context, sourceSection, arity, new RespondToNode(this.context, sourceSection, readArrayNode, "to_ary")), SequenceNode.sequence(this.context, sourceSection, writeArrayNode, newDestructureArguments), (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)loadArguments)), (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)loadArguments));
            } else {
                preludeBuilder = loadArguments;
            }
            prelude = SequenceNode.sequence(this.context, sourceSection, new BehaveAsBlockNode(this.context, sourceSection, new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), new CheckArityNode(this.context, sourceSection, arityForCheck, parameterCollector.getKeywords(), argsNode.getKeyRest() != null)), preludeBuilder);
        } else {
            prelude = this.usesRubiniusPrimitive ? loadArguments : SequenceNode.sequence(this.context, sourceSection, new CheckArityNode(this.context, sourceSection, arityForCheck, parameterCollector.getKeywords(), argsNode.getKeyRest() != null), loadArguments);
        }
        body = SequenceNode.sequence(this.context, sourceSection, prelude, body);
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = SequenceNode.sequence(this.context, sourceSection, this.initFlipFlopStates(sourceSection), body);
        }
        if (this.isBlock) {
            body = new RedoableNode(this.context, sourceSection, body);
            body = new CatchReturnPlaceholderNode(this.context, sourceSection, body, this.environment.getReturnID());
            body = new BehaveAsProcNode(this.context, sourceSection, new CatchBreakAsProcErrorNode(this.context, sourceSection, body), (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)body));
        } else {
            body = new CatchReturnNode(this.context, sourceSection, body, this.environment.getReturnID());
        }
        body = new CatchNextNode(this.context, sourceSection, body);
        body = new CatchRetryAsErrorNode(this.context, sourceSection, body);
        if (!this.isBlock) {
            body = new ExceptionTranslatingNode(this.context, sourceSection, body);
        }
        RubyRootNode rootNode = new RubyRootNode(this.context, sourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body);
        if (PRINT_AST_METHOD_NAMES.contains(methodName)) {
            System.err.println(sourceSection + " " + methodName);
            NodeUtil.printCompactTree((OutputStream)System.err, (com.oracle.truffle.api.nodes.Node)rootNode);
        }
        if (PRINT_FULL_AST_METHOD_NAMES.contains(methodName)) {
            System.err.println(sourceSection + " " + methodName);
            NodeUtil.printTree((OutputStream)System.err, (com.oracle.truffle.api.nodes.Node)rootNode);
        }
        if (this.isBlock) {
            RubyRootNode newRootNodeForBlocks = rootNode.cloneRubyRootNode();
            for (BehaveAsBlockNode behaveAsBlockNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForBlocks, BehaveAsBlockNode.class)) {
                behaveAsBlockNode.replace(behaveAsBlockNode.getAsBlock());
            }
            for (BehaveAsProcNode behaveAsProcNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForBlocks, BehaveAsProcNode.class)) {
                behaveAsProcNode.replace(behaveAsProcNode.getNotAsProc());
            }
            RootCallTarget callTargetAsBlock = Truffle.getRuntime().createCallTarget((RootNode)newRootNodeForBlocks);
            RubyRootNode newRootNodeForProcs = rootNode.cloneRubyRootNode();
            for (BehaveAsBlockNode behaveAsBlockNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForProcs, BehaveAsBlockNode.class)) {
                behaveAsBlockNode.replace(behaveAsBlockNode.getAsBlock());
            }
            for (BehaveAsProcNode behaveAsProcNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForProcs, BehaveAsProcNode.class)) {
                behaveAsProcNode.replace(behaveAsProcNode.getAsProc());
            }
            RootCallTarget callTargetAsProc = Truffle.getRuntime().createCallTarget((RootNode)newRootNodeForProcs);
            RubyRootNode newRootNodeForMethods = rootNode.cloneRubyRootNode();
            for (BehaveAsBlockNode behaveAsBlockNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForMethods, BehaveAsBlockNode.class)) {
                behaveAsBlockNode.replace(behaveAsBlockNode.getNotAsBlock());
            }
            for (BehaveAsProcNode behaveAsProcNode : NodeUtil.findAllNodeInstances((com.oracle.truffle.api.nodes.Node)newRootNodeForMethods, BehaveAsProcNode.class)) {
                behaveAsProcNode.replace(behaveAsProcNode.getNotAsProc());
            }
            RubyRootNode newRootNodeWithCatchReturn = new RubyRootNode(this.context, newRootNodeForMethods.getSourceSection(), newRootNodeForMethods.getFrameDescriptor(), newRootNodeForMethods.getSharedMethodInfo(), new CatchBreakAsReturnNode(this.context, sourceSection, new CatchReturnNode(this.context, newRootNodeForMethods.getSourceSection(), newRootNodeForMethods.getBody(), this.getEnvironment().getReturnID())));
            RootCallTarget callTargetAsMethod = Truffle.getRuntime().createCallTarget((RootNode)newRootNodeWithCatchReturn);
            return new BlockDefinitionNode(this.context, sourceSection, this.environment.getSharedMethodInfo(), this.environment.needsDeclarationFrame(), (CallTarget)callTargetAsBlock, (CallTarget)callTargetAsProc, (CallTarget)callTargetAsMethod, this.environment.getBlockID());
        }
        return new MethodDefinitionNode(this.context, sourceSection, methodName, this.environment.getSharedMethodInfo(), this.environment.needsDeclarationFrame(), (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNode));
    }

    public static Arity getArity(ArgsNode argsNode) {
        int minimum = argsNode.getRequiredArgsCount();
        int maximum = argsNode.getMaxArgumentsCount();
        return new Arity(minimum, argsNode.getOptionalArgsCount(), maximum == -1, argsNode.hasKwargs(), argsNode.hasKeyRest(), argsNode.countKeywords(), argsNode);
    }

    public RubyNode visitSuperNode(SuperNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        BodyTranslator.ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, node.getIterNode(), node.getArgsNode(), null, this.environment.getNamedMethodName());
        return new GeneralSuperCallNode(this.context, sourceSection, argumentsAndBlock.getBlock(), argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted());
    }

    public RubyNode visitZSuperNode(ZSuperNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.environment.isBlock()) {
            this.environment.setNeedsDeclarationFrame();
        }
        return new GeneralSuperReCallNode(this.context, sourceSection, this.environment.isBlock());
    }

    @Override
    protected FlipFlopStateNode createFlipFlopState(SourceSection sourceSection, int depth) {
        if (this.isBlock) {
            this.environment.setNeedsDeclarationFrame();
            return this.parent.createFlipFlopState(sourceSection, depth + 1);
        }
        return super.createFlipFlopState(sourceSection, depth);
    }
}

