/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import org.jruby.truffle.runtime.RubyContext;

public class RubiniusConfiguration {
    private static final int SIZE_OF_SHORT = 2;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_LONG = 8;
    private static final int SIZE_OF_POINTER = 8;
    private final RubyContext context;
    private final Map<String, Object> configuration = new HashMap<String, Object>();

    public RubiniusConfiguration(RubyContext context) {
        this.context = context;
        this.config("hash.hamt", false);
        this.config("rbx.platform.file.S_IRUSR", 256);
        this.config("rbx.platform.file.S_IWUSR", 128);
        this.config("rbx.platform.file.S_IXUSR", 64);
        this.config("rbx.platform.file.S_IRGRP", 32);
        this.config("rbx.platform.file.S_IWGRP", 16);
        this.config("rbx.platform.file.S_IXGRP", 8);
        this.config("rbx.platform.file.S_IROTH", 4);
        this.config("rbx.platform.file.S_IWOTH", 2);
        this.config("rbx.platform.file.S_IXOTH", 1);
        this.config("rbx.platform.file.S_IFMT", 61440);
        this.config("rbx.platform.file.S_IFIFO", 4096);
        this.config("rbx.platform.file.S_IFCHR", 8192);
        this.config("rbx.platform.file.S_IFDIR", 16384);
        this.config("rbx.platform.file.S_IFBLK", 24576);
        this.config("rbx.platform.file.S_IFREG", 32768);
        this.config("rbx.platform.file.S_IFLNK", 40960);
        this.config("rbx.platform.file.S_IFSOCK", 49152);
        this.config("rbx.platform.file.S_ISUID", 2048);
        this.config("rbx.platform.file.S_ISGID", 1024);
        this.config("rbx.platform.file.S_ISVTX", 512);
        for (Fcntl fcntl : Fcntl.values()) {
            if (!fcntl.name().startsWith("F_")) continue;
            this.config("rbx.platform.fcntl." + fcntl.name(), fcntl.intValue());
        }
        for (Fcntl fcntl : OpenFlags.values()) {
            if (!fcntl.name().startsWith("O_")) continue;
            this.config("rbx.platform.file." + fcntl.name(), fcntl.intValue());
        }
        this.config("rbx.platform.fcntl.O_ACCMODE", OpenFlags.O_RDONLY.intValue() | OpenFlags.O_WRONLY.intValue() | OpenFlags.O_RDWR.intValue());
        this.config("rbx.platform.typedef.time_t", "long");
        this.config("rbx.platform.timeval.sizeof", 16);
        this.config("rbx.platform.timeval.tv_sec.offset", 0);
        this.config("rbx.platform.timeval.tv_sec.size", 8);
        this.config("rbx.platform.timeval.tv_sec.type", "time_t");
        this.config("rbx.platform.timeval.tv_usec.offset", 8);
        this.config("rbx.platform.timeval.tv_usec.size", 8);
        this.config("rbx.platform.timeval.tv_usec.type", "time_t");
        this.config("rbx.platform.addrinfo.sizeof", 48);
        int addrInfoOffset = 0;
        for (String field : Arrays.asList("ai_flags", "ai_family", "ai_socktype", "ai_protocol")) {
            this.config("rbx.platform.addrinfo." + field + ".offset", addrInfoOffset);
            this.config("rbx.platform.addrinfo." + field + ".size", 4);
            this.config("rbx.platform.addrinfo." + field + ".type", "int");
            addrInfoOffset += 4;
        }
        this.config("rbx.platform.addrinfo.ai_addrlen.offset", addrInfoOffset);
        this.config("rbx.platform.addrinfo.ai_addrlen.size", 8);
        this.config("rbx.platform.addrinfo.ai_addrlen.type", "long");
        addrInfoOffset += 8;
        for (String field : Arrays.asList("ai_addr", "ai_canonname", "ai_next")) {
            this.config("rbx.platform.addrinfo." + field + ".offset", addrInfoOffset);
            this.config("rbx.platform.addrinfo." + field + ".size", 8);
            this.config("rbx.platform.addrinfo." + field + ".type", "pointer");
            addrInfoOffset += 8;
        }
        this.config("rbx.platform.linger.sizeof", 8);
        int lingerOffset = 0;
        for (String string : Arrays.asList("l_onoff", "l_linger")) {
            this.config("rbx.platform.linger." + string + ".offset", lingerOffset);
            this.config("rbx.platform.linger." + string + ".size", 4);
            this.config("rbx.platform.linger." + string + ".type", "int");
            lingerOffset += 4;
        }
        this.config("rbx.platform.sockaddr_in.sizeof", 20);
        this.config("rbx.platform.sockaddr_in.sin_family.offset", 0);
        this.config("rbx.platform.sockaddr_in.sin_family.size", 2);
        this.config("rbx.platform.sockaddr_in.sin_family.type", "short");
        this.config("rbx.platform.sockaddr_in.sin_port.offset", 2);
        this.config("rbx.platform.sockaddr_in.sin_port.size", 2);
        this.config("rbx.platform.sockaddr_in.sin_port.type", "ushort");
        this.config("rbx.platform.sockaddr_in.sin_addr.offset", 4);
        this.config("rbx.platform.sockaddr_in.sin_addr.size", 8);
        this.config("rbx.platform.sockaddr_in.sin_addr.type", "ulong");
        this.config("rbx.platform.sockaddr_in.sin_zero.offset", 12);
        this.config("rbx.platform.sockaddr_in.sin_zero.size", 8);
        this.config("rbx.platform.sockaddr_in.sin_zero.type", "char");
        this.config("rbx.platform.servent.sizeof", 28);
        this.config("rbx.platform.servent.s_name.offset", 0);
        this.config("rbx.platform.servent.s_name.size", 8);
        this.config("rbx.platform.servent.s_name.type", "pointer");
        this.config("rbx.platform.servent.s_aliases.offset", 8);
        this.config("rbx.platform.servent.s_aliases.size", 8);
        this.config("rbx.platform.servent.s_aliases.type", "pointer");
        this.config("rbx.platform.servent.s_port.offset", 16);
        this.config("rbx.platform.servent.s_port.size", 4);
        this.config("rbx.platform.servent.s_port.type", "int");
        this.config("rbx.platform.servent.s_proto.offset", 20);
        this.config("rbx.platform.servent.s_proto.size", 8);
        this.config("rbx.platform.servent.s_proto.type", "pointer");
        this.config("rbx.platform.io.SEEK_SET", 0);
        this.config("rbx.platform.io.SEEK_CUR", 1);
        this.config("rbx.platform.io.SEEK_END", 2);
        this.config("rbx.platform.socket.AI_PASSIVE", context.makeString("1"));
        this.config("rbx.platform.socket.AF_UNSPEC", context.makeString("0"));
        this.config("rbx.platform.socket.SOCK_STREAM", context.makeString("1"));
    }

    private void config(String key, String value) {
        this.config(key, this.context.getSymbolTable().getSymbol(value));
    }

    private void config(String key, Object value) {
        this.configuration.put(key, value);
    }

    public Object get(String key) {
        return this.configuration.get(key);
    }

    public Collection<String> getSection(String section) {
        ArrayList<String> sectionKeys = new ArrayList<String>();
        for (String key : this.configuration.keySet()) {
            if (!key.startsWith(section)) continue;
            sectionKeys.add(key);
        }
        return sectionKeys;
    }
}

