/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.jruby.RubyThread;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ReturnException;
import org.jruby.truffle.runtime.control.ThreadExitException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyFiber;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.subsystems.FiberManager;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

public class RubyThread
extends RubyBasicObject {
    private final ThreadManager manager;
    private final FiberManager fiberManager;
    private String name;
    private final CountDownLatch finished = new CountDownLatch(1);
    private volatile Thread thread;
    private volatile RubyThread.Status status = RubyThread.Status.RUN;
    private volatile RubyException exception;
    private volatile Object value;
    private final RubyBasicObject threadLocals;
    private final List<Lock> ownedLocks = new ArrayList<Lock>();

    public RubyThread(RubyClass rubyClass, ThreadManager manager) {
        super(rubyClass);
        this.manager = manager;
        this.threadLocals = new RubyBasicObject(rubyClass.getContext().getCoreLibrary().getObjectClass());
        this.fiberManager = new FiberManager(this, manager);
    }

    public void initialize(RubyContext context, Node currentNode, final RubyProc block) {
        String info = block.getSharedMethodInfo().getSourceSection().getShortDescription();
        this.initialize(context, currentNode, info, new Runnable(){

            @Override
            public void run() {
                RubyThread.this.value = block.rootCall(new Object[0]);
            }
        });
    }

    public void initialize(final RubyContext context, final Node currentNode, final String info, final Runnable task) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RubyThread.this.run(context, currentNode, info, task);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RubyContext context, Node currentNode, String info, Runnable task) {
        this.name = "Ruby Thread@" + info;
        Thread.currentThread().setName(this.name);
        this.start();
        try {
            RubyFiber fiber = this.getRootFiber();
            fiber.run(task);
        }
        catch (ThreadExitException e) {
            this.value = context.getCoreLibrary().getNilObject();
            return;
        }
        catch (RaiseException e) {
            this.exception = e.getRubyException();
        }
        catch (ReturnException e) {
            this.exception = context.getCoreLibrary().unexpectedReturn(currentNode);
        }
        finally {
            this.cleanup();
        }
    }

    public void start() {
        this.thread = Thread.currentThread();
        this.manager.registerThread(this);
    }

    public void cleanup() {
        this.status = RubyThread.Status.ABORTING;
        this.manager.unregisterThread(this);
        this.status = RubyThread.Status.DEAD;
        this.thread = null;
        this.releaseOwnedLocks();
        this.finished.countDown();
    }

    public void shutdown() {
        this.fiberManager.shutdown();
        throw new ThreadExitException();
    }

    public Thread getRootFiberJavaThread() {
        return this.thread;
    }

    public Thread getCurrentFiberJavaThread() {
        return this.fiberManager.getCurrentFiber().getJavaThread();
    }

    public void join() {
        this.manager.runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Boolean>(){

            @Override
            public Boolean block() throws InterruptedException {
                RubyThread.this.finished.await();
                return true;
            }
        });
        if (this.exception != null) {
            throw new RaiseException(this.exception);
        }
    }

    public boolean join(final int timeoutInMillis) {
        boolean joined = this.manager.runOnce(new ThreadManager.BlockingActionWithoutGlobalLock<Boolean>(){

            @Override
            public Boolean block() throws InterruptedException {
                return RubyThread.this.finished.await(timeoutInMillis, TimeUnit.MILLISECONDS);
            }
        });
        if (joined && this.exception != null) {
            throw new RaiseException(this.exception);
        }
        return joined;
    }

    public void wakeup() {
        this.status = RubyThread.Status.RUN;
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
        }
    }

    public void acquiredLock(Lock lock) {
        this.ownedLocks.add(lock);
    }

    public void releasedLock(Lock lock) {
        RubyNode.notDesignedForCompilation();
        this.ownedLocks.remove(lock);
    }

    protected void releaseOwnedLocks() {
        for (Lock lock : this.ownedLocks) {
            lock.unlock();
        }
    }

    public RubyThread.Status getStatus() {
        return this.status;
    }

    public void setStatus(RubyThread.Status status) {
        this.status = status;
    }

    public RubyBasicObject getThreadLocals() {
        return this.threadLocals;
    }

    public Object getValue() {
        return this.value;
    }

    public RubyException getException() {
        return this.exception;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ThreadManager getThreadManager() {
        return this.manager;
    }

    public FiberManager getFiberManager() {
        return this.fiberManager;
    }

    public RubyFiber getRootFiber() {
        return this.fiberManager.getRootFiber();
    }

    public static class ThreadAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyThread(rubyClass, context.getThreadManager());
        }
    }
}

