/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.runtime.Helpers;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.CodeRangeable;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

public class RubyString
extends RubyBasicObject
implements CodeRangeable {
    private ByteList bytes;
    private int codeRange = 0;

    public RubyString(RubyClass stringClass, ByteList bytes) {
        super(stringClass);
        this.bytes = bytes;
    }

    public static RubyString fromJavaString(RubyClass stringClass, String string) {
        return new RubyString(stringClass, new ByteList(RubyEncoding.encodeUTF8((String)string), (Encoding)USASCIIEncoding.INSTANCE, false));
    }

    public static RubyString fromJavaString(RubyClass stringClass, String string, Encoding encoding) {
        return new RubyString(stringClass, new ByteList(RubyEncoding.encodeUTF8((String)string), encoding, false));
    }

    public static RubyString fromByteList(RubyClass stringClass, ByteList bytes) {
        return new RubyString(stringClass, bytes);
    }

    public void set(ByteList bytes) {
        this.bytes = bytes;
    }

    public void forceEncoding(Encoding encoding) {
        this.modify();
        this.clearCodeRange();
        StringSupport.associateEncoding((CodeRangeable)this, (Encoding)encoding);
        this.clearCodeRange();
    }

    public ByteList getBytes() {
        return this.bytes;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        RubyNode.notDesignedForCompilation();
        return Helpers.decodeByteList((Ruby)this.getContext().getRuntime(), (ByteList)this.bytes);
    }

    public int length() {
        if (CompilerDirectives.injectBranchProbability((double)0.9999, (boolean)StringSupport.isSingleByteOptimizable((CodeRangeable)this, (Encoding)this.getByteList().getEncoding()))) {
            return this.getByteList().getRealSize();
        }
        return StringSupport.strLengthFromRubyString((CodeRangeable)this);
    }

    public int normalizeIndex(int length, int index) {
        return RubyArray.normalizeIndex(length, index);
    }

    public int normalizeIndex(int index) {
        return this.normalizeIndex(this.length(), index);
    }

    public int clampExclusiveIndex(int index) {
        return RubyArray.clampExclusiveIndex(this.bytes.length(), index);
    }

    public int getCodeRange() {
        return this.codeRange;
    }

    @CompilerDirectives.TruffleBoundary
    public int scanForCodeRange() {
        int cr = this.getCodeRange();
        if (cr == 0) {
            cr = this.slowCodeRangeScan();
            this.setCodeRange(cr);
        }
        return cr;
    }

    public boolean isCodeRangeValid() {
        return this.codeRange == 32;
    }

    public final void setCodeRange(int codeRange) {
        this.codeRange = codeRange;
    }

    public final void clearCodeRange() {
        this.codeRange = 0;
    }

    public final void keepCodeRange() {
        if (this.getCodeRange() == 48) {
            this.clearCodeRange();
        }
    }

    public final void modify() {
        this.bytes.invalidate();
    }

    public final void modify(int length) {
        this.bytes.ensure(length);
        this.bytes.invalidate();
    }

    public final void modifyAndKeepCodeRange() {
        this.modify();
        this.keepCodeRange();
    }

    @CompilerDirectives.TruffleBoundary
    public Encoding checkEncoding(CodeRangeable other) {
        Encoding encoding = StringSupport.areCompatible((CodeRangeable)this, (CodeRangeable)other);
        if (encoding == null) {
            throw this.getContext().getRuntime().newEncodingCompatibilityError(String.format("incompatible character encodings: %s and %s", this.getByteList().getEncoding().toString(), other.getByteList().getEncoding().toString()));
        }
        return encoding;
    }

    @CompilerDirectives.TruffleBoundary
    public Encoding checkEncoding(CodeRangeable other, Node node) {
        Encoding encoding = StringSupport.areCompatible((CodeRangeable)this, (CodeRangeable)other);
        if (encoding == null) {
            throw new RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityErrorIncompatible(this.getByteList().getEncoding().toString(), other.getByteList().getEncoding().toString(), node));
        }
        return encoding;
    }

    public ByteList getByteList() {
        return this.bytes;
    }

    @CompilerDirectives.TruffleBoundary
    private int slowCodeRangeScan() {
        return StringSupport.codeRangeScan((Encoding)this.bytes.getEncoding(), (ByteList)this.bytes);
    }

    public boolean singleByteOptimizable() {
        return StringSupport.isSingleByteOptimizable((CodeRangeable)this, (Encoding)EncodingUtils.STR_ENC_GET((ByteListHolder)this));
    }

    public static class StringAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyString(rubyClass, new ByteList());
        }
    }
}

