/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.backtrace;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.nodes.CoreSourceSection;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.util.cli.Options;

public class DebugBacktraceFormatter
implements BacktraceFormatter {
    @Override
    public String[] format(RubyContext context, RubyException exception, Backtrace backtrace) {
        try {
            List<Activation> activations = backtrace.getActivations();
            ArrayList<String> lines = new ArrayList<String>();
            if (exception != null) {
                lines.add(String.format("%s (%s)", exception.getMessage(), exception.getLogicalClass().getName()));
            }
            for (Activation activation : activations) {
                lines.add(DebugBacktraceFormatter.formatLine(context, activation));
            }
            return lines.toArray(new String[lines.size()]);
        }
        catch (Exception e) {
            throw new TruffleFatalException("Exception while trying to format a Ruby call stack", e);
        }
    }

    private static String formatLine(RubyContext context, Activation activation) {
        StringBuilder builder = new StringBuilder();
        builder.append(DebugBacktraceFormatter.formatBasicLine(activation));
        MaterializedFrame frame = activation.getMaterializedFrame();
        FrameDescriptor frameDescriptor = frame.getFrameDescriptor();
        builder.append(" self=");
        builder.append(DebugBacktraceFormatter.debugString(context, RubyArguments.getSelf(frame.getArguments())));
        for (Object identifier : frameDescriptor.getIdentifiers()) {
            if (!(identifier instanceof String)) continue;
            builder.append(" ");
            builder.append(identifier);
            builder.append("=");
            builder.append(DebugBacktraceFormatter.debugString(context, frame.getValue(frameDescriptor.findFrameSlot(identifier))));
        }
        return builder.toString();
    }

    public static String formatBasicLine(Activation activation) {
        StringBuilder builder = new StringBuilder();
        builder.append("    at ");
        SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
        if (sourceSection instanceof CoreSourceSection) {
            InternalMethod method = RubyArguments.getMethod(activation.getMaterializedFrame().getArguments());
            builder.append(method.getDeclaringModule().getName());
            builder.append("#");
            builder.append(method.getName());
        } else {
            builder.append(sourceSection.getSource().getName());
            builder.append(":");
            builder.append(sourceSection.getStartLine());
            builder.append(":in '");
            builder.append(sourceSection.getIdentifier());
            builder.append("'");
        }
        return builder.toString();
    }

    public static String debugString(RubyContext context, Object value) {
        if (value == null) {
            return "*null*";
        }
        try {
            String string = DebugOperations.inspect(context, value);
            if (string.length() <= (Integer)Options.TRUFFLE_BACKTRACE_MAX_VALUE_LENGTH.load()) {
                return string;
            }
            return string.substring(0, (Integer)Options.TRUFFLE_BACKTRACE_MAX_VALUE_LENGTH.load()) + "\u2026";
        }
        catch (Throwable t) {
            return "*error*";
        }
    }
}

