/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.ExactMath;
import java.math.BigInteger;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBignum;

public abstract class ObjectIDOperations {
    public static final int FALSE = 0;
    public static final int TRUE = 2;
    public static final int NIL = 4;
    public static final int FIRST_OBJECT_ID = 6;
    private static final BigInteger LARGE_FIXNUM_FLAG = BigInteger.ONE.shiftLeft(64);
    private static final BigInteger FLOAT_FLAG = BigInteger.ONE.shiftLeft(65);
    private static final long SMALL_FIXNUM_MIN = -4611686018427387904L;
    private static final long SMALL_FIXNUM_MAX = 0x3FFFFFFFFFFFFFFFL;

    public static boolean isSmallFixnum(long fixnum) {
        return -4611686018427387904L <= fixnum && fixnum <= 0x3FFFFFFFFFFFFFFFL;
    }

    public static long smallFixnumToIDOverflow(long fixnum) throws ArithmeticException {
        return ExactMath.addExact((long)ExactMath.multiplyExact((long)fixnum, (long)2L), (long)1L);
    }

    public static long smallFixnumToID(long fixnum) {
        assert (ObjectIDOperations.isSmallFixnum(fixnum));
        return fixnum * 2L + 1L;
    }

    public static RubyBignum largeFixnumToID(RubyContext context, long fixnum) {
        assert (!ObjectIDOperations.isSmallFixnum(fixnum));
        BigInteger big = ObjectIDOperations.unsignedBigInteger(fixnum);
        return new RubyBignum(context.getCoreLibrary().getBignumClass(), big.or(LARGE_FIXNUM_FLAG));
    }

    public static RubyBignum floatToID(RubyContext context, double value) {
        long bits = Double.doubleToRawLongBits(value);
        BigInteger big = ObjectIDOperations.unsignedBigInteger(bits);
        return new RubyBignum(context.getCoreLibrary().getBignumClass(), big.or(FLOAT_FLAG));
    }

    public static boolean isSmallFixnumID(long id) {
        return id % 2L != 0L;
    }

    public static long toFixnum(long id) {
        return (id - 1L) / 2L;
    }

    public static boolean isLargeFixnumID(BigInteger id) {
        return !id.and(LARGE_FIXNUM_FLAG).equals(BigInteger.ZERO);
    }

    public static long toFixnum(RubyBignum id) {
        return id.bigIntegerValue().longValue();
    }

    public static boolean isFloatID(BigInteger id) {
        return !id.and(FLOAT_FLAG).equals(BigInteger.ZERO);
    }

    public static double toFloat(RubyBignum id) {
        return Double.longBitsToDouble(id.bigIntegerValue().longValue());
    }

    private static BigInteger unsignedBigInteger(long value) {
        BigInteger big = BigInteger.valueOf(value);
        if (value < 0L) {
            big = new BigInteger(1, big.toByteArray());
        }
        return big;
    }
}

