/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.yield;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeUtil;
import java.util.concurrent.Callable;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.yield.CachedYieldDispatchNode;
import org.jruby.truffle.nodes.yield.GeneralYieldDispatchNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.nodes.yield.YieldDispatchNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyProc;

@NodeInfo(cost=NodeCost.UNINITIALIZED)
public class UninitializedYieldDispatchNode
extends YieldDispatchNode {
    private int depth = 0;

    public UninitializedYieldDispatchNode(RubyContext context) {
        super(context);
    }

    @Override
    protected boolean guard(RubyProc block) {
        return false;
    }

    @Override
    public Object dispatchWithSelfAndBlock(VirtualFrame frame, final RubyProc block, Object self, RubyProc modifiedBlock, Object ... argumentsObjects) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        YieldDispatchNode dispatch = (YieldDispatchNode)((Object)this.atomic(new Callable<YieldDispatchNode>(){

            @Override
            public YieldDispatchNode call() {
                YieldDispatchNode newDispatchNode;
                YieldDispatchNode first;
                YieldDispatchHeadNode dispatchHead = UninitializedYieldDispatchNode.this.getHeadNode();
                for (YieldDispatchNode lookupDispatch = first = dispatchHead.getDispatch(); lookupDispatch != null; lookupDispatch = lookupDispatch.getNext()) {
                    if (!lookupDispatch.guard(block)) continue;
                    return lookupDispatch;
                }
                if (UninitializedYieldDispatchNode.this.depth < DispatchNode.DISPATCH_POLYMORPHIC_MAX) {
                    UninitializedYieldDispatchNode.this.depth++;
                    newDispatchNode = new CachedYieldDispatchNode(UninitializedYieldDispatchNode.this.getContext(), block, first);
                } else {
                    newDispatchNode = new GeneralYieldDispatchNode(UninitializedYieldDispatchNode.this.getContext());
                }
                first.replace(newDispatchNode);
                return first;
            }
        }));
        return dispatch.dispatchWithSelfAndBlock(frame, block, self, modifiedBlock, argumentsObjects);
    }

    private YieldDispatchHeadNode getHeadNode() {
        return (YieldDispatchHeadNode)((Object)NodeUtil.findParent((Node)this, YieldDispatchHeadNode.class));
    }
}

