/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.objects.IsTaintedNode;
import org.jruby.truffle.nodes.objects.IsTaintedNodeFactory;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.nodes.objects.TaintNodeFactory;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.ObjectIDOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyNilClass;

public abstract class ObjectPrimitiveNodes {

    @RubiniusPrimitive(name="object_infect", needsSelf=false)
    public static abstract class ObjectInfectPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private IsTaintedNode isTaintedNode;
        @Node.Child
        private TaintNode taintNode;

        public ObjectInfectPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ObjectInfectPrimitiveNode(ObjectInfectPrimitiveNode prev) {
            super(prev);
            this.isTaintedNode = prev.isTaintedNode;
            this.taintNode = prev.taintNode;
        }

        @Specialization
        public Object objectInfect(Object host, Object source) {
            if (this.isTaintedNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isTaintedNode = (IsTaintedNode)this.insert(IsTaintedNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if (this.isTaintedNode.executeIsTainted(source)) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.taintNode = (TaintNode)this.insert(TaintNodeFactory.create(this.getContext(), this.getSourceSection(), null));
                }
                this.taintNode.executeTaint(host);
            }
            return host;
        }
    }

    @RubiniusPrimitive(name="object_id")
    public static abstract class ObjectIDPrimitiveNode
    extends RubiniusPrimitiveNode {
        public ObjectIDPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ObjectIDPrimitiveNode(ObjectIDPrimitiveNode prev) {
            super(prev);
        }

        public abstract Object executeObjectID(VirtualFrame var1, Object var2);

        @Specialization
        public int objectID(RubyNilClass nil) {
            return 4;
        }

        @Specialization(guards={"isTrue"})
        public int objectIDTrue(boolean value) {
            return 2;
        }

        @Specialization(guards={"!isTrue"})
        public int objectIDFalse(boolean value) {
            return 0;
        }

        @Specialization
        public long objectID(int value) {
            return ObjectIDOperations.smallFixnumToID(value);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long objectIDSmallFixnumOverflow(long value) throws ArithmeticException {
            return ObjectIDOperations.smallFixnumToIDOverflow(value);
        }

        @Specialization
        public Object objectID(long value) {
            if (this.isSmallFixnum(value)) {
                return ObjectIDOperations.smallFixnumToID(value);
            }
            return ObjectIDOperations.largeFixnumToID(this.getContext(), value);
        }

        @Specialization
        public Object objectID(double value) {
            return ObjectIDOperations.floatToID(this.getContext(), value);
        }

        @Specialization
        public long objectID(RubyBasicObject object) {
            return object.verySlowGetObjectID();
        }

        protected boolean isSmallFixnum(long fixnum) {
            return ObjectIDOperations.isSmallFixnum(fixnum);
        }
    }
}

