/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

public abstract class EncodingPrimitiveNodes {

    @RubiniusPrimitive(name="encoding_get_object_encoding", needsSelf=false)
    public static abstract class EncodingGetObjectEncodingNode
    extends RubiniusPrimitiveNode {
        public EncodingGetObjectEncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EncodingGetObjectEncodingNode(EncodingGetObjectEncodingNode prev) {
            super(prev);
        }

        @Specialization
        public RubyEncoding encodingGetObjectEncoding(RubyString string) {
            EncodingGetObjectEncodingNode.notDesignedForCompilation();
            return RubyEncoding.getEncoding(string.getBytes().getEncoding());
        }

        @Specialization
        public RubyEncoding encodingGetObjectEncoding(RubySymbol symbol) {
            EncodingGetObjectEncodingNode.notDesignedForCompilation();
            return RubyEncoding.getEncoding(symbol.getSymbolBytes().getEncoding());
        }

        @Specialization
        public RubyEncoding encodingGetObjectEncoding(RubyEncoding encoding) {
            return encoding;
        }

        @Specialization(guards={"!isRubyString", "!isRubySymbol", "!isRubyEncoding"})
        public RubyNilClass encodingGetObjectEncoding(RubyBasicObject object) {
            return this.nil();
        }
    }
}

