/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DoubleLocation;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldChainNode;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldNode;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@NodeInfo(cost=NodeCost.POLYMORPHIC)
public class ReadDoubleObjectFieldNode
extends ReadObjectFieldChainNode {
    private final DoubleLocation storageLocation;

    public ReadDoubleObjectFieldNode(Shape objectLayout, DoubleLocation storageLocation, ReadObjectFieldNode next) {
        super(objectLayout, next);
        this.storageLocation = storageLocation;
    }

    @Override
    public double executeDouble(RubyBasicObject object) throws UnexpectedResultException {
        boolean condition;
        try {
            this.objectLayout.getValidAssumption().check();
        }
        catch (InvalidAssumptionException e) {
            this.replace(this.next);
            return this.next.executeDouble(object);
        }
        boolean bl = condition = object.getObjectLayout() == this.objectLayout;
        if (condition) {
            return this.storageLocation.getDouble(object.getDynamicObject(), this.objectLayout);
        }
        return this.next.executeDouble(object);
    }

    @Override
    public Object execute(RubyBasicObject object) {
        boolean condition;
        try {
            this.objectLayout.getValidAssumption().check();
        }
        catch (InvalidAssumptionException e) {
            this.replace(this.next);
            return this.next.execute(object);
        }
        boolean bl = condition = object.getObjectLayout() == this.objectLayout;
        if (condition) {
            return this.storageLocation.get(object.getDynamicObject(), this.objectLayout);
        }
        return this.next.execute(object);
    }
}

