/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;

@GeneratedBy(value=SingletonClassNode.class)
public final class SingletonClassNodeFactory
extends NodeFactoryBase<SingletonClassNode> {
    private static SingletonClassNodeFactory instance;

    private SingletonClassNodeFactory() {
        super(SingletonClassNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public SingletonClassNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return SingletonClassNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static SingletonClassNode create(RubyContext context, SourceSection sourceSection, RubyNode object) {
        return SingletonClassUninitializedNode.create0(context, sourceSection, object);
    }

    public static NodeFactory<SingletonClassNode> getInstance() {
        if (instance == null) {
            instance = new SingletonClassNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=SingletonClassNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class SingletonClassPolymorphicNode
    extends SingletonClassBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> objectPolymorphicType;

        SingletonClassPolymorphicNode(SingletonClassBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            Object objectValue;
            try {
                objectValue = this.objectPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.object.executeBoolean(frameValue)) : (this.objectPolymorphicType == Integer.TYPE ? Integer.valueOf(this.object.executeIntegerFixnum(frameValue)) : (this.objectPolymorphicType == Long.TYPE ? Long.valueOf(this.object.executeLongFixnum(frameValue)) : (this.objectPolymorphicType == Double.TYPE ? Double.valueOf(this.object.executeFloat(frameValue)) : (this.objectPolymorphicType == RubyBasicObject.class ? this.object.executeRubyBasicObject(frameValue) : this.object.execute(frameValue)))));
            }
            catch (UnexpectedResultException ex) {
                this.objectPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        @Override
        public RubyClass executeSingletonClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            Object objectValue;
            try {
                objectValue = this.objectPolymorphicType == Boolean.TYPE ? Boolean.valueOf(RubyTypesGen.RUBYTYPES.expectBoolean(objectValueEvaluated)) : (this.objectPolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(objectValueEvaluated)) : (this.objectPolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(objectValueEvaluated)) : (this.objectPolymorphicType == Double.TYPE ? Double.valueOf(RubyTypesGen.RUBYTYPES.expectDouble(objectValueEvaluated)) : (this.objectPolymorphicType == RubyBasicObject.class ? RubyTypesGen.RUBYTYPES.expectRubyBasicObject(objectValueEvaluated) : objectValueEvaluated))));
            }
            catch (UnexpectedResultException ex) {
                this.objectPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.objectPolymorphicType = types[0];
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            return this.next0.executeChained0(frameValue, objectValue);
        }
    }

    @GeneratedBy(value=SingletonClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SingletonClassRubyBasicObjectNode
    extends SingletonClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SingletonClassRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        SingletonClassRubyBasicObjectNode(SingletonClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBasicObject objectValue;
            try {
                objectValue = this.object.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof RubyBasicObject");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        public RubyClass executeSingletonClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            RubyBasicObject objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof RubyBasicObject");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(objectValue)) {
                RubyBasicObject objectValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(objectValue);
                return super.singletonClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static SingletonClassNode create0(SingletonClassNode current) {
            return new SingletonClassRubyBasicObjectNode((SingletonClassBaseNode)current);
        }
    }

    @GeneratedBy(value=SingletonClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SingletonClassDoubleNode
    extends SingletonClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SingletonClassDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        SingletonClassDoubleNode(SingletonClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            double objectValue;
            try {
                objectValue = this.object.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof double");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        public RubyClass executeSingletonClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            double objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectDouble(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof double");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(objectValue)) {
                double objectValueCast = RubyTypesGen.RUBYTYPES.asDouble(objectValue);
                return super.singletonClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static SingletonClassNode create0(SingletonClassNode current) {
            return new SingletonClassDoubleNode((SingletonClassBaseNode)current);
        }
    }

    @GeneratedBy(value=SingletonClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SingletonClassLongNode
    extends SingletonClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SingletonClassLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        SingletonClassLongNode(SingletonClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            long objectValue;
            try {
                objectValue = this.object.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof long");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        public RubyClass executeSingletonClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            long objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectLong(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof long");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(objectValue)) {
                long objectValueCast = RubyTypesGen.RUBYTYPES.asLong(objectValue);
                return super.singletonClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static SingletonClassNode create0(SingletonClassNode current) {
            return new SingletonClassLongNode((SingletonClassBaseNode)current);
        }
    }

    @GeneratedBy(value=SingletonClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SingletonClassIntNode
    extends SingletonClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SingletonClassIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        SingletonClassIntNode(SingletonClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            int objectValue;
            try {
                objectValue = this.object.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof int");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        public RubyClass executeSingletonClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            int objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectInteger(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof int");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(objectValue)) {
                int objectValueCast = RubyTypesGen.RUBYTYPES.asInteger(objectValue);
                return super.singletonClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static SingletonClassNode create0(SingletonClassNode current) {
            return new SingletonClassIntNode((SingletonClassBaseNode)current);
        }
    }

    @GeneratedBy(value=SingletonClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SingletonClassBoolean1Node
    extends SingletonClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SingletonClassBoolean1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        SingletonClassBoolean1Node(SingletonClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean objectValue;
            try {
                objectValue = this.object.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof boolean");
            }
            if (!super.isTrue(objectValue)) {
                return super.singletonClassFalse(objectValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, objectValue, "One of guards [!isTrue] failed");
        }

        @Override
        public RubyClass executeSingletonClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            boolean objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectBoolean(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof boolean");
            }
            if (!super.isTrue(objectValue)) {
                return super.singletonClassFalse(objectValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, objectValue, "One of guards [!isTrue] failed");
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            boolean objectValueCast;
            if (RubyTypesGen.RUBYTYPES.isBoolean(objectValue) && !super.isTrue(objectValueCast = RubyTypesGen.RUBYTYPES.asBoolean(objectValue))) {
                return super.singletonClassFalse(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static SingletonClassNode create0(SingletonClassNode current) {
            return new SingletonClassBoolean1Node((SingletonClassBaseNode)current);
        }
    }

    @GeneratedBy(value=SingletonClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SingletonClassBoolean0Node
    extends SingletonClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SingletonClassBoolean0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        SingletonClassBoolean0Node(SingletonClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean objectValue;
            try {
                objectValue = this.object.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof boolean");
            }
            if (super.isTrue(objectValue)) {
                return super.singletonClassTrue(objectValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, objectValue, "One of guards [isTrue] failed");
        }

        @Override
        public RubyClass executeSingletonClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            boolean objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectBoolean(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof boolean");
            }
            if (super.isTrue(objectValue)) {
                return super.singletonClassTrue(objectValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, objectValue, "One of guards [isTrue] failed");
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            boolean objectValueCast;
            if (RubyTypesGen.RUBYTYPES.isBoolean(objectValue) && super.isTrue(objectValueCast = RubyTypesGen.RUBYTYPES.asBoolean(objectValue))) {
                return super.singletonClassTrue(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static SingletonClassNode create0(SingletonClassNode current) {
            return new SingletonClassBoolean0Node((SingletonClassBaseNode)current);
        }
    }

    @GeneratedBy(value=SingletonClassNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class SingletonClassUninitializedNode
    extends SingletonClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SingletonClassUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        SingletonClassUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode object) {
            super(context, sourceSection, object);
        }

        SingletonClassUninitializedNode(SingletonClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object objectValue = this.object.execute(frameValue);
            return this.executeUninitialized0(frameValue, objectValue);
        }

        @Override
        public RubyClass executeSingletonClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object objectValue = objectValueEvaluated;
            return this.executeUninitialized0(frameValue, objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, objectValue);
        }

        protected RubyClass executeUninitialized0(VirtualFrame frameValue, Object objectValue) {
            SingletonClassBaseNode newNode = this.specialize0(objectValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                SingletonClassBaseNode rootNode = (SingletonClassBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.object}, new Object[]{objectValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((SingletonClassBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, objectValue);
        }

        static SingletonClassNode create0(RubyContext context, SourceSection sourceSection, RubyNode object) {
            return new SingletonClassUninitializedNode(context, sourceSection, object);
        }
    }

    @GeneratedBy(value=SingletonClassNode.class)
    private static abstract class SingletonClassBaseNode
    extends SingletonClassNode
    implements DSLNode {
        @Node.Child
        protected RubyNode object;
        @Node.Child
        protected SingletonClassBaseNode next0;

        SingletonClassBaseNode(RubyContext context, SourceSection sourceSection, RubyNode object) {
            super(context, sourceSection);
            this.object = object;
        }

        SingletonClassBaseNode(SingletonClassBaseNode copy) {
            super(copy);
        }

        protected abstract RubyClass executeChained0(VirtualFrame var1, Object var2);

        protected final RubyClass rewrite0(VirtualFrame frameValue, Object objectValue, String reason) {
            String message;
            SingletonClassBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            SingletonClassBaseNode newNode = this.specialize0(objectValue);
            if (newNode == null) {
                newNode = new SingletonClassUninitializedNode(this);
                ((SingletonClassUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (SingletonClassBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SingletonClassBaseNode.createInfo0(reason, objectValue)))) == null) {
                returnNode = (SingletonClassBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SingletonClassUninitializedNode(this), (Node)new SingletonClassPolymorphicNode(this), (DSLNode)((SingletonClassBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, objectValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final SingletonClassBaseNode specialize0(Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(objectValue)) {
                boolean objectValueCast = RubyTypesGen.RUBYTYPES.asBoolean(objectValue);
                if (super.isTrue(objectValueCast)) {
                    return (SingletonClassBaseNode)SingletonClassBoolean0Node.create0(this);
                }
                return (SingletonClassBaseNode)SingletonClassBoolean1Node.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isInteger(objectValue)) {
                return (SingletonClassBaseNode)SingletonClassIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(objectValue)) {
                return (SingletonClassBaseNode)SingletonClassLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(objectValue)) {
                return (SingletonClassBaseNode)SingletonClassDoubleNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(objectValue)) {
                return (SingletonClassBaseNode)SingletonClassRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.object = other == null ? null : ((SingletonClassBaseNode)other).object;
            this.next0 = newNext == null ? null : (SingletonClassBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object objectValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("objectValue").append(" = ").append(objectValue);
                if (objectValue != null) {
                    builder.append(" (").append(objectValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

