/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyModule;

public class ReadClassVariableNode
extends RubyNode {
    private final String name;
    private final LexicalScope lexicalScope;

    public ReadClassVariableNode(RubyContext context, SourceSection sourceSection, String name, LexicalScope lexicalScope) {
        super(context, sourceSection);
        this.name = name;
        this.lexicalScope = lexicalScope;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        ReadClassVariableNode.notDesignedForCompilation();
        RubyModule moduleObject = this.lexicalScope.getLiveModule();
        Object value = ModuleOperations.lookupClassVariable(moduleObject, this.name);
        if (value == null) {
            return this.nil();
        }
        return value;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        RubyModule moduleObject = this.lexicalScope.getLiveModule();
        Object value = ModuleOperations.lookupClassVariable(moduleObject, this.name);
        if (value == null) {
            return this.nil();
        }
        return this.getContext().makeString("class variable");
    }
}

