/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;

@GeneratedBy(value=MetaClassNode.class)
public final class MetaClassNodeFactory
extends NodeFactoryBase<MetaClassNode> {
    private static MetaClassNodeFactory instance;

    private MetaClassNodeFactory() {
        super(MetaClassNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public MetaClassNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return MetaClassNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static MetaClassNode create(RubyContext context, SourceSection sourceSection, RubyNode object) {
        return MetaClassUninitializedNode.create0(context, sourceSection, object);
    }

    public static NodeFactory<MetaClassNode> getInstance() {
        if (instance == null) {
            instance = new MetaClassNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=MetaClassNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class MetaClassPolymorphicNode
    extends MetaClassBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> objectPolymorphicType;

        MetaClassPolymorphicNode(MetaClassBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            Object objectValue;
            try {
                objectValue = this.objectPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.object.executeBoolean(frameValue)) : (this.objectPolymorphicType == Integer.TYPE ? Integer.valueOf(this.object.executeIntegerFixnum(frameValue)) : (this.objectPolymorphicType == Long.TYPE ? Long.valueOf(this.object.executeLongFixnum(frameValue)) : (this.objectPolymorphicType == Double.TYPE ? Double.valueOf(this.object.executeFloat(frameValue)) : (this.objectPolymorphicType == RubyBasicObject.class ? this.object.executeRubyBasicObject(frameValue) : this.object.execute(frameValue)))));
            }
            catch (UnexpectedResultException ex) {
                this.objectPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        @Override
        public RubyClass executeMetaClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            Object objectValue;
            try {
                objectValue = this.objectPolymorphicType == Boolean.TYPE ? Boolean.valueOf(RubyTypesGen.RUBYTYPES.expectBoolean(objectValueEvaluated)) : (this.objectPolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(objectValueEvaluated)) : (this.objectPolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(objectValueEvaluated)) : (this.objectPolymorphicType == Double.TYPE ? Double.valueOf(RubyTypesGen.RUBYTYPES.expectDouble(objectValueEvaluated)) : (this.objectPolymorphicType == RubyBasicObject.class ? RubyTypesGen.RUBYTYPES.expectRubyBasicObject(objectValueEvaluated) : objectValueEvaluated))));
            }
            catch (UnexpectedResultException ex) {
                this.objectPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.objectPolymorphicType = types[0];
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            return this.next0.executeChained0(frameValue, objectValue);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class MetaClassRubyBasicObjectNode
    extends MetaClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(MetaClassRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        MetaClassRubyBasicObjectNode(MetaClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBasicObject objectValue;
            try {
                objectValue = this.object.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof RubyBasicObject");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        public RubyClass executeMetaClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            RubyBasicObject objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof RubyBasicObject");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(objectValue)) {
                RubyBasicObject objectValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(objectValue);
                return super.singletonClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static MetaClassNode create0(MetaClassNode current) {
            return new MetaClassRubyBasicObjectNode((MetaClassBaseNode)current);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class MetaClassDoubleNode
    extends MetaClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(MetaClassDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        MetaClassDoubleNode(MetaClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            double objectValue;
            try {
                objectValue = this.object.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof double");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        public RubyClass executeMetaClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            double objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectDouble(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof double");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(objectValue)) {
                double objectValueCast = RubyTypesGen.RUBYTYPES.asDouble(objectValue);
                return super.singletonClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static MetaClassNode create0(MetaClassNode current) {
            return new MetaClassDoubleNode((MetaClassBaseNode)current);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class MetaClassLongNode
    extends MetaClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(MetaClassLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        MetaClassLongNode(MetaClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            long objectValue;
            try {
                objectValue = this.object.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof long");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        public RubyClass executeMetaClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            long objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectLong(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof long");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(objectValue)) {
                long objectValueCast = RubyTypesGen.RUBYTYPES.asLong(objectValue);
                return super.singletonClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static MetaClassNode create0(MetaClassNode current) {
            return new MetaClassLongNode((MetaClassBaseNode)current);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class MetaClassIntNode
    extends MetaClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(MetaClassIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        MetaClassIntNode(MetaClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            int objectValue;
            try {
                objectValue = this.object.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof int");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        public RubyClass executeMetaClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            int objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectInteger(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof int");
            }
            return super.singletonClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(objectValue)) {
                int objectValueCast = RubyTypesGen.RUBYTYPES.asInteger(objectValue);
                return super.singletonClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static MetaClassNode create0(MetaClassNode current) {
            return new MetaClassIntNode((MetaClassBaseNode)current);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class MetaClassBoolean1Node
    extends MetaClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(MetaClassBoolean1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        MetaClassBoolean1Node(MetaClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean objectValue;
            try {
                objectValue = this.object.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof boolean");
            }
            if (!super.isTrue(objectValue)) {
                return super.singletonClassFalse(objectValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, objectValue, "One of guards [!isTrue] failed");
        }

        @Override
        public RubyClass executeMetaClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            boolean objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectBoolean(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof boolean");
            }
            if (!super.isTrue(objectValue)) {
                return super.singletonClassFalse(objectValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, objectValue, "One of guards [!isTrue] failed");
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            boolean objectValueCast;
            if (RubyTypesGen.RUBYTYPES.isBoolean(objectValue) && !super.isTrue(objectValueCast = RubyTypesGen.RUBYTYPES.asBoolean(objectValue))) {
                return super.singletonClassFalse(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static MetaClassNode create0(MetaClassNode current) {
            return new MetaClassBoolean1Node((MetaClassBaseNode)current);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class MetaClassBoolean0Node
    extends MetaClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(MetaClassBoolean0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        MetaClassBoolean0Node(MetaClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean objectValue;
            try {
                objectValue = this.object.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof boolean");
            }
            if (super.isTrue(objectValue)) {
                return super.singletonClassTrue(objectValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, objectValue, "One of guards [isTrue] failed");
        }

        @Override
        public RubyClass executeMetaClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            boolean objectValue;
            try {
                objectValue = RubyTypesGen.RUBYTYPES.expectBoolean(objectValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof boolean");
            }
            if (super.isTrue(objectValue)) {
                return super.singletonClassTrue(objectValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, objectValue, "One of guards [isTrue] failed");
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            boolean objectValueCast;
            if (RubyTypesGen.RUBYTYPES.isBoolean(objectValue) && super.isTrue(objectValueCast = RubyTypesGen.RUBYTYPES.asBoolean(objectValue))) {
                return super.singletonClassTrue(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static MetaClassNode create0(MetaClassNode current) {
            return new MetaClassBoolean0Node((MetaClassBaseNode)current);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class MetaClassUninitializedNode
    extends MetaClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(MetaClassUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        MetaClassUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode object) {
            super(context, sourceSection, object);
        }

        MetaClassUninitializedNode(MetaClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value;
            try {
                value = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object objectValue = this.object.execute(frameValue);
            return this.executeUninitialized0(frameValue, objectValue);
        }

        @Override
        public RubyClass executeMetaClass(VirtualFrame frameValue, Object objectValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object objectValue = objectValueEvaluated;
            return this.executeUninitialized0(frameValue, objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, objectValue);
        }

        protected RubyClass executeUninitialized0(VirtualFrame frameValue, Object objectValue) {
            MetaClassBaseNode newNode = this.specialize0(objectValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                MetaClassBaseNode rootNode = (MetaClassBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.object}, new Object[]{objectValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((MetaClassBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, objectValue);
        }

        static MetaClassNode create0(RubyContext context, SourceSection sourceSection, RubyNode object) {
            return new MetaClassUninitializedNode(context, sourceSection, object);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    private static abstract class MetaClassBaseNode
    extends MetaClassNode
    implements DSLNode {
        @Node.Child
        protected RubyNode object;
        @Node.Child
        protected MetaClassBaseNode next0;

        MetaClassBaseNode(RubyContext context, SourceSection sourceSection, RubyNode object) {
            super(context, sourceSection);
            this.object = object;
        }

        MetaClassBaseNode(MetaClassBaseNode copy) {
            super(copy);
        }

        protected abstract RubyClass executeChained0(VirtualFrame var1, Object var2);

        protected final RubyClass rewrite0(VirtualFrame frameValue, Object objectValue, String reason) {
            String message;
            MetaClassBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            MetaClassBaseNode newNode = this.specialize0(objectValue);
            if (newNode == null) {
                newNode = new MetaClassUninitializedNode(this);
                ((MetaClassUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (MetaClassBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MetaClassBaseNode.createInfo0(reason, objectValue)))) == null) {
                returnNode = (MetaClassBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MetaClassUninitializedNode(this), (Node)new MetaClassPolymorphicNode(this), (DSLNode)((MetaClassBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, objectValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final MetaClassBaseNode specialize0(Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(objectValue)) {
                boolean objectValueCast = RubyTypesGen.RUBYTYPES.asBoolean(objectValue);
                if (super.isTrue(objectValueCast)) {
                    return (MetaClassBaseNode)MetaClassBoolean0Node.create0(this);
                }
                return (MetaClassBaseNode)MetaClassBoolean1Node.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isInteger(objectValue)) {
                return (MetaClassBaseNode)MetaClassIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(objectValue)) {
                return (MetaClassBaseNode)MetaClassLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(objectValue)) {
                return (MetaClassBaseNode)MetaClassDoubleNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(objectValue)) {
                return (MetaClassBaseNode)MetaClassRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.object = other == null ? null : ((MetaClassBaseNode)other).object;
            this.next0 = newNext == null ? null : (MetaClassBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object objectValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("objectValue").append(" = ").append(objectValue);
                if (objectValue != null) {
                    builder.append(" (").append(objectValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

