/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.literal.HashLiteralNode;
import org.jruby.truffle.nodes.methods.MarkerNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;

public class ReadKeywordRestArgumentNode
extends RubyNode {
    private final int minimum;
    private final String[] excludedKeywords;
    private final int kwIndex;

    public ReadKeywordRestArgumentNode(RubyContext context, SourceSection sourceSection, int minimum, String[] excludedKeywords, int kwIndex) {
        super(context, sourceSection);
        this.minimum = minimum;
        this.excludedKeywords = excludedKeywords;
        this.kwIndex = kwIndex;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (RubyArguments.isKwOptimized(frame.getArguments())) {
            Object restHash = RubyArguments.getOptimizedKeywordArgument(frame.getArguments(), this.kwIndex);
            if (restHash instanceof MarkerNode.Marker) {
                return HashLiteralNode.create(this.getContext(), null, new RubyNode[0]).execute(frame);
            }
            return restHash;
        }
        return this.lookupRestKeywordArgumentHash(frame);
    }

    private Object lookupRestKeywordArgumentHash(VirtualFrame frame) {
        ReadKeywordRestArgumentNode.notDesignedForCompilation();
        RubyHash hash = RubyArguments.getUserKeywordsHash(frame.getArguments(), this.minimum);
        if (hash == null) {
            return new RubyHash(this.getContext().getCoreLibrary().getHashClass(), null, null, null, 0, null);
        }
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        block0: for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash)) {
            for (String excludedKeyword : this.excludedKeywords) {
                if (excludedKeyword.equals(keyValue.getKey().toString())) continue block0;
            }
            entries.add(new KeyValue(keyValue.getKey(), keyValue.getValue()));
        }
        return HashOperations.verySlowFromEntries(this.getContext(), entries, hash.isCompareByIdentity());
    }
}

