/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.ByteList;

public class StringLiteralNode
extends RubyNode {
    private final ByteList bytes;
    private final int codeRange;

    public StringLiteralNode(RubyContext context, SourceSection sourceSection, ByteList bytes, int codeRange) {
        super(context, sourceSection);
        assert (bytes != null);
        this.bytes = bytes;
        this.codeRange = codeRange;
    }

    @Override
    public RubyString execute(VirtualFrame frame) {
        RubyString string = new RubyString(this.getContext().getCoreLibrary().getStringClass(), this.bytes.dup());
        string.setCodeRange(this.codeRange);
        return string;
    }
}

