/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.concurrent.Callable;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.dispatch.CachedBooleanDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedMethodMissingDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedReturnMissingDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedSymbolDispatchNode;
import org.jruby.truffle.nodes.dispatch.CachedUnboxedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.dispatch.UncachedDispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;

public final class UnresolvedDispatchNode
extends DispatchNode {
    private int depth = 0;
    private final boolean ignoreVisibility;
    private final boolean indirect;
    private final MissingBehavior missingBehavior;
    @Node.Child
    private KernelNodes.RequireNode requireNode;

    public UnresolvedDispatchNode(RubyContext context, boolean ignoreVisibility, boolean indirect, MissingBehavior missingBehavior, DispatchAction dispatchAction) {
        super(context, dispatchAction);
        this.ignoreVisibility = ignoreVisibility;
        this.indirect = indirect;
        this.missingBehavior = missingBehavior;
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return false;
    }

    @Override
    public Object executeDispatch(final VirtualFrame frame, final Object receiverObject, final Object methodName, Object blockObject, final Object argumentsObjects) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        DispatchNode dispatch = (DispatchNode)((Object)this.atomic(new Callable<DispatchNode>(){

            @Override
            public DispatchNode call() throws Exception {
                DispatchNode newDispathNode;
                DispatchNode first;
                for (DispatchNode lookupDispatch = first = UnresolvedDispatchNode.this.getHeadNode().getFirstDispatchNode(); lookupDispatch != null; lookupDispatch = lookupDispatch.getNext()) {
                    if (!lookupDispatch.guard(methodName, receiverObject)) continue;
                    return lookupDispatch;
                }
                if (UnresolvedDispatchNode.this.depth == DispatchNode.DISPATCH_POLYMORPHIC_MAX) {
                    newDispathNode = new UncachedDispatchNode(UnresolvedDispatchNode.this.getContext(), UnresolvedDispatchNode.this.ignoreVisibility, UnresolvedDispatchNode.this.getDispatchAction(), UnresolvedDispatchNode.this.missingBehavior);
                } else {
                    UnresolvedDispatchNode.this.depth++;
                    if (UnresolvedDispatchNode.this.isRubyBasicObject(receiverObject)) {
                        newDispathNode = UnresolvedDispatchNode.this.doRubyBasicObject(frame, first, receiverObject, methodName, argumentsObjects);
                    } else {
                        if (UnresolvedDispatchNode.this.isForeign(receiverObject)) {
                            return UnresolvedDispatchNode.this.createForeign(argumentsObjects, first, methodName);
                        }
                        newDispathNode = UnresolvedDispatchNode.this.doUnboxedObject(frame, first, receiverObject, methodName);
                    }
                }
                first.replace(newDispathNode);
                return newDispathNode;
            }
        }));
        return dispatch.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
    }

    private boolean isForeign(Object receiverObject) {
        return false;
    }

    private DispatchNode createForeign(Object argumentsObjects, DispatchNode first, Object methodName) {
        throw new UnsupportedOperationException();
    }

    private DispatchNode doUnboxedObject(VirtualFrame frame, DispatchNode first, Object receiverObject, Object methodName) {
        DispatchAction dispatchAction = this.getDispatchAction();
        RubyClass callerClass = this.ignoreVisibility ? null : this.getContext().getCoreLibrary().getMetaClass(RubyArguments.getSelf(frame.getArguments()));
        if (dispatchAction == DispatchAction.CALL_METHOD || dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
            InternalMethod method = this.lookup(callerClass, receiverObject, methodName.toString(), this.ignoreVisibility);
            if (method == null) {
                return this.createMethodMissingNode(first, methodName, receiverObject);
            }
            if (receiverObject instanceof Boolean) {
                Assumption falseUnmodifiedAssumption = this.getContext().getCoreLibrary().getFalseClass().getUnmodifiedAssumption();
                InternalMethod falseMethod = this.lookup(callerClass, false, methodName.toString(), this.ignoreVisibility);
                Assumption trueUnmodifiedAssumption = this.getContext().getCoreLibrary().getTrueClass().getUnmodifiedAssumption();
                InternalMethod trueMethod = this.lookup(callerClass, true, methodName.toString(), this.ignoreVisibility);
                if (falseMethod == null && trueMethod == null) {
                    throw new UnsupportedOperationException();
                }
                return new CachedBooleanDispatchNode(this.getContext(), methodName, first, falseUnmodifiedAssumption, null, falseMethod, trueUnmodifiedAssumption, null, trueMethod, this.indirect, this.getDispatchAction());
            }
            return new CachedUnboxedDispatchNode(this.getContext(), methodName, first, receiverObject.getClass(), this.getContext().getCoreLibrary().getLogicalClass(receiverObject).getUnmodifiedAssumption(), null, method, this.indirect, this.getDispatchAction());
        }
        throw new UnsupportedOperationException();
    }

    private DispatchNode doRubyBasicObject(VirtualFrame frame, DispatchNode first, Object receiverObject, Object methodName, Object argumentsObjects) {
        RubyClass callerClass;
        DispatchAction dispatchAction = this.getDispatchAction();
        RubyClass rubyClass = callerClass = this.ignoreVisibility ? null : this.getContext().getCoreLibrary().getMetaClass(RubyArguments.getSelf(frame.getArguments()));
        if (dispatchAction == DispatchAction.CALL_METHOD || dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
            InternalMethod method = this.lookup(callerClass, receiverObject, methodName.toString(), this.ignoreVisibility);
            if (method == null) {
                DispatchNode multilanguage = this.tryMultilanguage(frame, first, methodName, argumentsObjects);
                if (multilanguage != null) {
                    return multilanguage;
                }
                return this.createMethodMissingNode(first, methodName, receiverObject);
            }
            if (receiverObject instanceof RubySymbol) {
                return new CachedBoxedSymbolDispatchNode(this.getContext(), methodName, first, null, method, this.indirect, this.getDispatchAction());
            }
            return new CachedBoxedDispatchNode(this.getContext(), methodName, first, this.getContext().getCoreLibrary().getMetaClass(receiverObject), null, method, this.indirect, this.getDispatchAction());
        }
        if (dispatchAction == DispatchAction.READ_CONSTANT) {
            RubyModule module = (RubyModule)receiverObject;
            RubyConstant constant = this.lookupConstant(module, methodName.toString(), this.ignoreVisibility);
            if (constant == null) {
                return this.createConstantMissingNode(first, methodName, callerClass, module);
            }
            if (constant.isAutoload()) {
                if (this.requireNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.requireNode = (KernelNodes.RequireNode)this.insert(KernelNodesFactory.RequireNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
                }
                this.requireNode.require((RubyString)constant.getValue());
                return this.doRubyBasicObject(frame, first, receiverObject, methodName, argumentsObjects);
            }
            return new CachedBoxedDispatchNode(this.getContext(), methodName, first, module.getSingletonClass(null), module.getUnmodifiedAssumption(), constant.getValue(), null, this.indirect, this.getDispatchAction());
        }
        throw new UnsupportedOperationException();
    }

    private DispatchNode tryMultilanguage(VirtualFrame frame, DispatchNode first, Object methodName, Object argumentsObjects) {
        return null;
    }

    private DispatchNode createConstantMissingNode(DispatchNode first, Object methodName, RubyClass callerClass, RubyBasicObject receiverObject) {
        switch (this.missingBehavior) {
            case RETURN_MISSING: {
                return new CachedBoxedReturnMissingDispatchNode(this.getContext(), methodName, first, receiverObject.getMetaClass(), this.indirect, this.getDispatchAction());
            }
            case CALL_CONST_MISSING: {
                InternalMethod method = this.lookup(callerClass, receiverObject, "const_missing", this.ignoreVisibility);
                if (method == null) {
                    throw new RaiseException(this.getContext().getCoreLibrary().runtimeError(receiverObject.toString() + " didn't have a #const_missing", this));
                }
                if (DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED) {
                    return new UncachedDispatchNode(this.getContext(), this.ignoreVisibility, this.getDispatchAction(), this.missingBehavior);
                }
                return new CachedBoxedMethodMissingDispatchNode(this.getContext(), methodName, first, receiverObject.getMetaClass(), method, DISPATCH_METAPROGRAMMING_ALWAYS_INDIRECT, this.getDispatchAction());
            }
        }
        throw new UnsupportedOperationException(this.missingBehavior.toString());
    }

    private DispatchNode createMethodMissingNode(DispatchNode first, Object methodName, Object receiverObject) {
        switch (this.missingBehavior) {
            case RETURN_MISSING: {
                return new CachedBoxedReturnMissingDispatchNode(this.getContext(), methodName, first, this.getContext().getCoreLibrary().getMetaClass(receiverObject), this.indirect, this.getDispatchAction());
            }
            case CALL_METHOD_MISSING: {
                InternalMethod method = this.lookup(null, receiverObject, "method_missing", true);
                if (method == null) {
                    throw new RaiseException(this.getContext().getCoreLibrary().runtimeError(receiverObject.toString() + " didn't have a #method_missing", this));
                }
                if (DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED) {
                    return new UncachedDispatchNode(this.getContext(), this.ignoreVisibility, this.getDispatchAction(), this.missingBehavior);
                }
                return new CachedBoxedMethodMissingDispatchNode(this.getContext(), methodName, first, this.getContext().getCoreLibrary().getMetaClass(receiverObject), method, DISPATCH_METAPROGRAMMING_ALWAYS_INDIRECT, this.getDispatchAction());
            }
        }
        throw new UnsupportedOperationException(this.missingBehavior.toString());
    }
}

