/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.dispatch.UseMethodMissingException;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyProc;

public class CallDispatchHeadNode
extends DispatchHeadNode {
    @Node.Child
    private BooleanCastNode booleanCastNode;

    public CallDispatchHeadNode(RubyContext context, boolean ignoreVisibility, boolean indirect, MissingBehavior missingBehavior, LexicalScope lexicalScope) {
        super(context, ignoreVisibility, indirect, missingBehavior, lexicalScope, DispatchAction.CALL_METHOD);
    }

    public Object call(VirtualFrame frame, Object receiverObject, Object methodName, RubyProc blockObject, Object ... argumentsObjects) {
        return this.dispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
    }

    public boolean callBoolean(VirtualFrame frame, Object receiverObject, Object methodName, RubyProc blockObject, Object ... argumentsObjects) {
        if (this.booleanCastNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeFactory.create(this.context, this.getSourceSection(), null));
        }
        return this.booleanCastNode.executeBoolean(frame, this.dispatch(frame, receiverObject, methodName, blockObject, argumentsObjects));
    }

    public double callFloat(VirtualFrame frame, Object receiverObject, Object methodName, RubyProc blockObject, Object ... argumentsObjects) throws UseMethodMissingException {
        Object value = this.call(frame, receiverObject, methodName, blockObject, argumentsObjects);
        if (this.missingBehavior == MissingBehavior.RETURN_MISSING && value == DispatchNode.MISSING) {
            throw new UseMethodMissingException();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.context.getCoreLibrary().typeErrorCantConvertTo(receiverObject, this.context.getCoreLibrary().getFloatClass(), (String)methodName, value, this));
    }

    public long callLongFixnum(VirtualFrame frame, Object receiverObject, Object methodName, RubyProc blockObject, Object ... argumentsObjects) throws UseMethodMissingException {
        Object value = this.call(frame, receiverObject, methodName, blockObject, argumentsObjects);
        if (this.missingBehavior == MissingBehavior.RETURN_MISSING && value == DispatchNode.MISSING) {
            throw new UseMethodMissingException();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.context.getCoreLibrary().typeErrorCantConvertTo(receiverObject, this.context.getCoreLibrary().getFixnumClass(), (String)methodName, value, this));
    }
}

