/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class CachedBoxedSymbolDispatchNode
extends CachedDispatchNode {
    private final Assumption unmodifiedAssumption;
    private final Object value;
    private final InternalMethod method;
    @Node.Child
    private DirectCallNode callNode;
    @Node.Child
    private IndirectCallNode indirectCallNode;

    public CachedBoxedSymbolDispatchNode(RubyContext context, Object cachedName, DispatchNode next, Object value, InternalMethod method, boolean indirect, DispatchAction dispatchAction) {
        super(context, cachedName, next, indirect, dispatchAction);
        this.unmodifiedAssumption = context.getCoreLibrary().getSymbolClass().getUnmodifiedAssumption();
        this.value = value;
        this.method = method;
        if (method != null) {
            if (indirect) {
                this.indirectCallNode = Truffle.getRuntime().createIndirectCallNode();
            } else {
                this.callNode = Truffle.getRuntime().createDirectCallNode(method.getCallTarget());
                if (this.callNode.isCallTargetCloningAllowed() && method.getSharedMethodInfo().shouldAlwaysSplit()) {
                    this.insert((Node)this.callNode);
                    this.callNode.cloneCallTarget();
                }
            }
        }
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return this.guardName(methodName) && receiver instanceof RubySymbol;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        if (!this.guard(methodName, receiverObject)) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        try {
            this.unmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, (RubyProc)blockObject, argumentsObjects, "class modified");
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                if (this.isIndirect()) {
                    return this.indirectCallNode.call(frame, this.method.getCallTarget(), RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, (RubyProc)blockObject, (Object[])argumentsObjects));
                }
                return this.callNode.call(frame, RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, (RubyProc)blockObject, (Object[])argumentsObjects));
            }
            case RESPOND_TO_METHOD: {
                return true;
            }
            case READ_CONSTANT: {
                return this.value;
            }
        }
        throw new UnsupportedOperationException();
    }
}

