/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.TrueClassNodes;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=TrueClassNodes.class)
public final class TrueClassNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(AndNodeFactory.getInstance(), OrNodeFactory.getInstance(), XorNodeFactory.getInstance());
    }

    @GeneratedBy(value=TrueClassNodes.XorNode.class)
    public static final class XorNodeFactory
    extends NodeFactoryBase<TrueClassNodes.XorNode> {
        private static XorNodeFactory xorNodeFactoryInstance;

        private XorNodeFactory() {
            super(TrueClassNodes.XorNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public TrueClassNodes.XorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return XorNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrueClassNodes.XorNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return XorUninitializedNode.create0(context, sourceSection, operand);
        }

        public static NodeFactory<TrueClassNodes.XorNode> getInstance() {
            if (xorNodeFactoryInstance == null) {
                xorNodeFactoryInstance = new XorNodeFactory();
            }
            return xorNodeFactoryInstance;
        }

        @GeneratedBy(value=TrueClassNodes.XorNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class XorPolymorphicNode
        extends XorBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> operandPolymorphicType;

            XorPolymorphicNode(XorBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object operandValue = this.operand.execute(frameValue);
                return this.next0.executeChained0(frameValue, operandValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.operandPolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                return this.next0.executeChained0(frameValue, operandValue);
            }
        }

        @GeneratedBy(value=TrueClassNodes.XorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class XorBooleanNode
        extends XorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(XorBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

            XorBooleanNode(XorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean operandValue;
                try {
                    operandValue = this.operand.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected operandValue instanceof boolean");
                }
                return super.xor(operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(operandValue)) {
                    boolean operandValueCast = RubyTypesGen.RUBYTYPES.asBoolean(operandValue);
                    return super.xor(operandValueCast);
                }
                return this.next0.executeChained0(frameValue, operandValue);
            }

            static TrueClassNodes.XorNode create0(TrueClassNodes.XorNode current) {
                return new XorBooleanNode((XorBaseNode)current);
            }
        }

        @GeneratedBy(value=TrueClassNodes.XorNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class XorUninitializedNode
        extends XorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(XorUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            XorUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection, operand);
            }

            XorUninitializedNode(XorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object operandValue = this.operand.execute(frameValue);
                return this.executeUninitialized0(frameValue, operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, operandValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object operandValue) {
                XorBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    XorBaseNode rootNode = (XorBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.operand}, new Object[]{operandValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((XorBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, operandValue);
            }

            static TrueClassNodes.XorNode create0(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                return new XorUninitializedNode(context, sourceSection, operand);
            }
        }

        @GeneratedBy(value=TrueClassNodes.XorNode.class)
        private static abstract class XorBaseNode
        extends TrueClassNodes.XorNode
        implements DSLNode {
            @Node.Child
            protected RubyNode operand;
            @Node.Child
            protected XorBaseNode next0;

            XorBaseNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand = super.createCast(operand);
            }

            XorBaseNode(XorBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand;
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object operandValue, String reason) {
                String message;
                XorBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                XorBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    newNode = new XorUninitializedNode(this);
                    ((XorUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (XorBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = XorBaseNode.createInfo0(reason, operandValue)))) == null) {
                    returnNode = (XorBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new XorUninitializedNode(this), (Node)new XorPolymorphicNode(this), (DSLNode)((XorBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, operandValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final XorBaseNode specialize0(Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(operandValue)) {
                    return (XorBaseNode)XorBooleanNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.operand = other == null ? null : ((XorBaseNode)other).operand;
                this.next0 = newNext == null ? null : (XorBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object operandValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("operandValue").append(" = ").append(operandValue);
                    if (operandValue != null) {
                        builder.append(" (").append(operandValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=TrueClassNodes.OrNode.class)
    public static final class OrNodeFactory
    extends NodeFactoryBase<TrueClassNodes.OrNode> {
        private static OrNodeFactory orNodeFactoryInstance;

        private OrNodeFactory() {
            super(TrueClassNodes.OrNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrueClassNodes.OrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return OrNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrueClassNodes.OrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return OrObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<TrueClassNodes.OrNode> getInstance() {
            if (orNodeFactoryInstance == null) {
                orNodeFactoryInstance = new OrNodeFactory();
            }
            return orNodeFactoryInstance;
        }

        @GeneratedBy(value=TrueClassNodes.OrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class OrObjectNode
        extends OrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OrObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            OrObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.or(arguments0Value);
            }

            static TrueClassNodes.OrNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new OrObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=TrueClassNodes.OrNode.class)
        private static abstract class OrBaseNode
        extends TrueClassNodes.OrNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            OrBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((OrBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=TrueClassNodes.AndNode.class)
    public static final class AndNodeFactory
    extends NodeFactoryBase<TrueClassNodes.AndNode> {
        private static AndNodeFactory andNodeFactoryInstance;

        private AndNodeFactory() {
            super(TrueClassNodes.AndNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public TrueClassNodes.AndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return AndNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TrueClassNodes.AndNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return AndUninitializedNode.create0(context, sourceSection, operand);
        }

        public static NodeFactory<TrueClassNodes.AndNode> getInstance() {
            if (andNodeFactoryInstance == null) {
                andNodeFactoryInstance = new AndNodeFactory();
            }
            return andNodeFactoryInstance;
        }

        @GeneratedBy(value=TrueClassNodes.AndNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AndPolymorphicNode
        extends AndBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> operandPolymorphicType;

            AndPolymorphicNode(AndBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object operandValue = this.operand.execute(frameValue);
                return this.next0.executeChained0(frameValue, operandValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.operandPolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                return this.next0.executeChained0(frameValue, operandValue);
            }
        }

        @GeneratedBy(value=TrueClassNodes.AndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AndBooleanNode
        extends AndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AndBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

            AndBooleanNode(AndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean operandValue;
                try {
                    operandValue = this.operand.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected operandValue instanceof boolean");
                }
                return super.and(operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(operandValue)) {
                    boolean operandValueCast = RubyTypesGen.RUBYTYPES.asBoolean(operandValue);
                    return super.and(operandValueCast);
                }
                return this.next0.executeChained0(frameValue, operandValue);
            }

            static TrueClassNodes.AndNode create0(TrueClassNodes.AndNode current) {
                return new AndBooleanNode((AndBaseNode)current);
            }
        }

        @GeneratedBy(value=TrueClassNodes.AndNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AndUninitializedNode
        extends AndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AndUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AndUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection, operand);
            }

            AndUninitializedNode(AndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object operandValue = this.operand.execute(frameValue);
                return this.executeUninitialized0(frameValue, operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, operandValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object operandValue) {
                AndBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AndBaseNode rootNode = (AndBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.operand}, new Object[]{operandValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AndBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, operandValue);
            }

            static TrueClassNodes.AndNode create0(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                return new AndUninitializedNode(context, sourceSection, operand);
            }
        }

        @GeneratedBy(value=TrueClassNodes.AndNode.class)
        private static abstract class AndBaseNode
        extends TrueClassNodes.AndNode
        implements DSLNode {
            @Node.Child
            protected RubyNode operand;
            @Node.Child
            protected AndBaseNode next0;

            AndBaseNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand = super.createCast(operand);
            }

            AndBaseNode(AndBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand;
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object operandValue, String reason) {
                String message;
                AndBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AndBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    newNode = new AndUninitializedNode(this);
                    ((AndUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AndBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AndBaseNode.createInfo0(reason, operandValue)))) == null) {
                    returnNode = (AndBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AndUninitializedNode(this), (Node)new AndPolymorphicNode(this), (DSLNode)((AndBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, operandValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AndBaseNode specialize0(Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(operandValue)) {
                    return (AndBaseNode)AndBooleanNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.operand = other == null ? null : ((AndBaseNode)other).operand;
                this.next0 = newNext == null ? null : (AndBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object operandValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("operandValue").append(" = ").append(operandValue);
                    if (operandValue != null) {
                        builder.append(" (").append(operandValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

