/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.TimeNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyTime;

@GeneratedBy(value=TimeNodes.class)
public final class TimeNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(InternalGMTNodeFactory.getInstance(), InternalSetGMTNodeFactory.getInstance(), InternalOffsetNodeFactory.getInstance(), InternalSetOffsetNodeFactory.getInstance());
    }

    @GeneratedBy(value=TimeNodes.InternalSetOffsetNode.class)
    public static final class InternalSetOffsetNodeFactory
    extends NodeFactoryBase<TimeNodes.InternalSetOffsetNode> {
        private static InternalSetOffsetNodeFactory internalSetOffsetNodeFactoryInstance;

        private InternalSetOffsetNodeFactory() {
            super(TimeNodes.InternalSetOffsetNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public TimeNodes.InternalSetOffsetNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return InternalSetOffsetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TimeNodes.InternalSetOffsetNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode offset) {
            return InternalSetOffsetUninitializedNode.create0(context, sourceSection, self, offset);
        }

        public static NodeFactory<TimeNodes.InternalSetOffsetNode> getInstance() {
            if (internalSetOffsetNodeFactoryInstance == null) {
                internalSetOffsetNodeFactoryInstance = new InternalSetOffsetNodeFactory();
            }
            return internalSetOffsetNodeFactoryInstance;
        }

        @GeneratedBy(value=TimeNodes.InternalSetOffsetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InternalSetOffsetPolymorphicNode
        extends InternalSetOffsetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> selfPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> offsetPolymorphicType;

            InternalSetOffsetPolymorphicNode(InternalSetOffsetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object selfValue = this.self.execute(frameValue);
                Object offsetValue = this.offset.execute(frameValue);
                return this.next0.executeChained0(frameValue, selfValue, offsetValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.selfPolymorphicType = types[0];
                this.offsetPolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object offsetValue) {
                return this.next0.executeChained0(frameValue, selfValue, offsetValue);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalSetOffsetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InternalSetOffsetRubyTimeNode
        extends InternalSetOffsetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InternalSetOffsetRubyTimeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyTime.class, Object.class}, 0, 0);

            InternalSetOffsetRubyTimeNode(InternalSetOffsetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyTime selfValue;
                try {
                    selfValue = this.self.executeRubyTime(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object offsetValue = this.offset.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), offsetValue, "Expected selfValue instanceof RubyTime");
                }
                Object offsetValue = this.offset.execute(frameValue);
                return super.internalSetOffset(selfValue, offsetValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object offsetValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyTime(selfValue)) {
                    RubyTime selfValueCast = RubyTypesGen.RUBYTYPES.asRubyTime(selfValue);
                    return super.internalSetOffset(selfValueCast, offsetValue);
                }
                return this.next0.executeChained0(frameValue, selfValue, offsetValue);
            }

            static TimeNodes.InternalSetOffsetNode create0(TimeNodes.InternalSetOffsetNode current) {
                return new InternalSetOffsetRubyTimeNode((InternalSetOffsetBaseNode)current);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalSetOffsetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InternalSetOffsetUninitializedNode
        extends InternalSetOffsetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InternalSetOffsetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InternalSetOffsetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode offset) {
                super(context, sourceSection, self, offset);
            }

            InternalSetOffsetUninitializedNode(InternalSetOffsetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object selfValue = this.self.execute(frameValue);
                Object offsetValue = this.offset.execute(frameValue);
                return this.executeUninitialized0(frameValue, selfValue, offsetValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue, Object offsetValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, selfValue, offsetValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object selfValue, Object offsetValue) {
                InternalSetOffsetBaseNode newNode = this.specialize0(selfValue, offsetValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InternalSetOffsetBaseNode rootNode = (InternalSetOffsetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.self, rootNode.offset}, new Object[]{selfValue, offsetValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InternalSetOffsetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, selfValue, offsetValue);
            }

            static TimeNodes.InternalSetOffsetNode create0(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode offset) {
                return new InternalSetOffsetUninitializedNode(context, sourceSection, self, offset);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalSetOffsetNode.class)
        private static abstract class InternalSetOffsetBaseNode
        extends TimeNodes.InternalSetOffsetNode
        implements DSLNode {
            @Node.Child
            protected RubyNode self;
            @Node.Child
            protected RubyNode offset;
            @Node.Child
            protected InternalSetOffsetBaseNode next0;

            InternalSetOffsetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode offset) {
                super(context, sourceSection);
                this.self = self;
                this.offset = offset;
            }

            InternalSetOffsetBaseNode(InternalSetOffsetBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object selfValue, Object offsetValue, String reason) {
                String message;
                InternalSetOffsetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InternalSetOffsetBaseNode newNode = this.specialize0(selfValue, offsetValue);
                if (newNode == null) {
                    newNode = new InternalSetOffsetUninitializedNode(this);
                    ((InternalSetOffsetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InternalSetOffsetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InternalSetOffsetBaseNode.createInfo0(reason, selfValue, offsetValue)))) == null) {
                    returnNode = (InternalSetOffsetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InternalSetOffsetUninitializedNode(this), (Node)new InternalSetOffsetPolymorphicNode(this), (DSLNode)((InternalSetOffsetBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, selfValue, offsetValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InternalSetOffsetBaseNode specialize0(Object selfValue, Object offsetValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyTime(selfValue)) {
                    return (InternalSetOffsetBaseNode)InternalSetOffsetRubyTimeNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.self = null;
                    this.offset = null;
                } else {
                    InternalSetOffsetBaseNode otherCast = (InternalSetOffsetBaseNode)other;
                    this.self = otherCast.self;
                    this.offset = otherCast.offset;
                }
                this.next0 = newNext == null ? null : (InternalSetOffsetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object selfValue, Object offsetValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("selfValue").append(" = ").append(selfValue);
                    if (selfValue != null) {
                        builder.append(" (").append(selfValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("offsetValue").append(" = ").append(offsetValue);
                    if (offsetValue != null) {
                        builder.append(" (").append(offsetValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=TimeNodes.InternalOffsetNode.class)
    public static final class InternalOffsetNodeFactory
    extends NodeFactoryBase<TimeNodes.InternalOffsetNode> {
        private static InternalOffsetNodeFactory internalOffsetNodeFactoryInstance;

        private InternalOffsetNodeFactory() {
            super(TimeNodes.InternalOffsetNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public TimeNodes.InternalOffsetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return InternalOffsetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TimeNodes.InternalOffsetNode create(RubyContext context, SourceSection sourceSection, RubyNode self) {
            return InternalOffsetUninitializedNode.create0(context, sourceSection, self);
        }

        public static NodeFactory<TimeNodes.InternalOffsetNode> getInstance() {
            if (internalOffsetNodeFactoryInstance == null) {
                internalOffsetNodeFactoryInstance = new InternalOffsetNodeFactory();
            }
            return internalOffsetNodeFactoryInstance;
        }

        @GeneratedBy(value=TimeNodes.InternalOffsetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InternalOffsetPolymorphicNode
        extends InternalOffsetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> selfPolymorphicType;

            InternalOffsetPolymorphicNode(InternalOffsetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object selfValue = this.self.execute(frameValue);
                return this.next0.executeChained0(frameValue, selfValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.selfPolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue) {
                return this.next0.executeChained0(frameValue, selfValue);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalOffsetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InternalOffsetRubyTimeNode
        extends InternalOffsetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InternalOffsetRubyTimeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyTime.class}, 0, 0);

            InternalOffsetRubyTimeNode(InternalOffsetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyTime selfValue;
                try {
                    selfValue = this.self.executeRubyTime(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected selfValue instanceof RubyTime");
                }
                return super.internalOffset(selfValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyTime(selfValue)) {
                    RubyTime selfValueCast = RubyTypesGen.RUBYTYPES.asRubyTime(selfValue);
                    return super.internalOffset(selfValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue);
            }

            static TimeNodes.InternalOffsetNode create0(TimeNodes.InternalOffsetNode current) {
                return new InternalOffsetRubyTimeNode((InternalOffsetBaseNode)current);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalOffsetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InternalOffsetUninitializedNode
        extends InternalOffsetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InternalOffsetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InternalOffsetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode self) {
                super(context, sourceSection, self);
            }

            InternalOffsetUninitializedNode(InternalOffsetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object selfValue = this.self.execute(frameValue);
                return this.executeUninitialized0(frameValue, selfValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object selfValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, selfValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object selfValue) {
                InternalOffsetBaseNode newNode = this.specialize0(selfValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InternalOffsetBaseNode rootNode = (InternalOffsetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.self}, new Object[]{selfValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InternalOffsetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, selfValue);
            }

            static TimeNodes.InternalOffsetNode create0(RubyContext context, SourceSection sourceSection, RubyNode self) {
                return new InternalOffsetUninitializedNode(context, sourceSection, self);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalOffsetNode.class)
        private static abstract class InternalOffsetBaseNode
        extends TimeNodes.InternalOffsetNode
        implements DSLNode {
            @Node.Child
            protected RubyNode self;
            @Node.Child
            protected InternalOffsetBaseNode next0;

            InternalOffsetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode self) {
                super(context, sourceSection);
                this.self = self;
            }

            InternalOffsetBaseNode(InternalOffsetBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object selfValue, String reason) {
                String message;
                InternalOffsetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InternalOffsetBaseNode newNode = this.specialize0(selfValue);
                if (newNode == null) {
                    newNode = new InternalOffsetUninitializedNode(this);
                    ((InternalOffsetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InternalOffsetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InternalOffsetBaseNode.createInfo0(reason, selfValue)))) == null) {
                    returnNode = (InternalOffsetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InternalOffsetUninitializedNode(this), (Node)new InternalOffsetPolymorphicNode(this), (DSLNode)((InternalOffsetBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, selfValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InternalOffsetBaseNode specialize0(Object selfValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyTime(selfValue)) {
                    return (InternalOffsetBaseNode)InternalOffsetRubyTimeNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.self = other == null ? null : ((InternalOffsetBaseNode)other).self;
                this.next0 = newNext == null ? null : (InternalOffsetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object selfValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("selfValue").append(" = ").append(selfValue);
                    if (selfValue != null) {
                        builder.append(" (").append(selfValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=TimeNodes.InternalSetGMTNode.class)
    public static final class InternalSetGMTNodeFactory
    extends NodeFactoryBase<TimeNodes.InternalSetGMTNode> {
        private static InternalSetGMTNodeFactory internalSetGMTNodeFactoryInstance;

        private InternalSetGMTNodeFactory() {
            super(TimeNodes.InternalSetGMTNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public TimeNodes.InternalSetGMTNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return InternalSetGMTNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TimeNodes.InternalSetGMTNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode isGMT) {
            return InternalSetGMTUninitializedNode.create0(context, sourceSection, self, isGMT);
        }

        public static NodeFactory<TimeNodes.InternalSetGMTNode> getInstance() {
            if (internalSetGMTNodeFactoryInstance == null) {
                internalSetGMTNodeFactoryInstance = new InternalSetGMTNodeFactory();
            }
            return internalSetGMTNodeFactoryInstance;
        }

        @GeneratedBy(value=TimeNodes.InternalSetGMTNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InternalSetGMTPolymorphicNode
        extends InternalSetGMTBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> selfPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> isGMTPolymorphicType;

            InternalSetGMTPolymorphicNode(InternalSetGMTBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object selfValue = this.self.execute(frameValue);
                Object isGMTValue = this.isGMT.execute(frameValue);
                return this.next0.executeChained0(frameValue, selfValue, isGMTValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.selfPolymorphicType = types[0];
                this.isGMTPolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object selfValue, Object isGMTValue) {
                return this.next0.executeChained0(frameValue, selfValue, isGMTValue);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalSetGMTNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InternalSetGMTRubyTimeNode
        extends InternalSetGMTBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InternalSetGMTRubyTimeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyTime.class, Boolean.TYPE}, 0, 0);

            InternalSetGMTRubyTimeNode(InternalSetGMTBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean isGMTValue;
                RubyTime selfValue;
                try {
                    selfValue = this.self.executeRubyTime(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object isGMTValue2 = this.isGMT.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), isGMTValue2, "Expected selfValue instanceof RubyTime");
                }
                try {
                    isGMTValue = this.isGMT.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, selfValue, ex.getResult(), "Expected isGMTValue instanceof boolean");
                }
                return super.internalSetGMT(selfValue, isGMTValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object selfValue, Object isGMTValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyTime(selfValue) && RubyTypesGen.RUBYTYPES.isBoolean(isGMTValue)) {
                    RubyTime selfValueCast = RubyTypesGen.RUBYTYPES.asRubyTime(selfValue);
                    boolean isGMTValueCast = RubyTypesGen.RUBYTYPES.asBoolean(isGMTValue);
                    return super.internalSetGMT(selfValueCast, isGMTValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue, isGMTValue);
            }

            static TimeNodes.InternalSetGMTNode create0(TimeNodes.InternalSetGMTNode current) {
                return new InternalSetGMTRubyTimeNode((InternalSetGMTBaseNode)current);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalSetGMTNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InternalSetGMTUninitializedNode
        extends InternalSetGMTBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InternalSetGMTUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InternalSetGMTUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode isGMT) {
                super(context, sourceSection, self, isGMT);
            }

            InternalSetGMTUninitializedNode(InternalSetGMTBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object selfValue = this.self.execute(frameValue);
                Object isGMTValue = this.isGMT.execute(frameValue);
                return this.executeUninitialized0(frameValue, selfValue, isGMTValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object selfValue, Object isGMTValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, selfValue, isGMTValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object selfValue, Object isGMTValue) {
                InternalSetGMTBaseNode newNode = this.specialize0(selfValue, isGMTValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InternalSetGMTBaseNode rootNode = (InternalSetGMTBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.self, rootNode.isGMT}, new Object[]{selfValue, isGMTValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InternalSetGMTBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, selfValue, isGMTValue);
            }

            static TimeNodes.InternalSetGMTNode create0(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode isGMT) {
                return new InternalSetGMTUninitializedNode(context, sourceSection, self, isGMT);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalSetGMTNode.class)
        private static abstract class InternalSetGMTBaseNode
        extends TimeNodes.InternalSetGMTNode
        implements DSLNode {
            @Node.Child
            protected RubyNode self;
            @Node.Child
            protected RubyNode isGMT;
            @Node.Child
            protected InternalSetGMTBaseNode next0;

            InternalSetGMTBaseNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode isGMT) {
                super(context, sourceSection);
                this.self = self;
                this.isGMT = isGMT;
            }

            InternalSetGMTBaseNode(InternalSetGMTBaseNode copy) {
                super(copy);
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object selfValue, Object isGMTValue, String reason) {
                String message;
                InternalSetGMTBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InternalSetGMTBaseNode newNode = this.specialize0(selfValue, isGMTValue);
                if (newNode == null) {
                    newNode = new InternalSetGMTUninitializedNode(this);
                    ((InternalSetGMTUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InternalSetGMTBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InternalSetGMTBaseNode.createInfo0(reason, selfValue, isGMTValue)))) == null) {
                    returnNode = (InternalSetGMTBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InternalSetGMTUninitializedNode(this), (Node)new InternalSetGMTPolymorphicNode(this), (DSLNode)((InternalSetGMTBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, selfValue, isGMTValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InternalSetGMTBaseNode specialize0(Object selfValue, Object isGMTValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyTime(selfValue) && RubyTypesGen.RUBYTYPES.isBoolean(isGMTValue)) {
                    return (InternalSetGMTBaseNode)InternalSetGMTRubyTimeNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.self = null;
                    this.isGMT = null;
                } else {
                    InternalSetGMTBaseNode otherCast = (InternalSetGMTBaseNode)other;
                    this.self = otherCast.self;
                    this.isGMT = otherCast.isGMT;
                }
                this.next0 = newNext == null ? null : (InternalSetGMTBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object selfValue, Object isGMTValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("selfValue").append(" = ").append(selfValue);
                    if (selfValue != null) {
                        builder.append(" (").append(selfValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("isGMTValue").append(" = ").append(isGMTValue);
                    if (isGMTValue != null) {
                        builder.append(" (").append(isGMTValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=TimeNodes.InternalGMTNode.class)
    public static final class InternalGMTNodeFactory
    extends NodeFactoryBase<TimeNodes.InternalGMTNode> {
        private static InternalGMTNodeFactory internalGMTNodeFactoryInstance;

        private InternalGMTNodeFactory() {
            super(TimeNodes.InternalGMTNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public TimeNodes.InternalGMTNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return InternalGMTNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static TimeNodes.InternalGMTNode create(RubyContext context, SourceSection sourceSection, RubyNode self) {
            return InternalGMTUninitializedNode.create0(context, sourceSection, self);
        }

        public static NodeFactory<TimeNodes.InternalGMTNode> getInstance() {
            if (internalGMTNodeFactoryInstance == null) {
                internalGMTNodeFactoryInstance = new InternalGMTNodeFactory();
            }
            return internalGMTNodeFactoryInstance;
        }

        @GeneratedBy(value=TimeNodes.InternalGMTNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InternalGMTPolymorphicNode
        extends InternalGMTBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> selfPolymorphicType;

            InternalGMTPolymorphicNode(InternalGMTBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object selfValue = this.self.execute(frameValue);
                return this.next0.executeChained0(frameValue, selfValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.selfPolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object selfValue) {
                return this.next0.executeChained0(frameValue, selfValue);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalGMTNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InternalGMTRubyTimeNode
        extends InternalGMTBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InternalGMTRubyTimeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyTime.class}, 0, 0);

            InternalGMTRubyTimeNode(InternalGMTBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyTime selfValue;
                try {
                    selfValue = this.self.executeRubyTime(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected selfValue instanceof RubyTime");
                }
                return super.internalGMT(selfValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object selfValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyTime(selfValue)) {
                    RubyTime selfValueCast = RubyTypesGen.RUBYTYPES.asRubyTime(selfValue);
                    return super.internalGMT(selfValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue);
            }

            static TimeNodes.InternalGMTNode create0(TimeNodes.InternalGMTNode current) {
                return new InternalGMTRubyTimeNode((InternalGMTBaseNode)current);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalGMTNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InternalGMTUninitializedNode
        extends InternalGMTBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InternalGMTUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InternalGMTUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode self) {
                super(context, sourceSection, self);
            }

            InternalGMTUninitializedNode(InternalGMTBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object selfValue = this.self.execute(frameValue);
                return this.executeUninitialized0(frameValue, selfValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object selfValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, selfValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object selfValue) {
                InternalGMTBaseNode newNode = this.specialize0(selfValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InternalGMTBaseNode rootNode = (InternalGMTBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.self}, new Object[]{selfValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InternalGMTBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, selfValue);
            }

            static TimeNodes.InternalGMTNode create0(RubyContext context, SourceSection sourceSection, RubyNode self) {
                return new InternalGMTUninitializedNode(context, sourceSection, self);
            }
        }

        @GeneratedBy(value=TimeNodes.InternalGMTNode.class)
        private static abstract class InternalGMTBaseNode
        extends TimeNodes.InternalGMTNode
        implements DSLNode {
            @Node.Child
            protected RubyNode self;
            @Node.Child
            protected InternalGMTBaseNode next0;

            InternalGMTBaseNode(RubyContext context, SourceSection sourceSection, RubyNode self) {
                super(context, sourceSection);
                this.self = self;
            }

            InternalGMTBaseNode(InternalGMTBaseNode copy) {
                super(copy);
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object selfValue, String reason) {
                String message;
                InternalGMTBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InternalGMTBaseNode newNode = this.specialize0(selfValue);
                if (newNode == null) {
                    newNode = new InternalGMTUninitializedNode(this);
                    ((InternalGMTUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InternalGMTBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InternalGMTBaseNode.createInfo0(reason, selfValue)))) == null) {
                    returnNode = (InternalGMTBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InternalGMTUninitializedNode(this), (Node)new InternalGMTPolymorphicNode(this), (DSLNode)((InternalGMTBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, selfValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InternalGMTBaseNode specialize0(Object selfValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyTime(selfValue)) {
                    return (InternalGMTBaseNode)InternalGMTRubyTimeNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.self = other == null ? null : ((InternalGMTBaseNode)other).self;
                this.next0 = newNext == null ? null : (InternalGMTBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object selfValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("selfValue").append(" = ").append(selfValue);
                    if (selfValue != null) {
                        builder.append(" (").append(selfValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

