/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.MutexNodes;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=MutexNodes.class)
public final class MutexNodesFactory {
    public static List<NodeFactory<? extends UnaryCoreMethodNode>> getFactories() {
        return Arrays.asList(LockNodeFactory.getInstance(), IsLockedNodeFactory.getInstance(), IsOwnedNodeFactory.getInstance(), TryLockNodeFactory.getInstance(), UnlockNodeFactory.getInstance());
    }

    @GeneratedBy(value=MutexNodes.UnlockNode.class)
    public static final class UnlockNodeFactory
    extends NodeFactoryBase<MutexNodes.UnlockNode> {
        private static UnlockNodeFactory unlockNodeFactoryInstance;

        private UnlockNodeFactory() {
            super(MutexNodes.UnlockNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.UnlockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return UnlockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MutexNodes.UnlockNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return UnlockUninitializedNode.create0(context, sourceSection, operand);
        }

        public static NodeFactory<MutexNodes.UnlockNode> getInstance() {
            if (unlockNodeFactoryInstance == null) {
                unlockNodeFactoryInstance = new UnlockNodeFactory();
            }
            return unlockNodeFactoryInstance;
        }

        @GeneratedBy(value=MutexNodes.UnlockNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UnlockPolymorphicNode
        extends UnlockBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> operandPolymorphicType;

            UnlockPolymorphicNode(UnlockBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object operandValue = this.operand.execute(frameValue);
                return this.next0.executeChained0(frameValue, operandValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.operandPolymorphicType = types[0];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object operandValue) {
                return this.next0.executeChained0(frameValue, operandValue);
            }
        }

        @GeneratedBy(value=MutexNodes.UnlockNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UnlockRubyBasicObjectNode
        extends UnlockBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnlockRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            UnlockRubyBasicObjectNode(UnlockBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject operandValue;
                try {
                    operandValue = this.operand.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected operandValue instanceof RubyBasicObject");
                }
                return super.unlock(operandValue);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    RubyBasicObject operandValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(operandValue);
                    return super.unlock(operandValueCast);
                }
                return this.next0.executeChained0(frameValue, operandValue);
            }

            static MutexNodes.UnlockNode create0(MutexNodes.UnlockNode current) {
                return new UnlockRubyBasicObjectNode((UnlockBaseNode)current);
            }
        }

        @GeneratedBy(value=MutexNodes.UnlockNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UnlockUninitializedNode
        extends UnlockBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnlockUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UnlockUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection, operand);
            }

            UnlockUninitializedNode(UnlockBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object operandValue = this.operand.execute(frameValue);
                return this.executeUninitialized0(frameValue, operandValue);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, operandValue);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object operandValue) {
                UnlockBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UnlockBaseNode rootNode = (UnlockBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.operand}, new Object[]{operandValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UnlockBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, operandValue);
            }

            static MutexNodes.UnlockNode create0(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                return new UnlockUninitializedNode(context, sourceSection, operand);
            }
        }

        @GeneratedBy(value=MutexNodes.UnlockNode.class)
        private static abstract class UnlockBaseNode
        extends MutexNodes.UnlockNode
        implements DSLNode {
            @Node.Child
            protected RubyNode operand;
            @Node.Child
            protected UnlockBaseNode next0;

            UnlockBaseNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand = operand;
            }

            UnlockBaseNode(UnlockBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand;
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object operandValue, String reason) {
                String message;
                UnlockBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UnlockBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    newNode = new UnlockUninitializedNode(this);
                    ((UnlockUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UnlockBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = UnlockBaseNode.createInfo0(reason, operandValue)))) == null) {
                    returnNode = (UnlockBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UnlockUninitializedNode(this), (Node)new UnlockPolymorphicNode(this), (DSLNode)((UnlockBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, operandValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UnlockBaseNode specialize0(Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    return (UnlockBaseNode)UnlockRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.operand = other == null ? null : ((UnlockBaseNode)other).operand;
                this.next0 = newNext == null ? null : (UnlockBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object operandValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("operandValue").append(" = ").append(operandValue);
                    if (operandValue != null) {
                        builder.append(" (").append(operandValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MutexNodes.TryLockNode.class)
    public static final class TryLockNodeFactory
    extends NodeFactoryBase<MutexNodes.TryLockNode> {
        private static TryLockNodeFactory tryLockNodeFactoryInstance;

        private TryLockNodeFactory() {
            super(MutexNodes.TryLockNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.TryLockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return TryLockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MutexNodes.TryLockNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return TryLockUninitializedNode.create0(context, sourceSection, operand);
        }

        public static NodeFactory<MutexNodes.TryLockNode> getInstance() {
            if (tryLockNodeFactoryInstance == null) {
                tryLockNodeFactoryInstance = new TryLockNodeFactory();
            }
            return tryLockNodeFactoryInstance;
        }

        @GeneratedBy(value=MutexNodes.TryLockNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class TryLockPolymorphicNode
        extends TryLockBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> operandPolymorphicType;

            TryLockPolymorphicNode(TryLockBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object operandValue = this.operand.execute(frameValue);
                return this.next0.executeChained0(frameValue, operandValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.operandPolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                return this.next0.executeChained0(frameValue, operandValue);
            }
        }

        @GeneratedBy(value=MutexNodes.TryLockNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TryLockRubyBasicObjectNode
        extends TryLockBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TryLockRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            TryLockRubyBasicObjectNode(TryLockBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject operandValue;
                try {
                    operandValue = this.operand.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected operandValue instanceof RubyBasicObject");
                }
                return super.tryLock(operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    RubyBasicObject operandValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(operandValue);
                    return super.tryLock(operandValueCast);
                }
                return this.next0.executeChained0(frameValue, operandValue);
            }

            static MutexNodes.TryLockNode create0(MutexNodes.TryLockNode current) {
                return new TryLockRubyBasicObjectNode((TryLockBaseNode)current);
            }
        }

        @GeneratedBy(value=MutexNodes.TryLockNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class TryLockUninitializedNode
        extends TryLockBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TryLockUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            TryLockUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection, operand);
            }

            TryLockUninitializedNode(TryLockBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object operandValue = this.operand.execute(frameValue);
                return this.executeUninitialized0(frameValue, operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, operandValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object operandValue) {
                TryLockBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    TryLockBaseNode rootNode = (TryLockBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.operand}, new Object[]{operandValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((TryLockBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, operandValue);
            }

            static MutexNodes.TryLockNode create0(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                return new TryLockUninitializedNode(context, sourceSection, operand);
            }
        }

        @GeneratedBy(value=MutexNodes.TryLockNode.class)
        private static abstract class TryLockBaseNode
        extends MutexNodes.TryLockNode
        implements DSLNode {
            @Node.Child
            protected RubyNode operand;
            @Node.Child
            protected TryLockBaseNode next0;

            TryLockBaseNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand = operand;
            }

            TryLockBaseNode(TryLockBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand;
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object operandValue, String reason) {
                String message;
                TryLockBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                TryLockBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    newNode = new TryLockUninitializedNode(this);
                    ((TryLockUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (TryLockBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = TryLockBaseNode.createInfo0(reason, operandValue)))) == null) {
                    returnNode = (TryLockBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new TryLockUninitializedNode(this), (Node)new TryLockPolymorphicNode(this), (DSLNode)((TryLockBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, operandValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final TryLockBaseNode specialize0(Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    return (TryLockBaseNode)TryLockRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.operand = other == null ? null : ((TryLockBaseNode)other).operand;
                this.next0 = newNext == null ? null : (TryLockBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object operandValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("operandValue").append(" = ").append(operandValue);
                    if (operandValue != null) {
                        builder.append(" (").append(operandValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MutexNodes.IsOwnedNode.class)
    public static final class IsOwnedNodeFactory
    extends NodeFactoryBase<MutexNodes.IsOwnedNode> {
        private static IsOwnedNodeFactory isOwnedNodeFactoryInstance;

        private IsOwnedNodeFactory() {
            super(MutexNodes.IsOwnedNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.IsOwnedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return IsOwnedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MutexNodes.IsOwnedNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return IsOwnedUninitializedNode.create0(context, sourceSection, operand);
        }

        public static NodeFactory<MutexNodes.IsOwnedNode> getInstance() {
            if (isOwnedNodeFactoryInstance == null) {
                isOwnedNodeFactoryInstance = new IsOwnedNodeFactory();
            }
            return isOwnedNodeFactoryInstance;
        }

        @GeneratedBy(value=MutexNodes.IsOwnedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IsOwnedPolymorphicNode
        extends IsOwnedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> operandPolymorphicType;

            IsOwnedPolymorphicNode(IsOwnedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object operandValue = this.operand.execute(frameValue);
                return this.next0.executeChained0(frameValue, operandValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.operandPolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                return this.next0.executeChained0(frameValue, operandValue);
            }
        }

        @GeneratedBy(value=MutexNodes.IsOwnedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsOwnedRubyBasicObjectNode
        extends IsOwnedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsOwnedRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            IsOwnedRubyBasicObjectNode(IsOwnedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject operandValue;
                try {
                    operandValue = this.operand.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected operandValue instanceof RubyBasicObject");
                }
                return super.isOwned(operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    RubyBasicObject operandValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(operandValue);
                    return super.isOwned(operandValueCast);
                }
                return this.next0.executeChained0(frameValue, operandValue);
            }

            static MutexNodes.IsOwnedNode create0(MutexNodes.IsOwnedNode current) {
                return new IsOwnedRubyBasicObjectNode((IsOwnedBaseNode)current);
            }
        }

        @GeneratedBy(value=MutexNodes.IsOwnedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IsOwnedUninitializedNode
        extends IsOwnedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsOwnedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IsOwnedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection, operand);
            }

            IsOwnedUninitializedNode(IsOwnedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object operandValue = this.operand.execute(frameValue);
                return this.executeUninitialized0(frameValue, operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, operandValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object operandValue) {
                IsOwnedBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IsOwnedBaseNode rootNode = (IsOwnedBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.operand}, new Object[]{operandValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IsOwnedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, operandValue);
            }

            static MutexNodes.IsOwnedNode create0(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                return new IsOwnedUninitializedNode(context, sourceSection, operand);
            }
        }

        @GeneratedBy(value=MutexNodes.IsOwnedNode.class)
        private static abstract class IsOwnedBaseNode
        extends MutexNodes.IsOwnedNode
        implements DSLNode {
            @Node.Child
            protected RubyNode operand;
            @Node.Child
            protected IsOwnedBaseNode next0;

            IsOwnedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand = operand;
            }

            IsOwnedBaseNode(IsOwnedBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand;
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object operandValue, String reason) {
                String message;
                IsOwnedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IsOwnedBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    newNode = new IsOwnedUninitializedNode(this);
                    ((IsOwnedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IsOwnedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IsOwnedBaseNode.createInfo0(reason, operandValue)))) == null) {
                    returnNode = (IsOwnedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IsOwnedUninitializedNode(this), (Node)new IsOwnedPolymorphicNode(this), (DSLNode)((IsOwnedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, operandValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IsOwnedBaseNode specialize0(Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    return (IsOwnedBaseNode)IsOwnedRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.operand = other == null ? null : ((IsOwnedBaseNode)other).operand;
                this.next0 = newNext == null ? null : (IsOwnedBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object operandValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("operandValue").append(" = ").append(operandValue);
                    if (operandValue != null) {
                        builder.append(" (").append(operandValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MutexNodes.IsLockedNode.class)
    public static final class IsLockedNodeFactory
    extends NodeFactoryBase<MutexNodes.IsLockedNode> {
        private static IsLockedNodeFactory isLockedNodeFactoryInstance;

        private IsLockedNodeFactory() {
            super(MutexNodes.IsLockedNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.IsLockedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return IsLockedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MutexNodes.IsLockedNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return IsLockedUninitializedNode.create0(context, sourceSection, operand);
        }

        public static NodeFactory<MutexNodes.IsLockedNode> getInstance() {
            if (isLockedNodeFactoryInstance == null) {
                isLockedNodeFactoryInstance = new IsLockedNodeFactory();
            }
            return isLockedNodeFactoryInstance;
        }

        @GeneratedBy(value=MutexNodes.IsLockedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IsLockedPolymorphicNode
        extends IsLockedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> operandPolymorphicType;

            IsLockedPolymorphicNode(IsLockedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object operandValue = this.operand.execute(frameValue);
                return this.next0.executeChained0(frameValue, operandValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.operandPolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                return this.next0.executeChained0(frameValue, operandValue);
            }
        }

        @GeneratedBy(value=MutexNodes.IsLockedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsLockedRubyBasicObjectNode
        extends IsLockedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsLockedRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            IsLockedRubyBasicObjectNode(IsLockedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject operandValue;
                try {
                    operandValue = this.operand.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected operandValue instanceof RubyBasicObject");
                }
                return super.isLocked(operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    RubyBasicObject operandValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(operandValue);
                    return super.isLocked(operandValueCast);
                }
                return this.next0.executeChained0(frameValue, operandValue);
            }

            static MutexNodes.IsLockedNode create0(MutexNodes.IsLockedNode current) {
                return new IsLockedRubyBasicObjectNode((IsLockedBaseNode)current);
            }
        }

        @GeneratedBy(value=MutexNodes.IsLockedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IsLockedUninitializedNode
        extends IsLockedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsLockedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IsLockedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection, operand);
            }

            IsLockedUninitializedNode(IsLockedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object operandValue = this.operand.execute(frameValue);
                return this.executeUninitialized0(frameValue, operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, operandValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object operandValue) {
                IsLockedBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IsLockedBaseNode rootNode = (IsLockedBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.operand}, new Object[]{operandValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IsLockedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, operandValue);
            }

            static MutexNodes.IsLockedNode create0(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                return new IsLockedUninitializedNode(context, sourceSection, operand);
            }
        }

        @GeneratedBy(value=MutexNodes.IsLockedNode.class)
        private static abstract class IsLockedBaseNode
        extends MutexNodes.IsLockedNode
        implements DSLNode {
            @Node.Child
            protected RubyNode operand;
            @Node.Child
            protected IsLockedBaseNode next0;

            IsLockedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand = operand;
            }

            IsLockedBaseNode(IsLockedBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand;
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object operandValue, String reason) {
                String message;
                IsLockedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IsLockedBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    newNode = new IsLockedUninitializedNode(this);
                    ((IsLockedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IsLockedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IsLockedBaseNode.createInfo0(reason, operandValue)))) == null) {
                    returnNode = (IsLockedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IsLockedUninitializedNode(this), (Node)new IsLockedPolymorphicNode(this), (DSLNode)((IsLockedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, operandValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IsLockedBaseNode specialize0(Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    return (IsLockedBaseNode)IsLockedRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.operand = other == null ? null : ((IsLockedBaseNode)other).operand;
                this.next0 = newNext == null ? null : (IsLockedBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object operandValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("operandValue").append(" = ").append(operandValue);
                    if (operandValue != null) {
                        builder.append(" (").append(operandValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MutexNodes.LockNode.class)
    public static final class LockNodeFactory
    extends NodeFactoryBase<MutexNodes.LockNode> {
        private static LockNodeFactory lockNodeFactoryInstance;

        private LockNodeFactory() {
            super(MutexNodes.LockNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MutexNodes.LockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return LockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MutexNodes.LockNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return LockUninitializedNode.create0(context, sourceSection, operand);
        }

        public static NodeFactory<MutexNodes.LockNode> getInstance() {
            if (lockNodeFactoryInstance == null) {
                lockNodeFactoryInstance = new LockNodeFactory();
            }
            return lockNodeFactoryInstance;
        }

        @GeneratedBy(value=MutexNodes.LockNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LockPolymorphicNode
        extends LockBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> operandPolymorphicType;

            LockPolymorphicNode(LockBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object operandValue = this.operand.execute(frameValue);
                return this.next0.executeChained0(frameValue, operandValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.operandPolymorphicType = types[0];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object operandValue) {
                return this.next0.executeChained0(frameValue, operandValue);
            }
        }

        @GeneratedBy(value=MutexNodes.LockNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LockRubyBasicObjectNode
        extends LockBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LockRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            LockRubyBasicObjectNode(LockBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject operandValue;
                try {
                    operandValue = this.operand.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected operandValue instanceof RubyBasicObject");
                }
                return super.lock(operandValue);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    RubyBasicObject operandValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(operandValue);
                    return super.lock(operandValueCast);
                }
                return this.next0.executeChained0(frameValue, operandValue);
            }

            static MutexNodes.LockNode create0(MutexNodes.LockNode current) {
                return new LockRubyBasicObjectNode((LockBaseNode)current);
            }
        }

        @GeneratedBy(value=MutexNodes.LockNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LockUninitializedNode
        extends LockBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LockUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LockUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection, operand);
            }

            LockUninitializedNode(LockBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object operandValue = this.operand.execute(frameValue);
                return this.executeUninitialized0(frameValue, operandValue);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, operandValue);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object operandValue) {
                LockBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LockBaseNode rootNode = (LockBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.operand}, new Object[]{operandValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LockBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, operandValue);
            }

            static MutexNodes.LockNode create0(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                return new LockUninitializedNode(context, sourceSection, operand);
            }
        }

        @GeneratedBy(value=MutexNodes.LockNode.class)
        private static abstract class LockBaseNode
        extends MutexNodes.LockNode
        implements DSLNode {
            @Node.Child
            protected RubyNode operand;
            @Node.Child
            protected LockBaseNode next0;

            LockBaseNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand = operand;
            }

            LockBaseNode(LockBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand;
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object operandValue, String reason) {
                String message;
                LockBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LockBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    newNode = new LockUninitializedNode(this);
                    ((LockUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LockBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = LockBaseNode.createInfo0(reason, operandValue)))) == null) {
                    returnNode = (LockBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LockUninitializedNode(this), (Node)new LockPolymorphicNode(this), (DSLNode)((LockBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, operandValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LockBaseNode specialize0(Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    return (LockBaseNode)LockRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.operand = other == null ? null : ((LockBaseNode)other).operand;
                this.next0 = newNext == null ? null : (LockBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object operandValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("operandValue").append(" = ").append(operandValue);
                    if (operandValue != null) {
                        builder.append(" (").append(operandValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

