/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.MatchDataNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=MatchDataNodes.class)
public final class MatchDataNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(GetIndexNodeFactory.getInstance(), BeginNodeFactory.getInstance(), CapturesNodeFactory.getInstance(), EndNodeFactory.getInstance(), LengthNodeFactory.getInstance(), PreMatchNodeFactory.getInstance(), PostMatchNodeFactory.getInstance(), ToANodeFactory.getInstance(), ToSNodeFactory.getInstance(), ValuesAtNodeFactory.getInstance(), RubiniusSourceNodeFactory.getInstance());
    }

    @GeneratedBy(value=MatchDataNodes.RubiniusSourceNode.class)
    public static final class RubiniusSourceNodeFactory
    extends NodeFactoryBase<MatchDataNodes.RubiniusSourceNode> {
        private static RubiniusSourceNodeFactory rubiniusSourceNodeFactoryInstance;

        private RubiniusSourceNodeFactory() {
            super(MatchDataNodes.RubiniusSourceNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public MatchDataNodes.RubiniusSourceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return RubiniusSourceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MatchDataNodes.RubiniusSourceNode create(RubyContext context, SourceSection sourceSection, RubyNode self) {
            return RubiniusSourceUninitializedNode.create0(context, sourceSection, self);
        }

        public static NodeFactory<MatchDataNodes.RubiniusSourceNode> getInstance() {
            if (rubiniusSourceNodeFactoryInstance == null) {
                rubiniusSourceNodeFactoryInstance = new RubiniusSourceNodeFactory();
            }
            return rubiniusSourceNodeFactoryInstance;
        }

        @GeneratedBy(value=MatchDataNodes.RubiniusSourceNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RubiniusSourcePolymorphicNode
        extends RubiniusSourceBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> selfPolymorphicType;

            RubiniusSourcePolymorphicNode(RubiniusSourceBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object selfValue = this.self.execute(frameValue);
                return this.next0.executeChained0(frameValue, selfValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.selfPolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object selfValue) {
                return this.next0.executeChained0(frameValue, selfValue);
            }
        }

        @GeneratedBy(value=MatchDataNodes.RubiniusSourceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RubiniusSourceRubyMatchDataNode
        extends RubiniusSourceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RubiniusSourceRubyMatchDataNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class}, 0, 0);

            RubiniusSourceRubyMatchDataNode(RubiniusSourceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMatchData selfValue;
                try {
                    selfValue = this.self.executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected selfValue instanceof RubyMatchData");
                }
                return super.rubiniusSource(selfValue);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object selfValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(selfValue)) {
                    RubyMatchData selfValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(selfValue);
                    return super.rubiniusSource(selfValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue);
            }

            static MatchDataNodes.RubiniusSourceNode create0(MatchDataNodes.RubiniusSourceNode current) {
                return new RubiniusSourceRubyMatchDataNode((RubiniusSourceBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.RubiniusSourceNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RubiniusSourceUninitializedNode
        extends RubiniusSourceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RubiniusSourceUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RubiniusSourceUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode self) {
                super(context, sourceSection, self);
            }

            RubiniusSourceUninitializedNode(RubiniusSourceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object selfValue = this.self.execute(frameValue);
                return this.executeUninitialized0(frameValue, selfValue);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object selfValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, selfValue);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object selfValue) {
                RubiniusSourceBaseNode newNode = this.specialize0(selfValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RubiniusSourceBaseNode rootNode = (RubiniusSourceBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.self}, new Object[]{selfValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RubiniusSourceBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, selfValue);
            }

            static MatchDataNodes.RubiniusSourceNode create0(RubyContext context, SourceSection sourceSection, RubyNode self) {
                return new RubiniusSourceUninitializedNode(context, sourceSection, self);
            }
        }

        @GeneratedBy(value=MatchDataNodes.RubiniusSourceNode.class)
        private static abstract class RubiniusSourceBaseNode
        extends MatchDataNodes.RubiniusSourceNode
        implements DSLNode {
            @Node.Child
            protected RubyNode self;
            @Node.Child
            protected RubiniusSourceBaseNode next0;

            RubiniusSourceBaseNode(RubyContext context, SourceSection sourceSection, RubyNode self) {
                super(context, sourceSection);
                this.self = self;
            }

            RubiniusSourceBaseNode(RubiniusSourceBaseNode copy) {
                super(copy);
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object selfValue, String reason) {
                String message;
                RubiniusSourceBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RubiniusSourceBaseNode newNode = this.specialize0(selfValue);
                if (newNode == null) {
                    newNode = new RubiniusSourceUninitializedNode(this);
                    ((RubiniusSourceUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RubiniusSourceBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RubiniusSourceBaseNode.createInfo0(reason, selfValue)))) == null) {
                    returnNode = (RubiniusSourceBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RubiniusSourceUninitializedNode(this), (Node)new RubiniusSourcePolymorphicNode(this), (DSLNode)((RubiniusSourceBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, selfValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RubiniusSourceBaseNode specialize0(Object selfValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(selfValue)) {
                    return (RubiniusSourceBaseNode)RubiniusSourceRubyMatchDataNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.self = other == null ? null : ((RubiniusSourceBaseNode)other).self;
                this.next0 = newNext == null ? null : (RubiniusSourceBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object selfValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("selfValue").append(" = ").append(selfValue);
                    if (selfValue != null) {
                        builder.append(" (").append(selfValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.ValuesAtNode.class)
    public static final class ValuesAtNodeFactory
    extends NodeFactoryBase<MatchDataNodes.ValuesAtNode> {
        private static ValuesAtNodeFactory valuesAtNodeFactoryInstance;

        private ValuesAtNodeFactory() {
            super(MatchDataNodes.ValuesAtNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MatchDataNodes.ValuesAtNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ValuesAtNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MatchDataNodes.ValuesAtNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ValuesAtUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MatchDataNodes.ValuesAtNode> getInstance() {
            if (valuesAtNodeFactoryInstance == null) {
                valuesAtNodeFactoryInstance = new ValuesAtNodeFactory();
            }
            return valuesAtNodeFactoryInstance;
        }

        @GeneratedBy(value=MatchDataNodes.ValuesAtNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ValuesAtPolymorphicNode
        extends ValuesAtBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ValuesAtPolymorphicNode(ValuesAtBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=MatchDataNodes.ValuesAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ValuesAtRubyMatchDataNode
        extends ValuesAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ValuesAtRubyMatchDataNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class, Object[].class}, 0, 0);

            ValuesAtRubyMatchDataNode(ValuesAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyMatchData");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.valuesAt(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.valuesAt(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.ValuesAtNode create0(MatchDataNodes.ValuesAtNode current) {
                return new ValuesAtRubyMatchDataNode((ValuesAtBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.ValuesAtNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ValuesAtUninitializedNode
        extends ValuesAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ValuesAtUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ValuesAtUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ValuesAtUninitializedNode(ValuesAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ValuesAtBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ValuesAtBaseNode rootNode = (ValuesAtBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ValuesAtBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.ValuesAtNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ValuesAtUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MatchDataNodes.ValuesAtNode.class)
        private static abstract class ValuesAtBaseNode
        extends MatchDataNodes.ValuesAtNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ValuesAtBaseNode next0;

            ValuesAtBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ValuesAtBaseNode(ValuesAtBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ValuesAtBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ValuesAtBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ValuesAtUninitializedNode(this);
                    ((ValuesAtUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ValuesAtBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ValuesAtBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ValuesAtBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ValuesAtUninitializedNode(this), (Node)new ValuesAtPolymorphicNode(this), (DSLNode)((ValuesAtBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ValuesAtBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (ValuesAtBaseNode)ValuesAtRubyMatchDataNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ValuesAtBaseNode otherCast = (ValuesAtBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ValuesAtBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<MatchDataNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(MatchDataNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MatchDataNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MatchDataNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MatchDataNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        @GeneratedBy(value=MatchDataNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSPolymorphicNode
        extends ToSBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSPolymorphicNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MatchDataNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSRubyMatchDataNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSRubyMatchDataNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class}, 0, 0);

            ToSRubyMatchDataNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMatchData");
                }
                return super.toS(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    return super.toS(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.ToSNode create0(MatchDataNodes.ToSNode current) {
                return new ToSRubyMatchDataNode((ToSBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSUninitializedNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSUninitializedNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSBaseNode rootNode = (ToSBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MatchDataNodes.ToSNode.class)
        private static abstract class ToSBaseNode
        extends MatchDataNodes.ToSNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSBaseNode next0;

            ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSBaseNode(ToSBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToSBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSUninitializedNode(this);
                    ((ToSUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToSBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToSBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSUninitializedNode(this), (Node)new ToSPolymorphicNode(this), (DSLNode)((ToSBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    return (ToSBaseNode)ToSRubyMatchDataNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.ToANode.class)
    public static final class ToANodeFactory
    extends NodeFactoryBase<MatchDataNodes.ToANode> {
        private static ToANodeFactory toANodeFactoryInstance;

        private ToANodeFactory() {
            super(MatchDataNodes.ToANode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MatchDataNodes.ToANode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToANodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MatchDataNodes.ToANode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToAUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MatchDataNodes.ToANode> getInstance() {
            if (toANodeFactoryInstance == null) {
                toANodeFactoryInstance = new ToANodeFactory();
            }
            return toANodeFactoryInstance;
        }

        @GeneratedBy(value=MatchDataNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToAPolymorphicNode
        extends ToABaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToAPolymorphicNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MatchDataNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToARubyMatchDataNode
        extends ToABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToARubyMatchDataNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class}, 0, 0);

            ToARubyMatchDataNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMatchData");
                }
                return super.toA(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    return super.toA(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.ToANode create0(MatchDataNodes.ToANode current) {
                return new ToARubyMatchDataNode((ToABaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToAUninitializedNode
        extends ToABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToAUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToAUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToAUninitializedNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToABaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToABaseNode rootNode = (ToABaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToABaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.ToANode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToAUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MatchDataNodes.ToANode.class)
        private static abstract class ToABaseNode
        extends MatchDataNodes.ToANode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToABaseNode next0;

            ToABaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToABaseNode(ToABaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToABaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToABaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToAUninitializedNode(this);
                    ((ToAUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToABaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToABaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToABaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToAUninitializedNode(this), (Node)new ToAPolymorphicNode(this), (DSLNode)((ToABaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToABaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    return (ToABaseNode)ToARubyMatchDataNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToABaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToABaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.PostMatchNode.class)
    public static final class PostMatchNodeFactory
    extends NodeFactoryBase<MatchDataNodes.PostMatchNode> {
        private static PostMatchNodeFactory postMatchNodeFactoryInstance;

        private PostMatchNodeFactory() {
            super(MatchDataNodes.PostMatchNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MatchDataNodes.PostMatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PostMatchNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MatchDataNodes.PostMatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PostMatchUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MatchDataNodes.PostMatchNode> getInstance() {
            if (postMatchNodeFactoryInstance == null) {
                postMatchNodeFactoryInstance = new PostMatchNodeFactory();
            }
            return postMatchNodeFactoryInstance;
        }

        @GeneratedBy(value=MatchDataNodes.PostMatchNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PostMatchPolymorphicNode
        extends PostMatchBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            PostMatchPolymorphicNode(PostMatchBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MatchDataNodes.PostMatchNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PostMatchRubyMatchDataNode
        extends PostMatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PostMatchRubyMatchDataNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class}, 0, 0);

            PostMatchRubyMatchDataNode(PostMatchBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMatchData");
                }
                return super.postMatch(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    return super.postMatch(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.PostMatchNode create0(MatchDataNodes.PostMatchNode current) {
                return new PostMatchRubyMatchDataNode((PostMatchBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.PostMatchNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PostMatchUninitializedNode
        extends PostMatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PostMatchUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PostMatchUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PostMatchUninitializedNode(PostMatchBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                PostMatchBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PostMatchBaseNode rootNode = (PostMatchBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PostMatchBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.PostMatchNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PostMatchUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MatchDataNodes.PostMatchNode.class)
        private static abstract class PostMatchBaseNode
        extends MatchDataNodes.PostMatchNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PostMatchBaseNode next0;

            PostMatchBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PostMatchBaseNode(PostMatchBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                PostMatchBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PostMatchBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new PostMatchUninitializedNode(this);
                    ((PostMatchUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PostMatchBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PostMatchBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (PostMatchBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PostMatchUninitializedNode(this), (Node)new PostMatchPolymorphicNode(this), (DSLNode)((PostMatchBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PostMatchBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    return (PostMatchBaseNode)PostMatchRubyMatchDataNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((PostMatchBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (PostMatchBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.PreMatchNode.class)
    public static final class PreMatchNodeFactory
    extends NodeFactoryBase<MatchDataNodes.PreMatchNode> {
        private static PreMatchNodeFactory preMatchNodeFactoryInstance;

        private PreMatchNodeFactory() {
            super(MatchDataNodes.PreMatchNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MatchDataNodes.PreMatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PreMatchNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MatchDataNodes.PreMatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PreMatchUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MatchDataNodes.PreMatchNode> getInstance() {
            if (preMatchNodeFactoryInstance == null) {
                preMatchNodeFactoryInstance = new PreMatchNodeFactory();
            }
            return preMatchNodeFactoryInstance;
        }

        @GeneratedBy(value=MatchDataNodes.PreMatchNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PreMatchPolymorphicNode
        extends PreMatchBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            PreMatchPolymorphicNode(PreMatchBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MatchDataNodes.PreMatchNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PreMatchRubyMatchDataNode
        extends PreMatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PreMatchRubyMatchDataNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class}, 0, 0);

            PreMatchRubyMatchDataNode(PreMatchBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMatchData");
                }
                return super.preMatch(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    return super.preMatch(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.PreMatchNode create0(MatchDataNodes.PreMatchNode current) {
                return new PreMatchRubyMatchDataNode((PreMatchBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.PreMatchNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PreMatchUninitializedNode
        extends PreMatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PreMatchUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PreMatchUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PreMatchUninitializedNode(PreMatchBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                PreMatchBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PreMatchBaseNode rootNode = (PreMatchBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PreMatchBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.PreMatchNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PreMatchUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MatchDataNodes.PreMatchNode.class)
        private static abstract class PreMatchBaseNode
        extends MatchDataNodes.PreMatchNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PreMatchBaseNode next0;

            PreMatchBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PreMatchBaseNode(PreMatchBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                PreMatchBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PreMatchBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new PreMatchUninitializedNode(this);
                    ((PreMatchUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PreMatchBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PreMatchBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (PreMatchBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PreMatchUninitializedNode(this), (Node)new PreMatchPolymorphicNode(this), (DSLNode)((PreMatchBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PreMatchBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    return (PreMatchBaseNode)PreMatchRubyMatchDataNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((PreMatchBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (PreMatchBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.LengthNode.class)
    public static final class LengthNodeFactory
    extends NodeFactoryBase<MatchDataNodes.LengthNode> {
        private static LengthNodeFactory lengthNodeFactoryInstance;

        private LengthNodeFactory() {
            super(MatchDataNodes.LengthNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MatchDataNodes.LengthNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LengthNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MatchDataNodes.LengthNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LengthUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MatchDataNodes.LengthNode> getInstance() {
            if (lengthNodeFactoryInstance == null) {
                lengthNodeFactoryInstance = new LengthNodeFactory();
            }
            return lengthNodeFactoryInstance;
        }

        @GeneratedBy(value=MatchDataNodes.LengthNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LengthPolymorphicNode
        extends LengthBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            LengthPolymorphicNode(LengthBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MatchDataNodes.LengthNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LengthRubyMatchDataNode
        extends LengthBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LengthRubyMatchDataNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class}, 0, 0);

            LengthRubyMatchDataNode(LengthBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMatchData");
                }
                return super.length(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    return super.length(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.LengthNode create0(MatchDataNodes.LengthNode current) {
                return new LengthRubyMatchDataNode((LengthBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.LengthNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LengthUninitializedNode
        extends LengthBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LengthUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LengthUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LengthUninitializedNode(LengthBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                LengthBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LengthBaseNode rootNode = (LengthBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LengthBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.LengthNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LengthUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MatchDataNodes.LengthNode.class)
        private static abstract class LengthBaseNode
        extends MatchDataNodes.LengthNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LengthBaseNode next0;

            LengthBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LengthBaseNode(LengthBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                LengthBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LengthBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new LengthUninitializedNode(this);
                    ((LengthUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LengthBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = LengthBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (LengthBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LengthUninitializedNode(this), (Node)new LengthPolymorphicNode(this), (DSLNode)((LengthBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LengthBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    return (LengthBaseNode)LengthRubyMatchDataNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((LengthBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (LengthBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.EndNode.class)
    public static final class EndNodeFactory
    extends NodeFactoryBase<MatchDataNodes.EndNode> {
        private static EndNodeFactory endNodeFactoryInstance;

        private EndNodeFactory() {
            super(MatchDataNodes.EndNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MatchDataNodes.EndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EndNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MatchDataNodes.EndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EndUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MatchDataNodes.EndNode> getInstance() {
            if (endNodeFactoryInstance == null) {
                endNodeFactoryInstance = new EndNodeFactory();
            }
            return endNodeFactoryInstance;
        }

        @GeneratedBy(value=MatchDataNodes.EndNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EndPolymorphicNode
        extends EndBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EndPolymorphicNode(EndBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=MatchDataNodes.EndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EndRubyMatchDataNode
        extends EndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EndRubyMatchDataNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class, Integer.TYPE}, 0, 0);

            EndRubyMatchDataNode(EndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyMatchData");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.end(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.end(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.EndNode create0(MatchDataNodes.EndNode current) {
                return new EndRubyMatchDataNode((EndBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.EndNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EndUninitializedNode
        extends EndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EndUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EndUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EndUninitializedNode(EndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EndBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EndBaseNode rootNode = (EndBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EndBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.EndNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EndUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MatchDataNodes.EndNode.class)
        private static abstract class EndBaseNode
        extends MatchDataNodes.EndNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EndBaseNode next0;

            EndBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EndBaseNode(EndBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EndBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EndBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EndUninitializedNode(this);
                    ((EndUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EndBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EndBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EndBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EndUninitializedNode(this), (Node)new EndPolymorphicNode(this), (DSLNode)((EndBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EndBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (EndBaseNode)EndRubyMatchDataNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EndBaseNode otherCast = (EndBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EndBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.CapturesNode.class)
    public static final class CapturesNodeFactory
    extends NodeFactoryBase<MatchDataNodes.CapturesNode> {
        private static CapturesNodeFactory capturesNodeFactoryInstance;

        private CapturesNodeFactory() {
            super(MatchDataNodes.CapturesNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MatchDataNodes.CapturesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CapturesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MatchDataNodes.CapturesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CapturesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MatchDataNodes.CapturesNode> getInstance() {
            if (capturesNodeFactoryInstance == null) {
                capturesNodeFactoryInstance = new CapturesNodeFactory();
            }
            return capturesNodeFactoryInstance;
        }

        @GeneratedBy(value=MatchDataNodes.CapturesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CapturesPolymorphicNode
        extends CapturesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CapturesPolymorphicNode(CapturesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=MatchDataNodes.CapturesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CapturesRubyMatchDataNode
        extends CapturesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapturesRubyMatchDataNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class}, 0, 0);

            CapturesRubyMatchDataNode(CapturesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyMatchData");
                }
                return super.toA(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    return super.toA(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.CapturesNode create0(MatchDataNodes.CapturesNode current) {
                return new CapturesRubyMatchDataNode((CapturesBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.CapturesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CapturesUninitializedNode
        extends CapturesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CapturesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CapturesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CapturesUninitializedNode(CapturesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CapturesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CapturesBaseNode rootNode = (CapturesBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CapturesBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static MatchDataNodes.CapturesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CapturesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MatchDataNodes.CapturesNode.class)
        private static abstract class CapturesBaseNode
        extends MatchDataNodes.CapturesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CapturesBaseNode next0;

            CapturesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CapturesBaseNode(CapturesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                CapturesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CapturesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CapturesUninitializedNode(this);
                    ((CapturesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CapturesBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CapturesBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (CapturesBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CapturesUninitializedNode(this), (Node)new CapturesPolymorphicNode(this), (DSLNode)((CapturesBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CapturesBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    return (CapturesBaseNode)CapturesRubyMatchDataNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CapturesBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CapturesBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.BeginNode.class)
    public static final class BeginNodeFactory
    extends NodeFactoryBase<MatchDataNodes.BeginNode> {
        private static BeginNodeFactory beginNodeFactoryInstance;

        private BeginNodeFactory() {
            super(MatchDataNodes.BeginNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MatchDataNodes.BeginNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BeginNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MatchDataNodes.BeginNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BeginUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MatchDataNodes.BeginNode> getInstance() {
            if (beginNodeFactoryInstance == null) {
                beginNodeFactoryInstance = new BeginNodeFactory();
            }
            return beginNodeFactoryInstance;
        }

        @GeneratedBy(value=MatchDataNodes.BeginNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BeginPolymorphicNode
        extends BeginBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            BeginPolymorphicNode(BeginBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=MatchDataNodes.BeginNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BeginRubyMatchDataNode
        extends BeginBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BeginRubyMatchDataNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class, Integer.TYPE}, 0, 0);

            BeginRubyMatchDataNode(BeginBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyMatchData");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.begin(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.begin(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.BeginNode create0(MatchDataNodes.BeginNode current) {
                return new BeginRubyMatchDataNode((BeginBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.BeginNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BeginUninitializedNode
        extends BeginBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BeginUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BeginUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BeginUninitializedNode(BeginBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                BeginBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BeginBaseNode rootNode = (BeginBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BeginBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.BeginNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BeginUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MatchDataNodes.BeginNode.class)
        private static abstract class BeginBaseNode
        extends MatchDataNodes.BeginNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BeginBaseNode next0;

            BeginBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BeginBaseNode(BeginBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                BeginBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BeginBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new BeginUninitializedNode(this);
                    ((BeginUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BeginBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = BeginBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (BeginBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BeginUninitializedNode(this), (Node)new BeginPolymorphicNode(this), (DSLNode)((BeginBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BeginBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (BeginBaseNode)BeginRubyMatchDataNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    BeginBaseNode otherCast = (BeginBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (BeginBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    extends NodeFactoryBase<MatchDataNodes.GetIndexNode> {
        private static GetIndexNodeFactory getIndexNodeFactoryInstance;

        private GetIndexNodeFactory() {
            super(MatchDataNodes.GetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public MatchDataNodes.GetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static MatchDataNodes.GetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetIndexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<MatchDataNodes.GetIndexNode> getInstance() {
            if (getIndexNodeFactoryInstance == null) {
                getIndexNodeFactoryInstance = new GetIndexNodeFactory();
            }
            return getIndexNodeFactoryInstance;
        }

        @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GetIndexPolymorphicNode
        extends GetIndexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GetIndexPolymorphicNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[1].executeIntegerFixnumRange(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyMatchDataIntegerFixnumRangeNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyMatchDataIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class, RubyRange.IntegerFixnumRange.class}, 0, 0);

            GetIndexRubyMatchDataIntegerFixnumRangeNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRange.IntegerFixnumRange arguments1Value;
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyMatchData");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof IntegerFixnumRange");
                }
                if (!super.isRubySymbol(arguments1Value) && !super.isRubyString(arguments1Value)) {
                    return super.getIndex(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubySymbol, !isRubyString] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value) && RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    RubyRange.IntegerFixnumRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments1Value);
                    if (!super.isRubySymbol(arguments1Value) && !super.isRubyString(arguments1Value)) {
                        return super.getIndex(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.GetIndexNode create0(MatchDataNodes.GetIndexNode current) {
                return new GetIndexRubyMatchDataIntegerFixnumRangeNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyMatchDataObjectNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyMatchDataObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class, Object.class}, 0, 0);

            GetIndexRubyMatchDataObjectNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyMatchData");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!(super.isRubySymbol(arguments1Value) || super.isRubyString(arguments1Value) || super.isIntegerFixnumRange(arguments1Value))) {
                    return super.getIndex(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubySymbol, !isRubyString, !isIntegerFixnumRange] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value) && !super.isRubySymbol(arguments1Value) && !super.isRubyString(arguments1Value) && !super.isIntegerFixnumRange(arguments1Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    return super.getIndex(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.GetIndexNode create0(MatchDataNodes.GetIndexNode current) {
                return new GetIndexRubyMatchDataObjectNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyMatchDataRubyStringNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyMatchDataRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class, RubyString.class}, 0, 0);

            GetIndexRubyMatchDataRubyStringNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyMatchData");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.getIndex(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.getIndex(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.GetIndexNode create0(MatchDataNodes.GetIndexNode current) {
                return new GetIndexRubyMatchDataRubyStringNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyMatchDataRubySymbolNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyMatchDataRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class, RubySymbol.class}, 0, 0);

            GetIndexRubyMatchDataRubySymbolNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyMatchData");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.getIndex(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.getIndex(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.GetIndexNode create0(MatchDataNodes.GetIndexNode current) {
                return new GetIndexRubyMatchDataRubySymbolNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetIndexRubyMatchDataIntNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexRubyMatchDataIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyMatchData.class, Integer.TYPE}, 0, 0);

            GetIndexRubyMatchDataIntNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyMatchData arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyMatchData(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyMatchData");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.getIndex(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyMatchData arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyMatchData(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.getIndex(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.GetIndexNode create0(MatchDataNodes.GetIndexNode current) {
                return new GetIndexRubyMatchDataIntNode((GetIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GetIndexUninitializedNode
        extends GetIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetIndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GetIndexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GetIndexUninitializedNode(GetIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GetIndexBaseNode rootNode = (GetIndexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GetIndexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static MatchDataNodes.GetIndexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetIndexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
        private static abstract class GetIndexBaseNode
        extends MatchDataNodes.GetIndexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GetIndexBaseNode next0;

            GetIndexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GetIndexBaseNode(GetIndexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                GetIndexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GetIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GetIndexUninitializedNode(this);
                    ((GetIndexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GetIndexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = GetIndexBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GetIndexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GetIndexUninitializedNode(this), (Node)new GetIndexPolymorphicNode(this), (DSLNode)((GetIndexBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GetIndexBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyMatchData(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (GetIndexBaseNode)GetIndexRubyMatchDataIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (GetIndexBaseNode)GetIndexRubyMatchDataRubySymbolNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (GetIndexBaseNode)GetIndexRubyMatchDataRubyStringNode.create0(this);
                    }
                    if (!super.isRubySymbol(arguments1Value) && !super.isRubyString(arguments1Value)) {
                        if (!super.isIntegerFixnumRange(arguments1Value)) {
                            return (GetIndexBaseNode)GetIndexRubyMatchDataObjectNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value)) {
                            return (GetIndexBaseNode)GetIndexRubyMatchDataIntegerFixnumRangeNode.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GetIndexBaseNode otherCast = (GetIndexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GetIndexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

