/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import org.joni.exception.ValueException;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.coerce.ToIntNodeFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.util.ByteList;

@CoreClass(name="MatchData")
public abstract class MatchDataNodes {

    @NodeChild(value="self")
    public static abstract class RubiniusSourceNode
    extends RubyNode {
        public RubiniusSourceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RubiniusSourceNode(RubiniusSourceNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString rubiniusSource(RubyMatchData matchData) {
            return matchData.getSource();
        }
    }

    @CoreMethod(names={"values_at"}, argumentsAsArray=true)
    public static abstract class ValuesAtNode
    extends CoreMethodNode {
        public ValuesAtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ValuesAtNode(ValuesAtNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray valuesAt(RubyMatchData matchData, Object[] args) {
            ValuesAtNode.notDesignedForCompilation();
            int[] indicies = new int[args.length];
            for (int n = 0; n < args.length; ++n) {
                indicies[n] = (Integer)args[n];
            }
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), matchData.valuesAt(indicies));
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString toS(RubyMatchData matchData) {
            ToSNode.notDesignedForCompilation();
            ByteList bytes = matchData.getGlobal().getBytes().dup();
            return this.getContext().makeString(bytes);
        }
    }

    @CoreMethod(names={"to_a"})
    public static abstract class ToANode
    extends CoreMethodNode {
        public ToANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToANode(ToANode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray toA(RubyMatchData matchData) {
            ToANode.notDesignedForCompilation();
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), matchData.getValues());
        }
    }

    @CoreMethod(names={"post_match"})
    public static abstract class PostMatchNode
    extends CoreMethodNode {
        public PostMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PostMatchNode(PostMatchNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString postMatch(RubyMatchData matchData) {
            return matchData.getPost();
        }
    }

    @CoreMethod(names={"pre_match"})
    public static abstract class PreMatchNode
    extends CoreMethodNode {
        public PreMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PreMatchNode(PreMatchNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString preMatch(RubyMatchData matchData) {
            return matchData.getPre();
        }
    }

    @CoreMethod(names={"length", "size"})
    public static abstract class LengthNode
    extends CoreMethodNode {
        public LengthNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LengthNode(LengthNode prev) {
            super(prev);
        }

        @Specialization
        public int length(RubyMatchData matchData) {
            return matchData.getValues().length;
        }
    }

    @CoreMethod(names={"end"}, required=1, lowerFixnumParameters={1})
    public static abstract class EndNode
    extends CoreMethodNode {
        private final ConditionProfile badIndexProfile = ConditionProfile.createBinaryProfile();

        public EndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EndNode(EndNode prev) {
            super(prev);
        }

        @Specialization
        public Object end(RubyMatchData matchData, int index) {
            EndNode.notDesignedForCompilation();
            if (this.badIndexProfile.profile(index < 0 || index >= matchData.getNumberOfRegions())) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of matches", index), this));
            }
            return matchData.end(index);
        }
    }

    @CoreMethod(names={"captures"})
    public static abstract class CapturesNode
    extends CoreMethodNode {
        public CapturesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CapturesNode(CapturesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray toA(RubyMatchData matchData) {
            CapturesNode.notDesignedForCompilation();
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), matchData.getCaptures());
        }
    }

    @CoreMethod(names={"begin"}, required=1, lowerFixnumParameters={1})
    public static abstract class BeginNode
    extends CoreMethodNode {
        private final ConditionProfile badIndexProfile = ConditionProfile.createBinaryProfile();

        public BeginNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BeginNode(BeginNode prev) {
            super(prev);
        }

        @Specialization
        public Object begin(RubyMatchData matchData, int index) {
            BeginNode.notDesignedForCompilation();
            if (this.badIndexProfile.profile(index < 0 || index >= matchData.getNumberOfRegions())) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of matches", index), this));
            }
            return matchData.begin(index);
        }
    }

    @CoreMethod(names={"[]"}, required=1, lowerFixnumParameters={0}, taintFromSelf=true)
    public static abstract class GetIndexNode
    extends CoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetIndexNode(GetIndexNode prev) {
            super(prev);
        }

        @Specialization
        public Object getIndex(RubyMatchData matchData, int index) {
            GetIndexNode.notDesignedForCompilation();
            Object[] values = matchData.getValues();
            int normalizedIndex = RubyArray.normalizeIndex(values.length, index);
            if (normalizedIndex < 0 || normalizedIndex >= values.length) {
                return this.nil();
            }
            return values[normalizedIndex];
        }

        @Specialization
        public Object getIndex(RubyMatchData matchData, RubySymbol index) {
            GetIndexNode.notDesignedForCompilation();
            try {
                int i = matchData.getBackrefNumber(index.getSymbolBytes());
                return this.getIndex(matchData, i);
            }
            catch (ValueException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("undefined group name reference: %s", index.toString()), this));
            }
        }

        @Specialization
        public Object getIndex(RubyMatchData matchData, RubyString index) {
            GetIndexNode.notDesignedForCompilation();
            try {
                int i = matchData.getBackrefNumber(index.getByteList());
                return this.getIndex(matchData, i);
            }
            catch (ValueException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("undefined group name reference: %s", index.toString()), this));
            }
        }

        @Specialization(guards={"!isRubySymbol(arguments[1])", "!isRubyString(arguments[1])", "!isIntegerFixnumRange(arguments[1])"})
        public Object getIndex(VirtualFrame frame, RubyMatchData matchData, Object index) {
            GetIndexNode.notDesignedForCompilation();
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.getIndex(matchData, this.toIntNode.executeInt(frame, index));
        }

        @Specialization(guards={"!isRubySymbol(arguments[1])", "!isRubyString(arguments[1])"})
        public Object getIndex(VirtualFrame frame, RubyMatchData matchData, RubyRange.IntegerFixnumRange range) {
            Object[] values = matchData.getValues();
            int normalizedIndex = RubyArray.normalizeIndex(values.length, range.getBegin());
            int end = RubyArray.normalizeIndex(values.length, range.getEnd());
            int exclusiveEnd = RubyArray.clampExclusiveIndex(values.length, range.doesExcludeEnd() ? end : end + 1);
            int length = exclusiveEnd - normalizedIndex;
            Object[] store = Arrays.copyOfRange(values, normalizedIndex, normalizedIndex + length);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), store, length);
        }
    }
}

