/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FloatNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=FloatNodes.class)
public final class FloatNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(NegNodeFactory.getInstance(), AddNodeFactory.getInstance(), SubNodeFactory.getInstance(), MulNodeFactory.getInstance(), PowNodeFactory.getInstance(), DivNodeFactory.getInstance(), ModNodeFactory.getInstance(), DivModNodeFactory.getInstance(), LessNodeFactory.getInstance(), LessEqualNodeFactory.getInstance(), EqualNodeFactory.getInstance(), CompareNodeFactory.getInstance(), GreaterEqualNodeFactory.getInstance(), GreaterNodeFactory.getInstance(), AbsNodeFactory.getInstance(), CeilNodeFactory.getInstance(), FloorNodeFactory.getInstance(), InfiniteNodeFactory.getInstance(), NaNNodeFactory.getInstance(), RoundNodeFactory.getInstance(), ToINodeFactory.getInstance(), ToFNodeFactory.getInstance(), ToSNodeFactory.getInstance());
    }

    @GeneratedBy(value=FloatNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<FloatNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(FloatNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToSPolymorphicNode
        extends ToSBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToSPolymorphicNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FloatNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSDoubleNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ToSDoubleNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.toS(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.toS(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.ToSNode create0(FloatNodes.ToSNode current) {
                return new ToSDoubleNode((ToSBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToSUninitializedNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToSUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToSUninitializedNode(ToSBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToSBaseNode rootNode = (ToSBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToSBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.ToSNode.class)
        private static abstract class ToSBaseNode
        extends FloatNodes.ToSNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToSBaseNode next0;

            ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToSBaseNode(ToSBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToSBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToSBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToSUninitializedNode(this);
                    ((ToSUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToSBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToSBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToSBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSUninitializedNode(this), (Node)new ToSPolymorphicNode(this), (DSLNode)((ToSBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToSBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ToSBaseNode)ToSDoubleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToSBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.ToFNode.class)
    public static final class ToFNodeFactory
    extends NodeFactoryBase<FloatNodes.ToFNode> {
        private static ToFNodeFactory toFNodeFactoryInstance;

        private ToFNodeFactory() {
            super(FloatNodes.ToFNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.ToFNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToFNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.ToFNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToFUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.ToFNode> getInstance() {
            if (toFNodeFactoryInstance == null) {
                toFNodeFactoryInstance = new ToFNodeFactory();
            }
            return toFNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToFPolymorphicNode
        extends ToFBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToFPolymorphicNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FloatNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToFDoubleNode
        extends ToFBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToFDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ToFDoubleNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.toF(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.toF(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.ToFNode create0(FloatNodes.ToFNode current) {
                return new ToFDoubleNode((ToFBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.ToFNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToFUninitializedNode
        extends ToFBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToFUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToFUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToFUninitializedNode(ToFBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToFBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToFBaseNode rootNode = (ToFBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToFBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.ToFNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToFUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.ToFNode.class)
        private static abstract class ToFBaseNode
        extends FloatNodes.ToFNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToFBaseNode next0;

            ToFBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToFBaseNode(ToFBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToFBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToFBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToFUninitializedNode(this);
                    ((ToFUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToFBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToFBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToFBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToFUninitializedNode(this), (Node)new ToFPolymorphicNode(this), (DSLNode)((ToFBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToFBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ToFBaseNode)ToFDoubleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToFBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToFBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.ToINode.class)
    public static final class ToINodeFactory
    extends NodeFactoryBase<FloatNodes.ToINode> {
        private static ToINodeFactory toINodeFactoryInstance;

        private ToINodeFactory() {
            super(FloatNodes.ToINode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.ToINode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToINodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.ToINode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToIUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.ToINode> getInstance() {
            if (toINodeFactoryInstance == null) {
                toINodeFactoryInstance = new ToINodeFactory();
            }
            return toINodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.ToINode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToIPolymorphicNode
        extends ToIBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToIPolymorphicNode(ToIBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public Object executeToI(VirtualFrame frameValue, double arguments0ValueEvaluated) {
                Double arguments0Value = arguments0ValueEvaluated;
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FloatNodes.ToINode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToIDoubleNode
        extends ToIBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToIDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            ToIDoubleNode(ToIBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.toI(arguments0Value);
            }

            @Override
            public Object executeToI(VirtualFrame frameValue, double arguments0ValueEvaluated) {
                double arguments0Value = arguments0ValueEvaluated;
                return super.toI(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.toI(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.ToINode create0(FloatNodes.ToINode current) {
                return new ToIDoubleNode((ToIBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.ToINode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToIUninitializedNode
        extends ToIBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToIUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToIUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToIUninitializedNode(ToIBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            public Object executeToI(VirtualFrame frameValue, double arguments0ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Double arguments0Value = arguments0ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToIBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToIBaseNode rootNode = (ToIBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToIBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.ToINode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToIUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.ToINode.class)
        private static abstract class ToIBaseNode
        extends FloatNodes.ToINode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToIBaseNode next0;

            ToIBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToIBaseNode(ToIBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToIBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToIBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToIUninitializedNode(this);
                    ((ToIUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToIBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToIBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToIBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToIUninitializedNode(this), (Node)new ToIPolymorphicNode(this), (DSLNode)((ToIBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToIBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (ToIBaseNode)ToIDoubleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToIBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToIBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.RoundNode.class)
    public static final class RoundNodeFactory
    extends NodeFactoryBase<FloatNodes.RoundNode> {
        private static RoundNodeFactory roundNodeFactoryInstance;

        private RoundNodeFactory() {
            super(FloatNodes.RoundNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.RoundNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RoundNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.RoundNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RoundUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.RoundNode> getInstance() {
            if (roundNodeFactoryInstance == null) {
                roundNodeFactoryInstance = new RoundNodeFactory();
            }
            return roundNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.RoundNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RoundPolymorphicNode
        extends RoundBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            RoundPolymorphicNode(RoundBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.RoundNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RoundDoubleObjectNode
        extends RoundBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RoundDoubleObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Object.class}, 0, 0);

            RoundDoubleObjectNode(RoundBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof double");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.round(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.round(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.RoundNode create0(FloatNodes.RoundNode current) {
                return new RoundDoubleObjectNode((RoundBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.RoundNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RoundDoubleUndefinedPlaceholderNode
        extends RoundBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RoundDoubleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, UndefinedPlaceholder.class}, 0, 0);

            RoundDoubleUndefinedPlaceholderNode(RoundBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.round(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.round(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.RoundNode create0(FloatNodes.RoundNode current) {
                return new RoundDoubleUndefinedPlaceholderNode((RoundBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.RoundNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RoundUninitializedNode
        extends RoundBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RoundUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RoundUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RoundUninitializedNode(RoundBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RoundBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RoundBaseNode rootNode = (RoundBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RoundBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.RoundNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RoundUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.RoundNode.class)
        private static abstract class RoundBaseNode
        extends FloatNodes.RoundNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RoundBaseNode next0;

            RoundBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RoundBaseNode(RoundBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                RoundBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RoundBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new RoundUninitializedNode(this);
                    ((RoundUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RoundBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RoundBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (RoundBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RoundUninitializedNode(this), (Node)new RoundPolymorphicNode(this), (DSLNode)((RoundBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RoundBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (RoundBaseNode)RoundDoubleUndefinedPlaceholderNode.create0(this);
                    }
                    if (!super.isUndefinedPlaceholder(arguments1Value)) {
                        return (RoundBaseNode)RoundDoubleObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    RoundBaseNode otherCast = (RoundBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (RoundBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.NaNNode.class)
    public static final class NaNNodeFactory
    extends NodeFactoryBase<FloatNodes.NaNNode> {
        private static NaNNodeFactory naNNodeFactoryInstance;

        private NaNNodeFactory() {
            super(FloatNodes.NaNNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.NaNNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NaNNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.NaNNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NaNUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.NaNNode> getInstance() {
            if (naNNodeFactoryInstance == null) {
                naNNodeFactoryInstance = new NaNNodeFactory();
            }
            return naNNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.NaNNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class NaNPolymorphicNode
        extends NaNBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            NaNPolymorphicNode(NaNBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FloatNodes.NaNNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NaNDoubleNode
        extends NaNBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NaNDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            NaNDoubleNode(NaNBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.nan(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.nan(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.NaNNode create0(FloatNodes.NaNNode current) {
                return new NaNDoubleNode((NaNBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.NaNNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class NaNUninitializedNode
        extends NaNBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NaNUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            NaNUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            NaNUninitializedNode(NaNBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                NaNBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    NaNBaseNode rootNode = (NaNBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((NaNBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.NaNNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NaNUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.NaNNode.class)
        private static abstract class NaNBaseNode
        extends FloatNodes.NaNNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected NaNBaseNode next0;

            NaNBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            NaNBaseNode(NaNBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                NaNBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                NaNBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new NaNUninitializedNode(this);
                    ((NaNUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (NaNBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = NaNBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (NaNBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new NaNUninitializedNode(this), (Node)new NaNPolymorphicNode(this), (DSLNode)((NaNBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final NaNBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (NaNBaseNode)NaNDoubleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((NaNBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (NaNBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.InfiniteNode.class)
    public static final class InfiniteNodeFactory
    extends NodeFactoryBase<FloatNodes.InfiniteNode> {
        private static InfiniteNodeFactory infiniteNodeFactoryInstance;

        private InfiniteNodeFactory() {
            super(FloatNodes.InfiniteNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.InfiniteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InfiniteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.InfiniteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InfiniteUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.InfiniteNode> getInstance() {
            if (infiniteNodeFactoryInstance == null) {
                infiniteNodeFactoryInstance = new InfiniteNodeFactory();
            }
            return infiniteNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.InfiniteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InfinitePolymorphicNode
        extends InfiniteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            InfinitePolymorphicNode(InfiniteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FloatNodes.InfiniteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InfiniteDoubleNode
        extends InfiniteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InfiniteDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            InfiniteDoubleNode(InfiniteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.infinite(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.infinite(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.InfiniteNode create0(FloatNodes.InfiniteNode current) {
                return new InfiniteDoubleNode((InfiniteBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.InfiniteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InfiniteUninitializedNode
        extends InfiniteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InfiniteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InfiniteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InfiniteUninitializedNode(InfiniteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                InfiniteBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InfiniteBaseNode rootNode = (InfiniteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InfiniteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.InfiniteNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InfiniteUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.InfiniteNode.class)
        private static abstract class InfiniteBaseNode
        extends FloatNodes.InfiniteNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InfiniteBaseNode next0;

            InfiniteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InfiniteBaseNode(InfiniteBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                InfiniteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InfiniteBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new InfiniteUninitializedNode(this);
                    ((InfiniteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InfiniteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InfiniteBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (InfiniteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InfiniteUninitializedNode(this), (Node)new InfinitePolymorphicNode(this), (DSLNode)((InfiniteBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InfiniteBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (InfiniteBaseNode)InfiniteDoubleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((InfiniteBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (InfiniteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.FloorNode.class)
    public static final class FloorNodeFactory
    extends NodeFactoryBase<FloatNodes.FloorNode> {
        private static FloorNodeFactory floorNodeFactoryInstance;

        private FloorNodeFactory() {
            super(FloatNodes.FloorNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.FloorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FloorNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.FloorNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FloorUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.FloorNode> getInstance() {
            if (floorNodeFactoryInstance == null) {
                floorNodeFactoryInstance = new FloorNodeFactory();
            }
            return floorNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FloorPolymorphicNode
        extends FloorBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            FloorPolymorphicNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FloatNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FloorDoubleNode
        extends FloorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FloorDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            FloorDoubleNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.floor(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.floor(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.FloorNode create0(FloatNodes.FloorNode current) {
                return new FloorDoubleNode((FloorBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FloorUninitializedNode
        extends FloorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FloorUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FloorUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FloorUninitializedNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                FloorBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FloorBaseNode rootNode = (FloorBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((FloorBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.FloorNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FloorUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.FloorNode.class)
        private static abstract class FloorBaseNode
        extends FloatNodes.FloorNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FloorBaseNode next0;

            FloorBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FloorBaseNode(FloorBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                FloorBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FloorBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new FloorUninitializedNode(this);
                    ((FloorUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (FloorBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = FloorBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (FloorBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new FloorUninitializedNode(this), (Node)new FloorPolymorphicNode(this), (DSLNode)((FloorBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FloorBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (FloorBaseNode)FloorDoubleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((FloorBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (FloorBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.CeilNode.class)
    public static final class CeilNodeFactory
    extends NodeFactoryBase<FloatNodes.CeilNode> {
        private static CeilNodeFactory ceilNodeFactoryInstance;

        private CeilNodeFactory() {
            super(FloatNodes.CeilNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.CeilNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CeilNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.CeilNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CeilUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.CeilNode> getInstance() {
            if (ceilNodeFactoryInstance == null) {
                ceilNodeFactoryInstance = new CeilNodeFactory();
            }
            return ceilNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.CeilNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CeilPolymorphicNode
        extends CeilBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CeilPolymorphicNode(CeilBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FloatNodes.CeilNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CeilDoubleNode
        extends CeilBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CeilDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            CeilDoubleNode(CeilBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.ceil(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.ceil(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.CeilNode create0(FloatNodes.CeilNode current) {
                return new CeilDoubleNode((CeilBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.CeilNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CeilUninitializedNode
        extends CeilBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CeilUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CeilUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CeilUninitializedNode(CeilBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CeilBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CeilBaseNode rootNode = (CeilBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CeilBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.CeilNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CeilUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.CeilNode.class)
        private static abstract class CeilBaseNode
        extends FloatNodes.CeilNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CeilBaseNode next0;

            CeilBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CeilBaseNode(CeilBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                CeilBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CeilBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CeilUninitializedNode(this);
                    ((CeilUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CeilBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CeilBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (CeilBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CeilUninitializedNode(this), (Node)new CeilPolymorphicNode(this), (DSLNode)((CeilBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CeilBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (CeilBaseNode)CeilDoubleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CeilBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CeilBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.AbsNode.class)
    public static final class AbsNodeFactory
    extends NodeFactoryBase<FloatNodes.AbsNode> {
        private static AbsNodeFactory absNodeFactoryInstance;

        private AbsNodeFactory() {
            super(FloatNodes.AbsNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.AbsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AbsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.AbsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AbsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.AbsNode> getInstance() {
            if (absNodeFactoryInstance == null) {
                absNodeFactoryInstance = new AbsNodeFactory();
            }
            return absNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.AbsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AbsPolymorphicNode
        extends AbsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            AbsPolymorphicNode(AbsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FloatNodes.AbsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AbsDoubleNode
        extends AbsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AbsDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            AbsDoubleNode(AbsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.abs(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.abs(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.AbsNode create0(FloatNodes.AbsNode current) {
                return new AbsDoubleNode((AbsBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.AbsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AbsUninitializedNode
        extends AbsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AbsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AbsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AbsUninitializedNode(AbsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                AbsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AbsBaseNode rootNode = (AbsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AbsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.AbsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AbsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.AbsNode.class)
        private static abstract class AbsBaseNode
        extends FloatNodes.AbsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AbsBaseNode next0;

            AbsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AbsBaseNode(AbsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                AbsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AbsBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new AbsUninitializedNode(this);
                    ((AbsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AbsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AbsBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (AbsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AbsUninitializedNode(this), (Node)new AbsPolymorphicNode(this), (DSLNode)((AbsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AbsBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (AbsBaseNode)AbsDoubleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((AbsBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (AbsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.GreaterNode.class)
    public static final class GreaterNodeFactory
    extends NodeFactoryBase<FloatNodes.GreaterNode> {
        private static GreaterNodeFactory greaterNodeFactoryInstance;

        private GreaterNodeFactory() {
            super(FloatNodes.GreaterNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.GreaterNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GreaterNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.GreaterNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GreaterUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.GreaterNode> getInstance() {
            if (greaterNodeFactoryInstance == null) {
                greaterNodeFactoryInstance = new GreaterNodeFactory();
            }
            return greaterNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GreaterPolymorphicNode
        extends GreaterBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GreaterPolymorphicNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterDoubleRubyBasicObjectNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterDoubleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBasicObject.class}, 0, 0);

            GreaterDoubleRubyBasicObjectNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                if (!super.isRubyBignum(arguments1Value)) {
                    return super.less(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyBignum] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    if (!super.isRubyBignum(arguments1Value)) {
                        return super.less(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterNode create0(FloatNodes.GreaterNode current) {
                return new GreaterDoubleRubyBasicObjectNode((GreaterBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterDoubleRubyBignumNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            GreaterDoubleRubyBignumNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterNode create0(FloatNodes.GreaterNode current) {
                return new GreaterDoubleRubyBignumNode((GreaterBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterDoubleNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            GreaterDoubleNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterNode create0(FloatNodes.GreaterNode current) {
                return new GreaterDoubleNode((GreaterBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterDoubleLongNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            GreaterDoubleLongNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterNode create0(FloatNodes.GreaterNode current) {
                return new GreaterDoubleLongNode((GreaterBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterDoubleIntNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            GreaterDoubleIntNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterNode create0(FloatNodes.GreaterNode current) {
                return new GreaterDoubleIntNode((GreaterBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GreaterUninitializedNode
        extends GreaterBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GreaterUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GreaterUninitializedNode(GreaterBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GreaterBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GreaterBaseNode rootNode = (GreaterBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GreaterBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GreaterUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterNode.class)
        private static abstract class GreaterBaseNode
        extends FloatNodes.GreaterNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GreaterBaseNode next0;

            GreaterBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GreaterBaseNode(GreaterBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                GreaterBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GreaterBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GreaterUninitializedNode(this);
                    ((GreaterUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GreaterBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = GreaterBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GreaterBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GreaterUninitializedNode(this), (Node)new GreaterPolymorphicNode(this), (DSLNode)((GreaterBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GreaterBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (GreaterBaseNode)GreaterDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (GreaterBaseNode)GreaterDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (GreaterBaseNode)GreaterDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (GreaterBaseNode)GreaterDoubleRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && !super.isRubyBignum(arguments1Value)) {
                        return (GreaterBaseNode)GreaterDoubleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GreaterBaseNode otherCast = (GreaterBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GreaterBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.GreaterEqualNode.class)
    public static final class GreaterEqualNodeFactory
    extends NodeFactoryBase<FloatNodes.GreaterEqualNode> {
        private static GreaterEqualNodeFactory greaterEqualNodeFactoryInstance;

        private GreaterEqualNodeFactory() {
            super(FloatNodes.GreaterEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.GreaterEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GreaterEqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.GreaterEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GreaterEqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.GreaterEqualNode> getInstance() {
            if (greaterEqualNodeFactoryInstance == null) {
                greaterEqualNodeFactoryInstance = new GreaterEqualNodeFactory();
            }
            return greaterEqualNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GreaterEqualPolymorphicNode
        extends GreaterEqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GreaterEqualPolymorphicNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualDoubleRubyBasicObjectNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualDoubleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBasicObject.class}, 0, 0);

            GreaterEqualDoubleRubyBasicObjectNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                if (!super.isRubyBignum(arguments1Value)) {
                    return super.less(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyBignum] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    if (!super.isRubyBignum(arguments1Value)) {
                        return super.less(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterEqualNode create0(FloatNodes.GreaterEqualNode current) {
                return new GreaterEqualDoubleRubyBasicObjectNode((GreaterEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualDoubleRubyBignumNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            GreaterEqualDoubleRubyBignumNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterEqualNode create0(FloatNodes.GreaterEqualNode current) {
                return new GreaterEqualDoubleRubyBignumNode((GreaterEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualDoubleNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            GreaterEqualDoubleNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterEqualNode create0(FloatNodes.GreaterEqualNode current) {
                return new GreaterEqualDoubleNode((GreaterEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualDoubleLongNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            GreaterEqualDoubleLongNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterEqualNode create0(FloatNodes.GreaterEqualNode current) {
                return new GreaterEqualDoubleLongNode((GreaterEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GreaterEqualDoubleIntNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            GreaterEqualDoubleIntNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.greaterEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.greaterEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterEqualNode create0(FloatNodes.GreaterEqualNode current) {
                return new GreaterEqualDoubleIntNode((GreaterEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterEqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GreaterEqualUninitializedNode
        extends GreaterEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GreaterEqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GreaterEqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GreaterEqualUninitializedNode(GreaterEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GreaterEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GreaterEqualBaseNode rootNode = (GreaterEqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GreaterEqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.GreaterEqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GreaterEqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.GreaterEqualNode.class)
        private static abstract class GreaterEqualBaseNode
        extends FloatNodes.GreaterEqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GreaterEqualBaseNode next0;

            GreaterEqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GreaterEqualBaseNode(GreaterEqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                GreaterEqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GreaterEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GreaterEqualUninitializedNode(this);
                    ((GreaterEqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GreaterEqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = GreaterEqualBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GreaterEqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GreaterEqualUninitializedNode(this), (Node)new GreaterEqualPolymorphicNode(this), (DSLNode)((GreaterEqualBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GreaterEqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualDoubleRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && !super.isRubyBignum(arguments1Value)) {
                        return (GreaterEqualBaseNode)GreaterEqualDoubleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GreaterEqualBaseNode otherCast = (GreaterEqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GreaterEqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<FloatNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(FloatNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompareUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ComparePolymorphicNode
        extends CompareBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ComparePolymorphicNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : this.arguments[0].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyNilClassDoubleRubyBasicObjectNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyNilClassDoubleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBasicObject.class}, 0, 0);

            CompareRubyNilClassDoubleRubyBasicObjectNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject"));
                }
                if (!super.isNaN(arguments0Value) && !super.isRubyBignum(arguments1Value)) {
                    return super.compare(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNaN, !isRubyBignum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    if (!super.isNaN(arguments0ValueCast) && !super.isRubyBignum(arguments1Value)) {
                        return super.compare(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.CompareNode create0(FloatNodes.CompareNode current) {
                return new CompareRubyNilClassDoubleRubyBasicObjectNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntDoubleDoubleNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntDoubleDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            CompareIntDoubleDoubleNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                if (!super.isNaN(arguments0Value) && !super.isNaN(arguments1Value)) {
                    return super.compare(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNaN, !isNaN] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    if (!super.isNaN(arguments0ValueCast) && !super.isNaN(arguments1ValueCast)) {
                        return super.compare(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.CompareNode create0(FloatNodes.CompareNode current) {
                return new CompareIntDoubleDoubleNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntDoubleRubyBignum1Node
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntDoubleRubyBignum1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            CompareIntDoubleRubyBignum1Node(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                if (!super.isNaN(arguments0Value) && !super.isInfinity(arguments0Value)) {
                    return super.compare(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNaN, !isInfinity] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    if (!super.isNaN(arguments0ValueCast) && !super.isInfinity(arguments0ValueCast)) {
                        return super.compare(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.CompareNode create0(FloatNodes.CompareNode current) {
                return new CompareIntDoubleRubyBignum1Node((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntDoubleRubyBignum0Node
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntDoubleRubyBignum0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            CompareIntDoubleRubyBignum0Node(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                if (super.isInfinity(arguments0Value)) {
                    return super.compareInfinity(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isInfinity] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    if (super.isInfinity(arguments0ValueCast)) {
                        return super.compareInfinity(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.CompareNode create0(FloatNodes.CompareNode current) {
                return new CompareIntDoubleRubyBignum0Node((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntDoubleLongNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            CompareIntDoubleLongNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                if (!super.isNaN(arguments0Value)) {
                    return super.compare(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNaN] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    if (!super.isNaN(arguments0ValueCast)) {
                        return super.compare(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.CompareNode create0(FloatNodes.CompareNode current) {
                return new CompareIntDoubleLongNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareIntDoubleIntNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareIntDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            CompareIntDoubleIntNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (!super.isNaN(arguments0Value)) {
                    return super.compare(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNaN] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (!super.isNaN(arguments0ValueCast)) {
                        return super.compare(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.CompareNode create0(FloatNodes.CompareNode current) {
                return new CompareIntDoubleIntNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyNilClassObjectDoubleNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyNilClassObjectDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Double.TYPE}, 0, 0);

            CompareRubyNilClassObjectDoubleNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                if (super.isNaN(arguments1Value)) {
                    return super.compareSecondNaN(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNaN] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                double arguments1ValueCast;
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value) && super.isNaN(arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value))) {
                    return super.compareSecondNaN(arguments0Value, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.CompareNode create0(FloatNodes.CompareNode current) {
                return new CompareRubyNilClassObjectDoubleNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareRubyNilClassDoubleObjectNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareRubyNilClassDoubleObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Object.class}, 0, 0);

            CompareRubyNilClassDoubleObjectNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof double"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (super.isNaN(arguments0Value)) {
                    return super.compareFirstNaN(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNaN] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                double arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && super.isNaN(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value))) {
                    return super.compareFirstNaN(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.CompareNode create0(FloatNodes.CompareNode current) {
                return new CompareRubyNilClassDoubleObjectNode((CompareBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CompareUninitializedNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CompareUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CompareUninitializedNode(CompareBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CompareBaseNode rootNode = (CompareBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CompareBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.CompareNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompareUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.CompareNode.class)
        private static abstract class CompareBaseNode
        extends FloatNodes.CompareNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CompareBaseNode next0;

            CompareBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CompareBaseNode(CompareBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                CompareBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CompareBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CompareUninitializedNode(this);
                    ((CompareUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CompareBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CompareBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CompareBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CompareUninitializedNode(this), (Node)new ComparePolymorphicNode(this), (DSLNode)((CompareBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CompareBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                double arguments1ValueCast;
                double arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && super.isNaN(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value))) {
                    return (CompareBaseNode)CompareRubyNilClassDoubleObjectNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value) && super.isNaN(arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value))) {
                    return (CompareBaseNode)CompareRubyNilClassObjectDoubleNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments1ValueCast2;
                    arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && !super.isNaN(arguments0ValueCast)) {
                        return (CompareBaseNode)CompareIntDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && !super.isNaN(arguments0ValueCast)) {
                        return (CompareBaseNode)CompareIntDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        if (super.isInfinity(arguments0ValueCast)) {
                            return (CompareBaseNode)CompareIntDoubleRubyBignum0Node.create0(this);
                        }
                        if (!super.isNaN(arguments0ValueCast) && !super.isInfinity(arguments0ValueCast)) {
                            return (CompareBaseNode)CompareIntDoubleRubyBignum1Node.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value) && !super.isNaN(arguments0ValueCast) && !super.isNaN(arguments1ValueCast2 = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value))) {
                        return (CompareBaseNode)CompareIntDoubleDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && !super.isNaN(arguments0ValueCast) && !super.isRubyBignum(arguments1Value)) {
                        return (CompareBaseNode)CompareRubyNilClassDoubleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CompareBaseNode otherCast = (CompareBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CompareBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<FloatNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(FloatNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EqualPolymorphicNode
        extends EqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EqualPolymorphicNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualObjectRubyBasicObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualObjectRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBasicObject.class}, 0, 0);

            EqualObjectRubyBasicObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                if (!super.isRubyBignum(arguments1Value)) {
                    return super.equal(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyBignum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    if (!super.isRubyBignum(arguments1Value)) {
                        return super.equal(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.EqualNode create0(FloatNodes.EqualNode current) {
                return new EqualObjectRubyBasicObjectNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanRubyBignumNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            EqualBooleanRubyBignumNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.EqualNode create0(FloatNodes.EqualNode current) {
                return new EqualBooleanRubyBignumNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanDoubleNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            EqualBooleanDoubleNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.EqualNode create0(FloatNodes.EqualNode current) {
                return new EqualBooleanDoubleNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanLongNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            EqualBooleanLongNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.EqualNode create0(FloatNodes.EqualNode current) {
                return new EqualBooleanLongNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanIntNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            EqualBooleanIntNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.EqualNode create0(FloatNodes.EqualNode current) {
                return new EqualBooleanIntNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EqualUninitializedNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EqualUninitializedNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EqualBaseNode rootNode = (EqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.EqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.EqualNode.class)
        private static abstract class EqualBaseNode
        extends FloatNodes.EqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EqualBaseNode next0;

            EqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EqualBaseNode(EqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EqualUninitializedNode(this);
                    ((EqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EqualBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EqualUninitializedNode(this), (Node)new EqualPolymorphicNode(this), (DSLNode)((EqualBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (EqualBaseNode)EqualBooleanRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && !super.isRubyBignum(arguments1Value)) {
                        return (EqualBaseNode)EqualObjectRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EqualBaseNode otherCast = (EqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.LessEqualNode.class)
    public static final class LessEqualNodeFactory
    extends NodeFactoryBase<FloatNodes.LessEqualNode> {
        private static LessEqualNodeFactory lessEqualNodeFactoryInstance;

        private LessEqualNodeFactory() {
            super(FloatNodes.LessEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.LessEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LessEqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.LessEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LessEqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.LessEqualNode> getInstance() {
            if (lessEqualNodeFactoryInstance == null) {
                lessEqualNodeFactoryInstance = new LessEqualNodeFactory();
            }
            return lessEqualNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LessEqualPolymorphicNode
        extends LessEqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            LessEqualPolymorphicNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualDoubleRubyBasicObjectNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualDoubleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBasicObject.class}, 0, 0);

            LessEqualDoubleRubyBasicObjectNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                if (!super.isRubyBignum(arguments1Value)) {
                    return super.less(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyBignum] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    if (!super.isRubyBignum(arguments1Value)) {
                        return super.less(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessEqualNode create0(FloatNodes.LessEqualNode current) {
                return new LessEqualDoubleRubyBasicObjectNode((LessEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualDoubleRubyBignumNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            LessEqualDoubleRubyBignumNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessEqualNode create0(FloatNodes.LessEqualNode current) {
                return new LessEqualDoubleRubyBignumNode((LessEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualDoubleNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            LessEqualDoubleNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessEqualNode create0(FloatNodes.LessEqualNode current) {
                return new LessEqualDoubleNode((LessEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualDoubleLongNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            LessEqualDoubleLongNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessEqualNode create0(FloatNodes.LessEqualNode current) {
                return new LessEqualDoubleLongNode((LessEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessEqualDoubleIntNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            LessEqualDoubleIntNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.lessEqual(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.lessEqual(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessEqualNode create0(FloatNodes.LessEqualNode current) {
                return new LessEqualDoubleIntNode((LessEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.LessEqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LessEqualUninitializedNode
        extends LessEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessEqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LessEqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LessEqualUninitializedNode(LessEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                LessEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LessEqualBaseNode rootNode = (LessEqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LessEqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessEqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LessEqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.LessEqualNode.class)
        private static abstract class LessEqualBaseNode
        extends FloatNodes.LessEqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LessEqualBaseNode next0;

            LessEqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LessEqualBaseNode(LessEqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                LessEqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LessEqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new LessEqualUninitializedNode(this);
                    ((LessEqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LessEqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = LessEqualBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (LessEqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LessEqualUninitializedNode(this), (Node)new LessEqualPolymorphicNode(this), (DSLNode)((LessEqualBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LessEqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualDoubleRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && !super.isRubyBignum(arguments1Value)) {
                        return (LessEqualBaseNode)LessEqualDoubleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    LessEqualBaseNode otherCast = (LessEqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (LessEqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.LessNode.class)
    public static final class LessNodeFactory
    extends NodeFactoryBase<FloatNodes.LessNode> {
        private static LessNodeFactory lessNodeFactoryInstance;

        private LessNodeFactory() {
            super(FloatNodes.LessNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.LessNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LessNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.LessNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LessUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.LessNode> getInstance() {
            if (lessNodeFactoryInstance == null) {
                lessNodeFactoryInstance = new LessNodeFactory();
            }
            return lessNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LessPolymorphicNode
        extends LessBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            LessPolymorphicNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessDoubleRubyBasicObjectNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessDoubleRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBasicObject.class}, 0, 0);

            LessDoubleRubyBasicObjectNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                if (!super.isRubyBignum(arguments1Value)) {
                    return super.less(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyBignum] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    if (!super.isRubyBignum(arguments1Value)) {
                        return super.less(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessNode create0(FloatNodes.LessNode current) {
                return new LessDoubleRubyBasicObjectNode((LessBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessDoubleRubyBignumNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            LessDoubleRubyBignumNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessNode create0(FloatNodes.LessNode current) {
                return new LessDoubleRubyBignumNode((LessBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessDoubleNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            LessDoubleNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessNode create0(FloatNodes.LessNode current) {
                return new LessDoubleNode((LessBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessDoubleLongNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            LessDoubleLongNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessNode create0(FloatNodes.LessNode current) {
                return new LessDoubleLongNode((LessBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LessDoubleIntNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            LessDoubleIntNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.less(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.less(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessNode create0(FloatNodes.LessNode current) {
                return new LessDoubleIntNode((LessBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.LessNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LessUninitializedNode
        extends LessBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LessUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LessUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LessUninitializedNode(LessBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                LessBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LessBaseNode rootNode = (LessBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LessBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.LessNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LessUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.LessNode.class)
        private static abstract class LessBaseNode
        extends FloatNodes.LessNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LessBaseNode next0;

            LessBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LessBaseNode(LessBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                LessBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LessBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new LessUninitializedNode(this);
                    ((LessUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LessBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = LessBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (LessBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LessUninitializedNode(this), (Node)new LessPolymorphicNode(this), (DSLNode)((LessBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LessBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (LessBaseNode)LessDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (LessBaseNode)LessDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (LessBaseNode)LessDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (LessBaseNode)LessDoubleRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && !super.isRubyBignum(arguments1Value)) {
                        return (LessBaseNode)LessDoubleRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    LessBaseNode otherCast = (LessBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (LessBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.DivModNode.class)
    public static final class DivModNodeFactory
    extends NodeFactoryBase<FloatNodes.DivModNode> {
        private static DivModNodeFactory divModNodeFactoryInstance;

        private DivModNodeFactory() {
            super(FloatNodes.DivModNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.DivModNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DivModNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.DivModNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DivModUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.DivModNode> getInstance() {
            if (divModNodeFactoryInstance == null) {
                divModNodeFactoryInstance = new DivModNodeFactory();
            }
            return divModNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DivModPolymorphicNode
        extends DivModBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DivModPolymorphicNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModDoubleRubyBignumNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            DivModDoubleRubyBignumNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.DivModNode create0(FloatNodes.DivModNode current) {
                return new DivModDoubleRubyBignumNode((DivModBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModDoubleNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            DivModDoubleNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.DivModNode create0(FloatNodes.DivModNode current) {
                return new DivModDoubleNode((DivModBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModDoubleLongNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            DivModDoubleLongNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.DivModNode create0(FloatNodes.DivModNode current) {
                return new DivModDoubleLongNode((DivModBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivModDoubleIntNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            DivModDoubleIntNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.divMod(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.divMod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.DivModNode create0(FloatNodes.DivModNode current) {
                return new DivModDoubleIntNode((DivModBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.DivModNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DivModUninitializedNode
        extends DivModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivModUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DivModUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DivModUninitializedNode(DivModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DivModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DivModBaseNode rootNode = (DivModBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DivModBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.DivModNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DivModUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.DivModNode.class)
        private static abstract class DivModBaseNode
        extends FloatNodes.DivModNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DivModBaseNode next0;

            DivModBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DivModBaseNode(DivModBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                DivModBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DivModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DivModUninitializedNode(this);
                    ((DivModUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DivModBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DivModBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DivModBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DivModUninitializedNode(this), (Node)new DivModPolymorphicNode(this), (DSLNode)((DivModBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DivModBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (DivModBaseNode)DivModDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (DivModBaseNode)DivModDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (DivModBaseNode)DivModDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (DivModBaseNode)DivModDoubleRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DivModBaseNode otherCast = (DivModBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DivModBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.ModNode.class)
    public static final class ModNodeFactory
    extends NodeFactoryBase<FloatNodes.ModNode> {
        private static ModNodeFactory modNodeFactoryInstance;

        private ModNodeFactory() {
            super(FloatNodes.ModNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.ModNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ModNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.ModNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ModUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.ModNode> getInstance() {
            if (modNodeFactoryInstance == null) {
                modNodeFactoryInstance = new ModNodeFactory();
            }
            return modNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ModPolymorphicNode
        extends ModBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ModPolymorphicNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModDoubleRubyBignumNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            ModDoubleRubyBignumNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.ModNode create0(FloatNodes.ModNode current) {
                return new ModDoubleRubyBignumNode((ModBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModDoubleNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            ModDoubleNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.ModNode create0(FloatNodes.ModNode current) {
                return new ModDoubleNode((ModBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModDoubleLongNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            ModDoubleLongNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.ModNode create0(FloatNodes.ModNode current) {
                return new ModDoubleLongNode((ModBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ModDoubleIntNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            ModDoubleIntNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.mod(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.mod(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.ModNode create0(FloatNodes.ModNode current) {
                return new ModDoubleIntNode((ModBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.ModNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ModUninitializedNode
        extends ModBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ModUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ModUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ModUninitializedNode(ModBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ModBaseNode rootNode = (ModBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ModBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.ModNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ModUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.ModNode.class)
        private static abstract class ModBaseNode
        extends FloatNodes.ModNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ModBaseNode next0;

            ModBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ModBaseNode(ModBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ModBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ModBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ModUninitializedNode(this);
                    ((ModUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ModBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ModBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ModBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ModUninitializedNode(this), (Node)new ModPolymorphicNode(this), (DSLNode)((ModBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ModBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (ModBaseNode)ModDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (ModBaseNode)ModDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (ModBaseNode)ModDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (ModBaseNode)ModDoubleRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ModBaseNode otherCast = (ModBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ModBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.DivNode.class)
    public static final class DivNodeFactory
    extends NodeFactoryBase<FloatNodes.DivNode> {
        private static DivNodeFactory divNodeFactoryInstance;

        private DivNodeFactory() {
            super(FloatNodes.DivNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.DivNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DivNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.DivNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DivUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.DivNode> getInstance() {
            if (divNodeFactoryInstance == null) {
                divNodeFactoryInstance = new DivNodeFactory();
            }
            return divNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DivPolymorphicNode
        extends DivBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DivPolymorphicNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivObjectNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Object.class}, 0, 0);

            DivObjectNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof double");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isDouble(arguments1Value) || super.isRubyBignum(arguments1Value))) {
                    return super.div(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isInteger, !isLong, !isDouble, !isRubyBignum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!(!RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) || super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isDouble(arguments1Value) || super.isRubyBignum(arguments1Value))) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.div(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.DivNode create0(FloatNodes.DivNode current) {
                return new DivObjectNode((DivBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivDoubleRubyBignumNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            DivDoubleRubyBignumNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.DivNode create0(FloatNodes.DivNode current) {
                return new DivDoubleRubyBignumNode((DivBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivDoubleNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            DivDoubleNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.DivNode create0(FloatNodes.DivNode current) {
                return new DivDoubleNode((DivBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivDoubleLongNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            DivDoubleLongNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.DivNode create0(FloatNodes.DivNode current) {
                return new DivDoubleLongNode((DivBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DivDoubleIntNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            DivDoubleIntNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.div(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.div(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.DivNode create0(FloatNodes.DivNode current) {
                return new DivDoubleIntNode((DivBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.DivNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DivUninitializedNode
        extends DivBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DivUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DivUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DivUninitializedNode(DivBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DivBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DivBaseNode rootNode = (DivBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DivBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.DivNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DivUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.DivNode.class)
        private static abstract class DivBaseNode
        extends FloatNodes.DivNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DivBaseNode next0;

            DivBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DivBaseNode(DivBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                DivBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DivBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DivUninitializedNode(this);
                    ((DivUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DivBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DivBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DivBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DivUninitializedNode(this), (Node)new DivPolymorphicNode(this), (DSLNode)((DivBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DivBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (DivBaseNode)DivDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (DivBaseNode)DivDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (DivBaseNode)DivDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (DivBaseNode)DivDoubleRubyBignumNode.create0(this);
                    }
                    if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isDouble(arguments1Value) || super.isRubyBignum(arguments1Value))) {
                        return (DivBaseNode)DivObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DivBaseNode otherCast = (DivBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DivBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.PowNode.class)
    public static final class PowNodeFactory
    extends NodeFactoryBase<FloatNodes.PowNode> {
        private static PowNodeFactory powNodeFactoryInstance;

        private PowNodeFactory() {
            super(FloatNodes.PowNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.PowNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PowNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.PowNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PowUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.PowNode> getInstance() {
            if (powNodeFactoryInstance == null) {
                powNodeFactoryInstance = new PowNodeFactory();
            }
            return powNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PowPolymorphicNode
        extends PowBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PowPolymorphicNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowObjectRubyBasicObjectNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowObjectRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBasicObject.class}, 0, 0);

            PowObjectRubyBasicObjectNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                if (!super.isRubyBignum(arguments1Value)) {
                    return super.powCoerced(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyBignum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    if (!super.isRubyBignum(arguments1Value)) {
                        return super.powCoerced(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.PowNode create0(FloatNodes.PowNode current) {
                return new PowObjectRubyBasicObjectNode((PowBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowDoubleRubyBignumNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            PowDoubleRubyBignumNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.PowNode create0(FloatNodes.PowNode current) {
                return new PowDoubleRubyBignumNode((PowBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowObjectDoubleNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowObjectDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            PowObjectDoubleNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.pow(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.pow(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.PowNode create0(FloatNodes.PowNode current) {
                return new PowObjectDoubleNode((PowBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowDoubleLongNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            PowDoubleLongNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.PowNode create0(FloatNodes.PowNode current) {
                return new PowDoubleLongNode((PowBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PowDoubleIntNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            PowDoubleIntNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.pow(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.pow(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.PowNode create0(FloatNodes.PowNode current) {
                return new PowDoubleIntNode((PowBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.PowNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PowUninitializedNode
        extends PowBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PowUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PowUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PowUninitializedNode(PowBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PowBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PowBaseNode rootNode = (PowBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PowBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.PowNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PowUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.PowNode.class)
        private static abstract class PowBaseNode
        extends FloatNodes.PowNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PowBaseNode next0;

            PowBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PowBaseNode(PowBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PowBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PowBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PowUninitializedNode(this);
                    ((PowUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PowBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PowBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PowBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PowUninitializedNode(this), (Node)new PowPolymorphicNode(this), (DSLNode)((PowBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PowBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (PowBaseNode)PowDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (PowBaseNode)PowDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (PowBaseNode)PowObjectDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (PowBaseNode)PowDoubleRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && !super.isRubyBignum(arguments1Value)) {
                        return (PowBaseNode)PowObjectRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PowBaseNode otherCast = (PowBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PowBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.MulNode.class)
    public static final class MulNodeFactory
    extends NodeFactoryBase<FloatNodes.MulNode> {
        private static MulNodeFactory mulNodeFactoryInstance;

        private MulNodeFactory() {
            super(FloatNodes.MulNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.MulNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MulNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.MulNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MulUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.MulNode> getInstance() {
            if (mulNodeFactoryInstance == null) {
                mulNodeFactoryInstance = new MulNodeFactory();
            }
            return mulNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MulPolymorphicNode
        extends MulBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MulPolymorphicNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulObjectRubyBasicObjectNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulObjectRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBasicObject.class}, 0, 0);

            MulObjectRubyBasicObjectNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                if (!super.isRubyBignum(arguments1Value)) {
                    return super.mulCoerced(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyBignum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    if (!super.isRubyBignum(arguments1Value)) {
                        return super.mulCoerced(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.MulNode create0(FloatNodes.MulNode current) {
                return new MulObjectRubyBasicObjectNode((MulBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulDoubleRubyBignumNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            MulDoubleRubyBignumNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.MulNode create0(FloatNodes.MulNode current) {
                return new MulDoubleRubyBignumNode((MulBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulDoubleNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            MulDoubleNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.MulNode create0(FloatNodes.MulNode current) {
                return new MulDoubleNode((MulBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulDoubleLongNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            MulDoubleLongNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.MulNode create0(FloatNodes.MulNode current) {
                return new MulDoubleLongNode((MulBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MulDoubleIntNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            MulDoubleIntNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.mul(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.mul(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.MulNode create0(FloatNodes.MulNode current) {
                return new MulDoubleIntNode((MulBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.MulNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MulUninitializedNode
        extends MulBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MulUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MulUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MulUninitializedNode(MulBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MulBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MulBaseNode rootNode = (MulBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MulBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.MulNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MulUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.MulNode.class)
        private static abstract class MulBaseNode
        extends FloatNodes.MulNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MulBaseNode next0;

            MulBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MulBaseNode(MulBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                MulBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MulBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MulUninitializedNode(this);
                    ((MulUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MulBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MulBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MulBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MulUninitializedNode(this), (Node)new MulPolymorphicNode(this), (DSLNode)((MulBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MulBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (MulBaseNode)MulDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (MulBaseNode)MulDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (MulBaseNode)MulDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (MulBaseNode)MulDoubleRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && !super.isRubyBignum(arguments1Value)) {
                        return (MulBaseNode)MulObjectRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MulBaseNode otherCast = (MulBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MulBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.SubNode.class)
    public static final class SubNodeFactory
    extends NodeFactoryBase<FloatNodes.SubNode> {
        private static SubNodeFactory subNodeFactoryInstance;

        private SubNodeFactory() {
            super(FloatNodes.SubNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.SubNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SubNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.SubNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SubUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.SubNode> getInstance() {
            if (subNodeFactoryInstance == null) {
                subNodeFactoryInstance = new SubNodeFactory();
            }
            return subNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SubPolymorphicNode
        extends SubBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SubPolymorphicNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : (this.arguments1PolymorphicType == RubyBasicObject.class ? this.arguments[1].executeRubyBasicObject(frameValue) : this.arguments[1].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubObjectRubyBasicObjectNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubObjectRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBasicObject.class}, 0, 0);

            SubObjectRubyBasicObjectNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                if (!super.isRubyBignum(arguments1Value)) {
                    return super.subCoerced(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyBignum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    if (!super.isRubyBignum(arguments1Value)) {
                        return super.subCoerced(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.SubNode create0(FloatNodes.SubNode current) {
                return new SubObjectRubyBasicObjectNode((SubBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubDoubleRubyBignumNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            SubDoubleRubyBignumNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum"));
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.SubNode create0(FloatNodes.SubNode current) {
                return new SubDoubleRubyBignumNode((SubBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubDoubleNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            SubDoubleNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double"));
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.SubNode create0(FloatNodes.SubNode current) {
                return new SubDoubleNode((SubBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubDoubleLongNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            SubDoubleLongNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long"));
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.SubNode create0(FloatNodes.SubNode current) {
                return new SubDoubleLongNode((SubBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SubDoubleIntNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            SubDoubleIntNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                return super.sub(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.sub(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.SubNode create0(FloatNodes.SubNode current) {
                return new SubDoubleIntNode((SubBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.SubNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SubUninitializedNode
        extends SubBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SubUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SubUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SubUninitializedNode(SubBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SubBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SubBaseNode rootNode = (SubBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SubBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.SubNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SubUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.SubNode.class)
        private static abstract class SubBaseNode
        extends FloatNodes.SubNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SubBaseNode next0;

            SubBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SubBaseNode(SubBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                SubBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SubBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SubUninitializedNode(this);
                    ((SubUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SubBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SubBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SubBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SubUninitializedNode(this), (Node)new SubPolymorphicNode(this), (DSLNode)((SubBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SubBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (SubBaseNode)SubDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (SubBaseNode)SubDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (SubBaseNode)SubDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (SubBaseNode)SubDoubleRubyBignumNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value) && !super.isRubyBignum(arguments1Value)) {
                        return (SubBaseNode)SubObjectRubyBasicObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SubBaseNode otherCast = (SubBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SubBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<FloatNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(FloatNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.AddNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AddNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.AddNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AddUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AddPolymorphicNode
        extends AddBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AddPolymorphicNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyBignum.class ? this.arguments[1].executeBignum(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=FloatNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddDoubleRubyBignumNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, RubyBignum.class}, 0, 0);

            AddDoubleRubyBignumNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBignum");
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    RubyBignum arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.AddNode create0(FloatNodes.AddNode current) {
                return new AddDoubleRubyBignumNode((AddBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddDoubleNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            AddDoubleNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.AddNode create0(FloatNodes.AddNode current) {
                return new AddDoubleNode((AddBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddDoubleLongNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Long.TYPE}, 0, 0);

            AddDoubleLongNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof long");
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.AddNode create0(FloatNodes.AddNode current) {
                return new AddDoubleLongNode((AddBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AddDoubleIntNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Integer.TYPE}, 0, 0);

            AddDoubleIntNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof double");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.add(arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.add(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.AddNode create0(FloatNodes.AddNode current) {
                return new AddDoubleIntNode((AddBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.AddNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AddUninitializedNode
        extends AddBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AddUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AddUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AddUninitializedNode(AddBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AddBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AddBaseNode rootNode = (AddBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AddBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static FloatNodes.AddNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AddUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.AddNode.class)
        private static abstract class AddBaseNode
        extends FloatNodes.AddNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AddBaseNode next0;

            AddBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AddBaseNode(AddBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                AddBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AddBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AddUninitializedNode(this);
                    ((AddUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AddBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AddBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (AddBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AddUninitializedNode(this), (Node)new AddPolymorphicNode(this), (DSLNode)((AddBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AddBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (AddBaseNode)AddDoubleIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (AddBaseNode)AddDoubleLongNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (AddBaseNode)AddDoubleNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments1Value)) {
                        return (AddBaseNode)AddDoubleRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AddBaseNode otherCast = (AddBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AddBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=FloatNodes.NegNode.class)
    public static final class NegNodeFactory
    extends NodeFactoryBase<FloatNodes.NegNode> {
        private static NegNodeFactory negNodeFactoryInstance;

        private NegNodeFactory() {
            super(FloatNodes.NegNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public FloatNodes.NegNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NegNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static FloatNodes.NegNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NegUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<FloatNodes.NegNode> getInstance() {
            if (negNodeFactoryInstance == null) {
                negNodeFactoryInstance = new NegNodeFactory();
            }
            return negNodeFactoryInstance;
        }

        @GeneratedBy(value=FloatNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class NegPolymorphicNode
        extends NegBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            NegPolymorphicNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=FloatNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NegDoubleNode
        extends NegBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NegDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            NegDoubleNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.neg(arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.neg(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.NegNode create0(FloatNodes.NegNode current) {
                return new NegDoubleNode((NegBaseNode)current);
            }
        }

        @GeneratedBy(value=FloatNodes.NegNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class NegUninitializedNode
        extends NegBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NegUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            NegUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            NegUninitializedNode(NegBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected double executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected double executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                NegBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    NegBaseNode rootNode = (NegBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((NegBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static FloatNodes.NegNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NegUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=FloatNodes.NegNode.class)
        private static abstract class NegBaseNode
        extends FloatNodes.NegNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected NegBaseNode next0;

            NegBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            NegBaseNode(NegBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract double executeChained0(VirtualFrame var1, Object var2);

            protected final double rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                NegBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                NegBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new NegUninitializedNode(this);
                    ((NegUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (NegBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = NegBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (NegBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new NegUninitializedNode(this), (Node)new NegPolymorphicNode(this), (DSLNode)((NegBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final NegBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (NegBaseNode)NegDoubleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((NegBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (NegBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

