/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.core.GeneralDivModNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

@CoreClass(name="Float")
public abstract class FloatNodes {

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(double value) {
            return this.getContext().makeString(Double.toString(value));
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToFNode(ToFNode prev) {
            super(prev);
        }

        @Specialization
        public double toF(double value) {
            return value;
        }
    }

    @CoreMethod(names={"to_i", "to_int", "truncate"})
    public static abstract class ToINode
    extends CoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public ToINode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public ToINode(ToINode prev) {
            super(prev);
            this.fixnumOrBignum = prev.fixnumOrBignum;
        }

        public abstract Object executeToI(VirtualFrame var1, double var2);

        @Specialization
        Object toI(double value) {
            if (Double.isInfinite(value)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Infinity", this));
            }
            if (Double.isNaN(value)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("NaN", this));
            }
            return this.fixnumOrBignum.fixnumOrBignum(value);
        }
    }

    @CoreMethod(names={"round"}, optional=1)
    public static abstract class RoundNode
    extends CoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;
        private final BranchProfile greaterZero = BranchProfile.create();
        private final BranchProfile lessZero = BranchProfile.create();

        public RoundNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public RoundNode(RoundNode prev) {
            super(prev);
            this.fixnumOrBignum = prev.fixnumOrBignum;
        }

        @Specialization
        public Object round(double n, UndefinedPlaceholder undefinedPlaceholder) {
            if (Double.isInfinite(n)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Infinity", this));
            }
            if (Double.isNaN(n)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("NaN", this));
            }
            double f = n;
            if (f > 0.0) {
                this.greaterZero.enter();
                f = Math.floor(f);
                if (n - f >= 0.5) {
                    f += 1.0;
                }
            } else if (f < 0.0) {
                this.lessZero.enter();
                f = Math.ceil(f);
                if (f - n >= 0.5) {
                    f -= 1.0;
                }
            }
            return this.fixnumOrBignum.fixnumOrBignum(f);
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[1])"})
        public Object round(VirtualFrame frame, double n, Object ndigits) {
            return this.ruby(frame, "round_internal(ndigits)", "ndigits", ndigits);
        }
    }

    @CoreMethod(names={"nan?"})
    public static abstract class NaNNode
    extends CoreMethodNode {
        public NaNNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NaNNode(NaNNode prev) {
            super(prev);
        }

        @Specialization
        public boolean nan(double value) {
            return Double.isNaN(value);
        }
    }

    @CoreMethod(names={"infinite?"})
    public static abstract class InfiniteNode
    extends CoreMethodNode {
        public InfiniteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InfiniteNode(InfiniteNode prev) {
            super(prev);
        }

        @Specialization
        public Object infinite(double value) {
            if (Double.isInfinite(value)) {
                if (value < 0.0) {
                    return -1;
                }
                return 1;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"floor"})
    public static abstract class FloorNode
    extends CoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public FloorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public FloorNode(FloorNode prev) {
            super(prev);
            this.fixnumOrBignum = prev.fixnumOrBignum;
        }

        @Specialization
        public Object floor(double n) {
            return this.fixnumOrBignum.fixnumOrBignum(Math.floor(n));
        }
    }

    @CoreMethod(names={"ceil"})
    public static abstract class CeilNode
    extends CoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public CeilNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public CeilNode(CeilNode prev) {
            super(prev);
            this.fixnumOrBignum = prev.fixnumOrBignum;
        }

        @Specialization
        public Object ceil(double n) {
            return this.fixnumOrBignum.fixnumOrBignum(Math.ceil(n));
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends CoreMethodNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AbsNode(AbsNode prev) {
            super(prev);
        }

        @Specialization
        public double abs(double n) {
            return Math.abs(n);
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends CoreMethodNode {
        public GreaterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterNode(GreaterNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(double a, int b) {
            return a > (double)b;
        }

        @Specialization
        public boolean equal(double a, long b) {
            return a > (double)b;
        }

        @Specialization
        public boolean equal(double a, double b) {
            return a > b;
        }

        @Specialization
        public boolean equal(double a, RubyBignum b) {
            return a > b.bigIntegerValue().doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public boolean less(double a, RubyBasicObject other) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(String.format("comparison of Float with %s failed", other.getLogicalClass().getName()), this));
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends CoreMethodNode {
        public GreaterEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterEqualNode(GreaterEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greaterEqual(double a, int b) {
            return a >= (double)b;
        }

        @Specialization
        public boolean greaterEqual(double a, long b) {
            return a >= (double)b;
        }

        @Specialization
        public boolean greaterEqual(double a, double b) {
            return a >= b;
        }

        @Specialization
        public boolean greaterEqual(double a, RubyBignum b) {
            return a >= b.bigIntegerValue().doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public boolean less(double a, RubyBasicObject other) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(String.format("comparison of Float with %s failed", other.getLogicalClass().getName()), this));
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNaN(arguments[0])"})
        public RubyNilClass compareFirstNaN(double a, Object b) {
            return this.nil();
        }

        @Specialization(guards={"isNaN(arguments[1])"})
        public RubyNilClass compareSecondNaN(Object a, double b) {
            return this.nil();
        }

        @Specialization(guards={"!isNaN(arguments[0])"})
        public int compare(double a, int b) {
            return Double.compare(a, b);
        }

        @Specialization(guards={"!isNaN(arguments[0])"})
        public int compare(double a, long b) {
            return Double.compare(a, b);
        }

        @Specialization(guards={"isInfinity(arguments[0])"})
        public int compareInfinity(double a, RubyBignum b) {
            if (a < 0.0) {
                return -1;
            }
            return 1;
        }

        @Specialization(guards={"!isNaN(arguments[0])", "!isInfinity(arguments[0])"})
        public int compare(double a, RubyBignum b) {
            return Double.compare(a, b.bigIntegerValue().doubleValue());
        }

        @Specialization(guards={"!isNaN(arguments[0])", "!isNaN(arguments[1])"})
        public int compare(double a, double b) {
            return Double.compare(a, b);
        }

        @Specialization(guards={"!isNaN(arguments[0])", "!isRubyBignum(arguments[1])"})
        public RubyNilClass compare(double a, RubyBasicObject b) {
            return this.nil();
        }
    }

    @CoreMethod(names={"==", "==="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(double a, int b) {
            return a == (double)b;
        }

        @Specialization
        public boolean equal(double a, long b) {
            return a == (double)b;
        }

        @Specialization
        public boolean equal(double a, double b) {
            return a == b;
        }

        @Specialization
        public boolean equal(double a, RubyBignum b) {
            return a == b.bigIntegerValue().doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object equal(VirtualFrame frame, double a, RubyBasicObject b) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            return this.fallbackCallNode.call(frame, a, "equal_fallback", null, b);
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends CoreMethodNode {
        public LessEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessEqualNode(LessEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean lessEqual(double a, int b) {
            return a <= (double)b;
        }

        @Specialization
        public boolean lessEqual(double a, long b) {
            return a <= (double)b;
        }

        @Specialization
        public boolean lessEqual(double a, double b) {
            return a <= b;
        }

        @Specialization
        public boolean lessEqual(double a, RubyBignum b) {
            return a <= b.bigIntegerValue().doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public boolean less(double a, RubyBasicObject other) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(String.format("comparison of Float with %s failed", other.getLogicalClass().getName()), this));
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends CoreMethodNode {
        public LessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessNode(LessNode prev) {
            super(prev);
        }

        @Specialization
        public boolean less(double a, int b) {
            return a < (double)b;
        }

        @Specialization
        public boolean less(double a, long b) {
            return a < (double)b;
        }

        @Specialization
        public boolean less(double a, double b) {
            return a < b;
        }

        @Specialization
        public boolean less(double a, RubyBignum b) {
            return a < b.bigIntegerValue().doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public boolean less(double a, RubyBasicObject other) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(String.format("comparison of Float with %s failed", other.getLogicalClass().getName()), this));
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        public DivModNode(DivModNode prev) {
            super(prev);
            this.divModNode = prev.divModNode;
        }

        @Specialization
        public RubyArray divMod(double a, int b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(double a, long b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(double a, double b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(double a, RubyBignum b) {
            return this.divModNode.execute(a, b);
        }
    }

    @CoreMethod(names={"%"}, required=1)
    public static abstract class ModNode
    extends CoreMethodNode {
        private ConditionProfile lessThanZeroProfile = ConditionProfile.createBinaryProfile();

        public ModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ModNode(ModNode prev) {
            super(prev);
        }

        @Specialization
        public double mod(double a, int b) {
            return this.mod(a, (double)b);
        }

        @Specialization
        public double mod(double a, long b) {
            return this.mod(a, (double)b);
        }

        @Specialization
        public double mod(double a, double b) {
            if (b == 0.0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().zeroDivisionError(this));
            }
            double result = Math.IEEEremainder(a, b);
            if (this.lessThanZeroProfile.profile(b * result < 0.0)) {
                result += b;
            }
            return result;
        }

        @Specialization
        public double mod(double a, RubyBignum b) {
            return this.mod(a, b.bigIntegerValue().doubleValue());
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode redoCoercedNode;

        public DivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DivNode(DivNode prev) {
            super(prev);
            this.redoCoercedNode = prev.redoCoercedNode;
        }

        @Specialization
        public double div(double a, int b) {
            return a / (double)b;
        }

        @Specialization
        public double div(double a, long b) {
            return a / (double)b;
        }

        @Specialization
        public double div(double a, double b) {
            return a / b;
        }

        @Specialization
        public double div(double a, RubyBignum b) {
            return a / b.bigIntegerValue().doubleValue();
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])", "!isDouble(arguments[1])", "!isRubyBignum(arguments[1])"})
        public Object div(VirtualFrame frame, double a, Object b) {
            if (this.redoCoercedNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.redoCoercedNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            return this.redoCoercedNode.call(frame, a, "redo_coerced", null, this.getContext().getSymbolTable().getSymbol("/"), b);
        }
    }

    @CoreMethod(names={"**"}, required=1)
    public static abstract class PowNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode complexConvertNode;
        @Node.Child
        private CallDispatchHeadNode complexPowNode;
        private final ConditionProfile complexProfile = ConditionProfile.createBinaryProfile();

        public PowNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PowNode(PowNode prev) {
            super(prev);
        }

        @Specialization
        public double pow(double a, int b) {
            return Math.pow(a, b);
        }

        @Specialization
        public double pow(double a, long b) {
            return Math.pow(a, b);
        }

        @Specialization
        public Object pow(VirtualFrame frame, double a, double b) {
            if (this.complexProfile.profile(a < 0.0 && b != (double)Math.round(b))) {
                if (this.complexConvertNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.complexConvertNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
                    this.complexPowNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                Object aComplex = this.complexConvertNode.call(frame, this.getContext().getCoreLibrary().getComplexClass(), "convert", null, a, 0);
                return this.complexPowNode.call(frame, aComplex, "**", null, b);
            }
            return Math.pow(a, b);
        }

        @Specialization
        public double pow(double a, RubyBignum b) {
            return Math.pow(a, b.bigIntegerValue().doubleValue());
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object powCoerced(VirtualFrame frame, double a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :**, b", "b", b);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends CoreMethodNode {
        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MulNode(MulNode prev) {
            super(prev);
        }

        @Specialization
        public double mul(double a, int b) {
            return a * (double)b;
        }

        @Specialization
        public double mul(double a, long b) {
            return a * (double)b;
        }

        @Specialization
        public double mul(double a, double b) {
            return a * b;
        }

        @Specialization
        public double mul(double a, RubyBignum b) {
            return a * b.bigIntegerValue().doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object mulCoerced(VirtualFrame frame, double a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :*, b", "b", b);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends CoreMethodNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SubNode(SubNode prev) {
            super(prev);
        }

        @Specialization
        public double sub(double a, int b) {
            return a - (double)b;
        }

        @Specialization
        public double sub(double a, long b) {
            return a - (double)b;
        }

        @Specialization
        public double sub(double a, double b) {
            return a - b;
        }

        @Specialization
        public double sub(double a, RubyBignum b) {
            return a - b.bigIntegerValue().doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object subCoerced(VirtualFrame frame, double a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :-, b", "b", b);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends CoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AddNode(AddNode prev) {
            super(prev);
        }

        @Specialization
        public double add(double a, int b) {
            return a + (double)b;
        }

        @Specialization
        public double add(double a, long b) {
            return a + (double)b;
        }

        @Specialization
        public double add(double a, double b) {
            return a + b;
        }

        @Specialization
        public double add(double a, RubyBignum b) {
            return a + b.bigIntegerValue().doubleValue();
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends CoreMethodNode {
        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NegNode(NegNode prev) {
            super(prev);
        }

        @Specialization
        public double neg(double value) {
            return -value;
        }
    }
}

