/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.coerce;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;

@GeneratedBy(value=ToIntNode.class)
public final class ToIntNodeFactory
extends NodeFactoryBase<ToIntNode> {
    private static ToIntNodeFactory instance;

    private ToIntNodeFactory() {
        super(ToIntNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public ToIntNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return ToIntNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ToIntNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return ToIntUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<ToIntNode> getInstance() {
        if (instance == null) {
            instance = new ToIntNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ToIntNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ToIntPolymorphicNode
    extends ToIntBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        ToIntPolymorphicNode(ToIntBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.child.executeBoolean(frameValue)) : (this.childPolymorphicType == Integer.TYPE ? Integer.valueOf(this.child.executeIntegerFixnum(frameValue)) : (this.childPolymorphicType == Long.TYPE ? Long.valueOf(this.child.executeLongFixnum(frameValue)) : (this.childPolymorphicType == Double.TYPE ? Double.valueOf(this.child.executeFloat(frameValue)) : (this.childPolymorphicType == RubyBignum.class ? this.child.executeBignum(frameValue) : (this.childPolymorphicType == RubyBasicObject.class ? this.child.executeRubyBasicObject(frameValue) : this.child.execute(frameValue))))));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public int executeInt(VirtualFrame frameValue, Object childValueEvaluated) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == Boolean.TYPE ? Boolean.valueOf(RubyTypesGen.RUBYTYPES.expectBoolean(childValueEvaluated)) : (this.childPolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(childValueEvaluated)) : (this.childPolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(childValueEvaluated)) : (this.childPolymorphicType == Double.TYPE ? Double.valueOf(RubyTypesGen.RUBYTYPES.expectDouble(childValueEvaluated)) : (this.childPolymorphicType == RubyBignum.class ? RubyTypesGen.RUBYTYPES.expectRubyBignum(childValueEvaluated) : (this.childPolymorphicType == RubyBasicObject.class ? RubyTypesGen.RUBYTYPES.expectRubyBasicObject(childValueEvaluated) : childValueEvaluated)))));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return RubyTypesGen.RUBYTYPES.asInteger(this.next0.executeChained0(frameValue, ex.getResult()));
            }
            return RubyTypesGen.RUBYTYPES.asInteger(this.next0.executeChained0(frameValue, childValue));
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=ToIntNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToIntObjectRubyBasicObjectNode
    extends ToIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToIntObjectRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        ToIntObjectRubyBasicObjectNode(ToIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyBasicObject childValue;
            try {
                childValue = this.child.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBasicObject");
            }
            if (!super.isRubyBignum(childValue)) {
                return super.coerceBasicObject(frameValue, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [!isRubyBignum] failed");
        }

        @Override
        public int executeInt(VirtualFrame frameValue, Object childValueEvaluated) {
            RubyBasicObject childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.asInteger(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBasicObject"));
            }
            if (!super.isRubyBignum(childValue)) {
                return RubyTypesGen.RUBYTYPES.asInteger(super.coerceBasicObject(frameValue, childValue));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.asInteger(this.rewrite0(frameValue, childValue, "One of guards [!isRubyBignum] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue)) {
                RubyBasicObject childValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(childValue);
                if (!super.isRubyBignum(childValue)) {
                    return super.coerceBasicObject(frameValue, childValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToIntNode create0(ToIntNode current) {
            return new ToIntObjectRubyBasicObjectNode((ToIntBaseNode)current);
        }
    }

    @GeneratedBy(value=ToIntNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToIntObjectBooleanNode
    extends ToIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToIntObjectBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        ToIntObjectBooleanNode(ToIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean childValue;
            try {
                childValue = this.child.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof boolean");
            }
            return super.coerceBoolean(frameValue, childValue);
        }

        @Override
        public int executeInt(VirtualFrame frameValue, Object childValueEvaluated) {
            boolean childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectBoolean(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.asInteger(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof boolean"));
            }
            return RubyTypesGen.RUBYTYPES.asInteger(super.coerceBoolean(frameValue, childValue));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                boolean childValueCast = RubyTypesGen.RUBYTYPES.asBoolean(childValue);
                return super.coerceBoolean(frameValue, childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToIntNode create0(ToIntNode current) {
            return new ToIntObjectBooleanNode((ToIntBaseNode)current);
        }
    }

    @GeneratedBy(value=ToIntNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToIntObjectDoubleNode
    extends ToIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToIntObjectDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        ToIntObjectDoubleNode(ToIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double childValue;
            try {
                childValue = this.child.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof double");
            }
            return super.coerceDouble(frameValue, childValue);
        }

        @Override
        public int executeInt(VirtualFrame frameValue, Object childValueEvaluated) {
            double childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectDouble(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.asInteger(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof double"));
            }
            return RubyTypesGen.RUBYTYPES.asInteger(super.coerceDouble(frameValue, childValue));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                double childValueCast = RubyTypesGen.RUBYTYPES.asDouble(childValue);
                return super.coerceDouble(frameValue, childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToIntNode create0(ToIntNode current) {
            return new ToIntObjectDoubleNode((ToIntBaseNode)current);
        }
    }

    @GeneratedBy(value=ToIntNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToIntRubyBignumNode
    extends ToIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToIntRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

        ToIntRubyBignumNode(ToIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyBignum value;
            try {
                value = this.executeBignum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBignum childValue;
            try {
                childValue = this.child.executeBignum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBignum"));
            }
            return super.coerceRubyBignum(childValue);
        }

        @Override
        public int executeInt(VirtualFrame frameValue, Object childValueEvaluated) {
            RubyBignum childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyBignum(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.asInteger(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBignum"));
            }
            return RubyTypesGen.RUBYTYPES.asInteger(super.coerceRubyBignum(childValue));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(childValue)) {
                RubyBignum childValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(childValue);
                return super.coerceRubyBignum(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToIntNode create0(ToIntNode current) {
            return new ToIntRubyBignumNode((ToIntBaseNode)current);
        }
    }

    @GeneratedBy(value=ToIntNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToIntLongNode
    extends ToIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToIntLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        ToIntLongNode(ToIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long value;
            try {
                value = this.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            long childValue;
            try {
                childValue = this.child.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof long"));
            }
            return super.coerceLong(childValue);
        }

        @Override
        public int executeInt(VirtualFrame frameValue, Object childValueEvaluated) {
            long childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectLong(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.asInteger(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof long"));
            }
            return RubyTypesGen.RUBYTYPES.asInteger(super.coerceLong(childValue));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                long childValueCast = RubyTypesGen.RUBYTYPES.asLong(childValue);
                return super.coerceLong(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToIntNode create0(ToIntNode current) {
            return new ToIntLongNode((ToIntBaseNode)current);
        }
    }

    @GeneratedBy(value=ToIntNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToIntIntNode
    extends ToIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToIntIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        ToIntIntNode(ToIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int childValue;
            try {
                childValue = this.child.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof int"));
            }
            return super.coerceInt(childValue);
        }

        @Override
        public int executeInt(VirtualFrame frameValue, Object childValueEvaluated) {
            int childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectInteger(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.asInteger(this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof int"));
            }
            return super.coerceInt(childValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                int childValueCast = RubyTypesGen.RUBYTYPES.asInteger(childValue);
                return super.coerceInt(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToIntNode create0(ToIntNode current) {
            return new ToIntIntNode((ToIntBaseNode)current);
        }
    }

    @GeneratedBy(value=ToIntNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ToIntUninitializedNode
    extends ToIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToIntUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ToIntUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        ToIntUninitializedNode(ToIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        public int executeInt(VirtualFrame frameValue, Object childValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = childValueEvaluated;
            return RubyTypesGen.RUBYTYPES.asInteger(this.executeUninitialized0(frameValue, childValue));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            ToIntBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ToIntBaseNode rootNode = (ToIntBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ToIntBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, childValue);
        }

        static ToIntNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new ToIntUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=ToIntNode.class)
    private static abstract class ToIntBaseNode
    extends ToIntNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected ToIntBaseNode next0;

        ToIntBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        ToIntBaseNode(ToIntBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2);

        protected final Object rewrite0(VirtualFrame frameValue, Object childValue, String reason) {
            String message;
            ToIntBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ToIntBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new ToIntUninitializedNode(this);
                ((ToIntUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ToIntBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToIntBaseNode.createInfo0(reason, childValue)))) == null) {
                returnNode = (ToIntBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToIntUninitializedNode(this), (Node)new ToIntPolymorphicNode(this), (DSLNode)((ToIntBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ToIntBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                return (ToIntBaseNode)ToIntIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                return (ToIntBaseNode)ToIntLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(childValue)) {
                return (ToIntBaseNode)ToIntRubyBignumNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                return (ToIntBaseNode)ToIntObjectDoubleNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                return (ToIntBaseNode)ToIntObjectBooleanNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue) && !super.isRubyBignum(childValue)) {
                return (ToIntBaseNode)ToIntObjectRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((ToIntBaseNode)other).child;
            this.next0 = newNext == null ? null : (ToIntBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

