/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.coerce;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;

@NodeChild(value="child", type=RubyNode.class)
public abstract class ToAryNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toAryNode;

    public ToAryNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public ToAryNode(ToAryNode prev) {
        super(prev);
    }

    @Specialization
    public RubyArray coerceRubyArray(RubyArray rubyArray) {
        return rubyArray;
    }

    @Specialization(guards={"!isRubyArray"})
    public RubyArray coerceObject(VirtualFrame frame, Object object) {
        Object coerced;
        ToAryNode.notDesignedForCompilation();
        if (this.toAryNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toAryNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        try {
            coerced = this.toAryNode.call(frame, object, "to_ary", null, new Object[0]);
        }
        catch (RaiseException e) {
            if (e.getRubyException().getLogicalClass() == this.getContext().getCoreLibrary().getNoMethodErrorClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(object, "Array", this));
            }
            throw e;
        }
        if (coerced instanceof RubyArray) {
            return (RubyArray)coerced;
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorBadCoercion(object, "Array", "to_ary", coerced, this));
    }
}

