/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;

@NodeChild(value="child", type=RubyNode.class)
public abstract class SingleValueCastNode
extends RubyNode {
    public SingleValueCastNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public SingleValueCastNode(SingleValueCastNode prev) {
        super(prev);
    }

    public abstract Object executeSingleValue(Object[] var1);

    @Specialization(guards={"noArguments"})
    protected RubyNilClass castNil(Object[] args) {
        return this.nil();
    }

    @Specialization(guards={"singleArgument"})
    protected Object castSingle(Object[] args) {
        return args[0];
    }

    @Specialization(guards={"!noArguments", "!singleArgument"})
    protected RubyArray castMany(Object[] args) {
        SingleValueCastNode.notDesignedForCompilation();
        return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), args);
    }

    protected boolean noArguments(Object[] args) {
        return args.length == 0;
    }

    protected boolean singleArgument(Object[] args) {
        return args.length == 1;
    }
}

