/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.CmpIntNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;

@GeneratedBy(value=CmpIntNode.class)
public final class CmpIntNodeFactory
extends NodeFactoryBase<CmpIntNode> {
    private static CmpIntNodeFactory instance;

    private CmpIntNodeFactory() {
        super(CmpIntNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
    }

    public CmpIntNode createNode(Object ... arguments) {
        if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
            return CmpIntNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static CmpIntNode create(RubyContext context, SourceSection sourceSection, RubyNode value, RubyNode receiver, RubyNode other) {
        return CmpIntUninitializedNode.create0(context, sourceSection, value, receiver, other);
    }

    public static NodeFactory<CmpIntNode> getInstance() {
        if (instance == null) {
            instance = new CmpIntNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=CmpIntNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class CmpIntPolymorphicNode
    extends CmpIntBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> valuePolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> receiverPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> otherPolymorphicType;

        CmpIntPolymorphicNode(CmpIntBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            Object valueValue;
            try {
                valueValue = this.valuePolymorphicType == Integer.TYPE ? Integer.valueOf(this.value.executeIntegerFixnum(frameValue)) : (this.valuePolymorphicType == Long.TYPE ? Long.valueOf(this.value.executeLongFixnum(frameValue)) : (this.valuePolymorphicType == RubyBignum.class ? this.value.executeBignum(frameValue) : (this.valuePolymorphicType == RubyNilClass.class ? this.value.executeRubyNilClass(frameValue) : this.value.execute(frameValue))));
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = this.receiver.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                this.valuePolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult(), receiverValue, otherValue);
            }
            Object receiverValue = this.receiver.execute(frameValue);
            Object otherValue = this.other.execute(frameValue);
            return this.next0.executeChained0(frameValue, valueValue, receiverValue, otherValue);
        }

        @Override
        public int executeCmpInt(VirtualFrame frameValue, Object valueValueEvaluated, Object receiverValueEvaluated, Object otherValueEvaluated) {
            Object valueValue;
            try {
                valueValue = this.valuePolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(valueValueEvaluated)) : (this.valuePolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(valueValueEvaluated)) : (this.valuePolymorphicType == RubyBignum.class ? RubyTypesGen.RUBYTYPES.expectRubyBignum(valueValueEvaluated) : (this.valuePolymorphicType == RubyNilClass.class ? RubyTypesGen.RUBYTYPES.expectRubyNilClass(valueValueEvaluated) : valueValueEvaluated)));
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = receiverValueEvaluated;
                Object otherValue = otherValueEvaluated;
                this.valuePolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult(), receiverValue, otherValue);
            }
            Object receiverValue = receiverValueEvaluated;
            Object otherValue = otherValueEvaluated;
            return this.next0.executeChained0(frameValue, valueValue, receiverValue, otherValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.valuePolymorphicType = types[0];
            this.receiverPolymorphicType = types[1];
            this.otherPolymorphicType = types[2];
        }

        @Override
        protected int executeChained0(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            return this.next0.executeChained0(frameValue, valueValue, receiverValue, otherValue);
        }
    }

    @GeneratedBy(value=CmpIntNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class CmpIntObjectNode
    extends CmpIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(CmpIntObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);

        CmpIntObjectNode(CmpIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            Object valueValue = this.value.execute(frameValue);
            Object receiverValue = this.receiver.execute(frameValue);
            Object otherValue = this.other.execute(frameValue);
            if (!(super.isInteger(valueValue) || super.isLong(valueValue) || super.isRubyBignum(valueValue) || super.isRubyNilClass(valueValue))) {
                return super.cmpObject(frameValue, valueValue, receiverValue, otherValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, valueValue, receiverValue, otherValue, "One of guards [!isInteger, !isLong, !isRubyBignum, !isRubyNilClass] failed");
        }

        @Override
        public int executeCmpInt(VirtualFrame frameValue, Object valueValueEvaluated, Object receiverValueEvaluated, Object otherValueEvaluated) {
            Object valueValue = valueValueEvaluated;
            Object receiverValue = receiverValueEvaluated;
            Object otherValue = otherValueEvaluated;
            if (!(super.isInteger(valueValue) || super.isLong(valueValue) || super.isRubyBignum(valueValue) || super.isRubyNilClass(valueValue))) {
                return super.cmpObject(frameValue, valueValue, receiverValue, otherValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, valueValue, receiverValue, otherValue, "One of guards [!isInteger, !isLong, !isRubyBignum, !isRubyNilClass] failed");
        }

        @Override
        protected int executeChained0(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            if (!(super.isInteger(valueValue) || super.isLong(valueValue) || super.isRubyBignum(valueValue) || super.isRubyNilClass(valueValue))) {
                return super.cmpObject(frameValue, valueValue, receiverValue, otherValue);
            }
            return this.next0.executeChained0(frameValue, valueValue, receiverValue, otherValue);
        }

        static CmpIntNode create0(CmpIntNode current) {
            return new CmpIntObjectNode((CmpIntBaseNode)current);
        }
    }

    @GeneratedBy(value=CmpIntNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class CmpIntRubyNilClassObjectNode
    extends CmpIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(CmpIntRubyNilClassObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyNilClass.class, Object.class, Object.class}, 0, 0);

        CmpIntRubyNilClassObjectNode(CmpIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyNilClass valueValue;
            try {
                valueValue = this.value.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = this.receiver.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), receiverValue, otherValue, "Expected valueValue instanceof RubyNilClass");
            }
            Object receiverValue = this.receiver.execute(frameValue);
            Object otherValue = this.other.execute(frameValue);
            return super.cmpNil(valueValue, receiverValue, otherValue);
        }

        @Override
        public int executeCmpInt(VirtualFrame frameValue, Object valueValueEvaluated, Object receiverValueEvaluated, Object otherValueEvaluated) {
            RubyNilClass valueValue;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectRubyNilClass(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = receiverValueEvaluated;
                Object otherValue = otherValueEvaluated;
                return this.rewrite0(frameValue, ex.getResult(), receiverValue, otherValue, "Expected valueValue instanceof RubyNilClass");
            }
            Object receiverValue = receiverValueEvaluated;
            Object otherValue = otherValueEvaluated;
            return super.cmpNil(valueValue, receiverValue, otherValue);
        }

        @Override
        protected int executeChained0(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(valueValue)) {
                RubyNilClass valueValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(valueValue);
                return super.cmpNil(valueValueCast, receiverValue, otherValue);
            }
            return this.next0.executeChained0(frameValue, valueValue, receiverValue, otherValue);
        }

        static CmpIntNode create0(CmpIntNode current) {
            return new CmpIntRubyNilClassObjectNode((CmpIntBaseNode)current);
        }
    }

    @GeneratedBy(value=CmpIntNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class CmpIntRubyBignumObjectNode
    extends CmpIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(CmpIntRubyBignumObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, Object.class, Object.class}, 0, 0);

        CmpIntRubyBignumObjectNode(CmpIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBignum valueValue;
            try {
                valueValue = this.value.executeBignum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = this.receiver.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), receiverValue, otherValue, "Expected valueValue instanceof RubyBignum");
            }
            Object receiverValue = this.receiver.execute(frameValue);
            Object otherValue = this.other.execute(frameValue);
            return super.cmpBignum(valueValue, receiverValue, otherValue);
        }

        @Override
        public int executeCmpInt(VirtualFrame frameValue, Object valueValueEvaluated, Object receiverValueEvaluated, Object otherValueEvaluated) {
            RubyBignum valueValue;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectRubyBignum(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = receiverValueEvaluated;
                Object otherValue = otherValueEvaluated;
                return this.rewrite0(frameValue, ex.getResult(), receiverValue, otherValue, "Expected valueValue instanceof RubyBignum");
            }
            Object receiverValue = receiverValueEvaluated;
            Object otherValue = otherValueEvaluated;
            return super.cmpBignum(valueValue, receiverValue, otherValue);
        }

        @Override
        protected int executeChained0(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(valueValue)) {
                RubyBignum valueValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(valueValue);
                return super.cmpBignum(valueValueCast, receiverValue, otherValue);
            }
            return this.next0.executeChained0(frameValue, valueValue, receiverValue, otherValue);
        }

        static CmpIntNode create0(CmpIntNode current) {
            return new CmpIntRubyBignumObjectNode((CmpIntBaseNode)current);
        }
    }

    @GeneratedBy(value=CmpIntNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class CmpIntLongObjectNode
    extends CmpIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(CmpIntLongObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Object.class, Object.class}, 0, 0);

        CmpIntLongObjectNode(CmpIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue;
            try {
                valueValue = this.value.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = this.receiver.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), receiverValue, otherValue, "Expected valueValue instanceof long");
            }
            Object receiverValue = this.receiver.execute(frameValue);
            Object otherValue = this.other.execute(frameValue);
            return super.cmpLong(valueValue, receiverValue, otherValue);
        }

        @Override
        public int executeCmpInt(VirtualFrame frameValue, Object valueValueEvaluated, Object receiverValueEvaluated, Object otherValueEvaluated) {
            long valueValue;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectLong(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = receiverValueEvaluated;
                Object otherValue = otherValueEvaluated;
                return this.rewrite0(frameValue, ex.getResult(), receiverValue, otherValue, "Expected valueValue instanceof long");
            }
            Object receiverValue = receiverValueEvaluated;
            Object otherValue = otherValueEvaluated;
            return super.cmpLong(valueValue, receiverValue, otherValue);
        }

        @Override
        protected int executeChained0(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(valueValue)) {
                long valueValueCast = RubyTypesGen.RUBYTYPES.asLong(valueValue);
                return super.cmpLong(valueValueCast, receiverValue, otherValue);
            }
            return this.next0.executeChained0(frameValue, valueValue, receiverValue, otherValue);
        }

        static CmpIntNode create0(CmpIntNode current) {
            return new CmpIntLongObjectNode((CmpIntBaseNode)current);
        }
    }

    @GeneratedBy(value=CmpIntNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class CmpIntIntObjectNode
    extends CmpIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(CmpIntIntObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Object.class, Object.class}, 0, 0);

        CmpIntIntObjectNode(CmpIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue;
            try {
                valueValue = this.value.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = this.receiver.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), receiverValue, otherValue, "Expected valueValue instanceof int");
            }
            Object receiverValue = this.receiver.execute(frameValue);
            Object otherValue = this.other.execute(frameValue);
            return super.cmpInt(valueValue, receiverValue, otherValue);
        }

        @Override
        public int executeCmpInt(VirtualFrame frameValue, Object valueValueEvaluated, Object receiverValueEvaluated, Object otherValueEvaluated) {
            int valueValue;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectInteger(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = receiverValueEvaluated;
                Object otherValue = otherValueEvaluated;
                return this.rewrite0(frameValue, ex.getResult(), receiverValue, otherValue, "Expected valueValue instanceof int");
            }
            Object receiverValue = receiverValueEvaluated;
            Object otherValue = otherValueEvaluated;
            return super.cmpInt(valueValue, receiverValue, otherValue);
        }

        @Override
        protected int executeChained0(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                int valueValueCast = RubyTypesGen.RUBYTYPES.asInteger(valueValue);
                return super.cmpInt(valueValueCast, receiverValue, otherValue);
            }
            return this.next0.executeChained0(frameValue, valueValue, receiverValue, otherValue);
        }

        static CmpIntNode create0(CmpIntNode current) {
            return new CmpIntIntObjectNode((CmpIntBaseNode)current);
        }
    }

    @GeneratedBy(value=CmpIntNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class CmpIntUninitializedNode
    extends CmpIntBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(CmpIntUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        CmpIntUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode value, RubyNode receiver, RubyNode other) {
            super(context, sourceSection, value, receiver, other);
        }

        CmpIntUninitializedNode(CmpIntBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object valueValue = this.value.execute(frameValue);
            Object receiverValue = this.receiver.execute(frameValue);
            Object otherValue = this.other.execute(frameValue);
            return this.executeUninitialized0(frameValue, valueValue, receiverValue, otherValue);
        }

        @Override
        public int executeCmpInt(VirtualFrame frameValue, Object valueValueEvaluated, Object receiverValueEvaluated, Object otherValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object valueValue = valueValueEvaluated;
            Object receiverValue = receiverValueEvaluated;
            Object otherValue = otherValueEvaluated;
            return this.executeUninitialized0(frameValue, valueValue, receiverValue, otherValue);
        }

        @Override
        protected int executeChained0(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, valueValue, receiverValue, otherValue);
        }

        protected int executeUninitialized0(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            CmpIntBaseNode newNode = this.specialize0(valueValue, receiverValue, otherValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                CmpIntBaseNode rootNode = (CmpIntBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.value, rootNode.receiver, rootNode.other}, new Object[]{valueValue, receiverValue, otherValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((CmpIntBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, valueValue, receiverValue, otherValue);
        }

        static CmpIntNode create0(RubyContext context, SourceSection sourceSection, RubyNode value, RubyNode receiver, RubyNode other) {
            return new CmpIntUninitializedNode(context, sourceSection, value, receiver, other);
        }
    }

    @GeneratedBy(value=CmpIntNode.class)
    private static abstract class CmpIntBaseNode
    extends CmpIntNode
    implements DSLNode {
        @Node.Child
        protected RubyNode value;
        @Node.Child
        protected RubyNode receiver;
        @Node.Child
        protected RubyNode other;
        @Node.Child
        protected CmpIntBaseNode next0;

        CmpIntBaseNode(RubyContext context, SourceSection sourceSection, RubyNode value, RubyNode receiver, RubyNode other) {
            super(context, sourceSection);
            this.value = value;
            this.receiver = receiver;
            this.other = other;
        }

        CmpIntBaseNode(CmpIntBaseNode copy) {
            super(copy);
        }

        protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

        protected final int rewrite0(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue, String reason) {
            String message;
            CmpIntBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            CmpIntBaseNode newNode = this.specialize0(valueValue, receiverValue, otherValue);
            if (newNode == null) {
                newNode = new CmpIntUninitializedNode(this);
                ((CmpIntUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (CmpIntBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CmpIntBaseNode.createInfo0(reason, valueValue, receiverValue, otherValue)))) == null) {
                returnNode = (CmpIntBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CmpIntUninitializedNode(this), (Node)new CmpIntPolymorphicNode(this), (DSLNode)((CmpIntBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, valueValue, receiverValue, otherValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final CmpIntBaseNode specialize0(Object valueValue, Object receiverValue, Object otherValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                return (CmpIntBaseNode)CmpIntIntObjectNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(valueValue)) {
                return (CmpIntBaseNode)CmpIntLongObjectNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBignum(valueValue)) {
                return (CmpIntBaseNode)CmpIntRubyBignumObjectNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(valueValue)) {
                return (CmpIntBaseNode)CmpIntRubyNilClassObjectNode.create0(this);
            }
            if (!(super.isInteger(valueValue) || super.isLong(valueValue) || super.isRubyBignum(valueValue) || super.isRubyNilClass(valueValue))) {
                return (CmpIntBaseNode)CmpIntObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            if (other == null) {
                this.value = null;
                this.receiver = null;
                this.other = null;
            } else {
                CmpIntBaseNode otherCast = (CmpIntBaseNode)other;
                this.value = otherCast.value;
                this.receiver = otherCast.receiver;
                this.other = otherCast.other;
            }
            this.next0 = newNext == null ? null : (CmpIntBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object valueValue, Object receiverValue, Object otherValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("valueValue").append(" = ").append(valueValue);
                if (valueValue != null) {
                    builder.append(" (").append(valueValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("receiverValue").append(" = ").append(receiverValue);
                if (receiverValue != null) {
                    builder.append(" (").append(receiverValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("otherValue").append(" = ").append(otherValue);
                if (otherValue != null) {
                    builder.append(" (").append(otherValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

