/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.CoreLibrary;

@NodeChild(value="child", type=RubyNode.class)
public abstract class NewFixnumLowerNode
extends RubyNode {
    public NewFixnumLowerNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public NewFixnumLowerNode(NewFixnumLowerNode prev) {
        super(prev);
    }

    @Specialization
    public int lower(int value) {
        return value;
    }

    @Specialization(guards={"canLower"})
    public int lower(long value) {
        return (int)value;
    }

    @Specialization(guards={"!canLower"})
    public long lowerFails(long value) {
        return value;
    }

    protected static boolean canLower(long value) {
        return CoreLibrary.fitsIntoInteger(value);
    }
}

