/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.util.ArrayUtils;

@ImportGuards(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="requiredCapacity", type=RubyNode.class)})
public abstract class EnsureCapacityArrayNode
extends RubyNode {
    private final ConditionProfile allocateProfile = ConditionProfile.createCountingProfile();

    public EnsureCapacityArrayNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public EnsureCapacityArrayNode(EnsureCapacityArrayNode prev) {
        super(prev);
    }

    public abstract Object executeEnsureCapacity(VirtualFrame var1, RubyArray var2, int var3);

    @Specialization(guards={"isIntArray"})
    public boolean ensureCapacityInt(RubyArray array, int requiredCapacity) {
        int[] store = (int[])array.getStore();
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            array.setStore(Arrays.copyOf(store, ArrayUtils.capacity(store.length, requiredCapacity)), array.getSize());
            return true;
        }
        return false;
    }

    @Specialization(guards={"isLongArray"})
    public boolean ensureCapacityLong(RubyArray array, int requiredCapacity) {
        long[] store = (long[])array.getStore();
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            array.setStore(Arrays.copyOf(store, ArrayUtils.capacity(store.length, requiredCapacity)), array.getSize());
            return true;
        }
        return false;
    }

    @Specialization(guards={"isDoubleArray"})
    public boolean ensureCapacityDouble(RubyArray array, int requiredCapacity) {
        double[] store = (double[])array.getStore();
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            array.setStore(Arrays.copyOf(store, ArrayUtils.capacity(store.length, requiredCapacity)), array.getSize());
            return true;
        }
        return false;
    }

    @Specialization(guards={"isObjectArray"})
    public boolean ensureCapacityObject(RubyArray array, int requiredCapacity) {
        Object[] store = (Object[])array.getStore();
        if (this.allocateProfile.profile(store.length < requiredCapacity)) {
            array.setStore(Arrays.copyOf(store, ArrayUtils.capacity(store.length, requiredCapacity)), array.getSize());
            return true;
        }
        return false;
    }
}

