/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.array.ArrayReadSliceNormalizedNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;

@GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
public final class ArrayReadSliceNormalizedNodeFactory
extends NodeFactoryBase<ArrayReadSliceNormalizedNode> {
    private static ArrayReadSliceNormalizedNodeFactory instance;

    private ArrayReadSliceNormalizedNodeFactory() {
        super(ArrayReadSliceNormalizedNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
    }

    public ArrayReadSliceNormalizedNode createNode(Object ... arguments) {
        if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
            return ArrayReadSliceNormalizedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArrayReadSliceNormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
        return ArrayReadSliceNormalizedUninitializedNode.create0(context, sourceSection, array, index, length);
    }

    public static NodeFactory<ArrayReadSliceNormalizedNode> getInstance() {
        if (instance == null) {
            instance = new ArrayReadSliceNormalizedNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArrayReadSliceNormalizedPolymorphicNode
    extends ArrayReadSliceNormalizedBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> indexPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> lengthPolymorphicType;

        ArrayReadSliceNormalizedPolymorphicNode(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            Object lengthValue = this.length.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            Integer lengthValue = lengthValueEvaluated;
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
            this.indexPolymorphicType = types[1];
            this.lengthPolymorphicType = types[2];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceNormalizedRubyArrayInt8Node
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedRubyArrayInt8Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceNormalizedRubyArrayInt8Node(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int"));
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int"));
            }
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return super.readObjectOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, !endInBounds, isObjectArray] failed"));
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return super.readObjectOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, !endInBounds, isObjectArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            int lengthValueCast;
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue) && ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue)) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isObjectArray(arrayValueCast)) {
                return super.readObjectOutOfBounds(arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(ArrayReadSliceNormalizedNode current) {
            return new ArrayReadSliceNormalizedRubyArrayInt8Node((ArrayReadSliceNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceNormalizedRubyArrayInt7Node
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedRubyArrayInt7Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceNormalizedRubyArrayInt7Node(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int"));
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int"));
            }
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return super.readDoubleOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, !endInBounds, isDoubleArray] failed"));
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return super.readDoubleOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, !endInBounds, isDoubleArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            int lengthValueCast;
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue) && ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue)) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isDoubleArray(arrayValueCast)) {
                return super.readDoubleOutOfBounds(arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(ArrayReadSliceNormalizedNode current) {
            return new ArrayReadSliceNormalizedRubyArrayInt7Node((ArrayReadSliceNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceNormalizedRubyArrayInt6Node
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedRubyArrayInt6Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceNormalizedRubyArrayInt6Node(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int"));
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int"));
            }
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isLongArray(arrayValue)) {
                return super.readLongOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, !endInBounds, isLongArray] failed"));
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isLongArray(arrayValue)) {
                return super.readLongOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, !endInBounds, isLongArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            int lengthValueCast;
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue) && ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue)) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isLongArray(arrayValueCast)) {
                return super.readLongOutOfBounds(arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(ArrayReadSliceNormalizedNode current) {
            return new ArrayReadSliceNormalizedRubyArrayInt6Node((ArrayReadSliceNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceNormalizedRubyArrayInt5Node
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedRubyArrayInt5Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceNormalizedRubyArrayInt5Node(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int"));
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int"));
            }
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isIntArray(arrayValue)) {
                return super.readIntOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, !endInBounds, isIntArray] failed"));
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isIntArray(arrayValue)) {
                return super.readIntOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, !endInBounds, isIntArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            int lengthValueCast;
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue) && ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue)) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && !ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isIntArray(arrayValueCast)) {
                return super.readIntOutOfBounds(arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(ArrayReadSliceNormalizedNode current) {
            return new ArrayReadSliceNormalizedRubyArrayInt5Node((ArrayReadSliceNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceNormalizedRubyArrayInt4Node
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedRubyArrayInt4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceNormalizedRubyArrayInt4Node(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int"));
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int"));
            }
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return super.readObjectInBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, endInBounds, isObjectArray] failed"));
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return super.readObjectInBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, endInBounds, isObjectArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            int lengthValueCast;
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue) && ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue)) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isObjectArray(arrayValueCast)) {
                return super.readObjectInBounds(arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(ArrayReadSliceNormalizedNode current) {
            return new ArrayReadSliceNormalizedRubyArrayInt4Node((ArrayReadSliceNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceNormalizedRubyArrayInt3Node
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedRubyArrayInt3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceNormalizedRubyArrayInt3Node(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int"));
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int"));
            }
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return super.readDoubleInBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, endInBounds, isDoubleArray] failed"));
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return super.readDoubleInBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, endInBounds, isDoubleArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            int lengthValueCast;
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue) && ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue)) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isDoubleArray(arrayValueCast)) {
                return super.readDoubleInBounds(arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(ArrayReadSliceNormalizedNode current) {
            return new ArrayReadSliceNormalizedRubyArrayInt3Node((ArrayReadSliceNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceNormalizedRubyArrayInt2Node
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedRubyArrayInt2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceNormalizedRubyArrayInt2Node(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int"));
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int"));
            }
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isLongArray(arrayValue)) {
                return super.readLongInBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, endInBounds, isLongArray] failed"));
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isLongArray(arrayValue)) {
                return super.readLongInBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, endInBounds, isLongArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            int lengthValueCast;
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue) && ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue)) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isLongArray(arrayValueCast)) {
                return super.readLongInBounds(arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(ArrayReadSliceNormalizedNode current) {
            return new ArrayReadSliceNormalizedRubyArrayInt2Node((ArrayReadSliceNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceNormalizedRubyArrayInt1Node
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedRubyArrayInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceNormalizedRubyArrayInt1Node(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int"));
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int"));
            }
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isIntArray(arrayValue)) {
                return super.readIntInBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, endInBounds, isIntArray] failed"));
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isIntArray(arrayValue)) {
                return super.readIntInBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, endInBounds, isIntArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            int lengthValueCast;
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue) && ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue)) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedBaseNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isIntArray(arrayValueCast)) {
                return super.readIntInBounds(arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(ArrayReadSliceNormalizedNode current) {
            return new ArrayReadSliceNormalizedRubyArrayInt1Node((ArrayReadSliceNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceNormalizedRubyArrayInt0Node
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedRubyArrayInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceNormalizedRubyArrayInt0Node(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int"));
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int"));
            }
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && ArrayGuards.isNullArray(arrayValue)) {
                return super.readNull(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, isNullArray] failed"));
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            if (ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue) && ArrayGuards.isNullArray(arrayValue)) {
                return super.readNull(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [indexInBounds, lengthPositive, isNullArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            int lengthValueCast;
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue) && ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue)) && ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isNullArray(arrayValueCast)) {
                return super.readNull(arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(ArrayReadSliceNormalizedNode current) {
            return new ArrayReadSliceNormalizedRubyArrayInt0Node((ArrayReadSliceNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceNormalizedRubyNilClassInt1Node
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedRubyNilClassInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceNormalizedRubyNilClassInt1Node(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value;
            try {
                value = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int"));
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int"));
            }
            if (!ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue)) {
                return super.readNegativeLength(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [!lengthPositive] failed"));
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            if (!ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValue, indexValue, lengthValue)) {
                return super.readNegativeLength(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [!lengthPositive] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            int lengthValueCast;
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue) && !ArrayReadSliceNormalizedBaseNode.lengthPositive(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue))) {
                return super.readNegativeLength(arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(ArrayReadSliceNormalizedNode current) {
            return new ArrayReadSliceNormalizedRubyNilClassInt1Node((ArrayReadSliceNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceNormalizedRubyNilClassInt0Node
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedRubyNilClassInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceNormalizedRubyNilClassInt0Node(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value;
            try {
                value = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int"));
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int"));
            }
            if (!ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue)) {
                return super.readIndexOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [!indexInBounds] failed"));
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            if (!ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValue, indexValue, lengthValue)) {
                return super.readIndexOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, lengthValue, "One of guards [!indexInBounds] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            int lengthValueCast;
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue) && !ArrayReadSliceNormalizedBaseNode.indexInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue))) {
                return super.readIndexOutOfBounds(arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(ArrayReadSliceNormalizedNode current) {
            return new ArrayReadSliceNormalizedRubyNilClassInt0Node((ArrayReadSliceNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArrayReadSliceNormalizedUninitializedNode
    extends ArrayReadSliceNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceNormalizedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArrayReadSliceNormalizedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
            super(context, sourceSection, array, index, length);
        }

        ArrayReadSliceNormalizedUninitializedNode(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            Object lengthValue = this.length.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, lengthValue);
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            Integer lengthValue = lengthValueEvaluated;
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, lengthValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, lengthValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            ArrayReadSliceNormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue, lengthValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArrayReadSliceNormalizedBaseNode rootNode = (ArrayReadSliceNormalizedBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.array, rootNode.index, rootNode.length}, new Object[]{arrayValue, indexValue, lengthValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ArrayReadSliceNormalizedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceNormalizedNode create0(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
            return new ArrayReadSliceNormalizedUninitializedNode(context, sourceSection, array, index, length);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    private static abstract class ArrayReadSliceNormalizedBaseNode
    extends ArrayReadSliceNormalizedNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected RubyNode index;
        @Node.Child
        protected RubyNode length;
        @Node.Child
        protected ArrayReadSliceNormalizedBaseNode next0;

        ArrayReadSliceNormalizedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
            super(context, sourceSection);
            this.array = array;
            this.index = index;
            this.length = length;
        }

        ArrayReadSliceNormalizedBaseNode(ArrayReadSliceNormalizedBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

        protected final Object rewrite0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue, String reason) {
            String message;
            ArrayReadSliceNormalizedBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArrayReadSliceNormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue, lengthValue);
            if (newNode == null) {
                newNode = new ArrayReadSliceNormalizedUninitializedNode(this);
                ((ArrayReadSliceNormalizedUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ArrayReadSliceNormalizedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ArrayReadSliceNormalizedBaseNode.createInfo0(reason, arrayValue, indexValue, lengthValue)))) == null) {
                returnNode = (ArrayReadSliceNormalizedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ArrayReadSliceNormalizedUninitializedNode(this), (Node)new ArrayReadSliceNormalizedPolymorphicNode(this), (DSLNode)((ArrayReadSliceNormalizedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArrayReadSliceNormalizedBaseNode specialize0(Object arrayValue, Object indexValue, Object lengthValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue)) {
                int lengthValueCast;
                int indexValueCast;
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                if (!ArrayReadSliceNormalizedNode.indexInBounds(arrayValueCast, indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue), lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue))) {
                    return (ArrayReadSliceNormalizedBaseNode)ArrayReadSliceNormalizedRubyNilClassInt0Node.create0(this);
                }
                if (!ArrayReadSliceNormalizedNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast)) {
                    return (ArrayReadSliceNormalizedBaseNode)ArrayReadSliceNormalizedRubyNilClassInt1Node.create0(this);
                }
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isNullArray(arrayValueCast)) {
                    return (ArrayReadSliceNormalizedBaseNode)ArrayReadSliceNormalizedRubyArrayInt0Node.create0(this);
                }
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isIntArray(arrayValueCast)) {
                    return (ArrayReadSliceNormalizedBaseNode)ArrayReadSliceNormalizedRubyArrayInt1Node.create0(this);
                }
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isLongArray(arrayValueCast)) {
                    return (ArrayReadSliceNormalizedBaseNode)ArrayReadSliceNormalizedRubyArrayInt2Node.create0(this);
                }
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isDoubleArray(arrayValueCast)) {
                    return (ArrayReadSliceNormalizedBaseNode)ArrayReadSliceNormalizedRubyArrayInt3Node.create0(this);
                }
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isObjectArray(arrayValueCast)) {
                    return (ArrayReadSliceNormalizedBaseNode)ArrayReadSliceNormalizedRubyArrayInt4Node.create0(this);
                }
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isIntArray(arrayValueCast)) {
                    return (ArrayReadSliceNormalizedBaseNode)ArrayReadSliceNormalizedRubyArrayInt5Node.create0(this);
                }
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isLongArray(arrayValueCast)) {
                    return (ArrayReadSliceNormalizedBaseNode)ArrayReadSliceNormalizedRubyArrayInt6Node.create0(this);
                }
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isDoubleArray(arrayValueCast)) {
                    return (ArrayReadSliceNormalizedBaseNode)ArrayReadSliceNormalizedRubyArrayInt7Node.create0(this);
                }
                if (ArrayReadSliceNormalizedNode.indexInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayReadSliceNormalizedNode.lengthPositive(arrayValueCast, indexValueCast, lengthValueCast) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValueCast, indexValueCast, lengthValueCast) && ArrayGuards.isObjectArray(arrayValueCast)) {
                    return (ArrayReadSliceNormalizedBaseNode)ArrayReadSliceNormalizedRubyArrayInt8Node.create0(this);
                }
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            if (other == null) {
                this.array = null;
                this.index = null;
                this.length = null;
            } else {
                ArrayReadSliceNormalizedBaseNode otherCast = (ArrayReadSliceNormalizedBaseNode)other;
                this.array = otherCast.array;
                this.index = otherCast.index;
                this.length = otherCast.length;
            }
            this.next0 = newNext == null ? null : (ArrayReadSliceNormalizedBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object arrayValue, Object indexValue, Object lengthValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("indexValue").append(" = ").append(indexValue);
                if (indexValue != null) {
                    builder.append(" (").append(indexValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("lengthValue").append(" = ").append(lengthValue);
                if (lengthValue != null) {
                    builder.append(" (").append(lengthValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

