/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;

@ImportGuards(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class), @NodeChild(value="length", type=RubyNode.class)})
public abstract class ArrayReadSliceNormalizedNode
extends RubyNode {
    public ArrayReadSliceNormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public ArrayReadSliceNormalizedNode(ArrayReadSliceNormalizedNode prev) {
        super(prev);
    }

    public abstract Object executeReadSlice(VirtualFrame var1, RubyArray var2, int var3, int var4);

    @Specialization(guards={"!indexInBounds"})
    public RubyNilClass readIndexOutOfBounds(RubyArray array, int index, int length) {
        return this.nil();
    }

    @Specialization(guards={"!lengthPositive"})
    public RubyNilClass readNegativeLength(RubyArray array, int index, int length) {
        return this.nil();
    }

    @Specialization(guards={"indexInBounds", "lengthPositive", "isNullArray"})
    public RubyArray readNull(RubyArray array, int index, int length) {
        return new RubyArray(array.getLogicalClass(), null, 0);
    }

    @Specialization(guards={"indexInBounds", "lengthPositive", "endInBounds", "isIntArray"})
    public RubyArray readIntInBounds(RubyArray array, int index, int length) {
        return new RubyArray(array.getLogicalClass(), Arrays.copyOfRange((int[])array.getStore(), index, index + length), length);
    }

    @Specialization(guards={"indexInBounds", "lengthPositive", "endInBounds", "isLongArray"})
    public RubyArray readLongInBounds(RubyArray array, int index, int length) {
        return new RubyArray(array.getLogicalClass(), Arrays.copyOfRange((long[])array.getStore(), index, index + length), length);
    }

    @Specialization(guards={"indexInBounds", "lengthPositive", "endInBounds", "isDoubleArray"})
    public RubyArray readDoubleInBounds(RubyArray array, int index, int length) {
        return new RubyArray(array.getLogicalClass(), Arrays.copyOfRange((double[])array.getStore(), index, index + length), length);
    }

    @Specialization(guards={"indexInBounds", "lengthPositive", "endInBounds", "isObjectArray"})
    public RubyArray readObjectInBounds(RubyArray array, int index, int length) {
        return new RubyArray(array.getLogicalClass(), Arrays.copyOfRange((Object[])array.getStore(), index, index + length), length);
    }

    @Specialization(guards={"indexInBounds", "lengthPositive", "!endInBounds", "isIntArray"})
    public RubyArray readIntOutOfBounds(RubyArray array, int index, int length) {
        int clampedLength = Math.min(array.getSize(), index + length) - index;
        return new RubyArray(array.getLogicalClass(), Arrays.copyOfRange((int[])array.getStore(), index, index + clampedLength), clampedLength);
    }

    @Specialization(guards={"indexInBounds", "lengthPositive", "!endInBounds", "isLongArray"})
    public RubyArray readLongOutOfBounds(RubyArray array, int index, int length) {
        int clampedLength = Math.min(array.getSize(), index + length) - index;
        return new RubyArray(array.getLogicalClass(), Arrays.copyOfRange((long[])array.getStore(), index, index + clampedLength), clampedLength);
    }

    @Specialization(guards={"indexInBounds", "lengthPositive", "!endInBounds", "isDoubleArray"})
    public RubyArray readDoubleOutOfBounds(RubyArray array, int index, int length) {
        int clampedLength = Math.min(array.getSize(), index + length) - index;
        return new RubyArray(array.getLogicalClass(), Arrays.copyOfRange((double[])array.getStore(), index, index + clampedLength), clampedLength);
    }

    @Specialization(guards={"indexInBounds", "lengthPositive", "!endInBounds", "isObjectArray"})
    public RubyArray readObjectOutOfBounds(RubyArray array, int index, int length) {
        int clampedLength = Math.min(array.getSize(), index + length) - index;
        return new RubyArray(array.getLogicalClass(), Arrays.copyOfRange((Object[])array.getStore(), index, index + clampedLength), clampedLength);
    }

    protected static boolean indexInBounds(RubyArray array, int index, int length) {
        return index >= 0 && index <= array.getSize();
    }

    protected static boolean lengthPositive(RubyArray array, int index, int length) {
        return length >= 0;
    }

    protected static boolean endInBounds(RubyArray array, int index, int length) {
        return index + length < array.getSize();
    }
}

