/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;

@ImportGuards(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class)})
public abstract class ArrayReadNormalizedNode
extends RubyNode {
    public ArrayReadNormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public ArrayReadNormalizedNode(ArrayReadNormalizedNode prev) {
        super(prev);
    }

    public abstract Object executeRead(VirtualFrame var1, RubyArray var2, int var3);

    @Specialization(guards={"isNullArray"})
    public RubyNilClass readNull(RubyArray array, int index) {
        return this.nil();
    }

    @Specialization(guards={"isInBounds", "isIntArray"})
    public int readIntInBounds(RubyArray array, int index) {
        return ((int[])array.getStore())[index];
    }

    @Specialization(guards={"isInBounds", "isLongArray"})
    public long readLongInBounds(RubyArray array, int index) {
        return ((long[])array.getStore())[index];
    }

    @Specialization(guards={"isInBounds", "isDoubleArray"})
    public double readDoubleInBounds(RubyArray array, int index) {
        return ((double[])array.getStore())[index];
    }

    @Specialization(guards={"isInBounds", "isObjectArray"})
    public Object readObjectInBounds(RubyArray array, int index) {
        return ((Object[])array.getStore())[index];
    }

    @Specialization(guards={"!isInBounds"})
    public RubyNilClass readOutOfBounds(RubyArray array, int index) {
        return this.nil();
    }

    protected static boolean isInBounds(RubyArray array, int index) {
        return index >= 0 && index < array.getSize();
    }
}

