/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.instrument.TruffleEventReceiver;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import jnr.posix.POSIX;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.instrument.RubyWrapperNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyEncodingConverter;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyFiber;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.core.RubyTime;
import org.jruby.truffle.runtime.core.RubyUnboundMethod;
import org.jruby.truffle.runtime.rubinius.RubiniusByteArray;

@TypeSystemReference(value=RubyTypes.class)
public abstract class RubyNode
extends Node
implements ProbeNode.Instrumentable {
    private final RubyContext context;

    public RubyNode(RubyContext context, SourceSection sourceSection) {
        super(sourceSection);
        assert (context != null);
        this.context = context;
    }

    public RubyNode(RubyNode prev) {
        this(prev.context, prev.getSourceSection());
    }

    public abstract Object execute(VirtualFrame var1);

    public Object isDefined(VirtualFrame frame) {
        return this.getContext().makeString("expression");
    }

    public String executeString(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectString(this.execute(frame));
    }

    public RubyArray executeArray(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.execute(frame));
    }

    public RubyBignum executeBignum(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.execute(frame));
    }

    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectBoolean(this.execute(frame));
    }

    public int executeIntegerFixnum(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectInteger(this.execute(frame));
    }

    public long executeLongFixnum(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectLong(this.execute(frame));
    }

    public RubyRange.IntegerFixnumRange executeIntegerFixnumRange(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectIntegerFixnumRange(this.execute(frame));
    }

    public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectLongFixnumRange(this.execute(frame));
    }

    public double executeFloat(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectDouble(this.execute(frame));
    }

    public Object[] executeObjectArray(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectObjectArray(this.execute(frame));
    }

    public RubyRange.ObjectRange executeObjectRange(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectObjectRange(this.execute(frame));
    }

    public RubyBasicObject executeRubyBasicObject(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyBasicObject(this.execute(frame));
    }

    public RubyBinding executeRubyBinding(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyBinding(this.execute(frame));
    }

    public RubyClass executeRubyClass(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyClass(this.execute(frame));
    }

    public RubyException executeRubyException(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyException(this.execute(frame));
    }

    public RubyFiber executeRubyFiber(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyFiber(this.execute(frame));
    }

    public RubyHash executeRubyHash(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyHash(this.execute(frame));
    }

    public RubyMatchData executeRubyMatchData(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyMatchData(this.execute(frame));
    }

    public RubyModule executeRubyModule(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyModule(this.execute(frame));
    }

    public RubyNilClass executeRubyNilClass(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.execute(frame));
    }

    public RubyProc executeRubyProc(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyProc(this.execute(frame));
    }

    public RubyRange executeRubyRange(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyRange(this.execute(frame));
    }

    public RubyRegexp executeRubyRegexp(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyRegexp(this.execute(frame));
    }

    public RubySymbol executeRubySymbol(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubySymbol(this.execute(frame));
    }

    public RubyThread executeRubyThread(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyThread(this.execute(frame));
    }

    public RubyTime executeRubyTime(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyTime(this.execute(frame));
    }

    public RubyString executeRubyString(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyString(this.execute(frame));
    }

    public RubyEncoding executeRubyEncoding(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyEncoding(this.execute(frame));
    }

    public UndefinedPlaceholder executeUndefinedPlaceholder(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(this.execute(frame));
    }

    public RubyEncodingConverter executeRubyEncodingConverter(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyEncodingConverter(this.execute(frame));
    }

    public RubyMethod executeRubyMethod(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyMethod(this.execute(frame));
    }

    public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyUnboundMethod(this.execute(frame));
    }

    public RubiniusByteArray executeRubiniusByteArray(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubiniusByteArray(this.execute(frame));
    }

    public void executeVoid(VirtualFrame frame) {
        this.execute(frame);
    }

    public RubyNode getNonProxyNode() {
        return this;
    }

    public RubyContext getContext() {
        return this.context;
    }

    public static void notDesignedForCompilation() {
        CompilerAsserts.neverPartOfCompilation();
    }

    public boolean isTrue(boolean value) {
        return value;
    }

    public RubyNode getNonWrapperNode() {
        return this;
    }

    public Probe probe() {
        Node parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Cannot call probe() on a node without a parent.");
        }
        if (parent instanceof RubyWrapperNode) {
            return ((RubyWrapperNode)parent).getProbe();
        }
        RubyWrapperNode wrapper = new RubyWrapperNode(this);
        Probe probe = ProbeNode.insertProbe((ProbeNode.WrapperNode)wrapper);
        this.replace(wrapper);
        return probe;
    }

    public void probeLite(TruffleEventReceiver eventReceiver) {
        Node parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Cannot call probeLite() on a node without a parent");
        }
        if (parent instanceof RubyWrapperNode) {
            throw new IllegalStateException("Cannot call probeLite() on a node that already has a wrapper.");
        }
        RubyWrapperNode wrapper = new RubyWrapperNode(this);
        ProbeNode.insertProbeLite((ProbeNode.WrapperNode)wrapper, (TruffleEventReceiver)eventReceiver);
        this.replace(wrapper);
    }

    public boolean isNaN(double value) {
        return Double.isNaN(value);
    }

    public boolean isInfinity(double value) {
        return Double.isInfinite(value);
    }

    public boolean isDispatchAction(Object value) {
        return value instanceof DispatchAction;
    }

    public boolean isLexicalScope(Object value) {
        return value instanceof LexicalScope;
    }

    public boolean isUndefinedPlaceholder(Object value) {
        return value instanceof UndefinedPlaceholder;
    }

    public boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    public boolean isInteger(Object value) {
        return value instanceof Integer;
    }

    public boolean isLong(Object value) {
        return value instanceof Long;
    }

    public boolean isDouble(Object value) {
        return value instanceof Double;
    }

    public boolean isString(Object value) {
        return value instanceof String;
    }

    public boolean isRubyBignum(Object value) {
        return value instanceof RubyBignum;
    }

    public boolean isIntegerFixnumRange(Object value) {
        return value instanceof RubyRange.IntegerFixnumRange;
    }

    public boolean isLongFixnumRange(Object value) {
        return value instanceof RubyRange.LongFixnumRange;
    }

    public boolean isObjectRange(Object value) {
        return value instanceof RubyRange.ObjectRange;
    }

    public boolean isRubyArray(Object value) {
        return value instanceof RubyArray;
    }

    public boolean isRubyBinding(Object value) {
        return value instanceof RubyBinding;
    }

    public boolean isRubyClass(Object value) {
        return value instanceof RubyClass;
    }

    public boolean isRubyException(Object value) {
        return value instanceof RubyException;
    }

    public boolean isRubyFiber(Object value) {
        return value instanceof RubyFiber;
    }

    public boolean isRubyHash(Object value) {
        return value instanceof RubyHash;
    }

    public boolean isRubyMatchData(Object value) {
        return value instanceof RubyMatchData;
    }

    public boolean isRubyModule(Object value) {
        return value instanceof RubyModule;
    }

    public boolean isRubyNilClass(Object value) {
        return value instanceof RubyNilClass;
    }

    public boolean isRubyProc(Object value) {
        return value instanceof RubyProc;
    }

    public boolean isRubyRange(Object value) {
        return value instanceof RubyRange;
    }

    public boolean isRubyRegexp(Object value) {
        return value instanceof RubyRegexp;
    }

    public boolean isRubyString(Object value) {
        return value instanceof RubyString;
    }

    public boolean isRubyEncoding(Object value) {
        return value instanceof RubyEncoding;
    }

    public boolean isRubySymbol(Object value) {
        return value instanceof RubySymbol;
    }

    public boolean isRubyThread(Object value) {
        return value instanceof RubyThread;
    }

    public boolean isRubyTime(Object value) {
        return value instanceof RubyTime;
    }

    public boolean isRubyEncodingConverter(Object value) {
        return value instanceof RubyEncodingConverter;
    }

    public boolean isRubyMethod(Object value) {
        return value instanceof RubyMethod;
    }

    public boolean isRubyUnboundMethod(Object value) {
        return value instanceof RubyUnboundMethod;
    }

    public boolean isRubyBasicObject(Object value) {
        return value instanceof RubyBasicObject;
    }

    public boolean isThreadLocal(Object value) {
        return value instanceof ThreadLocal;
    }

    public boolean isObjectArray(Object value) {
        return value instanceof Object[];
    }

    public boolean isRubyNilObject(Object value) {
        return value == this.nil();
    }

    public boolean isRubiniusUndefined(Object value) {
        return value == this.getContext().getCoreLibrary().getRubiniusUndefined();
    }

    protected Object ruby(VirtualFrame frame, String expression, Object ... arguments) {
        return this.rubyWithSelf(frame, RubyArguments.getSelf(frame.getArguments()), expression, arguments);
    }

    protected Object rubyWithSelf(VirtualFrame frame, Object self, String expression, Object ... arguments) {
        MaterializedFrame evalFrame = this.setupFrame(RubyArguments.getSelf(frame.getArguments()), arguments);
        RubyBinding binding = new RubyBinding(this.getContext().getCoreLibrary().getBindingClass(), self, evalFrame);
        return this.getContext().eval(expression, binding, true, "inline-ruby", (Node)this);
    }

    @CompilerDirectives.TruffleBoundary
    private MaterializedFrame setupFrame(Object self, Object ... arguments) {
        MaterializedFrame evalFrame = Truffle.getRuntime().createMaterializedFrame(RubyArguments.pack(null, null, self, null, new Object[0]));
        if (arguments.length % 2 == 1) {
            throw new UnsupportedOperationException("odd number of name-value pairs for arguments");
        }
        for (int n = 0; n < arguments.length; n += 2) {
            evalFrame.setObject(evalFrame.getFrameDescriptor().findOrAddFrameSlot(arguments[n]), arguments[n + 1]);
        }
        return evalFrame;
    }

    protected RubyNilClass nil() {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    protected POSIX posix() {
        return this.getContext().getPosix();
    }
}

