/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyModule;

public class ReadConstantNode
extends RubyNode {
    private final String name;
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private DispatchHeadNode dispatch;

    public ReadConstantNode(RubyContext context, SourceSection sourceSection, String name, RubyNode receiver, LexicalScope lexicalScope) {
        super(context, sourceSection);
        this.name = name;
        this.receiver = receiver;
        this.dispatch = new DispatchHeadNode(context, false, false, MissingBehavior.CALL_CONST_MISSING, lexicalScope, DispatchAction.READ_CONSTANT);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object receiverObject = this.receiver.execute(frame);
        if (!(receiverObject instanceof RubyModule)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorIsNotA(receiverObject.toString(), "class/module", this));
        }
        return this.dispatch.dispatch(frame, receiverObject, this.name, null, new Object[0]);
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object receiverObject;
        ReadConstantNode.notDesignedForCompilation();
        RubyContext context = this.getContext();
        if (this.name.equals("Encoding")) {
            return context.makeString("constant");
        }
        try {
            receiverObject = this.receiver.execute(frame);
        }
        catch (RaiseException e) {
            if (e.getRubyException().getLogicalClass() == context.getCoreLibrary().getNameErrorClass()) {
                return this.nil();
            }
            throw e;
        }
        RubyModule module = (RubyModule)receiverObject;
        RubyConstant constant = ModuleOperations.lookupConstant(context, this.dispatch.getLexicalScope(), module, this.name);
        if (constant == null || !constant.isVisibleTo(context, this.dispatch.getLexicalScope(), module)) {
            return this.nil();
        }
        return context.makeString("constant");
    }

    public String getName() {
        return this.name;
    }
}

