/*
 * Decompiled with CFR 0.152.
 */
package org.prism;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;

public abstract class ParsingOptions {
    public static byte[] serialize(byte[] filepath, int line, byte[] encoding, boolean frozenStringLiteral, EnumSet<CommandLine> commandLine, SyntaxVersion version, boolean encodingLocked, boolean mainScript, boolean partialScript, byte[][][] scopes) {
        Scope[] normalizedScopes = new Scope[scopes.length];
        for (int i = 0; i < scopes.length; ++i) {
            normalizedScopes[i] = new Scope(scopes[i]);
        }
        return ParsingOptions.serialize(filepath, line, encoding, frozenStringLiteral, commandLine, version, encodingLocked, mainScript, partialScript, normalizedScopes);
    }

    public static byte[] serialize(byte[] filepath, int line, byte[] encoding, boolean frozenStringLiteral, EnumSet<CommandLine> commandLine, SyntaxVersion version, boolean encodingLocked, boolean mainScript, boolean partialScript, Scope[] scopes) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ParsingOptions.write(output, ParsingOptions.serializeInt(filepath.length));
        ParsingOptions.write(output, filepath);
        ParsingOptions.write(output, ParsingOptions.serializeInt(line));
        ParsingOptions.write(output, ParsingOptions.serializeInt(encoding.length));
        ParsingOptions.write(output, encoding);
        output.write(frozenStringLiteral ? 1 : 0);
        output.write(ParsingOptions.serializeEnumSet(commandLine));
        output.write(version.getValue());
        output.write(encodingLocked ? 1 : 0);
        output.write(mainScript ? 1 : 0);
        output.write(partialScript ? 1 : 0);
        output.write(0);
        ParsingOptions.write(output, ParsingOptions.serializeInt(scopes.length));
        for (Scope scope : scopes) {
            byte[][] locals = scope.getLocals();
            ParsingOptions.write(output, ParsingOptions.serializeInt(locals.length));
            output.write(scope.getForwarding());
            for (byte[] local : locals) {
                ParsingOptions.write(output, ParsingOptions.serializeInt(local.length));
                ParsingOptions.write(output, local);
            }
        }
        return output.toByteArray();
    }

    private static void write(ByteArrayOutputStream output, byte[] bytes) {
        output.write(bytes, 0, bytes.length);
    }

    private static <T extends Enum<T>> byte serializeEnumSet(EnumSet<T> set) {
        byte result = 0;
        for (Enum value : set) {
            assert (1 << value.ordinal() <= 127);
            result = (byte)(result | (byte)(1 << value.ordinal()));
        }
        return result;
    }

    private static byte[] serializeInt(int n) {
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
        buffer.putInt(n);
        return buffer.array();
    }

    public static class Scope {
        private byte[][] locals;
        private Forwarding[] forwarding;

        Scope(byte[][] locals) {
            this(locals, new Forwarding[0]);
        }

        Scope(Forwarding[] forwarding) {
            this(new byte[0][], forwarding);
        }

        Scope(byte[][] locals, Forwarding[] forwarding) {
            this.locals = locals;
            this.forwarding = forwarding;
        }

        public byte[][] getLocals() {
            return this.locals;
        }

        public int getForwarding() {
            int value = 0;
            for (Forwarding f : this.forwarding) {
                value |= f.getValue();
            }
            return value;
        }
    }

    public static enum SyntaxVersion {
        LATEST(0),
        V3_3(1),
        V3_4(2);

        private final int value;

        private SyntaxVersion(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum Forwarding {
        NONE(0),
        POSITIONAL(1),
        KEYWORD(2),
        BLOCK(4),
        ALL(8);

        private final int value;

        private Forwarding(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum CommandLine {
        A,
        E,
        L,
        N,
        P,
        X;

    }
}

