/*
 * Decompiled with CFR 0.152.
 */
package org.prism;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.jruby.RubySymbol;
import org.prism.MarkNewlinesVisitor;
import org.prism.Nodes;
import org.prism.ParseResult;

public class Loader {
    private final ByteBuffer buffer;
    private final Nodes.Source source;
    protected String encodingName;
    private ConstantPool constantPool;
    private static final BigInteger UNSIGNED_LONG_MASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    private static final Nodes.Node[] EMPTY_Node_ARRAY = new Nodes.Node[0];
    private static final Nodes.BlockLocalVariableNode[] EMPTY_BlockLocalVariableNode_ARRAY = new Nodes.BlockLocalVariableNode[0];
    private static final Nodes.InNode[] EMPTY_InNode_ARRAY = new Nodes.InNode[0];
    private static final Nodes.WhenNode[] EMPTY_WhenNode_ARRAY = new Nodes.WhenNode[0];
    private static final Nodes.AssocNode[] EMPTY_AssocNode_ARRAY = new Nodes.AssocNode[0];
    private static final Nodes.LocalVariableTargetNode[] EMPTY_LocalVariableTargetNode_ARRAY = new Nodes.LocalVariableTargetNode[0];
    private static final Nodes.OptionalParameterNode[] EMPTY_OptionalParameterNode_ARRAY = new Nodes.OptionalParameterNode[0];

    public static ParseResult load(byte[] serialized, byte[] sourceBytes) {
        return new Loader(serialized, sourceBytes).load();
    }

    public Charset getEncodingCharset(String encodingName) {
        if ((encodingName = encodingName.toLowerCase(Locale.ROOT)).equals("ascii-8bit")) {
            return StandardCharsets.US_ASCII;
        }
        return Charset.forName(encodingName);
    }

    public RubySymbol bytesToName(byte[] bytes) {
        return null;
    }

    protected Loader(byte[] serialized, byte[] sourceBytes) {
        this.buffer = ByteBuffer.wrap(serialized).order(ByteOrder.nativeOrder());
        this.source = new Nodes.Source(sourceBytes);
    }

    protected ParseResult load() {
        Nodes.Node node;
        this.expect((byte)80, "incorrect prism header");
        this.expect((byte)82, "incorrect prism header");
        this.expect((byte)73, "incorrect prism header");
        this.expect((byte)83, "incorrect prism header");
        this.expect((byte)77, "incorrect prism header");
        this.expect((byte)1, "prism major version does not match");
        this.expect((byte)4, "prism minor version does not match");
        this.expect((byte)0, "prism patch version does not match");
        this.expect((byte)1, "Loader.java requires no location fields in the serialized output");
        int encodingLength = this.loadVarUInt();
        byte[] encodingNameBytes = new byte[encodingLength];
        this.buffer.get(encodingNameBytes);
        this.encodingName = new String(encodingNameBytes, StandardCharsets.US_ASCII);
        this.source.setStartLine(this.loadVarSInt());
        this.source.setLineOffsets(this.loadLineOffsets());
        ParseResult.MagicComment[] magicComments = this.loadMagicComments();
        Nodes.Location dataLocation = this.loadOptionalLocation();
        ParseResult.Error[] errors = this.loadErrors();
        ParseResult.Warning[] warnings = this.loadWarnings();
        int constantPoolBufferOffset = this.buffer.getInt();
        int constantPoolLength = this.loadVarUInt();
        this.constantPool = new ConstantPool(this, this.source.bytes, constantPoolBufferOffset, constantPoolLength);
        if (errors.length == 0) {
            node = this.loadNode();
            int left = constantPoolBufferOffset - this.buffer.position();
            if (left != 0) {
                throw new Error("Expected to consume all bytes while deserializing but there were " + left + " bytes left");
            }
            boolean[] newlineMarked = new boolean[1 + this.source.getLineCount()];
            MarkNewlinesVisitor visitor = new MarkNewlinesVisitor(this.source, newlineMarked);
            node.accept(visitor);
        } else {
            node = null;
        }
        return new ParseResult(node, magicComments, dataLocation, errors, warnings, this.source);
    }

    private byte[] loadEmbeddedString() {
        int length = this.loadVarUInt();
        byte[] bytes = new byte[length];
        this.buffer.get(bytes);
        return bytes;
    }

    private byte[] loadString() {
        switch (this.buffer.get()) {
            case 1: {
                int start = this.loadVarUInt();
                int length = this.loadVarUInt();
                byte[] bytes = new byte[length];
                System.arraycopy(this.source.bytes, start, bytes, 0, length);
                return bytes;
            }
            case 2: {
                return this.loadEmbeddedString();
            }
        }
        throw new Error("Expected 0 or 1 but was " + this.buffer.get());
    }

    private int[] loadLineOffsets() {
        int count = this.loadVarUInt();
        int[] lineOffsets = new int[count];
        for (int i = 0; i < count; ++i) {
            lineOffsets[i] = this.loadVarUInt();
        }
        return lineOffsets;
    }

    private ParseResult.MagicComment[] loadMagicComments() {
        int count = this.loadVarUInt();
        ParseResult.MagicComment[] magicComments = new ParseResult.MagicComment[count];
        for (int i = 0; i < count; ++i) {
            ParseResult.MagicComment magicComment;
            Nodes.Location keyLocation = this.loadLocation();
            Nodes.Location valueLocation = this.loadLocation();
            magicComments[i] = magicComment = new ParseResult.MagicComment(keyLocation, valueLocation);
        }
        return magicComments;
    }

    private ParseResult.Error[] loadErrors() {
        int count = this.loadVarUInt();
        ParseResult.Error[] errors = new ParseResult.Error[count];
        for (int i = 0; i < count; ++i) {
            ParseResult.Error error;
            Nodes.ErrorType type = Nodes.ERROR_TYPES[this.loadVarUInt()];
            byte[] bytes = this.loadEmbeddedString();
            String message = new String(bytes, StandardCharsets.US_ASCII);
            Nodes.Location location = this.loadLocation();
            ParseResult.ErrorLevel level = ParseResult.ERROR_LEVELS[this.buffer.get()];
            errors[i] = error = new ParseResult.Error(type, message, location, level);
        }
        return errors;
    }

    private ParseResult.Warning[] loadWarnings() {
        int count = this.loadVarUInt();
        ParseResult.Warning[] warnings = new ParseResult.Warning[count];
        for (int i = 0; i < count; ++i) {
            ParseResult.Warning warning;
            Nodes.WarningType type = Nodes.WARNING_TYPES[this.loadVarUInt() - 289];
            byte[] bytes = this.loadEmbeddedString();
            String message = new String(bytes, StandardCharsets.US_ASCII);
            Nodes.Location location = this.loadLocation();
            ParseResult.WarningLevel level = ParseResult.WARNING_LEVELS[this.buffer.get()];
            warnings[i] = warning = new ParseResult.Warning(type, message, location, level);
        }
        return warnings;
    }

    private Nodes.Node loadOptionalNode() {
        if (this.buffer.get(this.buffer.position()) != 0) {
            return this.loadNode();
        }
        this.buffer.position(this.buffer.position() + 1);
        return null;
    }

    private RubySymbol loadConstant() {
        return this.constantPool.get(this.buffer, this.loadVarUInt());
    }

    private RubySymbol loadOptionalConstant() {
        if (this.buffer.get(this.buffer.position()) != 0) {
            return this.loadConstant();
        }
        this.buffer.position(this.buffer.position() + 1);
        return null;
    }

    private RubySymbol[] loadConstants() {
        int length = this.loadVarUInt();
        if (length == 0) {
            return Nodes.EMPTY_STRING_ARRAY;
        }
        RubySymbol[] constants = new RubySymbol[length];
        for (int i = 0; i < length; ++i) {
            constants[i] = this.constantPool.get(this.buffer, this.loadVarUInt());
        }
        return constants;
    }

    private Nodes.Location loadLocation() {
        return new Nodes.Location(this.loadVarUInt(), this.loadVarUInt());
    }

    private Nodes.Location loadOptionalLocation() {
        if (this.buffer.get() != 0) {
            return this.loadLocation();
        }
        return null;
    }

    private int loadVarUInt() {
        int x = this.buffer.get();
        if (x >= 0) {
            return x;
        }
        if ((x ^= this.buffer.get() << 7) < 0) {
            x ^= 0xFFFFFF80;
        } else if ((x ^= this.buffer.get() << 14) >= 0) {
            x ^= 0x3F80;
        } else if ((x ^= this.buffer.get() << 21) < 0) {
            x ^= 0xFFE03F80;
        } else {
            x ^= this.buffer.get() << 28;
            x ^= 0xFE03F80;
        }
        return x;
    }

    private int loadVarSInt() {
        int x = this.loadVarUInt();
        return x >>> 1 ^ -(x & 1);
    }

    private short loadFlags() {
        int flags = this.loadVarUInt();
        assert (flags >= 0 && flags <= Short.MAX_VALUE);
        return (short)flags;
    }

    private Object loadInteger() {
        boolean negative = this.buffer.get() != 0;
        int wordsLength = this.loadVarUInt();
        assert (wordsLength > 0);
        int firstWord = this.loadVarUInt();
        if (wordsLength == 1) {
            if (firstWord < 0) {
                if (negative && firstWord == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                long words = Integer.toUnsignedLong(firstWord);
                return negative ? -words : words;
            }
            return negative ? -firstWord : firstWord;
        }
        int secondWord = this.loadVarUInt();
        if (wordsLength == 2) {
            long words = (long)secondWord << 32 | Integer.toUnsignedLong(firstWord);
            if (words < 0L) {
                if (negative && words == Long.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                BigInteger result = BigInteger.valueOf(words).and(UNSIGNED_LONG_MASK);
                return negative ? result.negate() : result;
            }
            return negative ? -words : words;
        }
        BigInteger result = BigInteger.valueOf(Integer.toUnsignedLong(firstWord));
        result = result.or(BigInteger.valueOf(Integer.toUnsignedLong(secondWord)).shiftLeft(32));
        for (int wordsIndex = 2; wordsIndex < wordsLength; ++wordsIndex) {
            result = result.or(BigInteger.valueOf(Integer.toUnsignedLong(this.loadVarUInt())).shiftLeft(wordsIndex * 32));
        }
        return negative ? result.negate() : result;
    }

    private Nodes.Node loadNode() {
        int type = this.buffer.get() & 0xFF;
        int startOffset = this.loadVarUInt();
        int length = this.loadVarUInt();
        switch (type) {
            case 1: {
                return new Nodes.AliasGlobalVariableNode(startOffset, length, this.loadNode(), this.loadNode());
            }
            case 2: {
                return new Nodes.AliasMethodNode(startOffset, length, this.loadNode(), this.loadNode());
            }
            case 3: {
                return new Nodes.AlternationPatternNode(startOffset, length, this.loadNode(), this.loadNode());
            }
            case 4: {
                return new Nodes.AndNode(startOffset, length, this.loadNode(), this.loadNode());
            }
            case 5: {
                return new Nodes.ArgumentsNode(startOffset, length, this.loadFlags(), this.loadNodes());
            }
            case 6: {
                return new Nodes.ArrayNode(startOffset, length, this.loadFlags(), this.loadNodes());
            }
            case 7: {
                return new Nodes.ArrayPatternNode(startOffset, length, this.loadOptionalNode(), this.loadNodes(), this.loadOptionalNode(), this.loadNodes());
            }
            case 8: {
                return new Nodes.AssocNode(startOffset, length, this.loadNode(), this.loadNode());
            }
            case 9: {
                return new Nodes.AssocSplatNode(startOffset, length, this.loadOptionalNode());
            }
            case 10: {
                return new Nodes.BackReferenceReadNode(startOffset, length, this.loadConstant());
            }
            case 11: {
                return new Nodes.BeginNode(startOffset, length, (Nodes.StatementsNode)this.loadOptionalNode(), (Nodes.RescueNode)this.loadOptionalNode(), (Nodes.ElseNode)this.loadOptionalNode(), (Nodes.EnsureNode)this.loadOptionalNode());
            }
            case 12: {
                return new Nodes.BlockArgumentNode(startOffset, length, this.loadOptionalNode());
            }
            case 13: {
                return new Nodes.BlockLocalVariableNode(startOffset, length, this.loadFlags(), this.loadConstant());
            }
            case 14: {
                return new Nodes.BlockNode(startOffset, length, this.loadConstants(), this.loadOptionalNode(), this.loadOptionalNode());
            }
            case 15: {
                return new Nodes.BlockParameterNode(startOffset, length, this.loadFlags(), this.loadOptionalConstant());
            }
            case 16: {
                return new Nodes.BlockParametersNode(startOffset, length, (Nodes.ParametersNode)this.loadOptionalNode(), this.loadBlockLocalVariableNodes());
            }
            case 17: {
                return new Nodes.BreakNode(startOffset, length, (Nodes.ArgumentsNode)this.loadOptionalNode());
            }
            case 18: {
                return new Nodes.CallAndWriteNode(startOffset, length, this.loadFlags(), this.loadOptionalNode(), this.loadConstant(), this.loadConstant(), this.loadNode());
            }
            case 19: {
                return new Nodes.CallNode(startOffset, length, this.loadFlags(), this.loadOptionalNode(), this.loadConstant(), (Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadOptionalNode());
            }
            case 20: {
                return new Nodes.CallOperatorWriteNode(startOffset, length, this.loadFlags(), this.loadOptionalNode(), this.loadConstant(), this.loadConstant(), this.loadConstant(), this.loadNode());
            }
            case 21: {
                return new Nodes.CallOrWriteNode(startOffset, length, this.loadFlags(), this.loadOptionalNode(), this.loadConstant(), this.loadConstant(), this.loadNode());
            }
            case 22: {
                return new Nodes.CallTargetNode(startOffset, length, this.loadFlags(), this.loadNode(), this.loadConstant());
            }
            case 23: {
                return new Nodes.CapturePatternNode(startOffset, length, this.loadNode(), (Nodes.LocalVariableTargetNode)this.loadNode());
            }
            case 24: {
                return new Nodes.CaseMatchNode(startOffset, length, this.loadOptionalNode(), this.loadInNodes(), (Nodes.ElseNode)this.loadOptionalNode());
            }
            case 25: {
                return new Nodes.CaseNode(startOffset, length, this.loadOptionalNode(), this.loadWhenNodes(), (Nodes.ElseNode)this.loadOptionalNode());
            }
            case 26: {
                return new Nodes.ClassNode(startOffset, length, this.loadConstants(), this.loadNode(), this.loadOptionalNode(), this.loadOptionalNode(), this.loadConstant());
            }
            case 27: {
                return new Nodes.ClassVariableAndWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 28: {
                return new Nodes.ClassVariableOperatorWriteNode(startOffset, length, this.loadConstant(), this.loadNode(), this.loadConstant());
            }
            case 29: {
                return new Nodes.ClassVariableOrWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 30: {
                return new Nodes.ClassVariableReadNode(startOffset, length, this.loadConstant());
            }
            case 31: {
                return new Nodes.ClassVariableTargetNode(startOffset, length, this.loadConstant());
            }
            case 32: {
                return new Nodes.ClassVariableWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 33: {
                return new Nodes.ConstantAndWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 34: {
                return new Nodes.ConstantOperatorWriteNode(startOffset, length, this.loadConstant(), this.loadNode(), this.loadConstant());
            }
            case 35: {
                return new Nodes.ConstantOrWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 36: {
                return new Nodes.ConstantPathAndWriteNode(startOffset, length, (Nodes.ConstantPathNode)this.loadNode(), this.loadNode());
            }
            case 37: {
                return new Nodes.ConstantPathNode(startOffset, length, this.loadOptionalNode(), this.loadOptionalConstant());
            }
            case 38: {
                return new Nodes.ConstantPathOperatorWriteNode(startOffset, length, (Nodes.ConstantPathNode)this.loadNode(), this.loadNode(), this.loadConstant());
            }
            case 39: {
                return new Nodes.ConstantPathOrWriteNode(startOffset, length, (Nodes.ConstantPathNode)this.loadNode(), this.loadNode());
            }
            case 40: {
                return new Nodes.ConstantPathTargetNode(startOffset, length, this.loadOptionalNode(), this.loadOptionalConstant());
            }
            case 41: {
                return new Nodes.ConstantPathWriteNode(startOffset, length, (Nodes.ConstantPathNode)this.loadNode(), this.loadNode());
            }
            case 42: {
                return new Nodes.ConstantReadNode(startOffset, length, this.loadConstant());
            }
            case 43: {
                return new Nodes.ConstantTargetNode(startOffset, length, this.loadConstant());
            }
            case 44: {
                return new Nodes.ConstantWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 45: {
                return new Nodes.DefNode(startOffset, length, this.buffer.getInt(), this.loadConstant(), this.loadOptionalNode(), (Nodes.ParametersNode)this.loadOptionalNode(), this.loadOptionalNode(), this.loadConstants());
            }
            case 46: {
                return new Nodes.DefinedNode(startOffset, length, this.loadNode());
            }
            case 47: {
                return new Nodes.ElseNode(startOffset, length, (Nodes.StatementsNode)this.loadOptionalNode());
            }
            case 48: {
                return new Nodes.EmbeddedStatementsNode(startOffset, length, (Nodes.StatementsNode)this.loadOptionalNode());
            }
            case 49: {
                return new Nodes.EmbeddedVariableNode(startOffset, length, this.loadNode());
            }
            case 50: {
                return new Nodes.EnsureNode(startOffset, length, (Nodes.StatementsNode)this.loadOptionalNode());
            }
            case 51: {
                return new Nodes.FalseNode(startOffset, length);
            }
            case 52: {
                return new Nodes.FindPatternNode(startOffset, length, this.loadOptionalNode(), (Nodes.SplatNode)this.loadNode(), this.loadNodes(), (Nodes.SplatNode)this.loadNode());
            }
            case 53: {
                return new Nodes.FlipFlopNode(startOffset, length, this.loadFlags(), this.loadOptionalNode(), this.loadOptionalNode());
            }
            case 54: {
                return new Nodes.FloatNode(startOffset, length, this.buffer.getDouble());
            }
            case 55: {
                return new Nodes.ForNode(startOffset, length, this.loadNode(), this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode());
            }
            case 56: {
                return new Nodes.ForwardingArgumentsNode(startOffset, length);
            }
            case 57: {
                return new Nodes.ForwardingParameterNode(startOffset, length);
            }
            case 58: {
                return new Nodes.ForwardingSuperNode(startOffset, length, (Nodes.BlockNode)this.loadOptionalNode());
            }
            case 59: {
                return new Nodes.GlobalVariableAndWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 60: {
                return new Nodes.GlobalVariableOperatorWriteNode(startOffset, length, this.loadConstant(), this.loadNode(), this.loadConstant());
            }
            case 61: {
                return new Nodes.GlobalVariableOrWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 62: {
                return new Nodes.GlobalVariableReadNode(startOffset, length, this.loadConstant());
            }
            case 63: {
                return new Nodes.GlobalVariableTargetNode(startOffset, length, this.loadConstant());
            }
            case 64: {
                return new Nodes.GlobalVariableWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 65: {
                return new Nodes.HashNode(startOffset, length, this.loadNodes());
            }
            case 66: {
                return new Nodes.HashPatternNode(startOffset, length, this.loadOptionalNode(), this.loadAssocNodes(), this.loadOptionalNode());
            }
            case 67: {
                return new Nodes.IfNode(startOffset, length, this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), this.loadOptionalNode());
            }
            case 68: {
                return new Nodes.ImaginaryNode(startOffset, length, this.loadNode());
            }
            case 69: {
                return new Nodes.ImplicitNode(startOffset, length, this.loadNode());
            }
            case 70: {
                return new Nodes.ImplicitRestNode(startOffset, length);
            }
            case 71: {
                return new Nodes.InNode(startOffset, length, this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode());
            }
            case 72: {
                return new Nodes.IndexAndWriteNode(startOffset, length, this.loadFlags(), this.loadOptionalNode(), (Nodes.ArgumentsNode)this.loadOptionalNode(), (Nodes.BlockArgumentNode)this.loadOptionalNode(), this.loadNode());
            }
            case 73: {
                return new Nodes.IndexOperatorWriteNode(startOffset, length, this.loadFlags(), this.loadOptionalNode(), (Nodes.ArgumentsNode)this.loadOptionalNode(), (Nodes.BlockArgumentNode)this.loadOptionalNode(), this.loadConstant(), this.loadNode());
            }
            case 74: {
                return new Nodes.IndexOrWriteNode(startOffset, length, this.loadFlags(), this.loadOptionalNode(), (Nodes.ArgumentsNode)this.loadOptionalNode(), (Nodes.BlockArgumentNode)this.loadOptionalNode(), this.loadNode());
            }
            case 75: {
                return new Nodes.IndexTargetNode(startOffset, length, this.loadFlags(), this.loadNode(), (Nodes.ArgumentsNode)this.loadOptionalNode(), (Nodes.BlockArgumentNode)this.loadOptionalNode());
            }
            case 76: {
                return new Nodes.InstanceVariableAndWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 77: {
                return new Nodes.InstanceVariableOperatorWriteNode(startOffset, length, this.loadConstant(), this.loadNode(), this.loadConstant());
            }
            case 78: {
                return new Nodes.InstanceVariableOrWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 79: {
                return new Nodes.InstanceVariableReadNode(startOffset, length, this.loadConstant());
            }
            case 80: {
                return new Nodes.InstanceVariableTargetNode(startOffset, length, this.loadConstant());
            }
            case 81: {
                return new Nodes.InstanceVariableWriteNode(startOffset, length, this.loadConstant(), this.loadNode());
            }
            case 82: {
                return new Nodes.IntegerNode(startOffset, length, this.loadFlags(), this.loadInteger());
            }
            case 83: {
                return new Nodes.InterpolatedMatchLastLineNode(startOffset, length, this.loadFlags(), this.loadNodes());
            }
            case 84: {
                return new Nodes.InterpolatedRegularExpressionNode(startOffset, length, this.loadFlags(), this.loadNodes());
            }
            case 85: {
                return new Nodes.InterpolatedStringNode(startOffset, length, this.loadFlags(), this.loadNodes());
            }
            case 86: {
                return new Nodes.InterpolatedSymbolNode(startOffset, length, this.loadNodes());
            }
            case 87: {
                return new Nodes.InterpolatedXStringNode(startOffset, length, this.loadNodes());
            }
            case 88: {
                return new Nodes.ItLocalVariableReadNode(startOffset, length);
            }
            case 89: {
                return new Nodes.ItParametersNode(startOffset, length);
            }
            case 90: {
                return new Nodes.KeywordHashNode(startOffset, length, this.loadFlags(), this.loadNodes());
            }
            case 91: {
                return new Nodes.KeywordRestParameterNode(startOffset, length, this.loadFlags(), this.loadOptionalConstant());
            }
            case 92: {
                return new Nodes.LambdaNode(startOffset, length, this.loadConstants(), this.loadOptionalNode(), this.loadOptionalNode());
            }
            case 93: {
                return new Nodes.LocalVariableAndWriteNode(startOffset, length, this.loadNode(), this.loadConstant(), this.loadVarUInt());
            }
            case 94: {
                return new Nodes.LocalVariableOperatorWriteNode(startOffset, length, this.loadNode(), this.loadConstant(), this.loadConstant(), this.loadVarUInt());
            }
            case 95: {
                return new Nodes.LocalVariableOrWriteNode(startOffset, length, this.loadNode(), this.loadConstant(), this.loadVarUInt());
            }
            case 96: {
                return new Nodes.LocalVariableReadNode(startOffset, length, this.loadConstant(), this.loadVarUInt());
            }
            case 97: {
                return new Nodes.LocalVariableTargetNode(startOffset, length, this.loadConstant(), this.loadVarUInt());
            }
            case 98: {
                return new Nodes.LocalVariableWriteNode(startOffset, length, this.loadConstant(), this.loadVarUInt(), this.loadNode());
            }
            case 99: {
                return new Nodes.MatchLastLineNode(startOffset, length, this.loadFlags(), this.loadString());
            }
            case 100: {
                return new Nodes.MatchPredicateNode(startOffset, length, this.loadNode(), this.loadNode());
            }
            case 101: {
                return new Nodes.MatchRequiredNode(startOffset, length, this.loadNode(), this.loadNode());
            }
            case 102: {
                return new Nodes.MatchWriteNode(startOffset, length, (Nodes.CallNode)this.loadNode(), this.loadLocalVariableTargetNodes());
            }
            case 103: {
                return new Nodes.MissingNode(startOffset, length);
            }
            case 104: {
                return new Nodes.ModuleNode(startOffset, length, this.loadConstants(), this.loadNode(), this.loadOptionalNode(), this.loadConstant());
            }
            case 105: {
                return new Nodes.MultiTargetNode(startOffset, length, this.loadNodes(), this.loadOptionalNode(), this.loadNodes());
            }
            case 106: {
                return new Nodes.MultiWriteNode(startOffset, length, this.loadNodes(), this.loadOptionalNode(), this.loadNodes(), this.loadNode());
            }
            case 107: {
                return new Nodes.NextNode(startOffset, length, (Nodes.ArgumentsNode)this.loadOptionalNode());
            }
            case 108: {
                return new Nodes.NilNode(startOffset, length);
            }
            case 109: {
                return new Nodes.NoKeywordsParameterNode(startOffset, length);
            }
            case 110: {
                return new Nodes.NumberedParametersNode(startOffset, length, this.buffer.get());
            }
            case 111: {
                return new Nodes.NumberedReferenceReadNode(startOffset, length, this.loadVarUInt());
            }
            case 112: {
                return new Nodes.OptionalKeywordParameterNode(startOffset, length, this.loadFlags(), this.loadConstant(), this.loadNode());
            }
            case 113: {
                return new Nodes.OptionalParameterNode(startOffset, length, this.loadFlags(), this.loadConstant(), this.loadNode());
            }
            case 114: {
                return new Nodes.OrNode(startOffset, length, this.loadNode(), this.loadNode());
            }
            case 115: {
                return new Nodes.ParametersNode(startOffset, length, this.loadNodes(), this.loadOptionalParameterNodes(), this.loadOptionalNode(), this.loadNodes(), this.loadNodes(), this.loadOptionalNode(), (Nodes.BlockParameterNode)this.loadOptionalNode());
            }
            case 116: {
                return new Nodes.ParenthesesNode(startOffset, length, this.loadFlags(), this.loadOptionalNode());
            }
            case 117: {
                return new Nodes.PinnedExpressionNode(startOffset, length, this.loadNode());
            }
            case 118: {
                return new Nodes.PinnedVariableNode(startOffset, length, this.loadNode());
            }
            case 119: {
                return new Nodes.PostExecutionNode(startOffset, length, (Nodes.StatementsNode)this.loadOptionalNode());
            }
            case 120: {
                return new Nodes.PreExecutionNode(startOffset, length, (Nodes.StatementsNode)this.loadOptionalNode());
            }
            case 121: {
                return new Nodes.ProgramNode(startOffset, length, this.loadConstants(), (Nodes.StatementsNode)this.loadNode());
            }
            case 122: {
                return new Nodes.RangeNode(startOffset, length, this.loadFlags(), this.loadOptionalNode(), this.loadOptionalNode());
            }
            case 123: {
                return new Nodes.RationalNode(startOffset, length, this.loadFlags(), this.loadInteger(), this.loadInteger());
            }
            case 124: {
                return new Nodes.RedoNode(startOffset, length);
            }
            case 125: {
                return new Nodes.RegularExpressionNode(startOffset, length, this.loadFlags(), this.loadString());
            }
            case 126: {
                return new Nodes.RequiredKeywordParameterNode(startOffset, length, this.loadFlags(), this.loadConstant());
            }
            case 127: {
                return new Nodes.RequiredParameterNode(startOffset, length, this.loadFlags(), this.loadConstant());
            }
            case 128: {
                return new Nodes.RescueModifierNode(startOffset, length, this.loadNode(), this.loadNode());
            }
            case 129: {
                return new Nodes.RescueNode(startOffset, length, this.loadNodes(), this.loadOptionalNode(), (Nodes.StatementsNode)this.loadOptionalNode(), (Nodes.RescueNode)this.loadOptionalNode());
            }
            case 130: {
                return new Nodes.RestParameterNode(startOffset, length, this.loadFlags(), this.loadOptionalConstant());
            }
            case 131: {
                return new Nodes.RetryNode(startOffset, length);
            }
            case 132: {
                return new Nodes.ReturnNode(startOffset, length, (Nodes.ArgumentsNode)this.loadOptionalNode());
            }
            case 133: {
                return new Nodes.SelfNode(startOffset, length);
            }
            case 134: {
                return new Nodes.ShareableConstantNode(startOffset, length, this.loadFlags(), this.loadNode());
            }
            case 135: {
                return new Nodes.SingletonClassNode(startOffset, length, this.loadConstants(), this.loadNode(), this.loadOptionalNode());
            }
            case 136: {
                return new Nodes.SourceEncodingNode(startOffset, length);
            }
            case 137: {
                return new Nodes.SourceFileNode(startOffset, length, this.loadFlags(), this.loadString());
            }
            case 138: {
                return new Nodes.SourceLineNode(startOffset, length);
            }
            case 139: {
                return new Nodes.SplatNode(startOffset, length, this.loadOptionalNode());
            }
            case 140: {
                return new Nodes.StatementsNode(startOffset, length, this.loadNodes());
            }
            case 141: {
                return new Nodes.StringNode(startOffset, length, this.loadFlags(), this.loadString());
            }
            case 142: {
                return new Nodes.SuperNode(startOffset, length, (Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadOptionalNode());
            }
            case 143: {
                return new Nodes.SymbolNode(startOffset, length, this.loadFlags(), this.loadString());
            }
            case 144: {
                return new Nodes.TrueNode(startOffset, length);
            }
            case 145: {
                return new Nodes.UndefNode(startOffset, length, this.loadNodes());
            }
            case 146: {
                return new Nodes.UnlessNode(startOffset, length, this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), (Nodes.ElseNode)this.loadOptionalNode());
            }
            case 147: {
                return new Nodes.UntilNode(startOffset, length, this.loadFlags(), this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode());
            }
            case 148: {
                return new Nodes.WhenNode(startOffset, length, this.loadNodes(), (Nodes.StatementsNode)this.loadOptionalNode());
            }
            case 149: {
                return new Nodes.WhileNode(startOffset, length, this.loadFlags(), this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode());
            }
            case 150: {
                return new Nodes.XStringNode(startOffset, length, this.loadFlags(), this.loadString());
            }
            case 151: {
                return new Nodes.YieldNode(startOffset, length, (Nodes.ArgumentsNode)this.loadOptionalNode());
            }
        }
        throw new Error("Unknown node type: " + type);
    }

    private Nodes.Node[] loadNodes() {
        int length = this.loadVarUInt();
        if (length == 0) {
            return EMPTY_Node_ARRAY;
        }
        Nodes.Node[] nodes = new Nodes.Node[length];
        for (int i = 0; i < length; ++i) {
            nodes[i] = this.loadNode();
        }
        return nodes;
    }

    private Nodes.BlockLocalVariableNode[] loadBlockLocalVariableNodes() {
        int length = this.loadVarUInt();
        if (length == 0) {
            return EMPTY_BlockLocalVariableNode_ARRAY;
        }
        Nodes.BlockLocalVariableNode[] nodes = new Nodes.BlockLocalVariableNode[length];
        for (int i = 0; i < length; ++i) {
            nodes[i] = (Nodes.BlockLocalVariableNode)this.loadNode();
        }
        return nodes;
    }

    private Nodes.InNode[] loadInNodes() {
        int length = this.loadVarUInt();
        if (length == 0) {
            return EMPTY_InNode_ARRAY;
        }
        Nodes.InNode[] nodes = new Nodes.InNode[length];
        for (int i = 0; i < length; ++i) {
            nodes[i] = (Nodes.InNode)this.loadNode();
        }
        return nodes;
    }

    private Nodes.WhenNode[] loadWhenNodes() {
        int length = this.loadVarUInt();
        if (length == 0) {
            return EMPTY_WhenNode_ARRAY;
        }
        Nodes.WhenNode[] nodes = new Nodes.WhenNode[length];
        for (int i = 0; i < length; ++i) {
            nodes[i] = (Nodes.WhenNode)this.loadNode();
        }
        return nodes;
    }

    private Nodes.AssocNode[] loadAssocNodes() {
        int length = this.loadVarUInt();
        if (length == 0) {
            return EMPTY_AssocNode_ARRAY;
        }
        Nodes.AssocNode[] nodes = new Nodes.AssocNode[length];
        for (int i = 0; i < length; ++i) {
            nodes[i] = (Nodes.AssocNode)this.loadNode();
        }
        return nodes;
    }

    private Nodes.LocalVariableTargetNode[] loadLocalVariableTargetNodes() {
        int length = this.loadVarUInt();
        if (length == 0) {
            return EMPTY_LocalVariableTargetNode_ARRAY;
        }
        Nodes.LocalVariableTargetNode[] nodes = new Nodes.LocalVariableTargetNode[length];
        for (int i = 0; i < length; ++i) {
            nodes[i] = (Nodes.LocalVariableTargetNode)this.loadNode();
        }
        return nodes;
    }

    private Nodes.OptionalParameterNode[] loadOptionalParameterNodes() {
        int length = this.loadVarUInt();
        if (length == 0) {
            return EMPTY_OptionalParameterNode_ARRAY;
        }
        Nodes.OptionalParameterNode[] nodes = new Nodes.OptionalParameterNode[length];
        for (int i = 0; i < length; ++i) {
            nodes[i] = (Nodes.OptionalParameterNode)this.loadNode();
        }
        return nodes;
    }

    private void expect(byte value, String error) {
        byte b = this.buffer.get();
        if (b != value) {
            throw new Error("Deserialization error: " + error + " (expected " + value + " but was " + b + " at position " + this.buffer.position() + ")");
        }
    }

    private static final class ConstantPool {
        private final Loader loader;
        private final byte[] source;
        private final int bufferOffset;
        private final RubySymbol[] cache;

        ConstantPool(Loader loader, byte[] source, int bufferOffset, int length) {
            this.loader = loader;
            this.source = source;
            this.bufferOffset = bufferOffset;
            this.cache = new RubySymbol[length];
        }

        RubySymbol get(ByteBuffer buffer, int oneBasedIndex) {
            int index = oneBasedIndex - 1;
            RubySymbol constant = this.cache[index];
            if (constant == null) {
                int offset = this.bufferOffset + index * 8;
                int start = buffer.getInt(offset);
                int length = buffer.getInt(offset + 4);
                byte[] bytes = new byte[length];
                if (Integer.compareUnsigned(start, Integer.MAX_VALUE) <= 0) {
                    System.arraycopy(this.source, start, bytes, 0, length);
                } else {
                    int position = buffer.position();
                    buffer.position(start & Integer.MAX_VALUE);
                    buffer.get(bytes, 0, length);
                    buffer.position(position);
                }
                this.cache[index] = constant = this.loader.bytesToName(bytes);
            }
            return constant;
        }
    }
}

