/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.prism.parser;

import org.jcodings.Encoding;
import org.jruby.ParseResult;
import org.jruby.parser.StaticScope;
import org.jruby.prism.builder.IRBuilderPrism;
import org.jruby.runtime.DynamicScope;
import org.prism.Nodes;

public class ParseResultPrism
implements ParseResult {
    final Encoding encoding;
    StaticScope rootScope;
    Nodes.ProgramNode root;
    final Nodes.Source nodeSource;
    final String fileName;
    final byte[] source;
    final int coverageMode;
    DynamicScope toplevelScope;

    public ParseResultPrism(String fileName, byte[] source, Nodes.ProgramNode root, Nodes.Source nodeSource, Encoding encoding, int coverageMode) {
        this.root = root;
        this.fileName = fileName;
        this.source = source;
        this.nodeSource = nodeSource;
        this.encoding = encoding;
        this.coverageMode = coverageMode;
    }

    public void setDynamicScope(DynamicScope scope) {
        this.toplevelScope = scope;
        this.rootScope = scope.getStaticScope();
    }

    public DynamicScope getDynamicScope() {
        if (this.rootScope == null) {
            this.getStaticScope();
        }
        return this.toplevelScope;
    }

    public StaticScope getStaticScope() {
        if (this.rootScope == null) {
            this.rootScope = IRBuilderPrism.createStaticScopeFrom(this.fileName, this.root.locals, StaticScope.Type.LOCAL, null);
            this.toplevelScope = DynamicScope.newDynamicScope((StaticScope)this.rootScope);
        }
        return this.rootScope;
    }

    public int getLine() {
        return 0;
    }

    public String getFile() {
        return this.fileName;
    }

    public int getCoverageMode() {
        return this.coverageMode;
    }

    public Nodes.ProgramNode getRoot() {
        return this.root;
    }

    public void setRoot(Nodes.ProgramNode root) {
        this.root = root;
    }

    public byte[] getSource() {
        return this.source;
    }

    public Object getAST() {
        return this.root;
    }

    public Nodes.Source getSourceNode() {
        return this.nodeSource;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }
}

