/*
 * Decompiled with CFR 0.152.
 */
package org.prism;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.jruby.RubySymbol;
import org.prism.MarkNewlinesVisitor;
import org.prism.Nodes;
import org.prism.ParseResult;

public class Loader {
    private final ByteBuffer buffer;
    private final Nodes.Source source;
    protected String encodingName;
    private ConstantPool constantPool;

    public static ParseResult load(byte[] serialized, byte[] sourceBytes) {
        return new Loader(serialized, sourceBytes).load();
    }

    public Charset getEncodingCharset(String encodingName) {
        if ((encodingName = encodingName.toLowerCase(Locale.ROOT)).equals("ascii-8bit")) {
            return StandardCharsets.US_ASCII;
        }
        return Charset.forName(encodingName);
    }

    public RubySymbol bytesToName(byte[] bytes) {
        return null;
    }

    protected Loader(byte[] serialized, byte[] sourceBytes) {
        this.buffer = ByteBuffer.wrap(serialized).order(ByteOrder.nativeOrder());
        this.source = new Nodes.Source(sourceBytes);
    }

    protected ParseResult load() {
        this.expect((byte)80, "incorrect prism header");
        this.expect((byte)82, "incorrect prism header");
        this.expect((byte)73, "incorrect prism header");
        this.expect((byte)83, "incorrect prism header");
        this.expect((byte)77, "incorrect prism header");
        this.expect((byte)0, "prism major version does not match");
        this.expect((byte)24, "prism minor version does not match");
        this.expect((byte)0, "prism patch version does not match");
        this.expect((byte)1, "Loader.java requires no location fields in the serialized output");
        int encodingLength = this.loadVarUInt();
        byte[] encodingNameBytes = new byte[encodingLength];
        this.buffer.get(encodingNameBytes);
        this.encodingName = new String(encodingNameBytes, StandardCharsets.US_ASCII);
        this.source.setStartLine(this.loadVarSInt());
        this.source.setLineOffsets(this.loadLineOffsets());
        ParseResult.MagicComment[] magicComments = this.loadMagicComments();
        Nodes.Location dataLocation = this.loadOptionalLocation();
        ParseResult.Error[] errors = this.loadSyntaxErrors();
        ParseResult.Warning[] warnings = this.loadWarnings();
        int constantPoolBufferOffset = this.buffer.getInt();
        int constantPoolLength = this.loadVarUInt();
        this.constantPool = new ConstantPool(this, this.source.bytes, constantPoolBufferOffset, constantPoolLength);
        Nodes.Node node = this.loadNode();
        int left = constantPoolBufferOffset - this.buffer.position();
        if (left != 0) {
            throw new Error("Expected to consume all bytes while deserializing but there were " + left + " bytes left");
        }
        boolean[] newlineMarked = new boolean[1 + this.source.getLineCount()];
        MarkNewlinesVisitor visitor = new MarkNewlinesVisitor(this.source, newlineMarked);
        node.accept(visitor);
        return new ParseResult(node, magicComments, dataLocation, errors, warnings, this.source);
    }

    private byte[] loadEmbeddedString() {
        int length = this.loadVarUInt();
        byte[] bytes = new byte[length];
        this.buffer.get(bytes);
        return bytes;
    }

    private byte[] loadString() {
        switch (this.buffer.get()) {
            case 1: {
                int start = this.loadVarUInt();
                int length = this.loadVarUInt();
                byte[] bytes = new byte[length];
                System.arraycopy(this.source.bytes, start, bytes, 0, length);
                return bytes;
            }
            case 2: {
                return this.loadEmbeddedString();
            }
        }
        throw new Error("Expected 0 or 1 but was " + this.buffer.get());
    }

    private int[] loadLineOffsets() {
        int count = this.loadVarUInt();
        int[] lineOffsets = new int[count];
        for (int i = 0; i < count; ++i) {
            lineOffsets[i] = this.loadVarUInt();
        }
        return lineOffsets;
    }

    private ParseResult.MagicComment[] loadMagicComments() {
        int count = this.loadVarUInt();
        ParseResult.MagicComment[] magicComments = new ParseResult.MagicComment[count];
        for (int i = 0; i < count; ++i) {
            ParseResult.MagicComment magicComment;
            Nodes.Location keyLocation = this.loadLocation();
            Nodes.Location valueLocation = this.loadLocation();
            magicComments[i] = magicComment = new ParseResult.MagicComment(keyLocation, valueLocation);
        }
        return magicComments;
    }

    private ParseResult.Error[] loadSyntaxErrors() {
        int count = this.loadVarUInt();
        ParseResult.Error[] errors = new ParseResult.Error[count];
        for (int i = 0; i < count; ++i) {
            ParseResult.Error error;
            byte[] bytes = this.loadEmbeddedString();
            String message = new String(bytes, StandardCharsets.US_ASCII);
            Nodes.Location location = this.loadLocation();
            ParseResult.ErrorLevel level = ParseResult.ERROR_LEVELS[this.buffer.get()];
            errors[i] = error = new ParseResult.Error(message, location, level);
        }
        return errors;
    }

    private ParseResult.Warning[] loadWarnings() {
        int count = this.loadVarUInt();
        ParseResult.Warning[] warnings = new ParseResult.Warning[count];
        for (int i = 0; i < count; ++i) {
            ParseResult.Warning warning;
            byte[] bytes = this.loadEmbeddedString();
            String message = new String(bytes, StandardCharsets.US_ASCII);
            Nodes.Location location = this.loadLocation();
            ParseResult.WarningLevel level = ParseResult.WARNING_LEVELS[this.buffer.get()];
            warnings[i] = warning = new ParseResult.Warning(message, location, level);
        }
        return warnings;
    }

    private Nodes.Node loadOptionalNode() {
        if (this.buffer.get(this.buffer.position()) != 0) {
            return this.loadNode();
        }
        this.buffer.position(this.buffer.position() + 1);
        return null;
    }

    private RubySymbol loadConstant() {
        return this.constantPool.get(this.buffer, this.loadVarUInt());
    }

    private RubySymbol loadOptionalConstant() {
        if (this.buffer.get(this.buffer.position()) != 0) {
            return this.loadConstant();
        }
        this.buffer.position(this.buffer.position() + 1);
        return null;
    }

    private RubySymbol[] loadConstants() {
        int length = this.loadVarUInt();
        if (length == 0) {
            return Nodes.EMPTY_STRING_ARRAY;
        }
        RubySymbol[] constants = new RubySymbol[length];
        for (int i = 0; i < length; ++i) {
            constants[i] = this.constantPool.get(this.buffer, this.loadVarUInt());
        }
        return constants;
    }

    private Nodes.Node[] loadNodes() {
        int length = this.loadVarUInt();
        if (length == 0) {
            return Nodes.Node.EMPTY_ARRAY;
        }
        Nodes.Node[] nodes = new Nodes.Node[length];
        for (int i = 0; i < length; ++i) {
            nodes[i] = this.loadNode();
        }
        return nodes;
    }

    private Nodes.Location loadLocation() {
        return new Nodes.Location(this.loadVarUInt(), this.loadVarUInt());
    }

    private Nodes.Location loadOptionalLocation() {
        if (this.buffer.get() != 0) {
            return this.loadLocation();
        }
        return null;
    }

    private int loadVarUInt() {
        int x = this.buffer.get();
        if (x >= 0) {
            return x;
        }
        if ((x ^= this.buffer.get() << 7) < 0) {
            x ^= 0xFFFFFF80;
        } else if ((x ^= this.buffer.get() << 14) >= 0) {
            x ^= 0x3F80;
        } else if ((x ^= this.buffer.get() << 21) < 0) {
            x ^= 0xFFE03F80;
        } else {
            x ^= this.buffer.get() << 28;
            x ^= 0xFE03F80;
        }
        return x;
    }

    private int loadVarSInt() {
        int x = this.loadVarUInt();
        return x >>> 1 ^ -(x & 1);
    }

    private short loadFlags() {
        int flags = this.loadVarUInt();
        assert (flags >= 0 && flags <= Short.MAX_VALUE);
        return (short)flags;
    }

    private Nodes.Node loadNode() {
        int type = this.buffer.get() & 0xFF;
        int startOffset = this.loadVarUInt();
        int length = this.loadVarUInt();
        switch (type) {
            case 1: {
                return new Nodes.AliasGlobalVariableNode(this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 2: {
                return new Nodes.AliasMethodNode(this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 3: {
                return new Nodes.AlternationPatternNode(this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 4: {
                return new Nodes.AndNode(this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 5: {
                return new Nodes.ArgumentsNode(this.loadFlags(), this.loadNodes(), startOffset, length);
            }
            case 6: {
                return new Nodes.ArrayNode(this.loadFlags(), this.loadNodes(), startOffset, length);
            }
            case 7: {
                return new Nodes.ArrayPatternNode(this.loadOptionalNode(), this.loadNodes(), this.loadOptionalNode(), this.loadNodes(), startOffset, length);
            }
            case 8: {
                return new Nodes.AssocNode(this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 9: {
                return new Nodes.AssocSplatNode(this.loadOptionalNode(), startOffset, length);
            }
            case 10: {
                return new Nodes.BackReferenceReadNode(this.loadConstant(), startOffset, length);
            }
            case 11: {
                return new Nodes.BeginNode((Nodes.StatementsNode)this.loadOptionalNode(), (Nodes.RescueNode)this.loadOptionalNode(), (Nodes.ElseNode)this.loadOptionalNode(), (Nodes.EnsureNode)this.loadOptionalNode(), startOffset, length);
            }
            case 12: {
                return new Nodes.BlockArgumentNode(this.loadOptionalNode(), startOffset, length);
            }
            case 13: {
                return new Nodes.BlockLocalVariableNode(this.loadFlags(), this.loadConstant(), startOffset, length);
            }
            case 14: {
                return new Nodes.BlockNode(this.loadConstants(), this.loadOptionalNode(), this.loadOptionalNode(), startOffset, length);
            }
            case 15: {
                return new Nodes.BlockParameterNode(this.loadFlags(), this.loadOptionalConstant(), startOffset, length);
            }
            case 16: {
                return new Nodes.BlockParametersNode((Nodes.ParametersNode)this.loadOptionalNode(), this.loadNodes(), startOffset, length);
            }
            case 17: {
                return new Nodes.BreakNode((Nodes.ArgumentsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 18: {
                return new Nodes.CallAndWriteNode(this.loadFlags(), this.loadOptionalNode(), this.loadConstant(), this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 19: {
                return new Nodes.CallNode(this.loadFlags(), this.loadOptionalNode(), this.loadConstant(), (Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadOptionalNode(), startOffset, length);
            }
            case 20: {
                return new Nodes.CallOperatorWriteNode(this.loadFlags(), this.loadOptionalNode(), this.loadConstant(), this.loadConstant(), this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 21: {
                return new Nodes.CallOrWriteNode(this.loadFlags(), this.loadOptionalNode(), this.loadConstant(), this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 22: {
                return new Nodes.CallTargetNode(this.loadFlags(), this.loadNode(), this.loadConstant(), startOffset, length);
            }
            case 23: {
                return new Nodes.CapturePatternNode(this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 24: {
                return new Nodes.CaseMatchNode(this.loadOptionalNode(), this.loadNodes(), (Nodes.ElseNode)this.loadOptionalNode(), startOffset, length);
            }
            case 25: {
                return new Nodes.CaseNode(this.loadOptionalNode(), this.loadNodes(), (Nodes.ElseNode)this.loadOptionalNode(), startOffset, length);
            }
            case 26: {
                return new Nodes.ClassNode(this.loadConstants(), this.loadNode(), this.loadOptionalNode(), this.loadOptionalNode(), this.loadConstant(), startOffset, length);
            }
            case 27: {
                return new Nodes.ClassVariableAndWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 28: {
                return new Nodes.ClassVariableOperatorWriteNode(this.loadConstant(), this.loadNode(), this.loadConstant(), startOffset, length);
            }
            case 29: {
                return new Nodes.ClassVariableOrWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 30: {
                return new Nodes.ClassVariableReadNode(this.loadConstant(), startOffset, length);
            }
            case 31: {
                return new Nodes.ClassVariableTargetNode(this.loadConstant(), startOffset, length);
            }
            case 32: {
                return new Nodes.ClassVariableWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 33: {
                return new Nodes.ConstantAndWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 34: {
                return new Nodes.ConstantOperatorWriteNode(this.loadConstant(), this.loadNode(), this.loadConstant(), startOffset, length);
            }
            case 35: {
                return new Nodes.ConstantOrWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 36: {
                return new Nodes.ConstantPathAndWriteNode((Nodes.ConstantPathNode)this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 37: {
                return new Nodes.ConstantPathNode(this.loadOptionalNode(), this.loadNode(), startOffset, length);
            }
            case 38: {
                return new Nodes.ConstantPathOperatorWriteNode((Nodes.ConstantPathNode)this.loadNode(), this.loadNode(), this.loadConstant(), startOffset, length);
            }
            case 39: {
                return new Nodes.ConstantPathOrWriteNode((Nodes.ConstantPathNode)this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 40: {
                return new Nodes.ConstantPathTargetNode(this.loadOptionalNode(), this.loadNode(), startOffset, length);
            }
            case 41: {
                return new Nodes.ConstantPathWriteNode((Nodes.ConstantPathNode)this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 42: {
                return new Nodes.ConstantReadNode(this.loadConstant(), startOffset, length);
            }
            case 43: {
                return new Nodes.ConstantTargetNode(this.loadConstant(), startOffset, length);
            }
            case 44: {
                return new Nodes.ConstantWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 45: {
                return new Nodes.DefNode(this.buffer.getInt(), this.loadConstant(), this.loadOptionalNode(), (Nodes.ParametersNode)this.loadOptionalNode(), this.loadOptionalNode(), this.loadConstants(), startOffset, length);
            }
            case 46: {
                return new Nodes.DefinedNode(this.loadNode(), startOffset, length);
            }
            case 47: {
                return new Nodes.ElseNode((Nodes.StatementsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 48: {
                return new Nodes.EmbeddedStatementsNode((Nodes.StatementsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 49: {
                return new Nodes.EmbeddedVariableNode(this.loadNode(), startOffset, length);
            }
            case 50: {
                return new Nodes.EnsureNode((Nodes.StatementsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 51: {
                return new Nodes.FalseNode(startOffset, length);
            }
            case 52: {
                return new Nodes.FindPatternNode(this.loadOptionalNode(), this.loadNode(), this.loadNodes(), this.loadNode(), startOffset, length);
            }
            case 53: {
                return new Nodes.FlipFlopNode(this.loadFlags(), this.loadOptionalNode(), this.loadOptionalNode(), startOffset, length);
            }
            case 54: {
                return new Nodes.FloatNode(startOffset, length);
            }
            case 55: {
                return new Nodes.ForNode(this.loadNode(), this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 56: {
                return new Nodes.ForwardingArgumentsNode(startOffset, length);
            }
            case 57: {
                return new Nodes.ForwardingParameterNode(startOffset, length);
            }
            case 58: {
                return new Nodes.ForwardingSuperNode((Nodes.BlockNode)this.loadOptionalNode(), startOffset, length);
            }
            case 59: {
                return new Nodes.GlobalVariableAndWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 60: {
                return new Nodes.GlobalVariableOperatorWriteNode(this.loadConstant(), this.loadNode(), this.loadConstant(), startOffset, length);
            }
            case 61: {
                return new Nodes.GlobalVariableOrWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 62: {
                return new Nodes.GlobalVariableReadNode(this.loadConstant(), startOffset, length);
            }
            case 63: {
                return new Nodes.GlobalVariableTargetNode(this.loadConstant(), startOffset, length);
            }
            case 64: {
                return new Nodes.GlobalVariableWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 65: {
                return new Nodes.HashNode(this.loadNodes(), startOffset, length);
            }
            case 66: {
                return new Nodes.HashPatternNode(this.loadOptionalNode(), this.loadNodes(), this.loadOptionalNode(), startOffset, length);
            }
            case 67: {
                return new Nodes.IfNode(this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), this.loadOptionalNode(), startOffset, length);
            }
            case 68: {
                return new Nodes.ImaginaryNode(this.loadNode(), startOffset, length);
            }
            case 69: {
                return new Nodes.ImplicitNode(this.loadNode(), startOffset, length);
            }
            case 70: {
                return new Nodes.ImplicitRestNode(startOffset, length);
            }
            case 71: {
                return new Nodes.InNode(this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 72: {
                return new Nodes.IndexAndWriteNode(this.loadFlags(), this.loadOptionalNode(), (Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadOptionalNode(), this.loadNode(), startOffset, length);
            }
            case 73: {
                return new Nodes.IndexOperatorWriteNode(this.loadFlags(), this.loadOptionalNode(), (Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadOptionalNode(), this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 74: {
                return new Nodes.IndexOrWriteNode(this.loadFlags(), this.loadOptionalNode(), (Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadOptionalNode(), this.loadNode(), startOffset, length);
            }
            case 75: {
                return new Nodes.IndexTargetNode(this.loadFlags(), this.loadNode(), (Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadOptionalNode(), startOffset, length);
            }
            case 76: {
                return new Nodes.InstanceVariableAndWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 77: {
                return new Nodes.InstanceVariableOperatorWriteNode(this.loadConstant(), this.loadNode(), this.loadConstant(), startOffset, length);
            }
            case 78: {
                return new Nodes.InstanceVariableOrWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 79: {
                return new Nodes.InstanceVariableReadNode(this.loadConstant(), startOffset, length);
            }
            case 80: {
                return new Nodes.InstanceVariableTargetNode(this.loadConstant(), startOffset, length);
            }
            case 81: {
                return new Nodes.InstanceVariableWriteNode(this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 82: {
                return new Nodes.IntegerNode(this.loadFlags(), startOffset, length);
            }
            case 83: {
                return new Nodes.InterpolatedMatchLastLineNode(this.loadFlags(), this.loadNodes(), startOffset, length);
            }
            case 84: {
                return new Nodes.InterpolatedRegularExpressionNode(this.loadFlags(), this.loadNodes(), startOffset, length);
            }
            case 85: {
                return new Nodes.InterpolatedStringNode(this.loadNodes(), startOffset, length);
            }
            case 86: {
                return new Nodes.InterpolatedSymbolNode(this.loadNodes(), startOffset, length);
            }
            case 87: {
                return new Nodes.InterpolatedXStringNode(this.loadNodes(), startOffset, length);
            }
            case 88: {
                return new Nodes.KeywordHashNode(this.loadFlags(), this.loadNodes(), startOffset, length);
            }
            case 89: {
                return new Nodes.KeywordRestParameterNode(this.loadFlags(), this.loadOptionalConstant(), startOffset, length);
            }
            case 90: {
                return new Nodes.LambdaNode(this.loadConstants(), this.loadOptionalNode(), this.loadOptionalNode(), startOffset, length);
            }
            case 91: {
                return new Nodes.LocalVariableAndWriteNode(this.loadNode(), this.loadConstant(), this.loadVarUInt(), startOffset, length);
            }
            case 92: {
                return new Nodes.LocalVariableOperatorWriteNode(this.loadNode(), this.loadConstant(), this.loadConstant(), this.loadVarUInt(), startOffset, length);
            }
            case 93: {
                return new Nodes.LocalVariableOrWriteNode(this.loadNode(), this.loadConstant(), this.loadVarUInt(), startOffset, length);
            }
            case 94: {
                return new Nodes.LocalVariableReadNode(this.loadConstant(), this.loadVarUInt(), startOffset, length);
            }
            case 95: {
                return new Nodes.LocalVariableTargetNode(this.loadConstant(), this.loadVarUInt(), startOffset, length);
            }
            case 96: {
                return new Nodes.LocalVariableWriteNode(this.loadConstant(), this.loadVarUInt(), this.loadNode(), startOffset, length);
            }
            case 97: {
                return new Nodes.MatchLastLineNode(this.loadFlags(), this.loadString(), startOffset, length);
            }
            case 98: {
                return new Nodes.MatchPredicateNode(this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 99: {
                return new Nodes.MatchRequiredNode(this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 100: {
                return new Nodes.MatchWriteNode((Nodes.CallNode)this.loadNode(), this.loadNodes(), startOffset, length);
            }
            case 101: {
                return new Nodes.MissingNode(startOffset, length);
            }
            case 102: {
                return new Nodes.ModuleNode(this.loadConstants(), this.loadNode(), this.loadOptionalNode(), this.loadConstant(), startOffset, length);
            }
            case 103: {
                return new Nodes.MultiTargetNode(this.loadNodes(), this.loadOptionalNode(), this.loadNodes(), startOffset, length);
            }
            case 104: {
                return new Nodes.MultiWriteNode(this.loadNodes(), this.loadOptionalNode(), this.loadNodes(), this.loadNode(), startOffset, length);
            }
            case 105: {
                return new Nodes.NextNode((Nodes.ArgumentsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 106: {
                return new Nodes.NilNode(startOffset, length);
            }
            case 107: {
                return new Nodes.NoKeywordsParameterNode(startOffset, length);
            }
            case 108: {
                return new Nodes.NumberedParametersNode(this.buffer.get(), startOffset, length);
            }
            case 109: {
                return new Nodes.NumberedReferenceReadNode(this.loadVarUInt(), startOffset, length);
            }
            case 110: {
                return new Nodes.OptionalKeywordParameterNode(this.loadFlags(), this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 111: {
                return new Nodes.OptionalParameterNode(this.loadFlags(), this.loadConstant(), this.loadNode(), startOffset, length);
            }
            case 112: {
                return new Nodes.OrNode(this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 113: {
                return new Nodes.ParametersNode(this.loadNodes(), this.loadNodes(), this.loadOptionalNode(), this.loadNodes(), this.loadNodes(), this.loadOptionalNode(), (Nodes.BlockParameterNode)this.loadOptionalNode(), startOffset, length);
            }
            case 114: {
                return new Nodes.ParenthesesNode(this.loadOptionalNode(), startOffset, length);
            }
            case 115: {
                return new Nodes.PinnedExpressionNode(this.loadNode(), startOffset, length);
            }
            case 116: {
                return new Nodes.PinnedVariableNode(this.loadNode(), startOffset, length);
            }
            case 117: {
                return new Nodes.PostExecutionNode((Nodes.StatementsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 118: {
                return new Nodes.PreExecutionNode((Nodes.StatementsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 119: {
                return new Nodes.ProgramNode(this.loadConstants(), (Nodes.StatementsNode)this.loadNode(), startOffset, length);
            }
            case 120: {
                return new Nodes.RangeNode(this.loadFlags(), this.loadOptionalNode(), this.loadOptionalNode(), startOffset, length);
            }
            case 121: {
                return new Nodes.RationalNode(this.loadNode(), startOffset, length);
            }
            case 122: {
                return new Nodes.RedoNode(startOffset, length);
            }
            case 123: {
                return new Nodes.RegularExpressionNode(this.loadFlags(), this.loadString(), startOffset, length);
            }
            case 124: {
                return new Nodes.RequiredKeywordParameterNode(this.loadFlags(), this.loadConstant(), startOffset, length);
            }
            case 125: {
                return new Nodes.RequiredParameterNode(this.loadFlags(), this.loadConstant(), startOffset, length);
            }
            case 126: {
                return new Nodes.RescueModifierNode(this.loadNode(), this.loadNode(), startOffset, length);
            }
            case 127: {
                return new Nodes.RescueNode(this.loadNodes(), this.loadOptionalNode(), (Nodes.StatementsNode)this.loadOptionalNode(), (Nodes.RescueNode)this.loadOptionalNode(), startOffset, length);
            }
            case 128: {
                return new Nodes.RestParameterNode(this.loadFlags(), this.loadOptionalConstant(), startOffset, length);
            }
            case 129: {
                return new Nodes.RetryNode(startOffset, length);
            }
            case 130: {
                return new Nodes.ReturnNode((Nodes.ArgumentsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 131: {
                return new Nodes.SelfNode(startOffset, length);
            }
            case 132: {
                return new Nodes.SingletonClassNode(this.loadConstants(), this.loadNode(), this.loadOptionalNode(), startOffset, length);
            }
            case 133: {
                return new Nodes.SourceEncodingNode(startOffset, length);
            }
            case 134: {
                return new Nodes.SourceFileNode(this.loadString(), startOffset, length);
            }
            case 135: {
                return new Nodes.SourceLineNode(startOffset, length);
            }
            case 136: {
                return new Nodes.SplatNode(this.loadOptionalNode(), startOffset, length);
            }
            case 137: {
                return new Nodes.StatementsNode(this.loadNodes(), startOffset, length);
            }
            case 138: {
                return new Nodes.StringNode(this.loadFlags(), this.loadString(), startOffset, length);
            }
            case 139: {
                return new Nodes.SuperNode((Nodes.ArgumentsNode)this.loadOptionalNode(), this.loadOptionalNode(), startOffset, length);
            }
            case 140: {
                return new Nodes.SymbolNode(this.loadFlags(), this.loadString(), startOffset, length);
            }
            case 141: {
                return new Nodes.TrueNode(startOffset, length);
            }
            case 142: {
                return new Nodes.UndefNode(this.loadNodes(), startOffset, length);
            }
            case 143: {
                return new Nodes.UnlessNode(this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), (Nodes.ElseNode)this.loadOptionalNode(), startOffset, length);
            }
            case 144: {
                return new Nodes.UntilNode(this.loadFlags(), this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 145: {
                return new Nodes.WhenNode(this.loadNodes(), (Nodes.StatementsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 146: {
                return new Nodes.WhileNode(this.loadFlags(), this.loadNode(), (Nodes.StatementsNode)this.loadOptionalNode(), startOffset, length);
            }
            case 147: {
                return new Nodes.XStringNode(this.loadFlags(), this.loadString(), startOffset, length);
            }
            case 148: {
                return new Nodes.YieldNode((Nodes.ArgumentsNode)this.loadOptionalNode(), startOffset, length);
            }
        }
        throw new Error("Unknown node type: " + type);
    }

    private void expect(byte value, String error) {
        byte b = this.buffer.get();
        if (b != value) {
            throw new Error("Deserialization error: " + error + " (expected " + value + " but was " + b + " at position " + this.buffer.position() + ")");
        }
    }

    private static final class ConstantPool {
        private final Loader loader;
        private final byte[] source;
        private final int bufferOffset;
        private final RubySymbol[] cache;

        ConstantPool(Loader loader, byte[] source, int bufferOffset, int length) {
            this.loader = loader;
            this.source = source;
            this.bufferOffset = bufferOffset;
            this.cache = new RubySymbol[length];
        }

        RubySymbol get(ByteBuffer buffer, int oneBasedIndex) {
            int index = oneBasedIndex - 1;
            RubySymbol constant = this.cache[index];
            if (constant == null) {
                int offset = this.bufferOffset + index * 8;
                int start = buffer.getInt(offset);
                int length = buffer.getInt(offset + 4);
                byte[] bytes = new byte[length];
                if (Integer.compareUnsigned(start, Integer.MAX_VALUE) <= 0) {
                    System.arraycopy(this.source, start, bytes, 0, length);
                } else {
                    int position = buffer.position();
                    buffer.position(start & Integer.MAX_VALUE);
                    buffer.get(bytes, 0, length);
                    buffer.position(position);
                }
                this.cache[index] = constant = this.loader.bytesToName(bytes);
            }
            return constant;
        }
    }
}

