/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.Option;
import org.joni.ast.Node;
import org.joni.ast.StateNode;
import org.joni.constants.EncloseType;

public final class EncloseNode
extends StateNode
implements EncloseType {
    public int type;
    public int regNum;
    public int option;
    public Node target;
    public int callAddr;
    public int minLength;
    public int maxLength;
    public int charLength;
    public int optCount;
    public Node containingAnchor;

    public EncloseNode(int type2) {
        this.type = type2;
        this.callAddr = -1;
    }

    public EncloseNode(int option, boolean isNamed) {
        this(1);
        if (isNamed) {
            this.setNamedGroup();
        }
        this.option = option;
    }

    public EncloseNode(int option, int _) {
        this(2);
        this.option = option;
    }

    public int getType() {
        return 6;
    }

    protected void setChild(Node newChild) {
        this.target = newChild;
    }

    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node tgt) {
        this.target = tgt;
        tgt.parent = this;
    }

    public String getName() {
        return "Enclose";
    }

    public String toString(int level2) {
        StringBuilder value2 = new StringBuilder(super.toString(level2));
        value2.append("\n  type: " + this.typeToString());
        value2.append("\n  regNum: " + this.regNum);
        value2.append("\n  option: " + Option.toString(this.option));
        value2.append("\n  target: " + EncloseNode.pad(this.target, level2 + 1));
        value2.append("\n  callAddr: " + this.callAddr);
        value2.append("\n  minLength: " + this.minLength);
        value2.append("\n  maxLength: " + this.maxLength);
        value2.append("\n  charLength: " + this.charLength);
        value2.append("\n  optCount: " + this.optCount);
        return value2.toString();
    }

    public String typeToString() {
        StringBuilder types = new StringBuilder();
        if (this.isStopBacktrack()) {
            types.append("STOP_BACKTRACK ");
        }
        if (this.isMemory()) {
            types.append("MEMORY ");
        }
        if (this.isOption()) {
            types.append("OPTION ");
        }
        return types.toString();
    }

    public void setEncloseStatus(int flag) {
        this.state |= flag;
    }

    public void clearEncloseStatus(int flag) {
        this.state &= ~flag;
    }

    public void clearMemory() {
        this.type &= 0xFFFFFFFE;
    }

    public void setMemory() {
        this.type |= 1;
    }

    public boolean isMemory() {
        return (this.type & 1) != 0;
    }

    public void clearOption() {
        this.type &= 0xFFFFFFFD;
    }

    public void setOption() {
        this.type |= 2;
    }

    public boolean isOption() {
        return (this.type & 2) != 0;
    }

    public void clearStopBacktrack() {
        this.type &= 0xFFFFFFFB;
    }

    public void setStopBacktrack() {
        this.type |= 4;
    }

    public boolean isStopBacktrack() {
        return (this.type & 4) != 0;
    }
}

