/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.posix.POSIX;
import jnr.posix.Timeval;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.tz.FixedDateTimeZone;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.TypeError;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.RubyDateFormatter;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Time"}, include={"Comparable"})
public class RubyTime
extends RubyObject {
    public static final String UTC = "UTC";
    private static final BigDecimal ONE_MILLION_BD = BigDecimal.valueOf(1000000L);
    private static final BigDecimal ONE_BILLION_BD = BigDecimal.valueOf(1000000000L);
    public static final int TIME_SCALE = 1000000000;
    private DateTime dt;
    private long nsec;
    private static final DateTimeFormatter ONE_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM  d HH:mm:ss yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TWO_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss Z").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_UTC_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss 'UTC'").withLocale(Locale.ENGLISH);
    private static final Pattern TZ_PATTERN = Pattern.compile("([^-\\+\\d]+)?([\\+-]?)(\\d+)(?::(\\d+))?(?::(\\d+))?");
    private static final Pattern TIME_OFFSET_PATTERN = Pattern.compile("([\\+-])(\\d\\d):(\\d\\d)(?::(\\d\\d))?");
    private static final ByteList TZ_STRING = ByteList.create("TZ");
    private boolean isTzRelative = false;
    private static final ObjectAllocator TIME_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyTime(runtime2, klass);
        }
    };
    private static final DateTime TIME0 = new DateTime(0L, DateTimeZone.UTC);
    private static final int ARG_SIZE = 7;

    private void setIsTzRelative(boolean tzRelative) {
        this.isTzRelative = tzRelative;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.TIME;
    }

    public static String getEnvTimeZone(Ruby runtime2) {
        RubyString tz = runtime2.tzVar;
        if (tz == null) {
            tz = runtime2.newString(TZ_STRING);
            tz.setFrozen(true);
            runtime2.tzVar = tz;
        }
        RubyHash.RubyHashEntry entry = runtime2.getENV().getEntry(tz);
        if (entry.key == null || entry.key == NEVER) {
            return null;
        }
        if (entry.key != tz) {
            runtime2.tzVar = (RubyString)entry.key;
        }
        return entry.value instanceof RubyString ? ((RubyString)entry.value).asJavaString() : null;
    }

    public static DateTimeZone getLocalTimeZone(Ruby runtime2) {
        String tz = RubyTime.getEnvTimeZone(runtime2);
        return tz == null ? DateTimeZone.getDefault() : RubyTime.getTimeZoneFromTZString(runtime2, tz);
    }

    public static DateTimeZone getTimeZoneFromTZString(Ruby runtime2, String zone2) {
        DateTimeZone cachedZone = runtime2.getTimezoneCache().get(zone2);
        if (cachedZone != null) {
            return cachedZone;
        }
        DateTimeZone dtz = RubyTime.parseTZString(runtime2, zone2);
        runtime2.getTimezoneCache().put(zone2, dtz);
        return dtz;
    }

    private static DateTimeZone parseTZString(Ruby runtime2, String zone2) {
        Matcher tzMatcher = TZ_PATTERN.matcher(zone2);
        if (tzMatcher.matches()) {
            String zoneName = tzMatcher.group(1);
            String sign2 = tzMatcher.group(2);
            String hours = tzMatcher.group(3);
            String minutes = tzMatcher.group(4);
            String seconds = tzMatcher.group(5);
            if (zoneName == null) {
                zoneName = "";
            }
            return RubyTime.getTimeZoneFromHHMM(runtime2, zoneName, sign2.equals("-"), hours, minutes, seconds);
        }
        if (zone2.length() == 3) {
            switch (zone2.toUpperCase()) {
                case "MET": {
                    zone2 = "CET";
                    break;
                }
                case "ROC": {
                    zone2 = "Asia/Taipei";
                    break;
                }
                case "WET": {
                    zone2 = "Europe/Lisbon";
                    break;
                }
                case "UTC": {
                    zone2 = "Etc/UTC";
                    break;
                }
                case "GMT": {
                    zone2 = "Etc/GMT";
                }
            }
        }
        try {
            return DateTimeZone.forID((String)zone2);
        }
        catch (IllegalArgumentException e) {
            runtime2.getWarnings().warning("Unrecognized time zone: " + zone2);
            return DateTimeZone.UTC;
        }
    }

    public static DateTimeZone getTimeZoneFromString(Ruby runtime2, String zone2) {
        DateTimeZone cachedZone = runtime2.getTimezoneCache().get(zone2);
        if (cachedZone != null) {
            return cachedZone;
        }
        DateTimeZone dtz = RubyTime.parseZoneString(runtime2, zone2);
        runtime2.getTimezoneCache().put(zone2, dtz);
        return dtz;
    }

    private static DateTimeZone parseZoneString(Ruby runtime2, String zone2) {
        return RubyTime.parseTZString(runtime2, zone2);
    }

    public static DateTimeZone getTimeZoneFromUtcOffset(ThreadContext context, IRubyObject utcOffset) {
        DateTimeZone dtz;
        Ruby runtime2 = context.runtime;
        String strOffset = utcOffset.toString();
        DateTimeZone cachedZone = runtime2.getTimezoneCache().get(strOffset);
        if (cachedZone != null) {
            return cachedZone;
        }
        if (utcOffset instanceof RubyString) {
            Matcher offsetMatcher = TIME_OFFSET_PATTERN.matcher(strOffset);
            if (!offsetMatcher.matches()) {
                throw runtime2.newArgumentError("\"+HH:MM\" or \"-HH:MM\" expected for utc_offset");
            }
            String sign2 = offsetMatcher.group(1);
            String hours = offsetMatcher.group(2);
            String minutes = offsetMatcher.group(3);
            String seconds = offsetMatcher.group(4);
            dtz = RubyTime.getTimeZoneFromHHMM(runtime2, "", !sign2.equals("-"), hours, minutes, seconds);
        } else {
            RubyNumeric numericOffset = RubyTime.numExact(context, utcOffset);
            int newOffset = (int)Math.round(numericOffset.convertToFloat().value * 1000.0);
            dtz = RubyTime.getTimeZoneWithOffset(runtime2, "", newOffset);
        }
        runtime2.getTimezoneCache().put(strOffset, dtz);
        return dtz;
    }

    private static RubyNumeric numExact(ThreadContext context, IRubyObject v) {
        boolean typeError = false;
        switch (v.getMetaClass().getClassIndex()) {
            case NIL: {
                throw context.runtime.newTypeError("can't convert nil into an exact number");
            }
            case INTEGER: {
                return (RubyInteger)v;
            }
            case RATIONAL: {
                break;
            }
            case STRING: {
                typeError = true;
                break;
            }
            default: {
                IRubyObject tmp = v.getMetaClass().finvokeChecked(context, v, RubyTime.sites((ThreadContext)context).checked_to_r);
                if (tmp != null) {
                    if (!RubyTime.sites((ThreadContext)context).respond_to_to_int.respondsTo(context, v, v)) {
                        typeError = true;
                        break;
                    }
                    v = tmp;
                    break;
                }
                tmp = TypeConverter.checkIntegerType(context, v);
                if (!tmp.isNil()) {
                    v = tmp;
                    break;
                }
                typeError = true;
            }
        }
        switch (v.getMetaClass().getClassIndex()) {
            case INTEGER: {
                return (RubyInteger)v;
            }
            case RATIONAL: {
                if (!((RubyRational)v).getDenominator().isOne()) break;
                return ((RubyRational)v).getNumerator();
            }
            default: {
                typeError = true;
            }
        }
        if (typeError) {
            Ruby runtime2 = context.runtime;
            throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, "can't convert ", RubyStringBuilder.types(runtime2, v.getMetaClass()), " into an exact number"));
        }
        return (RubyNumeric)v;
    }

    private static DateTimeZone getTimeZoneFromHHMM(Ruby runtime2, String name2, boolean positive, String hours, String minutes, String seconds) {
        int h = Integer.parseInt(hours);
        int m = 0;
        int s2 = 0;
        if (minutes != null) {
            m = Integer.parseInt(minutes);
        }
        if (seconds != null) {
            s2 = Integer.parseInt(seconds);
        }
        if (h > 23 || m > 59) {
            throw runtime2.newArgumentError("utc_offset out of range");
        }
        int offset2 = (positive ? 1 : -1) * (h * 3600 + m * 60 + s2) * 1000;
        return RubyTime.timeZoneWithOffset(name2, offset2);
    }

    public static DateTimeZone getTimeZone(Ruby runtime2, long seconds) {
        if (seconds >= 86400L || seconds <= -86400L) {
            throw runtime2.newArgumentError("utc_offset out of range");
        }
        return RubyTime.getTimeZoneWithOffset(runtime2, "", (int)(seconds * 1000L));
    }

    public static DateTimeZone getTimeZoneWithOffset(Ruby runtime2, String zoneName, int offset2) {
        zoneName = zoneName.trim();
        String zone2 = zoneName + offset2;
        DateTimeZone cachedZone = runtime2.getTimezoneCache().get(zone2);
        if (cachedZone != null) {
            return cachedZone;
        }
        DateTimeZone dtz = RubyTime.timeZoneWithOffset(zoneName, offset2);
        runtime2.getTimezoneCache().put(zone2, dtz);
        return dtz;
    }

    private static DateTimeZone timeZoneWithOffset(String zoneName, int offset2) {
        if (zoneName.isEmpty()) {
            return DateTimeZone.forOffsetMillis((int)offset2);
        }
        return new FixedDateTimeZone(zoneName, null, offset2, offset2);
    }

    public RubyTime(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public RubyTime(Ruby runtime2, RubyClass rubyClass, DateTime dt) {
        super(runtime2, rubyClass);
        this.dt = dt;
    }

    public RubyTime(Ruby runtime2, RubyClass rubyClass, DateTime dt, boolean tzRelative) {
        super(runtime2, rubyClass);
        this.dt = dt;
        this.setIsTzRelative(tzRelative);
    }

    public static RubyClass createTimeClass(Ruby runtime2) {
        RubyClass timeClass = runtime2.defineClass("Time", runtime2.getObject(), TIME_ALLOCATOR);
        timeClass.setClassIndex(ClassIndex.TIME);
        timeClass.setReifiedClass(RubyTime.class);
        runtime2.setTime(timeClass);
        timeClass.includeModule(runtime2.getComparable());
        timeClass.defineAnnotatedMethods(RubyTime.class);
        return timeClass;
    }

    public void setNSec(long nsec2) {
        this.nsec = nsec2;
    }

    public long getNSec() {
        return this.nsec;
    }

    public void setUSec(long usec2) {
        this.nsec = 1000L * usec2;
    }

    public long getUSec() {
        return this.nsec / 1000L;
    }

    @Deprecated
    public void updateCal(DateTime dt) {
        this.dt = dt;
    }

    public static RubyTime newTime(Ruby runtime2, long milliseconds) {
        return RubyTime.newTime(runtime2, new DateTime(milliseconds));
    }

    public static RubyTime newTimeFromNanoseconds(Ruby runtime2, long nanoseconds) {
        long milliseconds = nanoseconds / 1000000L;
        long extraNanoseconds = nanoseconds % 1000000L;
        return RubyTime.newTime(runtime2, new DateTime(milliseconds), extraNanoseconds);
    }

    public static RubyTime newTime(Ruby runtime2, DateTime dt) {
        return new RubyTime(runtime2, runtime2.getTime(), dt);
    }

    public static RubyTime newTime(Ruby runtime2, DateTime dt, long nsec2) {
        RubyTime t = new RubyTime(runtime2, runtime2.getTime(), dt);
        t.setNSec(nsec2);
        return t;
    }

    @Override
    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (!(original instanceof RubyTime)) {
            throw this.getRuntime().newTypeError("Expecting an instance of class Time");
        }
        RubyTime originalTime = (RubyTime)original;
        this.dt = originalTime.dt;
        this.nsec = originalTime.nsec;
        this.isTzRelative = originalTime.isTzRelative;
        return this;
    }

    @JRubyMethod
    public RubyTime succ() {
        RubyTime time = RubyTime.newTime(this.getRuntime(), this.dt.plusSeconds(1));
        time.setIsTzRelative(this.isTzRelative);
        return time;
    }

    @JRubyMethod(name={"gmtime", "utc"})
    public RubyTime gmtime() {
        return this.adjustTimeZone(this.getRuntime(), DateTimeZone.UTC, false);
    }

    public final RubyTime localtime() {
        return this.localtime(this.metaClass.runtime.getCurrentContext());
    }

    @JRubyMethod(name={"localtime"})
    public RubyTime localtime(ThreadContext context) {
        return this.adjustTimeZone(context.runtime, RubyTime.getLocalTimeZone(context.runtime), false);
    }

    @JRubyMethod(name={"localtime"})
    public RubyTime localtime(ThreadContext context, IRubyObject arg2) {
        DateTimeZone zone2 = RubyTime.getTimeZoneFromUtcOffset(context, arg2);
        return this.adjustTimeZone(context.runtime, zone2, true);
    }

    private RubyTime adjustTimeZone(Ruby runtime2, DateTimeZone zone2, boolean isTzRelative) {
        boolean zoneOk = zone2.equals((Object)this.dt.getZone());
        if (zoneOk && isTzRelative == this.isTzRelative) {
            return this;
        }
        if (this.isFrozen()) {
            throw runtime2.newFrozenError("Time", true);
        }
        if (!zoneOk) {
            this.dt = this.dt.withZone(zone2);
        }
        this.setIsTzRelative(isTzRelative);
        return this;
    }

    @Deprecated
    public final RubyTime localtime19(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.localtime(context);
            }
            case 1: {
                return this.localtime(context, args2[0]);
            }
        }
        throw new AssertionError((Object)Arrays.toString(args2));
    }

    @JRubyMethod(name={"gmt?", "utc?", "gmtime?"})
    public RubyBoolean gmt() {
        return this.metaClass.runtime.newBoolean(this.isUTC());
    }

    public boolean isUTC() {
        return !this.isTzRelative && this.dt.getZone().getID().equals(UTC);
    }

    @JRubyMethod(name={"getgm", "getutc"})
    public RubyTime getgm() {
        return RubyTime.newTime(this.metaClass.runtime, this.dt.withZone(DateTimeZone.UTC), this.nsec);
    }

    public final RubyTime getlocal() {
        return this.getlocal(this.metaClass.runtime.getCurrentContext());
    }

    @JRubyMethod(name={"getlocal"})
    public RubyTime getlocal(ThreadContext context) {
        return RubyTime.newTime(context.runtime, this.dt.withZone(RubyTime.getLocalTimeZone(context.runtime)), this.nsec);
    }

    @JRubyMethod(name={"getlocal"})
    public RubyTime getlocal(ThreadContext context, IRubyObject arg2) {
        if (arg2 == context.nil) {
            return RubyTime.newTime(context.runtime, this.dt.withZone(RubyTime.getLocalTimeZone(context.runtime)), this.nsec);
        }
        DateTimeZone dtz = RubyTime.getTimeZoneFromUtcOffset(context, arg2);
        RubyTime time = RubyTime.newTime(context.runtime, this.dt.withZone(dtz), this.nsec);
        time.setIsTzRelative(true);
        return time;
    }

    @Deprecated
    public RubyTime getlocal19(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.getlocal(context);
            }
            case 1: {
                return this.getlocal(context, args2[0]);
            }
        }
        throw new AssertionError((Object)Arrays.toString(args2));
    }

    @Deprecated
    public RubyString strftime(IRubyObject format) {
        return this.strftime(this.getRuntime().getCurrentContext(), format);
    }

    @JRubyMethod(required=1)
    public RubyString strftime(ThreadContext context, IRubyObject format) {
        RubyDateFormatter rdf = context.getRubyDateFormatter();
        return rdf.compileAndFormat(format.convertToString(), false, this.dt, this.nsec, null);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return context.runtime.newBoolean(this.cmp((RubyTime)other) == 0);
        }
        if (other == context.nil) {
            return context.fals;
        }
        return RubyComparable.op_equal(context, this, other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return context.runtime.newBoolean(this.cmp((RubyTime)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return context.runtime.newBoolean(this.cmp((RubyTime)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return context.runtime.newBoolean(this.cmp((RubyTime)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return context.runtime.newBoolean(this.cmp((RubyTime)other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    private int cmp(RubyTime other) {
        long millis = this.getTimeInMillis();
        long millis_other = other.getTimeInMillis();
        long nsec2 = this.nsec;
        long nsec_other = other.nsec;
        if (millis > millis_other || millis == millis_other && nsec2 > nsec_other) {
            return 1;
        }
        if (millis < millis_other || millis == millis_other && nsec2 < nsec_other) {
            return -1;
        }
        return 0;
    }

    public IRubyObject op_plus(IRubyObject other) {
        return this.op_plus(this.getRuntime().getCurrentContext(), other);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            throw context.runtime.newTypeError("time + time?");
        }
        double adjustMillis = RubyNumeric.num2dbl(context, RubyTime.numExact(context, other)) * 1000.0;
        return this.opPlusMillis(context.runtime, adjustMillis);
    }

    @Deprecated
    public IRubyObject op_plus19(ThreadContext context, IRubyObject other) {
        return this.op_plus(context, other);
    }

    private RubyTime opPlusMillis(Ruby runtime2, double adjustMillis) {
        long currentMillis = this.getTimeInMillis();
        long newMillisPart = currentMillis + (long)adjustMillis;
        long adjustNanos = (long)((adjustMillis - Math.floor(adjustMillis)) * 1000000.0);
        long newNanosPart = this.nsec + adjustNanos;
        if (newNanosPart >= 1000000L) {
            newNanosPart -= 1000000L;
            ++newMillisPart;
        }
        RubyTime newTime = new RubyTime(runtime2, this.getMetaClass());
        newTime.dt = new DateTime(newMillisPart, this.dt.getZone());
        newTime.setNSec(newNanosPart);
        newTime.setIsTzRelative(this.isTzRelative);
        return newTime;
    }

    private RubyFloat opMinus(Ruby runtime2, RubyTime other) {
        long timeInMillis = this.getTimeInMillis() - other.getTimeInMillis();
        double timeInSeconds = (double)timeInMillis / 1000.0 + (double)(this.getNSec() - other.getNSec()) / 1.0E9;
        return RubyFloat.newFloat(runtime2, timeInSeconds);
    }

    public IRubyObject op_minus(IRubyObject other) {
        return this.op_minus(this.getRuntime().getCurrentContext(), other);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.opMinus(context.runtime, (RubyTime)other);
        }
        return this.opMinus(context.runtime, RubyNumeric.num2dbl(context, RubyTime.numExact(context, other)));
    }

    @Deprecated
    public IRubyObject op_minus19(ThreadContext context, IRubyObject other) {
        return this.op_minus(context, other);
    }

    private RubyTime opMinus(Ruby runtime2, double other) {
        long nano;
        long adjustmentInNanos = (long)(other * 1.0E9);
        long adjustmentInMillis = adjustmentInNanos / 1000000L;
        long adjustmentInNanosLeft = adjustmentInNanos % 1000000L;
        long time = this.getTimeInMillis() - adjustmentInMillis;
        if (this.nsec < adjustmentInNanosLeft) {
            --time;
            nano = 1000000L - (adjustmentInNanosLeft - this.nsec);
        } else {
            nano = this.nsec - adjustmentInNanosLeft;
        }
        RubyTime newTime = new RubyTime(runtime2, this.getMetaClass());
        newTime.dt = new DateTime(time, this.dt.getZone());
        newTime.setNSec(nano);
        newTime.setIsTzRelative(this.isTzRelative);
        return newTime;
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return context.runtime.newBoolean(RubyNumeric.fix2int(Helpers.invokedynamic(context, (IRubyObject)this, MethodNames.OP_CMP, other)) == 0);
        }
        return context.fals;
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return context.runtime.newFixnum(this.cmp((RubyTime)other));
        }
        return RubyComparable.invcmp(context, RubyTime.sites((ThreadContext)context).recursive_cmp, this, other);
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyTime) {
            RubyTime otherTime = (RubyTime)other;
            return this.nsec == otherTime.nsec && this.getTimeInMillis() == otherTime.getTimeInMillis() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"asctime", "ctime"})
    public RubyString asctime() {
        DateTimeFormatter simpleDateFormat = this.dt.getDayOfMonth() < 10 ? ONE_DAY_CTIME_FORMATTER : TWO_DAY_CTIME_FORMATTER;
        String result2 = simpleDateFormat.print((ReadableInstant)this.dt);
        return RubyString.newString(this.getRuntime(), result2, (Encoding)USASCIIEncoding.INSTANCE);
    }

    @Override
    @JRubyMethod(name={"to_s", "inspect"})
    public IRubyObject to_s() {
        String str = this.inspectCommon(TO_S_FORMATTER, TO_S_UTC_FORMATTER);
        return RubyString.newString(this.getRuntime(), str, (Encoding)USASCIIEncoding.INSTANCE);
    }

    public final IRubyObject to_s19() {
        return this.to_s();
    }

    private String inspectCommon(DateTimeFormatter formatter, DateTimeFormatter utcFormatter) {
        DateTimeFormatter simpleDateFormat = this.dt.getZone() == DateTimeZone.UTC && !this.isTzRelative ? utcFormatter : formatter;
        if (this.isTzRelative) {
            DateTimeZone dtz = this.dt.getZone();
            int offset2 = dtz.toTimeZone().getOffset(this.dt.getMillis());
            DateTimeZone invertedDTZ = DateTimeZone.forOffsetMillis((int)offset2);
            DateTime invertedDT = this.dt.withZone(invertedDTZ);
            return simpleDateFormat.print((ReadableInstant)invertedDT);
        }
        return simpleDateFormat.print((ReadableInstant)this.dt);
    }

    @Override
    public String toString() {
        return this.inspectCommon(TO_S_FORMATTER, TO_S_UTC_FORMATTER);
    }

    @Override
    @JRubyMethod
    public RubyArray to_a() {
        return RubyArray.newArrayNoCopy(this.getRuntime(), this.sec(), this.min(), this.hour(), this.mday(), this.month(), this.year(), this.wday(), this.yday(), this.isdst(), this.zone());
    }

    @JRubyMethod
    public RubyFloat to_f() {
        long millis = this.getTimeInMillis();
        long nanos = this.nsec;
        double secs = 0.0;
        if (millis != 0L) {
            secs += (double)millis / 1000.0;
        }
        if (nanos != 0L) {
            secs += (double)nanos / 1.0E9;
        }
        return RubyFloat.newFloat(this.getRuntime(), secs);
    }

    @JRubyMethod(name={"to_i", "tv_sec"})
    public RubyInteger to_i() {
        return this.getRuntime().newFixnum(this.getTimeInMillis() / 1000L);
    }

    @JRubyMethod(name={"nsec", "tv_nsec"})
    public RubyInteger nsec() {
        return this.getRuntime().newFixnum(this.getNanos());
    }

    @JRubyMethod
    public IRubyObject to_r(ThreadContext context) {
        return RubyRational.newRationalCanonicalize(context, this.getTimeInMillis() * 1000000L + this.nsec, 1000000000L);
    }

    @JRubyMethod(name={"usec", "tv_usec"})
    public RubyInteger usec() {
        return this.getRuntime().newFixnum((long)(this.dt.getMillisOfSecond() * 1000) + this.getUSec());
    }

    public long getTimeInMicros() {
        return this.getTimeInMillis() * 1000L + this.getUSec();
    }

    public int getMicros() {
        return (int)(this.getTimeInMillis() % 1000L) * 1000 + (int)this.getUSec();
    }

    public void setMicros(int micros) {
        long millis = this.getTimeInMillis();
        millis = millis - millis % 1000L + (long)(micros / 1000);
        this.dt = this.dt.withMillis(millis);
        this.nsec = micros % 1000 * 1000;
    }

    public void setMicroseconds(long micros) {
        this.setMicros((int)micros);
    }

    public long microseconds() {
        return this.getMicros();
    }

    public int getNanos() {
        return (int)((long)this.dt.getMillisOfSecond() * 1000000L + this.getNSec());
    }

    public void setNanos(int nanos) {
        long millis = this.getTimeInMillis();
        millis = millis - millis % 1000L + (long)(nanos / 1000000);
        this.dt = this.dt.withMillis(millis);
        this.nsec = nanos % 1000000;
    }

    @JRubyMethod
    public RubyInteger sec() {
        return this.getRuntime().newFixnum(this.dt.getSecondOfMinute());
    }

    @JRubyMethod
    public RubyInteger min() {
        return this.getRuntime().newFixnum(this.dt.getMinuteOfHour());
    }

    @JRubyMethod
    public RubyInteger hour() {
        return this.getRuntime().newFixnum(this.dt.getHourOfDay());
    }

    @JRubyMethod(name={"mday", "day"})
    public RubyInteger mday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfMonth());
    }

    @JRubyMethod(name={"month", "mon"})
    public RubyInteger month() {
        return this.getRuntime().newFixnum(this.dt.getMonthOfYear());
    }

    @JRubyMethod
    public RubyInteger year() {
        return this.getRuntime().newFixnum(this.dt.getYear());
    }

    @JRubyMethod
    public RubyInteger wday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfWeek() % 7);
    }

    @JRubyMethod
    public RubyInteger yday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfYear());
    }

    @JRubyMethod(name={"sunday?"})
    public RubyBoolean sunday_p(ThreadContext context) {
        return context.runtime.newBoolean(this.dt.getDayOfWeek() % 7 == 0);
    }

    @JRubyMethod(name={"monday?"})
    public RubyBoolean monday_p(ThreadContext context) {
        return context.runtime.newBoolean(this.dt.getDayOfWeek() % 7 == 1);
    }

    @JRubyMethod(name={"tuesday?"})
    public RubyBoolean tuesday_p(ThreadContext context) {
        return context.runtime.newBoolean(this.dt.getDayOfWeek() % 7 == 2);
    }

    @JRubyMethod(name={"wednesday?"})
    public RubyBoolean wednesday_p(ThreadContext context) {
        return context.runtime.newBoolean(this.dt.getDayOfWeek() % 7 == 3);
    }

    @JRubyMethod(name={"thursday?"})
    public RubyBoolean thursday_p(ThreadContext context) {
        return context.runtime.newBoolean(this.dt.getDayOfWeek() % 7 == 4);
    }

    @JRubyMethod(name={"friday?"})
    public RubyBoolean friday_p(ThreadContext context) {
        return context.runtime.newBoolean(this.dt.getDayOfWeek() % 7 == 5);
    }

    @JRubyMethod(name={"saturday?"})
    public RubyBoolean saturday_p(ThreadContext context) {
        return context.runtime.newBoolean(this.dt.getDayOfWeek() % 7 == 6);
    }

    @Deprecated
    public IRubyObject subsec() {
        return this.subsec(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public RubyNumeric subsec(ThreadContext context) {
        long nanosec = (long)(this.dt.getMillisOfSecond() * 1000000) + this.nsec;
        RubyNumeric subsec2 = (RubyNumeric)RubyRational.newRationalCanonicalize(context, nanosec, 1000000000L);
        return subsec2.isZero() ? RubyFixnum.zero(context.runtime) : subsec2;
    }

    @JRubyMethod(name={"gmt_offset", "gmtoff", "utc_offset"})
    public RubyInteger gmt_offset() {
        int offset2 = this.dt.getZone().getOffset(this.dt.getMillis());
        return this.getRuntime().newFixnum(offset2 / 1000);
    }

    @JRubyMethod(name={"isdst", "dst?"})
    public RubyBoolean isdst() {
        return this.getRuntime().newBoolean(!this.dt.getZone().isStandardOffset(this.dt.getMillis()));
    }

    @JRubyMethod
    public IRubyObject zone() {
        if (this.isTzRelative) {
            return this.getRuntime().getNil();
        }
        String zoneName = this.getZoneName();
        if ("".equals(zoneName)) {
            return this.getRuntime().getNil();
        }
        RubyString zone2 = this.getRuntime().newString(zoneName);
        if (zone2.isAsciiOnly()) {
            zone2.setEncoding((Encoding)USASCIIEncoding.INSTANCE);
        }
        return zone2;
    }

    public String getZoneName() {
        return RubyTime.getRubyTimeZoneName(this.getRuntime(), this.dt);
    }

    public static String getRubyTimeZoneName(Ruby runtime2, DateTime dt) {
        String tz = RubyTime.getEnvTimeZone(runtime2);
        return RubyTime.getRubyTimeZoneName(tz == null ? "" : tz, dt);
    }

    public static String getRubyTimeZoneName(String envTZ, DateTime dt) {
        switch (envTZ) {
            case "Etc/UCT": 
            case "UCT": {
                return "UCT";
            }
            case "MET": {
                return RubyTime.inDaylighTime(dt) ? "MEST" : "MET";
            }
        }
        String zone2 = dt.getZone().getShortName(dt.getMillis());
        Matcher offsetMatcher = TIME_OFFSET_PATTERN.matcher(zone2);
        if (offsetMatcher.matches()) {
            if (zone2.equals("+00:00")) {
                zone2 = UTC;
            } else {
                zone2 = dt.getZone().getNameKey(dt.getMillis());
                if (zone2 == null) {
                    zone2 = "";
                }
            }
        }
        return zone2;
    }

    private static boolean inDaylighTime(DateTime dt) {
        return dt.getZone().toTimeZone().inDaylightTime(dt.toDate());
    }

    public void setDateTime(DateTime dt) {
        this.dt = dt;
    }

    public DateTime getDateTime() {
        return this.dt;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.hashCode());
    }

    @Override
    public int hashCode() {
        return (int)((this.dt.getMillis() / 1000L ^ (long)this.getMicros()) << 1) >> 1;
    }

    @JRubyMethod(name={"_dump"})
    public RubyString dump(ThreadContext context) {
        RubyString str = this.mdump(context.runtime);
        str.syncVariables(this);
        return str;
    }

    @JRubyMethod(name={"_dump"})
    public RubyString dump(ThreadContext context, IRubyObject arg2) {
        return this.dump(context);
    }

    @Deprecated
    public RubyString dump(IRubyObject[] args2, Block unusedBlock) {
        RubyString str = (RubyString)this.mdump();
        str.syncVariables(this);
        return str;
    }

    @Deprecated
    public RubyObject mdump() {
        return this.mdump(this.getRuntime());
    }

    private RubyString mdump(Ruby runtime2) {
        int i2;
        DateTime dateTime = this.dt.toDateTime(DateTimeZone.UTC);
        byte[] dumpValue = new byte[8];
        long usec2 = this.nsec / 1000L;
        long nanosec = this.nsec % 1000L;
        int pe = Integer.MIN_VALUE | (this.isUTC() ? 1 : 0) << 30 | dateTime.getYear() - 1900 << 14 | dateTime.getMonthOfYear() - 1 << 10 | dateTime.getDayOfMonth() << 5 | dateTime.getHourOfDay();
        int se = dateTime.getMinuteOfHour() << 26 | dateTime.getSecondOfMinute() << 20 | dateTime.getMillisOfSecond() * 1000 + (int)usec2;
        for (i2 = 0; i2 < 4; ++i2) {
            dumpValue[i2] = (byte)(pe & 0xFF);
            pe >>>= 8;
        }
        for (i2 = 4; i2 < 8; ++i2) {
            dumpValue[i2] = (byte)(se & 0xFF);
            se >>>= 8;
        }
        RubyString string2 = RubyString.newString(runtime2, new ByteList(dumpValue, false));
        this.copyInstanceVariablesInto(string2);
        if (nanosec != 0L) {
            string2.setInternalVariable("nano_num", runtime2.newFixnum(nanosec));
            string2.setInternalVariable("nano_den", runtime2.newFixnum(1));
        }
        byte[] submicro = new byte[2];
        int len = 2;
        submicro[1] = (byte)(nanosec % 10L << 4);
        submicro[0] = (byte)((nanosec /= 10L) % 10L);
        submicro[0] = (byte)(submicro[0] | (byte)((nanosec /= 10L) % 10L << 4));
        if (submicro[1] == 0) {
            len = 1;
        }
        string2.setInternalVariable("submicro", RubyString.newString(runtime2, submicro, 0, len));
        DateTimeZone zone2 = this.dt.getZone();
        if (zone2 != DateTimeZone.UTC) {
            long offset2 = zone2.getOffset(this.dt.getMillis());
            string2.setInternalVariable("offset", runtime2.newFixnum(offset2 / 1000L));
            String zoneName = zone2.getShortName(this.dt.getMillis());
            if (!TIME_OFFSET_PATTERN.matcher(zoneName).matches()) {
                string2.setInternalVariable("zone", runtime2.newString(zoneName));
            }
        }
        return string2;
    }

    @JRubyMethod(optional=1)
    public RubyTime round(ThreadContext context, IRubyObject[] args2) {
        int ndigits;
        int n = ndigits = args2.length == 0 ? 0 : RubyNumeric.num2int(args2[0]);
        if (ndigits > 9) {
            ndigits = 9;
        } else if (ndigits < 0) {
            throw context.getRuntime().newArgumentError("negative ndigits given");
        }
        int _nsec = this.dt.getMillisOfSecond() * 1000000 + (int)this.nsec;
        int pow2 = (int)Math.pow(10.0, 9 - ndigits);
        int rounded = (_nsec + pow2 / 2) / pow2 * pow2;
        DateTime _dt = this.dt.withMillisOfSecond(0).plusMillis(rounded / 1000000);
        return RubyTime.newTime(context.runtime, _dt, rounded % 1000000);
    }

    @Deprecated
    public static IRubyObject s_new(IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        RubyTime time = new RubyTime(runtime2, (RubyClass)recv2, new DateTime(RubyTime.getLocalTimeZone(runtime2)));
        time.callInit(args2, block);
        return time;
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTime.newInstance(context, recv2);
    }

    @JRubyMethod(name={"now"}, meta=true)
    public static RubyTime newInstance(ThreadContext context, IRubyObject recv2) {
        RubyTime obj = (RubyTime)((RubyClass)recv2).allocate();
        obj.getMetaClass().getBaseCallSite(0).call(context, recv2, obj);
        return obj;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyTime time;
        Ruby runtime2 = context.runtime;
        if (arg2 instanceof RubyTime) {
            RubyTime other = (RubyTime)arg2;
            time = new RubyTime(runtime2, (RubyClass)recv2, other.dt);
            time.setNSec(other.getNSec());
        } else {
            long nanosecs;
            long millisecs;
            if ((arg2 = RubyTime.numExact(context, arg2)) instanceof RubyFloat) {
                long seconds = RubyNumeric.float2long((RubyFloat)arg2);
                double dbl = ((RubyFloat)arg2).value;
                long nano = (long)((dbl - (double)seconds) * 1.0E9);
                if (dbl < 0.0 && nano != 0L) {
                    nano += 1000000000L;
                }
                millisecs = seconds * 1000L + nano / 1000000L;
                nanosecs = nano % 1000000L;
            } else if (arg2 instanceof RubyRational) {
                RubyRational rational = (RubyRational)arg2;
                BigInteger numerator2 = rational.getNumerator().getBigIntegerValue();
                BigInteger denominator2 = rational.getDenominator().getBigIntegerValue();
                BigDecimal nanosBD = new BigDecimal(numerator2).divide(new BigDecimal(denominator2), 50, 4).multiply(ONE_BILLION_BD);
                BigInteger millis = nanosBD.divide(ONE_MILLION_BD).toBigInteger();
                BigInteger nanos = nanosBD.remainder(ONE_MILLION_BD).toBigInteger();
                millisecs = millis.longValue();
                nanosecs = nanos.longValue();
            } else {
                nanosecs = 0L;
                millisecs = RubyNumeric.num2long(arg2) * 1000L;
            }
            try {
                time = new RubyTime(runtime2, (RubyClass)recv2, new DateTime(millisecs, RubyTime.getLocalTimeZone(runtime2)));
            }
            catch (ArithmeticException | IllegalFieldValueException ex) {
                throw runtime2.newRangeError(ex.getMessage());
            }
            time.setNSec(nanosecs);
        }
        return time;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        RubySymbol ms = context.runtime.newSymbol("microsecond");
        return RubyTime.at(context, recv2, arg1, arg2, ms);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(meta=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        long millisecs;
        Ruby runtime2 = context.runtime;
        RubyTime time = new RubyTime(runtime2, (RubyClass)recv2, new DateTime(0L, RubyTime.getLocalTimeZone(runtime2)));
        long nanosecs = 0L;
        arg1 = RubyTime.numExact(context, arg1);
        arg2 = RubyTime.numExact(context, arg2);
        if (arg1 instanceof RubyFloat || arg1 instanceof RubyRational) {
            double dbl = RubyNumeric.num2dbl(context, arg1);
            millisecs = (long)(dbl * 1000.0);
            nanosecs = (long)(dbl * 1.0E9) % 1000000L;
        } else {
            millisecs = RubyNumeric.num2long(arg1) * 1000L;
        }
        if (!(arg3 instanceof RubySymbol)) {
            throw context.runtime.newArgumentError("unexpected unit " + arg3);
        }
        RubySymbol unit = (RubySymbol)arg3;
        if (arg2 instanceof RubyFloat || arg2 instanceof RubyRational) {
            if (runtime2.newSymbol("microsecond").eql(unit) || runtime2.newSymbol("usec").eql(unit)) {
                double micros = RubyNumeric.num2dbl(context, arg2);
                double nanos = micros * 1000.0;
                millisecs += (long)(nanos / 1000000.0);
                nanosecs += (long)(nanos % 1000000.0);
            } else if (runtime2.newSymbol("millisecond").eql(unit)) {
                double millis = RubyNumeric.num2dbl(context, arg2);
                double nanos = millis * 1000000.0;
                millisecs += (long)(nanos / 1000000.0);
                nanosecs += (long)(nanos % 1000000.0);
            } else {
                if (!runtime2.newSymbol("nanosecond").eql(unit) && !runtime2.newSymbol("nsec").eql(unit)) throw context.runtime.newArgumentError("unexpected unit " + arg3);
                nanosecs += RubyNumeric.num2long(arg2);
            }
        } else if (runtime2.newSymbol("microsecond").eql(unit) || runtime2.newSymbol("usec").eql(unit)) {
            long micros = RubyNumeric.num2long(arg2);
            long nanos = micros * 1000L;
            millisecs += nanos / 1000000L;
            nanosecs += nanos % 1000000L;
        } else if (runtime2.newSymbol("millisecond").eql(unit)) {
            double millis = RubyNumeric.num2long(arg2);
            double nanos = millis * 1000000.0;
            millisecs = (long)((double)millisecs + nanos / 1000000.0);
            nanosecs = (long)((double)nanosecs + nanos % 1000000.0);
        } else {
            if (!runtime2.newSymbol("nanosecond").eql(unit) && !runtime2.newSymbol("nsec").eql(unit)) throw context.runtime.newArgumentError("unexpected unit " + arg3);
            nanosecs += RubyNumeric.num2long(arg2);
        }
        long nanosecOverflow = nanosecs / 1000000L;
        time.setNSec(nanosecs % 1000000L);
        time.dt = time.dt.withMillis(millisecs + nanosecOverflow);
        return time;
    }

    @JRubyMethod(name={"local", "mktime"}, required=1, optional=9, meta=true)
    public static RubyTime local(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyTime)((RubyClass)recv2).allocate()).initTime(context, args2, false, false);
    }

    @JRubyMethod(name={"initialize"}, optional=7, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        if (args2.length == 0) {
            DateTime dt;
            long nsecs;
            long msecs;
            DateTimeZone dtz = RubyTime.getLocalTimeZone(runtime2);
            POSIX posix = runtime2.getPosix();
            if (posix.isNative()) {
                try {
                    Timeval tv = posix.allocateTimeval();
                    posix.gettimeofday(tv);
                    long secs = tv.sec();
                    long usecs = tv.usec();
                    msecs = secs * 1000L + usecs / 1000L;
                    nsecs = usecs % 1000L * 1000L;
                }
                catch (RaiseException notImplementedError) {
                    msecs = System.currentTimeMillis();
                    nsecs = 0L;
                }
            } else {
                msecs = System.currentTimeMillis();
                nsecs = 0L;
            }
            this.dt = dt = new DateTime(msecs, dtz);
            this.setNSec(nsecs);
            return context.nil;
        }
        if (args2.length == 7) {
            RubySymbol dstSymbol = RubySymbol.newSymbol(runtime2, "dst");
            boolean receivedDstSymbolAsArgument = args2[6].op_equal(context, dstSymbol).isTrue();
            RubyBoolean isDst = RubyBoolean.newBoolean(runtime2, receivedDstSymbolAsArgument);
            args2 = new IRubyObject[]{args2[5], args2[4], args2[3], args2[2], args2[1], args2[0], context.nil, context.nil, isDst, args2[6]};
        }
        return this.initTime(context, args2, false, true);
    }

    @JRubyMethod(name={"utc", "gm"}, required=1, optional=9, meta=true)
    public static RubyTime utc(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyTime)((RubyClass)recv2).allocate()).initTime(context, args2, true, false);
    }

    @Deprecated
    public static RubyTime load(IRubyObject recv2, IRubyObject from, Block block) {
        return RubyTime.s_mload(recv2.getRuntime().getCurrentContext(), (RubyTime)((RubyClass)recv2).allocate(), from);
    }

    @JRubyMethod(name={"_load"}, meta=true)
    public static RubyTime load(ThreadContext context, IRubyObject recv2, IRubyObject from) {
        return RubyTime.s_mload(context, (RubyTime)((RubyClass)recv2).allocate(), from);
    }

    @Override
    public Class<?> getJavaClass() {
        return java.util.Date.class;
    }

    @Override
    public <T> T toJava(Class<T> target) {
        if (target == java.util.Date.class || target == Comparable.class || target == Object.class) {
            return target.cast(this.getJavaDate());
        }
        if (target == Calendar.class || target == GregorianCalendar.class) {
            return target.cast(this.dt.toGregorianCalendar());
        }
        if (target.isAssignableFrom(DateTime.class) && target != Serializable.class) {
            return target.cast(this.dt);
        }
        if (target == Date.class) {
            return target.cast(new Date(this.dt.getMillis()));
        }
        if (target == Time.class) {
            return target.cast(new Time(this.dt.getMillis()));
        }
        if (target == Timestamp.class) {
            Timestamp timestamp = new Timestamp(this.dt.getMillis());
            timestamp.setNanos(this.getNanos());
            return target.cast(timestamp);
        }
        if (target != Serializable.class) {
            if (target.isAssignableFrom(Instant.class)) {
                return (T)this.toInstant();
            }
            if (target.isAssignableFrom(LocalDateTime.class)) {
                return (T)this.toLocalDateTime();
            }
            if (target.isAssignableFrom(ZonedDateTime.class)) {
                return (T)this.toZonedDateTime();
            }
            if (target.isAssignableFrom(OffsetDateTime.class)) {
                return (T)this.toOffsetDateTime();
            }
        }
        return super.toJava(target);
    }

    public long getTimeInMillis() {
        return this.dt.getMillis();
    }

    public int getYear() {
        return this.dt.getYear();
    }

    public int getMonth() {
        return this.dt.getMonthOfYear();
    }

    public int getDay() {
        return this.dt.getDayOfMonth();
    }

    public int getHour() {
        return this.dt.getHourOfDay();
    }

    public int getMinute() {
        return this.dt.getMinuteOfHour();
    }

    public int getSecond() {
        return this.dt.getSecondOfMinute();
    }

    public java.util.Date getJavaDate() {
        return this.dt.toDate();
    }

    public Instant toInstant() {
        long millis = this.getTimeInMillis();
        long sec2 = Math.floorDiv(millis, 1000L);
        long nanoAdj = this.getNSec() + Math.floorMod(millis, 1000L) * 1000000L;
        return Instant.ofEpochSecond(sec2, nanoAdj);
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.of(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getNanos());
    }

    public ZonedDateTime toZonedDateTime() {
        return ZonedDateTime.of(this.toLocalDateTime(), ZoneId.of(this.dt.getZone().getID()));
    }

    public OffsetDateTime toOffsetDateTime() {
        int offset2 = this.dt.getZone().getOffset(this.dt.getMillis()) / 1000;
        return OffsetDateTime.of(this.toLocalDateTime(), ZoneOffset.ofTotalSeconds(offset2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double convertTimeInterval(ThreadContext context, IRubyObject sec2) {
        double seconds;
        if (sec2 instanceof RubyNumeric) {
            seconds = ((RubyNumeric)sec2).getDoubleValue();
        } else if (RubyTime.sites((ThreadContext)context).respond_to_divmod.respondsTo(context, sec2, sec2)) {
            Ruby runtime2 = context.runtime;
            IRubyObject result2 = RubyTime.sites((ThreadContext)context).divmod.call(context, sec2, sec2, 1L);
            if (!(result2 instanceof RubyArray)) throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, "unexpected divmod result: into %s", RubyStringBuilder.types(runtime2, result2.getMetaClass())));
            seconds = ((RubyNumeric)((RubyArray)result2).eltOk(0L)).getDoubleValue();
            seconds += ((RubyNumeric)((RubyArray)result2).eltOk(1L)).getDoubleValue();
        } else {
            seconds = 0.0;
            boolean raise2 = true;
            if (sec2 instanceof JavaProxy) {
                try {
                    seconds = sec2.convertToFloat().value;
                    raise2 = false;
                }
                catch (TypeError result2) {
                    // empty catch block
                }
            }
            if (raise2) {
                Ruby runtime3 = context.runtime;
                throw context.runtime.newTypeError(RubyStringBuilder.str(runtime3, "can't convert ", RubyStringBuilder.types(runtime3, sec2.getMetaClass()), " into time interval"));
            }
        }
        if (!(seconds < 0.0)) return seconds;
        throw context.runtime.newArgumentError("time interval must be positive");
    }

    private static RubyTime s_mload(ThreadContext context, RubyTime time, IRubyObject from) {
        int i2;
        DateTime dt = TIME0;
        byte[] fromAsBytes = from.convertToString().getBytes();
        if (fromAsBytes.length != 8) {
            throw context.runtime.newTypeError("marshaled time format differ");
        }
        int p2 = 0;
        int s2 = 0;
        for (i2 = 0; i2 < 4; ++i2) {
            p2 |= (fromAsBytes[i2] & 0xFF) << 8 * i2;
        }
        for (i2 = 4; i2 < 8; ++i2) {
            s2 |= (fromAsBytes[i2] & 0xFF) << 8 * (i2 - 4);
        }
        boolean utc2 = false;
        if ((p2 & Integer.MIN_VALUE) == 0) {
            dt = dt.withMillis((long)p2 * 1000L);
            time.setUSec((s2 & 0xFFFFF) % 1000);
        } else {
            utc2 = ((p2 &= Integer.MAX_VALUE) >>> 30 & 1) == 1;
            dt = dt.withYear((p2 >>> 14 & 0xFFFF) + 1900);
            dt = dt.withMonthOfYear((p2 >>> 10 & 0xF) + 1);
            dt = dt.withDayOfMonth(p2 >>> 5 & 0x1F);
            dt = dt.withHourOfDay(p2 & 0x1F);
            dt = dt.withMinuteOfHour(s2 >>> 26 & 0x3F);
            dt = dt.withSecondOfMinute(s2 >>> 20 & 0x3F);
            dt = dt.withMillisOfSecond((s2 & 0xFFFFF) / 1000);
            time.setUSec((s2 & 0xFFFFF) % 1000);
        }
        time.setDateTime(dt);
        if (!utc2) {
            time.localtime();
        }
        from.getInstanceVariables().copyInstanceVariablesInto(time);
        IRubyObject nano_num = (IRubyObject)from.getInternalVariables().getInternalVariable("nano_num");
        IRubyObject nano_den = (IRubyObject)from.getInternalVariables().getInternalVariable("nano_den");
        IRubyObject offsetVar = (IRubyObject)from.getInternalVariables().getInternalVariable("offset");
        IRubyObject zoneVar = (IRubyObject)from.getInternalVariables().getInternalVariable("zone");
        if (nano_num != null && nano_den != null) {
            long nanos = nano_num.convertToInteger().getLongValue() / nano_den.convertToInteger().getLongValue();
            time.nsec += nanos;
        }
        int offset2 = 0;
        if (offsetVar != null && offsetVar.respondsTo("to_int")) {
            IRubyObject $ex = context.getErrorInfo();
            try {
                offset2 = offsetVar.convertToInteger().getIntValue() * 1000;
            }
            catch (TypeError typeError) {
                context.setErrorInfo($ex);
            }
        }
        String zone2 = "";
        if (zoneVar != null && zoneVar.respondsTo("to_str")) {
            IRubyObject $ex = context.getErrorInfo();
            try {
                zone2 = zoneVar.convertToString().toString();
            }
            catch (TypeError typeError) {
                context.setErrorInfo($ex);
            }
        }
        time.dt = dt.withZone(RubyTime.getTimeZoneWithOffset(context.runtime, zone2, offset2));
        return time;
    }

    private RubyTime initTime(ThreadContext context, IRubyObject[] args2, boolean gmt2, boolean utcOffset) {
        DateTime dt;
        DateTimeZone dtz;
        Ruby runtime2 = context.runtime;
        int len = 7;
        boolean isDst = false;
        boolean setTzRelative = false;
        long nanos = 0L;
        if (gmt2) {
            dtz = DateTimeZone.UTC;
        } else if (utcOffset) {
            if (args2.length == 10 && args2[9] instanceof RubyString) {
                dtz = RubyTime.getTimeZoneFromUtcOffset(context, args2[9]);
                setTzRelative = true;
            } else if (args2.length == 10 && RubyTime.sites((ThreadContext)context).respond_to_to_int.respondsTo(context, args2[9], args2[9])) {
                IRubyObject offsetInt = RubyTime.sites((ThreadContext)context).to_int.call(context, args2[9], (IRubyObject)args2[9]);
                dtz = RubyTime.getTimeZone(runtime2, ((RubyNumeric)offsetInt).getLongValue());
                setTzRelative = true;
            } else {
                dtz = RubyTime.getLocalTimeZone(runtime2);
            }
        } else {
            dtz = RubyTime.getLocalTimeZone(runtime2);
        }
        if (args2.length == 10) {
            if (args2[8] instanceof RubyBoolean) {
                isDst = args2[8].isTrue();
            }
            args2 = new IRubyObject[]{args2[5], args2[4], args2[3], args2[2], args2[1], args2[0], context.nil};
        } else {
            len = args2.length;
            if (len < 7) {
                Object[] newArgs = new IRubyObject[7];
                ArraySupport.copy(args2, newArgs, 0, len);
                for (int i2 = len; i2 < 7; ++i2) {
                    newArgs[i2] = context.nil;
                }
                args2 = newArgs;
                len = 7;
            }
        }
        if (args2[0] instanceof RubyString) {
            args2[0] = RubyNumeric.str2inum(runtime2, (RubyString)args2[0], 10, false);
        }
        int year2 = (int)RubyNumeric.num2long(args2[0]);
        int month2 = 1;
        if (len > 1) {
            if (args2[1] != context.nil) {
                month2 = RubyTime.parseMonth(context, (IRubyObject)args2[1]);
            }
            if (month2 < 1 || month2 > 12) {
                throw runtime2.newArgumentError("Argument out of range: for month: " + month2);
            }
        }
        int i_args0 = RubyTime.argToInt(context, (IRubyObject[])args2, 2, 1);
        int i_args1 = RubyTime.argToInt(context, (IRubyObject[])args2, 3, 0);
        int i_args2 = RubyTime.argToInt(context, (IRubyObject[])args2, 4, 0);
        int i_args3 = RubyTime.argToInt(context, (IRubyObject[])args2, 5, 0);
        if (i_args0 < 1 || i_args0 > 31 || i_args1 < 0 || i_args1 > 24 || i_args1 == 24 && (i_args2 > 0 || i_args3 > 0) || i_args2 < 0 || i_args2 > 59 || i_args3 < 0 || i_args3 > 60) {
            throw runtime2.newArgumentError("argument out of range.");
        }
        try {
            dt = new DateTime(year2, month2, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            Chronology chrono = dt.getChronology();
            long instant = dt.getMillis();
            instant = chrono.days().add(instant, i_args0 - 1);
            if (i_args1 != 0) {
                instant = chrono.hours().add(instant, i_args1);
            }
            if (i_args2 != 0) {
                instant = chrono.minutes().add(instant, i_args2);
            }
            if (i_args3 != 0) {
                instant = chrono.seconds().add(instant, i_args3);
            }
            if (args2[5] != context.nil && args2[6] == context.nil) {
                if (args2[5] instanceof RubyRational) {
                    RubyRational rat = (RubyRational)args2[5];
                    if (rat.isNegative()) {
                        throw runtime2.newArgumentError("argument out of range.");
                    }
                    RubyRational nsec2 = (RubyRational)rat.op_mul(context, runtime2.newFixnum(1000000000));
                    long full_nanos = nsec2.getLongValue();
                    long millis = full_nanos / 1000000L;
                    nanos = full_nanos - millis * 1000000L;
                    instant = chrono.millis().add(instant, millis % 1000L);
                } else {
                    double secs = RubyFloat.num2dbl(context, (IRubyObject)args2[5]);
                    if (secs < 0.0 || secs >= 1.0E9) {
                        throw runtime2.newArgumentError("argument out of range.");
                    }
                    int int_millis = (int)(secs * 1000.0) % 1000;
                    instant = chrono.millis().add(instant, int_millis);
                    nanos = (long)(secs * 1.0E9) % 1000000L;
                }
            }
            dt = dt.withMillis(instant);
            dt = dt.withZoneRetainFields(dtz);
            DateTime beforeDstBoundary = dt.withEarlierOffsetAtOverlap();
            DateTime afterDstBoundary = dt.withLaterOffsetAtOverlap();
            int offsetBeforeBoundary = dtz.getOffset((ReadableInstant)beforeDstBoundary);
            int offsetAfterBoundary = dtz.getOffset((ReadableInstant)afterDstBoundary);
            dt = isDst ? (offsetBeforeBoundary > offsetAfterBoundary ? beforeDstBoundary : afterDstBoundary) : (offsetBeforeBoundary > offsetAfterBoundary ? afterDstBoundary : beforeDstBoundary);
        }
        catch (IllegalFieldValueException e) {
            throw runtime2.newArgumentError("time out of range");
        }
        if (args2.length != 8 && args2[6] != context.nil) {
            if (args2[6] instanceof RubyRational) {
                RubyRational rat = (RubyRational)args2[6];
                if (rat.isNegative()) {
                    throw runtime2.newArgumentError("argument out of range.");
                }
                RubyRational nsec3 = (RubyRational)rat.op_mul(context, runtime2.newFixnum(1000));
                long tmpNanos = (long)nsec3.getDoubleValue(context);
                dt = dt.withMillis(dt.getMillis() + tmpNanos / 1000000L);
                nanos = tmpNanos % 1000000L;
            } else if (args2[6] instanceof RubyFloat) {
                RubyFloat flo = (RubyFloat)args2[6];
                if (flo.isNegative()) {
                    throw runtime2.newArgumentError("argument out of range.");
                }
                double micros = flo.value;
                dt = dt.withMillis(dt.getMillis() + (long)(micros / 1000.0));
                nanos = (long)Math.rint(micros * 1000.0 % 1000000.0);
            } else {
                int i_args4 = RubyTime.argToInt(context, (IRubyObject[])args2, 6, 0);
                if (i_args4 < 0 || i_args4 >= 1000000) {
                    throw runtime2.newArgumentError("argument out of range.");
                }
                int usec2 = i_args4 % 1000;
                int msec = i_args4 / 1000;
                if (i_args4 < 0) {
                    --msec;
                    usec2 += 1000;
                }
                dt = dt.withMillis(dt.getMillis() + (long)msec);
                this.setUSec(usec2);
            }
        }
        this.dt = dt;
        if (nanos != 0L) {
            this.setNSec(nanos);
        }
        this.setIsTzRelative(setTzRelative);
        return this;
    }

    private static int argToInt(ThreadContext context, IRubyObject[] args2, int i2, int def) {
        IRubyObject arg2 = args2[i2];
        if (arg2 != context.nil) {
            if (!(arg2 instanceof RubyNumeric)) {
                JavaSites.TimeSites sites = RubyTime.sites(context);
                arg2 = sites.respond_to_to_int.respondsTo(context, arg2, arg2) ? (args2[i2] = sites.to_int.call(context, arg2, arg2)) : (args2[i2] = sites.to_i.call(context, arg2, arg2));
            }
            return RubyNumeric.num2int(arg2);
        }
        return def;
    }

    private static int parseMonth(ThreadContext context, IRubyObject arg2) {
        IRubyObject tmp = arg2.checkStringType();
        if (tmp != context.nil) {
            String monthStr = tmp.toString().toLowerCase();
            if (monthStr.length() == 3) {
                switch (monthStr) {
                    case "jan": {
                        return 1;
                    }
                    case "feb": {
                        return 2;
                    }
                    case "mar": {
                        return 3;
                    }
                    case "apr": {
                        return 4;
                    }
                    case "may": {
                        return 5;
                    }
                    case "jun": {
                        return 6;
                    }
                    case "jul": {
                        return 7;
                    }
                    case "aug": {
                        return 8;
                    }
                    case "sep": {
                        return 9;
                    }
                    case "oct": {
                        return 10;
                    }
                    case "nov": {
                        return 11;
                    }
                    case "dec": {
                        return 12;
                    }
                }
            }
            try {
                return Integer.parseInt(monthStr);
            }
            catch (NumberFormatException ex) {
                throw context.runtime.newArgumentError("Argument out of range.");
            }
        }
        return (int)RubyNumeric.num2long(arg2);
    }

    private static JavaSites.TimeSites sites(ThreadContext context) {
        return context.sites.Time;
    }

    @Deprecated
    public static RubyTime new_local(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyTime)((RubyClass)recv2).allocate()).initTime(recv2.getRuntime().getCurrentContext(), args2, false, false);
    }

    @Deprecated
    public static RubyTime new_utc(IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyTime)((RubyClass)recv2).allocate()).initTime(recv2.getRuntime().getCurrentContext(), args2, true, false);
    }

    @Deprecated
    public static IRubyObject new19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return ((RubyClass)recv2).allocate().callMethod(context, "initialize", args2);
    }
}

