/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaUtil;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.Constants;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ReadonlyGlobalVariable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.OSEnvironment;
import org.jruby.util.RegexpOptions;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;
import org.jruby.util.io.ChannelHelper;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.STDIO;

public class RubyGlobal {
    public static final List<String> UNCACHED_GLOBALS = Collections.unmodifiableList(Arrays.asList("$.", "$INPUT_LINE_NUMBER", "$FILENAME"));

    public static void initARGV(Ruby runtime2) {
        String[] argv2;
        RubyArray argvArray = runtime2.newArray();
        for (String arg2 : argv2 = runtime2.getInstanceConfig().getArgv()) {
            argvArray.append(RubyString.newInternalFromJavaExternal(runtime2, arg2).tainted());
        }
        if (runtime2.getObject().getConstantNoConstMissing("ARGV") != null) {
            ((RubyArray)runtime2.getObject().getConstant("ARGV")).replace(argvArray);
        } else {
            runtime2.getObject().setConstantQuiet("ARGV", argvArray);
            runtime2.getGlobalVariables().define("$*", new ValueAccessor(argvArray), GlobalVariable.Scope.GLOBAL);
        }
    }

    public static void createGlobals(ThreadContext context, Ruby runtime2) {
        GlobalVariables globals = runtime2.getGlobalVariables();
        runtime2.defineGlobalConstant("TOPLEVEL_BINDING", runtime2.newBinding());
        runtime2.defineGlobalConstant("TRUE", runtime2.getTrue());
        runtime2.defineGlobalConstant("FALSE", runtime2.getFalse());
        runtime2.defineGlobalConstant("NIL", runtime2.getNil());
        runtime2.getObject().deprecateConstant(runtime2, "TRUE");
        runtime2.getObject().deprecateConstant(runtime2, "FALSE");
        runtime2.getObject().deprecateConstant(runtime2, "NIL");
        RubyGlobal.initARGV(runtime2);
        ValueAccessor d = new ValueAccessor(runtime2.newString(runtime2.getInstanceConfig().displayedFileName()));
        globals.define("$PROGRAM_NAME", d, GlobalVariable.Scope.GLOBAL);
        globals.define("$0", d, GlobalVariable.Scope.GLOBAL);
        IRubyObject version = null;
        RubyFixnum patchlevel = null;
        IRubyObject release = runtime2.newString("2019-04-09").freeze(context);
        IRubyObject platform = runtime2.newString("java").freeze(context);
        IRubyObject engine = runtime2.newString("jruby").freeze(context);
        version = runtime2.newString("2.5.3").freeze(context);
        patchlevel = runtime2.newFixnum(0);
        runtime2.defineGlobalConstant("RUBY_VERSION", version);
        runtime2.defineGlobalConstant("RUBY_PATCHLEVEL", patchlevel);
        runtime2.defineGlobalConstant("RUBY_RELEASE_DATE", release);
        runtime2.defineGlobalConstant("RUBY_PLATFORM", platform);
        IRubyObject description = runtime2.newString(OutputStrings.getVersionString()).freeze(context);
        runtime2.defineGlobalConstant("RUBY_DESCRIPTION", description);
        IRubyObject copyright = runtime2.newString(OutputStrings.getCopyrightString()).freeze(context);
        runtime2.defineGlobalConstant("RUBY_COPYRIGHT", copyright);
        runtime2.defineGlobalConstant("RELEASE_DATE", release);
        runtime2.defineGlobalConstant("PLATFORM", platform);
        IRubyObject jrubyVersion = runtime2.newString("9.2.7.0").freeze(context);
        IRubyObject jrubyRevision = runtime2.newString(Constants.REVISION).freeze(context);
        runtime2.defineGlobalConstant("JRUBY_VERSION", jrubyVersion);
        runtime2.defineGlobalConstant("JRUBY_REVISION", jrubyRevision);
        runtime2.defineGlobalConstant("RUBY_REVISION", runtime2.newFixnum(Constants.RUBY_REVISION));
        runtime2.defineGlobalConstant("RUBY_ENGINE", engine);
        runtime2.defineGlobalConstant("RUBY_ENGINE_VERSION", jrubyVersion);
        RubyInstanceConfig.Verbosity verbosity = runtime2.getInstanceConfig().getVerbosity();
        runtime2.defineVariable(new WarningGlobalVariable(runtime2, "$-W", verbosity), GlobalVariable.Scope.GLOBAL);
        NonEffectiveGlobalVariable kcodeGV = new NonEffectiveGlobalVariable(runtime2, "$KCODE", runtime2.getNil());
        runtime2.defineVariable(kcodeGV, GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new GlobalVariable.Copy(runtime2, "$-K", kcodeGV), GlobalVariable.Scope.GLOBAL);
        IRubyObject defaultRS = runtime2.newString(runtime2.getInstanceConfig().getRecordSeparator()).freeze(context);
        StringGlobalVariable rs = new StringGlobalVariable(runtime2, "$/", defaultRS);
        runtime2.defineVariable(rs, GlobalVariable.Scope.GLOBAL);
        runtime2.setRecordSeparatorVar(rs);
        globals.setDefaultSeparator(defaultRS);
        runtime2.defineVariable(new StringGlobalVariable(runtime2, "$\\", runtime2.getNil()), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new StringGlobalVariable(runtime2, "$,", runtime2.getNil()), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LineNumberGlobalVariable(runtime2, "$."), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LastlineGlobalVariable(runtime2, "$_"), GlobalVariable.Scope.FRAME);
        runtime2.defineVariable(new LastExitStatusVariable(runtime2, "$?"), GlobalVariable.Scope.THREAD);
        runtime2.defineVariable(new ErrorInfoGlobalVariable(runtime2, "$!", runtime2.getNil()), GlobalVariable.Scope.THREAD);
        runtime2.defineVariable(new NonEffectiveGlobalVariable(runtime2, "$=", runtime2.getFalse()), GlobalVariable.Scope.GLOBAL);
        if (runtime2.getInstanceConfig().getInputFieldSeparator() == null) {
            runtime2.defineVariable(new StringOrRegexpGlobalVariable(runtime2, "$;", runtime2.getNil()), GlobalVariable.Scope.GLOBAL);
        } else {
            runtime2.defineVariable(new StringOrRegexpGlobalVariable(runtime2, "$;", RubyRegexp.newRegexp(runtime2, runtime2.getInstanceConfig().getInputFieldSeparator(), new RegexpOptions())), GlobalVariable.Scope.GLOBAL);
        }
        RubyInstanceConfig.Verbosity verbose = runtime2.getInstanceConfig().getVerbosity();
        IRubyObject verboseValue = null;
        verboseValue = verbose == RubyInstanceConfig.Verbosity.NIL ? runtime2.getNil() : (verbose == RubyInstanceConfig.Verbosity.TRUE ? runtime2.getTrue() : runtime2.getFalse());
        runtime2.defineVariable(new VerboseGlobalVariable(runtime2, "$VERBOSE", verboseValue), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new VerboseGlobalVariable(runtime2, "$-v", verboseValue), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new VerboseGlobalVariable(runtime2, "$-w", verboseValue), GlobalVariable.Scope.GLOBAL);
        RubyBoolean debug = runtime2.newBoolean(runtime2.getInstanceConfig().isDebug());
        runtime2.defineVariable(new DebugGlobalVariable(runtime2, "$DEBUG", debug), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new DebugGlobalVariable(runtime2, "$-d", debug), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new SafeGlobalVariable(runtime2, "$SAFE"), GlobalVariable.Scope.THREAD);
        runtime2.defineVariable(new BacktraceGlobalVariable(runtime2, "$@"), GlobalVariable.Scope.THREAD);
        RubyGlobal.initSTDIO(runtime2, globals);
        runtime2.defineVariable(new LoadedFeatures(runtime2, "$\""), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LoadedFeatures(runtime2, "$LOADED_FEATURES"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LoadPath(runtime2, "$:"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LoadPath(runtime2, "$-I"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new LoadPath(runtime2, "$LOAD_PATH"), GlobalVariable.Scope.GLOBAL);
        runtime2.defineVariable(new MatchMatchGlobalVariable(runtime2, "$&"), GlobalVariable.Scope.FRAME);
        runtime2.defineVariable(new PreMatchGlobalVariable(runtime2, "$`"), GlobalVariable.Scope.FRAME);
        runtime2.defineVariable(new PostMatchGlobalVariable(runtime2, "$'"), GlobalVariable.Scope.FRAME);
        runtime2.defineVariable(new LastMatchGlobalVariable(runtime2, "$+"), GlobalVariable.Scope.FRAME);
        runtime2.defineVariable(new BackRefGlobalVariable(runtime2, "$~"), GlobalVariable.Scope.FRAME);
        globals.defineReadonly("$$", new PidAccessor(runtime2), GlobalVariable.Scope.GLOBAL);
        RubyGlobal.defineGlobalEnvConstants(runtime2);
        if (globals.get("$*").isNil()) {
            globals.defineReadonly("$*", new ValueAccessor(runtime2.newArray()), GlobalVariable.Scope.GLOBAL);
        }
        globals.defineReadonly("$-p", new ValueAccessor(runtime2.newBoolean(runtime2.getInstanceConfig().isAssumePrinting())), GlobalVariable.Scope.GLOBAL);
        globals.defineReadonly("$-a", new ValueAccessor(runtime2.newBoolean(runtime2.getInstanceConfig().isSplit())), GlobalVariable.Scope.GLOBAL);
        globals.defineReadonly("$-l", new ValueAccessor(runtime2.newBoolean(runtime2.getInstanceConfig().isProcessLineEnds())), GlobalVariable.Scope.GLOBAL);
        RubyArgsFile.initArgsFile(runtime2);
        globals.alias("$-0", "$/");
        globals.alias("$ERROR_INFO", "$!");
        globals.alias("$ERROR_POSITION", "$@");
        globals.alias("$FS", "$;");
        globals.alias("$FIELD_SEPARATOR", "$;");
        globals.alias("$OFS", "$,");
        globals.alias("$OUTPUT_FIELD_SEPARATOR", "$,");
        globals.alias("$RS", "$/");
        globals.alias("$INPUT_RECORD_SEPARATOR", "$/");
        globals.alias("$ORS", "$\\");
        globals.alias("$OUTPUT_RECORD_SEPARATOR", "$\\");
        globals.alias("$NR", "$.");
        globals.alias("$INPUT_LINE_NUMBER", "$.");
        globals.alias("$LAST_READ_LINE", "$_");
        globals.alias("$DEFAULT_OUTPUT", "$>");
        globals.alias("$DEFAULT_INPUT", "$<");
        globals.alias("$PID", "$$");
        globals.alias("$PROCESS_ID", "$$");
        globals.alias("$CHILD_STATUS", "$?");
        globals.alias("$LAST_MATCH_INFO", "$~");
        globals.alias("$IGNORECASE", "$=");
        globals.alias("$ARGV", "$*");
        globals.alias("$MATCH", "$&");
        globals.alias("$PREMATCH", "$`");
        globals.alias("$POSTMATCH", "$'");
        globals.alias("$LAST_PAREN_MATCH", "$+");
    }

    public static void initSTDIO(Ruby runtime2, GlobalVariables globals) {
        RubyIO stderr;
        RubyIO stdout;
        RubyIO stdin;
        if (!Platform.IS_WINDOWS && runtime2.getPosix().isNative() && runtime2.getInstanceConfig().isHardExit() && ((Boolean)Options.NATIVE_STDIO.load()).booleanValue()) {
            stdin = RubyIO.prepStdio(runtime2, runtime2.getIn(), (Channel)new NativeDeviceChannel(0), 1, runtime2.getIO(), "<STDIN>");
            stdout = RubyIO.prepStdio(runtime2, runtime2.getOut(), (Channel)new NativeDeviceChannel(1), 2, runtime2.getIO(), "<STDOUT>");
            stderr = RubyIO.prepStdio(runtime2, runtime2.getErr(), (Channel)new NativeDeviceChannel(2), 10, runtime2.getIO(), "<STDERR>");
        } else {
            stdin = RubyIO.prepStdio(runtime2, runtime2.getIn(), RubyGlobal.prepareStdioChannel(runtime2, STDIO.IN, runtime2.getIn()), 1, runtime2.getIO(), "<STDIN>");
            stdout = RubyIO.prepStdio(runtime2, runtime2.getOut(), RubyGlobal.prepareStdioChannel(runtime2, STDIO.OUT, runtime2.getOut()), 2, runtime2.getIO(), "<STDOUT>");
            stderr = RubyIO.prepStdio(runtime2, runtime2.getErr(), RubyGlobal.prepareStdioChannel(runtime2, STDIO.ERR, runtime2.getErr()), 10, runtime2.getIO(), "<STDERR>");
        }
        if (runtime2.getObject().getConstantFromNoConstMissing("STDIN") == null) {
            runtime2.defineVariable(new InputGlobalVariable(runtime2, "$stdin", stdin), GlobalVariable.Scope.GLOBAL);
            runtime2.defineVariable(new OutputGlobalVariable(runtime2, "$stdout", stdout), GlobalVariable.Scope.GLOBAL);
            globals.alias("$>", "$stdout");
            runtime2.defineVariable(new OutputGlobalVariable(runtime2, "$stderr", stderr), GlobalVariable.Scope.GLOBAL);
            runtime2.defineGlobalConstant("STDIN", stdin);
            runtime2.defineGlobalConstant("STDOUT", stdout);
            runtime2.defineGlobalConstant("STDERR", stderr);
        } else {
            ((RubyIO)runtime2.getObject().getConstant("STDIN")).getOpenFile().setFD(stdin.getOpenFile().fd());
            ((RubyIO)runtime2.getObject().getConstant("STDOUT")).getOpenFile().setFD(stdout.getOpenFile().fd());
            ((RubyIO)runtime2.getObject().getConstant("STDERR")).getOpenFile().setFD(stderr.getOpenFile().fd());
        }
    }

    private static Channel prepareStdioChannel(Ruby runtime2, STDIO stdio, Object stream) {
        if (runtime2.getPosix().isNative() && stdio.isJVMDefault(stream) && !Platform.IS_WINDOWS) {
            OutputStream unwrappedStream;
            int fileno2 = -1;
            Channel channel = null;
            if (stream instanceof Channel) {
                channel = (Channel)stream;
                fileno2 = FilenoUtil.filenoFrom(channel);
            } else if (stream instanceof InputStream) {
                InputStream unwrappedStream2 = ChannelHelper.unwrapFilterInputStream((InputStream)stream);
                if (unwrappedStream2 instanceof FileInputStream) {
                    fileno2 = FilenoUtil.filenoFrom(((FileInputStream)unwrappedStream2).getChannel());
                }
            } else if (stream instanceof OutputStream && (unwrappedStream = ChannelHelper.unwrapFilterOutputStream((OutputStream)stream)) instanceof FileOutputStream) {
                fileno2 = FilenoUtil.filenoFrom(((FileOutputStream)unwrappedStream).getChannel());
            }
            if (fileno2 >= 0) {
                return new NativeDeviceChannel(fileno2);
            }
        }
        switch (stdio) {
            case IN: {
                return Channels.newChannel((InputStream)stream);
            }
            case OUT: 
            case ERR: {
                return Channels.newChannel((OutputStream)stream);
            }
        }
        throw new RuntimeException("invalid stdio: " + (Object)((Object)stdio));
    }

    private static int unwrapDripStream(Object stream) {
        if (stream.getClass().getName().startsWith("org.flatland.drip.Switchable")) {
            try {
                FileDescriptor fd = (FileDescriptor)stream.getClass().getMethod("getFD", new Class[0]).invoke(stream, new Object[0]);
                return FilenoUtil.filenoFrom(fd);
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace(System.err);
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace(System.err);
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace(System.err);
            }
        }
        return -1;
    }

    private static void defineGlobalEnvConstants(Ruby runtime2) {
        Map<RubyString, RubyString> environmentVariableMap = OSEnvironment.environmentVariableMap(runtime2);
        CaseInsensitiveStringOnlyRubyHash env = new CaseInsensitiveStringOnlyRubyHash(runtime2, environmentVariableMap, runtime2.getNil(), runtime2.getInstanceConfig().isNativeEnabled() && runtime2.getInstanceConfig().isUpdateNativeENVEnabled());
        env.getSingletonClass().defineAnnotatedMethods(CaseInsensitiveStringOnlyRubyHash.class);
        runtime2.defineGlobalConstant("ENV", env);
        runtime2.setENV(env);
        Map<RubyString, RubyString> systemPropertiesMap = OSEnvironment.systemPropertiesMap(runtime2);
        ReadOnlySystemPropertiesHash envJava = new ReadOnlySystemPropertiesHash(runtime2, systemPropertiesMap, runtime2.getNil());
        envJava.setFrozen(true);
        runtime2.defineGlobalConstant("ENV_JAVA", envJava);
    }

    private static final class PidAccessor
    implements IAccessor {
        private final Ruby runtime;
        private volatile IRubyObject pid = null;

        public PidAccessor(Ruby runtime2) {
            this.runtime = runtime2;
        }

        @Override
        public IRubyObject getValue() {
            return this.pid != null ? this.pid : (this.pid = this.runtime.newFixnum(this.runtime.getPosix().getpid()));
        }

        @Override
        public IRubyObject setValue(IRubyObject newValue) {
            throw this.runtime.newRuntimeError("cannot assign to $$");
        }
    }

    private static class LoadedFeatures
    extends ReadonlyGlobalVariable {
        public LoadedFeatures(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadedFeatures();
        }
    }

    private static class LoadPath
    extends ReadonlyGlobalVariable {
        public LoadPath(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadPath();
        }
    }

    public static class OutputGlobalVariable
    extends GlobalVariable {
        public OutputGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (value2 == this.get()) {
                return value2;
            }
            if (!value2.respondsTo("write") && !value2.respondsToMissing("write")) {
                throw this.runtime.newTypeError(this.name() + " must have write method, " + value2.getType().getName() + " given");
            }
            return super.set(value2);
        }
    }

    public static class InputGlobalVariable
    extends GlobalVariable {
        public InputGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (value2 == this.get()) {
                return value2;
            }
            return super.set(value2);
        }
    }

    private static class LastlineGlobalVariable
    extends GlobalVariable {
        public LastlineGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject get() {
            return Helpers.getLastLine(this.runtime, this.runtime.getCurrentContext());
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            Helpers.setLastLine(this.runtime, this.runtime.getCurrentContext(), value2);
            return value2;
        }
    }

    private static class BacktraceGlobalVariable
    extends GlobalVariable {
        public BacktraceGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject get() {
            IRubyObject backtrace2;
            IRubyObject errorInfo = this.runtime.getGlobalVariables().get("$!");
            IRubyObject iRubyObject = backtrace2 = errorInfo.isNil() ? this.runtime.getNil() : errorInfo.callMethod(errorInfo.getRuntime().getCurrentContext(), "backtrace");
            if (!(backtrace2 instanceof RubyArray)) {
                backtrace2 = this.runtime.getNil();
            }
            return backtrace2;
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (this.runtime.getGlobalVariables().get("$!").isNil()) {
                throw this.runtime.newArgumentError("$! not set");
            }
            this.runtime.getGlobalVariables().get("$!").callMethod(value2.getRuntime().getCurrentContext(), "set_backtrace", value2);
            return value2;
        }
    }

    private static class DebugGlobalVariable
    extends GlobalVariable {
        public DebugGlobalVariable(Ruby runtime2, String name2, IRubyObject initialValue) {
            super(runtime2, name2, initialValue);
            this.set(initialValue);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getDebug();
        }

        @Override
        public IRubyObject set(IRubyObject newValue) {
            if (newValue.isNil()) {
                this.runtime.setDebug(newValue);
            } else {
                this.runtime.setDebug(this.runtime.newBoolean(newValue.isTrue()));
            }
            return newValue;
        }
    }

    private static class WarningGlobalVariable
    extends ReadonlyGlobalVariable {
        public WarningGlobalVariable(Ruby runtime2, String name2, RubyInstanceConfig.Verbosity verbosity) {
            super(runtime2, name2, verbosity == RubyInstanceConfig.Verbosity.NIL ? RubyFixnum.newFixnum(runtime2, 0L) : (verbosity == RubyInstanceConfig.Verbosity.FALSE ? RubyFixnum.newFixnum(runtime2, 1L) : (verbosity == RubyInstanceConfig.Verbosity.TRUE ? RubyFixnum.newFixnum(runtime2, 2L) : runtime2.getNil())));
        }
    }

    private static class VerboseGlobalVariable
    extends GlobalVariable {
        public VerboseGlobalVariable(Ruby runtime2, String name2, IRubyObject initialValue) {
            super(runtime2, name2, initialValue);
            this.set(initialValue);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getVerbose();
        }

        @Override
        public IRubyObject set(IRubyObject newValue) {
            if (newValue.isNil()) {
                this.runtime.setVerbose(newValue);
            } else {
                this.runtime.setVerbose(this.runtime.newBoolean(newValue.isTrue()));
            }
            return newValue;
        }
    }

    private static class SafeGlobalVariable
    extends GlobalVariable {
        public SafeGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject get() {
            return RubyFixnum.zero(this.runtime);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            this.runtime.getWarnings().warnOnce(IRubyWarnings.ID.SAFE_NOT_SUPPORTED, "SAFE levels are not supported in JRuby");
            return RubyFixnum.zero(this.runtime);
        }
    }

    public static class KCodeGlobalVariable
    extends GlobalVariable {
        public KCodeGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject get() {
            String kcode = this.runtime.getKCode().getKCode();
            return kcode == null ? this.runtime.getNil() : this.runtime.newString(kcode);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            this.runtime.setKCode(KCode.create(value2.convertToString().toString()));
            return value2;
        }
    }

    public static class StringOrRegexpGlobalVariable
    extends GlobalVariable {
        public StringOrRegexpGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (!(value2.isNil() || value2 instanceof RubyString || value2 instanceof RubyRegexp)) {
                throw this.runtime.newTypeError("value of " + this.name() + " must be String or Regexp");
            }
            return super.set(value2);
        }
    }

    public static class StringGlobalVariable
    extends GlobalVariable {
        public StringGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (!value2.isNil() && !(value2 instanceof RubyString)) {
                throw this.runtime.newTypeError("value of " + this.name() + " must be a String");
            }
            return super.set(value2);
        }
    }

    private static class ErrorInfoGlobalVariable
    extends GlobalVariable {
        public ErrorInfoGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, null);
            this.set(value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (!(value2.isNil() || this.runtime.getException().isInstance(value2) || JavaUtil.isJavaObject(value2) && JavaUtil.unwrapJavaObject(value2) instanceof Throwable)) {
                throw this.runtime.newTypeError("assigning non-exception to $!");
            }
            return this.runtime.getCurrentContext().setErrorInfo(value2);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getCurrentContext().getErrorInfo();
        }
    }

    private static class LineNumberGlobalVariable
    extends GlobalVariable {
        public LineNumberGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, null);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            int line = (int)value2.convertToInteger().getLongValue();
            this.runtime.setCurrentLine(line);
            return value2;
        }

        @Override
        public IRubyObject get() {
            return this.runtime.newFixnum(this.runtime.getCurrentLine());
        }
    }

    private static class BackRefGlobalVariable
    extends GlobalVariable {
        public BackRefGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            return Helpers.getBackref(this.runtime, this.runtime.getCurrentContext());
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            Helpers.setBackref(this.runtime, this.runtime.getCurrentContext(), value2);
            return value2;
        }
    }

    private static class LastMatchGlobalVariable
    extends GlobalVariable {
        public LastMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.match_last(this.runtime.getCurrentContext().getBackRef());
        }
    }

    private static class PostMatchGlobalVariable
    extends GlobalVariable {
        public PostMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.match_post(this.runtime.getCurrentContext().getBackRef());
        }
    }

    private static class PreMatchGlobalVariable
    extends GlobalVariable {
        public PreMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.match_pre(this.runtime.getCurrentContext().getBackRef());
        }
    }

    private static class MatchMatchGlobalVariable
    extends GlobalVariable {
        public MatchMatchGlobalVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.last_match(this.runtime.getCurrentContext().getBackRef());
        }
    }

    private static class LastExitStatusVariable
    extends GlobalVariable {
        public LastExitStatusVariable(Ruby runtime2, String name2) {
            super(runtime2, name2, runtime2.getNil());
        }

        @Override
        public IRubyObject get() {
            IRubyObject lastExitStatus = this.runtime.getCurrentContext().getLastExitStatus();
            return lastExitStatus == null ? this.runtime.getNil() : lastExitStatus;
        }

        @Override
        public IRubyObject set(IRubyObject lastExitStatus) {
            throw this.runtime.newNameError("$? is a read-only variable", "$?");
        }
    }

    private static class NonEffectiveGlobalVariable
    extends GlobalVariable {
        public NonEffectiveGlobalVariable(Ruby runtime2, String name2, IRubyObject value2) {
            super(runtime2, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective; ignored");
            return value2;
        }

        @Override
        public IRubyObject get() {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective");
            return this.value;
        }
    }

    private static class ReadOnlySystemPropertiesHash
    extends StringOnlyRubyHash {
        public ReadOnlySystemPropertiesHash(Ruby runtime2, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime2, valueMap, defaultValue, updateRealENV);
        }

        public ReadOnlySystemPropertiesHash(Ruby runtime2, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue) {
            this(runtime2, valueMap, defaultValue, false);
        }

        @Override
        public void modify() {
            if (this.isFrozen()) {
                throw this.getRuntime().newTypeError("ENV_JAVA is not writable until you require 'java'");
            }
        }
    }

    public static class StringOnlyRubyHash
    extends RubyHash {
        private final boolean updateRealENV;
        private static final ByteList PATH_BYTES = new ByteList(new byte[]{80, 65, 84, 72}, (Encoding)USASCIIEncoding.INSTANCE, false);

        public StringOnlyRubyHash(Ruby runtime2, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime2, valueMap, defaultValue);
            this.updateRealENV = updateRealENV;
        }

        protected boolean isCaseSensitive() {
            return true;
        }

        public StringOnlyRubyHash(Ruby runtime2, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue) {
            this(runtime2, valueMap, defaultValue, false);
        }

        @Override
        public RubyHash to_hash() {
            Ruby runtime2 = this.getRuntime();
            RubyHash hash2 = RubyHash.newHash(runtime2);
            hash2.replace(runtime2.getCurrentContext(), this);
            return hash2;
        }

        @Override
        protected IRubyObject internalGet(IRubyObject key2) {
            if (this.size == 0) {
                return null;
            }
            if (!this.isCaseSensitive()) {
                key2 = this.getCorrectKey(key2.convertToString());
            }
            return super.internalGet(key2);
        }

        @Override
        public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.case_aware_op_aset(context, key2, value2);
        }

        @Override
        @Deprecated
        public IRubyObject op_aset19(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.op_aset(context, key2, value2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private IRubyObject case_aware_op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            if (!StringOnlyRubyHash.isStringLike(key2)) {
                throw context.runtime.newTypeError("can't convert " + key2.getMetaClass() + " into String");
            }
            RubyString keyAsStr = key2.convertToString();
            if (!this.isCaseSensitive()) {
                keyAsStr = this.getCorrectKey(keyAsStr);
                key2 = keyAsStr;
            }
            if (value2 == context.nil) {
                return super.delete(context, key2, Block.NULL_BLOCK);
            }
            if (!StringOnlyRubyHash.isStringLike(value2)) {
                throw context.runtime.newTypeError("can't convert " + value2.getMetaClass() + " into String");
            }
            RubyString valueAsStr = StringOnlyRubyHash.normalizeEnvString(context, keyAsStr, value2.convertToString());
            if (!this.updateRealENV) return super.op_aset(context, keyAsStr, valueAsStr);
            POSIX posix = context.runtime.getPosix();
            String keyAsJava = keyAsStr.asJavaString();
            if (valueAsStr == context.nil) {
                Class<Object> clazz = Object.class;
                synchronized (Object.class) {
                    posix.unsetenv(keyAsJava);
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return super.op_aset(context, keyAsStr, valueAsStr);
                }
            }
            String valueAsJava = valueAsStr.asJavaString();
            Class<Object> clazz = Object.class;
            synchronized (Object.class) {
                posix.setenv(keyAsJava, valueAsJava, 1);
                // ** MonitorExit[var9_11] (shouldn't be in output)
                return super.op_aset(context, keyAsStr, valueAsStr);
            }
        }

        private static boolean isStringLike(IRubyObject obj) {
            return obj instanceof RubyString || obj.respondsTo("to_str");
        }

        private RubyString getCorrectKey(RubyString key2) {
            RubyString actualKey = key2;
            if (Platform.IS_WINDOWS) {
                ThreadContext context = this.getRuntime().getCurrentContext();
                RubyArray keys2 = super.keys(context);
                for (int i2 = 0; i2 < keys2.size(); ++i2) {
                    RubyString candidateKey = keys2.eltInternal(i2).convertToString();
                    if (!StringOnlyRubyHash.equalIgnoreCase(context, candidateKey, key2)) continue;
                    actualKey = candidateKey;
                    break;
                }
            }
            return actualKey;
        }

        private static RubyString normalizeEnvString(ThreadContext context, RubyString key2, RubyString value2) {
            RubyString valueStr;
            Ruby runtime2 = context.runtime;
            if (Platform.IS_WINDOWS ? StringOnlyRubyHash.equalIgnoreCase(context, key2, RubyString.newString(context.runtime, PATH_BYTES)) : key2.getByteList().equal(PATH_BYTES)) {
                Encoding enc = runtime2.getEncodingService().getFileSystemEncoding();
                valueStr = EncodingUtils.strConvEnc(context, value2, value2.getEncoding(), enc);
                if (value2 == valueStr) {
                    valueStr = (RubyString)value2.dup();
                }
            } else {
                valueStr = RubyString.newString(runtime2, value2.toString(), runtime2.getEncodingService().getLocaleEncoding());
            }
            valueStr.setFrozen(true);
            return valueStr;
        }

        private static boolean equalIgnoreCase(ThreadContext context, RubyString str1, RubyString str2) {
            return ((RubyFixnum)str1.casecmp(context, str2)).isZero();
        }
    }

    public static class CaseInsensitiveStringOnlyRubyHash
    extends StringOnlyRubyHash {
        private static final ByteList ENV = new ByteList(new byte[]{69, 78, 86}, (Encoding)USASCIIEncoding.INSTANCE, false);

        public CaseInsensitiveStringOnlyRubyHash(Ruby runtime2, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime2, valueMap, defaultValue, updateRealENV);
        }

        @Override
        protected final boolean isCaseSensitive() {
            return false;
        }

        @Override
        public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
            IRubyObject val = super.op_aref(context, key2);
            val.setTaint(true);
            return val;
        }

        @Override
        @JRubyMethod(name={"to_s"})
        public RubyString to_s(ThreadContext context) {
            return RubyString.newStringShared(context.runtime, ENV);
        }

        @Override
        public IRubyObject to_s() {
            return RubyString.newStringShared(this.getRuntime(), ENV);
        }

        @JRubyMethod
        public RubyHash to_h() {
            return this.to_hash();
        }
    }
}

