/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import jnr.ffi.util.ref.FinalizableWeakReference;
import org.jruby.Ruby;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.jffi.AllocatedNativeMemoryIO;
import org.jruby.ext.ffi.jffi.BoundedNativeMemoryIO;
import org.jruby.ext.ffi.jffi.NativeFinalizer;

final class CachingNativeMemoryAllocator {
    protected static final com.kenai.jffi.MemoryIO IO = com.kenai.jffi.MemoryIO.getInstance();
    private static final Bucket[] buckets = new Bucket[32];
    private static final Map<AllocationGroup, Boolean> referenceSet = new ConcurrentHashMap<AllocationGroup, Boolean>();
    private static final ThreadLocal<Reference<Allocator>> currentAllocator = new ThreadLocal();

    CachingNativeMemoryAllocator() {
    }

    static int bucketIndex(int size2) {
        return Integer.numberOfTrailingZeros(size2);
    }

    static MemoryIO allocateAligned(Ruby runtime2, int size2, int align, boolean clear2) {
        Allocator allocator;
        if (size2 > 256 || align > 8) {
            return AllocatedNativeMemoryIO.allocateAligned(runtime2, size2, align, clear2);
        }
        Reference<Allocator> allocatorReference = currentAllocator.get();
        Allocator allocator2 = allocator = allocatorReference != null ? allocatorReference.get() : null;
        if (allocator == null) {
            allocator = new Allocator();
            currentAllocator.set(new SoftReference<Allocator>(allocator));
        }
        return allocator.allocate(runtime2, size2, clear2);
    }

    private static long align(long offset2, long align) {
        return offset2 + align - 1L & (align - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static int roundUpToPowerOf2(int n) {
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    static void clearMemory(long address2, int size2) {
        switch (size2) {
            case 1: {
                IO.putByte(address2, (byte)0);
                break;
            }
            case 2: {
                IO.putShort(address2, (short)0);
                break;
            }
            case 4: {
                IO.putInt(address2, 0);
                break;
            }
            case 8: {
                IO.putLong(address2, 0L);
                break;
            }
            default: {
                IO.setMemory(address2, (long)size2, (byte)0);
            }
        }
    }

    static {
        for (int i2 = 0; i2 < buckets.length; ++i2) {
            CachingNativeMemoryAllocator.buckets[i2] = new Bucket(1 << i2);
        }
    }

    private static final class Allocator {
        final AllocationGroup[] allocationGroups = new AllocationGroup[32];

        private Allocator() {
        }

        AllocatedMemoryIO allocate(Ruby runtime2, int size2, boolean clear2) {
            MemoryAllocation allocation;
            Object sentinel;
            int idx = CachingNativeMemoryAllocator.bucketIndex(CachingNativeMemoryAllocator.roundUpToPowerOf2(Math.max(8, size2)));
            AllocationGroup group2 = this.allocationGroups[idx];
            if (group2 == null || (sentinel = group2.get()) == null || (allocation = group2.allocate(clear2)) == null) {
                sentinel = new Object();
                this.allocationGroups[idx] = group2 = new AllocationGroup(buckets[idx].getMagazine(), sentinel);
                referenceSet.put(group2, Boolean.TRUE);
                allocation = group2.allocate(clear2);
            }
            return new AllocatedMemoryIO(runtime2, sentinel, allocation, size2);
        }
    }

    private static final class Bucket {
        final int size;
        final Set<CacheElement> cache = new HashSet<CacheElement>();

        Bucket(int size2) {
            this.size = CachingNativeMemoryAllocator.roundUpToPowerOf2(size2);
        }

        synchronized Magazine getMagazine() {
            Iterator<CacheElement> it = this.cache.iterator();
            while (it.hasNext()) {
                CacheElement e = it.next();
                it.remove();
                e.clear();
                if (e.disposed.getAndSet(true)) continue;
                return e.magazine;
            }
            return new Magazine(this);
        }

        synchronized void recycle(Magazine magazine) {
            this.cache.add(new CacheElement(magazine));
        }

        private synchronized void removeCacheElement(CacheElement e) {
            this.cache.remove(e);
        }

        final class CacheElement
        extends FinalizableWeakReference<Object> {
            private final Magazine magazine;
            private final AtomicBoolean disposed;

            CacheElement(Magazine magazine) {
                super(new Object(), NativeFinalizer.getInstance().getFinalizerQueue());
                this.disposed = new AtomicBoolean(false);
                this.magazine = magazine;
            }

            @Override
            public void finalizeReferent() {
                if (!this.disposed.getAndSet(true)) {
                    Bucket.this.removeCacheElement(this);
                    this.magazine.dispose();
                }
            }
        }
    }

    private static final class Magazine {
        static final int MAX_BYTES_PER_MAGAZINE = 16384;
        final Bucket bucket;
        private final MemoryAllocation[] allocations;
        private int nextIndex;
        private volatile boolean fragmented;

        Magazine(Bucket bucket) {
            this.bucket = bucket;
            this.allocations = new MemoryAllocation[16384 / bucket.size];
            this.nextIndex = 0;
        }

        MemoryAllocation allocate(boolean clear2) {
            long address2;
            if (this.nextIndex < this.allocations.length && this.allocations[this.nextIndex] != null) {
                MemoryAllocation allocation = this.allocations[this.nextIndex++];
                if (clear2) {
                    CachingNativeMemoryAllocator.clearMemory(allocation.address, this.bucket.size);
                }
                return allocation;
            }
            if (this.nextIndex >= this.allocations.length) {
                return null;
            }
            while ((address2 = IO.allocateMemory((long)this.bucket.size, clear2)) == 0L) {
                System.gc();
            }
            MemoryAllocation allocation = new MemoryAllocation(this, address2);
            this.allocations[this.nextIndex++] = allocation;
            return allocation;
        }

        void setFragmented() {
            this.fragmented = true;
        }

        synchronized void dispose() {
            for (int i2 = 0; i2 < this.allocations.length; ++i2) {
                MemoryAllocation m = this.allocations[i2];
                if (m == null || m.isUnmanaged()) continue;
                m.dispose();
            }
        }

        synchronized void recycle() {
            if (this.fragmented) {
                int size2 = this.bucket.size;
                for (int i2 = 0; i2 < this.allocations.length; ++i2) {
                    MemoryAllocation m = this.allocations[i2];
                    if (m == null) continue;
                    if (m.isUnmanaged()) {
                        this.allocations[i2] = null;
                        continue;
                    }
                    CachingNativeMemoryAllocator.clearMemory(this.allocations[i2].address, size2);
                }
                this.fragmented = false;
            }
            this.nextIndex = 0;
            this.bucket.recycle(this);
        }
    }

    private static final class MemoryAllocation {
        static final int UNMANAGED = 1;
        static final int RELEASED = 2;
        final Magazine magazine;
        final long address;
        volatile int flags;

        MemoryAllocation(Magazine magazine, long address2) {
            this.magazine = magazine;
            this.address = address2;
        }

        final void dispose() {
            IO.freeMemory(this.address);
        }

        final boolean isReleased() {
            return (this.flags & 2) != 0;
        }

        final boolean isUnmanaged() {
            return (this.flags & 1) != 0;
        }

        public void setAutoRelease(boolean autorelease2) {
            if ((this.flags & 2) == 0) {
                this.flags |= !autorelease2 ? 1 : 0;
            }
            if (!autorelease2) {
                this.magazine.setFragmented();
            }
        }

        final void free() {
            if ((this.flags & 2) == 0) {
                this.flags = 3;
                this.magazine.setFragmented();
                this.dispose();
            }
        }
    }

    private static final class AllocationGroup
    extends FinalizableWeakReference<Object> {
        final Magazine magazine;

        AllocationGroup(Magazine magazine, Object sentinel) {
            super(sentinel, NativeFinalizer.getInstance().getFinalizerQueue());
            this.magazine = magazine;
        }

        MemoryAllocation allocate(boolean clear2) {
            return this.magazine.allocate(clear2);
        }

        @Override
        public void finalizeReferent() {
            referenceSet.remove(this);
            this.magazine.recycle();
        }
    }

    static final class AllocatedMemoryIO
    extends BoundedNativeMemoryIO
    implements AllocatedDirectMemoryIO {
        private final MemoryAllocation allocation;
        private Object sentinel;

        private AllocatedMemoryIO(Ruby runtime2, Object sentinel, MemoryAllocation allocation, int size2) {
            super(runtime2, allocation.address, size2);
            this.sentinel = sentinel;
            this.allocation = allocation;
        }

        @Override
        public void free() {
            if (this.allocation.isReleased()) {
                throw this.getRuntime().newRuntimeError("memory already freed");
            }
            this.allocation.free();
            this.sentinel = null;
        }

        @Override
        public void setAutoRelease(boolean autorelease2) {
            this.allocation.setAutoRelease(autorelease2);
        }

        @Override
        public boolean isAutoRelease() {
            return !this.allocation.isUnmanaged();
        }
    }
}

