/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.Watchable;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jnr.constants.platform.OpenFlags;
import jnr.posix.POSIX;
import jnr.posix.util.Platform;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyDir;
import org.jruby.RubyEncoding;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.NotImplementedError;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PosixShim;

@JRubyClass(name={"File"}, parent="IO", include={"FileTest"})
public class RubyFile
extends RubyIO
implements EncodingCapable {
    static final ByteList SLASH = RubyInteger.singleCharByteList((byte)47);
    static final ByteList BACKSLASH = RubyInteger.singleCharByteList((byte)92);
    private static final ObjectAllocator FILE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyFile(runtime2, klass);
        }
    };
    private static final String URI_PREFIX_STRING = "^(uri|jar|file|classpath):([^:/]{2,}:([^:/]{2,}:)?)?";
    private static final Pattern ROOT_PATTERN = Pattern.compile("^(uri|jar|file|classpath):([^:/]{2,}:([^:/]{2,}:)?)?/?/?$");
    private static final int NULL_CHAR = 0;
    static final Pattern PROTOCOL_PATTERN = Pattern.compile("^(uri|jar|file|classpath):([^:/]{2,}:([^:/]{2,}:)?)?.*");
    private static final Pattern PROTOCOL_PREFIX_PATTERN = Pattern.compile("^(uri|jar|file|classpath):([^:/]{2,}:([^:/]{2,}:)?)?");
    private static final long serialVersionUID = 1L;
    public static final int LOCK_SH = 1;
    public static final int LOCK_EX = 2;
    public static final int LOCK_NB = 4;
    public static final int LOCK_UN = 8;
    private static final int FNM_NOESCAPE = 1;
    private static final int FNM_PATHNAME = 2;
    private static final int FNM_DOTMATCH = 4;
    private static final int FNM_CASEFOLD = 8;
    private static final int FNM_EXTGLOB = 16;
    private static final int FNM_SYSCASE = Platform.IS_WINDOWS ? 8 : 0;
    private static final String[] SLASHES = new String[]{"", "/", "//"};
    private static final Pattern URI_PREFIX = Pattern.compile("^(jar:)?[a-z]{2,}:(.*)");
    @Deprecated
    protected String path;

    public static RubyClass createFileClass(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyClass fileClass = runtime2.defineClass("File", runtime2.getIO(), FILE_ALLOCATOR);
        fileClass.defineAnnotatedMethods(RubyFile.class);
        fileClass.setClassIndex(ClassIndex.FILE);
        fileClass.setReifiedClass(RubyFile.class);
        fileClass.kindOf = new RubyModule.JavaClassKindOf(RubyFile.class);
        RubyString separator = RubyString.newString(runtime2, SLASH);
        separator.freeze(context);
        fileClass.defineConstant("SEPARATOR", separator);
        fileClass.defineConstant("Separator", separator);
        if (File.separatorChar == '\\') {
            RubyString altSeparator = RubyString.newString(runtime2, BACKSLASH);
            altSeparator.freeze(context);
            fileClass.defineConstant("ALT_SEPARATOR", altSeparator);
        } else {
            fileClass.defineConstant("ALT_SEPARATOR", context.nil);
        }
        RubyString pathSeparator = RubyString.newString(runtime2, RubyInteger.singleCharByteList((byte)File.pathSeparatorChar));
        pathSeparator.freeze(context);
        fileClass.defineConstant("PATH_SEPARATOR", pathSeparator);
        fileClass.getSingletonClass().defineAnnotatedMethods(RubyFileTest.FileTestFileMethods.class);
        RubyModule constants2 = fileClass.defineModuleUnder("Constants");
        constants2.setConstant("RDONLY", runtime2.newFixnum(OpenFlags.O_RDONLY.intValue()));
        constants2.setConstant("WRONLY", runtime2.newFixnum(OpenFlags.O_WRONLY.intValue()));
        constants2.setConstant("RDWR", runtime2.newFixnum(OpenFlags.O_RDWR.intValue()));
        constants2.setConstant("APPEND", runtime2.newFixnum(OpenFlags.O_APPEND.intValue()));
        constants2.setConstant("CREAT", runtime2.newFixnum(OpenFlags.O_CREAT.intValue()));
        constants2.setConstant("EXCL", runtime2.newFixnum(OpenFlags.O_EXCL.intValue()));
        if (OpenFlags.O_NONBLOCK.defined()) {
            if (!OpenFlags.O_NONBLOCK.defined()) {
                // empty if block
            }
            constants2.setConstant("NONBLOCK", runtime2.newFixnum(OpenFlags.O_NONBLOCK.intValue()));
        } else if (Platform.IS_WINDOWS) {
            constants2.setConstant("NONBLOCK", runtime2.newFixnum(1));
        }
        constants2.setConstant("TRUNC", runtime2.newFixnum(OpenFlags.O_TRUNC.intValue()));
        constants2.setConstant("NOCTTY", runtime2.newFixnum(OpenFlags.O_NOCTTY.intValue()));
        if (!OpenFlags.O_BINARY.defined()) {
            constants2.setConstant("BINARY", runtime2.newFixnum(0));
        } else {
            constants2.setConstant("BINARY", runtime2.newFixnum(OpenFlags.O_BINARY.intValue()));
        }
        constants2.setConstant("SHARE_DELETE", runtime2.newFixnum(0));
        if (OpenFlags.O_SYNC.defined()) {
            constants2.setConstant("SYNC", runtime2.newFixnum(OpenFlags.O_SYNC.intValue()));
        }
        if (OpenFlags.O_NOFOLLOW.defined()) {
            constants2.setConstant("NOFOLLOW", runtime2.newFixnum(OpenFlags.O_NOFOLLOW.intValue()));
        }
        if (OpenFlags.O_TMPFILE.defined()) {
            constants2.setConstant("TMPFILE", runtime2.newFixnum(OpenFlags.O_TMPFILE.intValue()));
        }
        constants2.setConstant("FNM_NOESCAPE", runtime2.newFixnum(1));
        constants2.setConstant("FNM_CASEFOLD", runtime2.newFixnum(8));
        constants2.setConstant("FNM_SYSCASE", runtime2.newFixnum(FNM_SYSCASE));
        constants2.setConstant("FNM_DOTMATCH", runtime2.newFixnum(4));
        constants2.setConstant("FNM_PATHNAME", runtime2.newFixnum(2));
        constants2.setConstant("FNM_EXTGLOB", runtime2.newFixnum(16));
        constants2.setConstant("LOCK_SH", runtime2.newFixnum(1));
        constants2.setConstant("LOCK_EX", runtime2.newFixnum(2));
        constants2.setConstant("LOCK_NB", runtime2.newFixnum(4));
        constants2.setConstant("LOCK_UN", runtime2.newFixnum(8));
        constants2.setConstant("NULL", runtime2.newString(RubyFile.getNullDevice()));
        runtime2.getIO().includeModule(constants2);
        if (Platform.IS_WINDOWS) {
            fileClass.searchMethod("readlink").setNotImplemented(true);
            fileClass.searchMethod("mkfifo").setNotImplemented(true);
        }
        if (!Platform.IS_BSD) {
            fileClass.getSingletonClass().searchMethod("lchmod").setNotImplemented(true);
        }
        return fileClass;
    }

    private static String getNullDevice() {
        String null_device = Platform.IS_WINDOWS ? "NUL" : "/dev/null";
        return null_device;
    }

    public RubyFile(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    RubyFile(Ruby runtime2, String path2, final Reader reader) {
        this(runtime2, path2, new InputStream(){

            @Override
            public int read() throws IOException {
                return reader.read();
            }
        });
    }

    public RubyFile(Ruby runtime2, String path2, InputStream in) {
        super(runtime2, runtime2.getFile(), Channels.newChannel(in));
        this.setPath(path2);
    }

    public RubyFile(Ruby runtime2, String path2, FileChannel channel) {
        super(runtime2, runtime2.getFile(), channel);
        this.setPath(path2);
    }

    @Override
    protected IRubyObject rbIoClose(ThreadContext context) {
        if (this.openFile.currentLock != null) {
            try {
                this.openFile.currentLock.release();
            }
            catch (IOException e) {
                throw context.runtime.newIOError(e.getMessage());
            }
        }
        return super.rbIoClose(context);
    }

    @JRubyMethod(required=1)
    public IRubyObject flock(ThreadContext context, IRubyObject operation) {
        if (Platform.IS_SOLARIS) {
            return this.callMethod(context, "flock", operation);
        }
        Ruby runtime2 = context.runtime;
        int op1 = RubyNumeric.num2int(operation);
        OpenFile fptr = this.getOpenFileChecked();
        if (fptr.isWritable()) {
            this.flushRaw(context, false);
        }
        block6: while (fptr.threadFlock(context, op1) < 0) {
            switch (fptr.errno()) {
                case EAGAIN: 
                case EACCES: 
                case EWOULDBLOCK: {
                    if ((op1 & 4) != 0) {
                        return runtime2.getFalse();
                    }
                    try {
                        context.getThread().sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        context.pollThreadEvents();
                    }
                    fptr.checkClosed();
                    continue block6;
                }
                case EINTR: {
                    continue block6;
                }
            }
            throw runtime2.newErrnoFromErrno(fptr.errno(), fptr.getPath());
        }
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=3, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject fd;
        if (this.openFile != null) {
            throw context.runtime.newRuntimeError("reinitializing File");
        }
        if (args2.length > 0 && args2.length <= 3 && !(fd = TypeConverter.convertToTypeWithCheck(context, args2[0], context.runtime.getFixnum(), RubyFile.sites((ThreadContext)context).to_int_checked)).isNil()) {
            if (args2.length == 1) {
                return super.initialize(context, fd, block);
            }
            if (args2.length == 2) {
                return super.initialize(context, fd, args2[1], block);
            }
            return super.initialize(context, fd, args2[1], args2[2], block);
        }
        return this.openFile(context, args2);
    }

    @JRubyMethod(required=1)
    public IRubyObject chmod(ThreadContext context, IRubyObject arg2) {
        this.checkClosed(context);
        int mode2 = (int)arg2.convertToInteger().getLongValue();
        String path2 = this.getPath();
        if (!new File(path2).exists()) {
            throw context.runtime.newErrnoENOENTError(path2);
        }
        return context.runtime.newFixnum(context.runtime.getPosix().chmod(path2, mode2));
    }

    @JRubyMethod(required=2)
    public IRubyObject chown(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        String path2;
        this.checkClosed(context);
        int owner2 = -1;
        if (!arg1.isNil()) {
            owner2 = RubyNumeric.num2int(arg1);
        }
        int group2 = -1;
        if (!arg2.isNil()) {
            group2 = RubyNumeric.num2int(arg2);
        }
        if (!new File(path2 = this.getPath()).exists()) {
            throw context.runtime.newErrnoENOENTError(path2);
        }
        return context.runtime.newFixnum(context.runtime.getPosix().chown(path2, owner2, group2));
    }

    @JRubyMethod
    public IRubyObject atime(ThreadContext context) {
        this.checkClosed(context);
        return context.runtime.newFileStat(this.getPath(), false).atime();
    }

    @JRubyMethod(name={"ctime"})
    public IRubyObject ctime(ThreadContext context) {
        this.checkClosed(context);
        return context.runtime.newFileStat(this.getPath(), false).ctime();
    }

    @JRubyMethod(name={"birthtime"})
    public IRubyObject birthtime(ThreadContext context) {
        this.checkClosed(context);
        FileTime btime = RubyFile.getBirthtimeWithNIO(this.getPath());
        if (btime != null) {
            return context.runtime.newTime(btime.toMillis());
        }
        return this.ctime(context);
    }

    public static final FileTime getBirthtimeWithNIO(String pathString) {
        Path path2 = Paths.get(pathString, new String[0]);
        PosixFileAttributeView view = Files.getFileAttributeView(path2, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        try {
            if (view != null) {
                return view.readAttributes().creationTime();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @JRubyMethod
    public IRubyObject lstat(ThreadContext context) {
        this.checkClosed(context);
        return context.runtime.newFileStat(this.getPath(), true);
    }

    @JRubyMethod
    public IRubyObject mtime(ThreadContext context) {
        this.checkClosed(context);
        return ((RubyFileStat)this.stat(context)).mtime();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject path(ThreadContext context, IRubyObject self2, IRubyObject str) {
        return StringSupport.checkEmbeddedNulls(context.runtime, RubyFile.get_path(context, str));
    }

    @JRubyMethod(name={"path", "to_path"})
    public IRubyObject path(ThreadContext context) {
        if ((this.openFile.getMode() & 0x410000) != 0) {
            throw context.runtime.newIOError("File is unnamed (TMPFILE?)");
        }
        String path2 = this.getPath();
        if (path2 != null) {
            RubyString newPath = context.runtime.newString(path2);
            newPath.setTaint(true);
            return newPath;
        }
        return context.nil;
    }

    @JRubyMethod(required=1)
    public IRubyObject truncate(ThreadContext context, IRubyObject len) {
        Ruby runtime2 = context.runtime;
        long pos2 = RubyNumeric.num2int(len);
        OpenFile fptr = this.getOpenFileChecked();
        if (!fptr.isWritable()) {
            throw runtime2.newIOError("not opened for writing");
        }
        this.flushRaw(context, false);
        if (pos2 < 0L) {
            throw runtime2.newErrnoEINVALError(this.openFile.getPath());
        }
        if (fptr.posix.ftruncate(fptr.fd(), pos2) < 0) {
            throw runtime2.newErrnoFromErrno(fptr.posix.getErrno(), fptr.getPath());
        }
        return RubyFixnum.zero(runtime2);
    }

    @Override
    public final IRubyObject inspect() {
        return this.inspect(this.metaClass.runtime.getCurrentContext());
    }

    @JRubyMethod
    public RubyString inspect(ThreadContext context) {
        String path2 = this.openFile.getPath();
        ByteList str = new ByteList((path2 == null ? 4 : path2.length()) + 8);
        str.append(35).append(60);
        str.append(this.getMetaClass().getRealClass().to_s().getByteList());
        str.append(58).append(path2 == null ? RubyNil.nilBytes : RubyEncoding.encodeUTF8(path2));
        if (!this.openFile.isOpen()) {
            str.append(32).append(40);
            str.append(99).append(108).append(111).append(115).append(101).append(100);
            str.append(41);
        }
        str.append(62);
        str.setEncoding((Encoding)UTF8Encoding.INSTANCE);
        return RubyString.newStringLight(context.runtime, str);
    }

    @JRubyMethod(meta=true)
    public static RubyString basename(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        return RubyFile.basenameImpl(context, (RubyClass)recv2, path2, null);
    }

    @JRubyMethod(meta=true)
    public static RubyString basename(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject ext2) {
        return RubyFile.basenameImpl(context, (RubyClass)recv2, path2, ext2 == context.nil ? null : ext2);
    }

    @Deprecated
    public static IRubyObject basename(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject ext2 = args2.length > 1 && args2[1] != context.nil ? args2[1] : null;
        return RubyFile.basenameImpl(context, (RubyClass)recv2, args2[0], ext2);
    }

    private static RubyString basenameImpl(ThreadContext context, RubyClass klass, IRubyObject path2, IRubyObject ext2) {
        char c;
        Ruby runtime2 = context.runtime;
        int separatorChar = RubyFile.getSeparatorChar(klass);
        int altSeparatorChar = RubyFile.getAltSeparatorChar(klass);
        RubyString origString = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, path2));
        Encoding origEncoding = origString.getEncoding();
        String name2 = origString.toString();
        if (name2.endsWith(".jar!/") || ROOT_PATTERN.matcher(name2).matches()) {
            return (RubyString)path2;
        }
        if (Platform.IS_WINDOWS && name2.length() > 1 && name2.charAt(1) == ':' && Character.isLetter(name2.charAt(0))) {
            switch (name2.length()) {
                case 2: {
                    return (RubyString)RubyString.newEmptyString(runtime2, origString.getEncoding()).infectBy(path2);
                }
                case 3: {
                    return RubyString.newString(runtime2, RubyString.encodeBytelist(name2.substring(2), origEncoding));
                }
            }
            switch (name2.charAt(2)) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    name2 = name2.substring(2);
                }
            }
        }
        while (name2.length() > 1 && (name2.charAt(name2.length() - 1) == separatorChar || name2.charAt(name2.length() - 1) == altSeparatorChar)) {
            name2 = name2.substring(0, name2.length() - 1);
        }
        int slashCount = 0;
        int length2 = name2.length();
        for (int i2 = length2 - 1; i2 >= 0 && ((c = name2.charAt(i2)) == separatorChar || c == altSeparatorChar); --i2) {
            ++slashCount;
        }
        if (slashCount > 0 && length2 > 1) {
            name2 = name2.substring(0, name2.length() - slashCount);
        }
        int index2 = name2.lastIndexOf(separatorChar);
        if (altSeparatorChar != 0) {
            index2 = Math.max(index2, name2.lastIndexOf(altSeparatorChar));
        }
        if (!StringSupport.contentEquals(name2, separatorChar) && !StringSupport.contentEquals(name2, altSeparatorChar) && index2 != -1) {
            name2 = name2.substring(index2 + 1);
        }
        if (ext2 != null) {
            String extStr = RubyString.stringValue(ext2).toString();
            if (".*".equals(extStr)) {
                index2 = name2.lastIndexOf(46);
                if (index2 > 0) {
                    name2 = name2.substring(0, index2);
                }
            } else if (name2.endsWith(extStr)) {
                name2 = name2.substring(0, name2.length() - extStr.length());
            }
        }
        return RubyString.newString(runtime2, RubyString.encodeBytelist(name2, origEncoding));
    }

    private static int getSeparatorChar(RubyClass File2) {
        RubyString sep = RubyString.stringValue(File2.getConstant("SEPARATOR"));
        return sep.getByteList().get(0);
    }

    private static int getAltSeparatorChar(RubyClass File2) {
        IRubyObject sep = File2.getConstant("ALT_SEPARATOR");
        if (sep instanceof RubyString) {
            return ((RubyString)sep).getByteList().get(0);
        }
        return 0;
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject chmod(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        int count2 = 0;
        RubyInteger mode2 = args2[0].convertToInteger();
        for (int i2 = 1; i2 < args2.length; ++i2) {
            JRubyFile filename2 = RubyFile.file(args2[i2]);
            if (!filename2.exists()) {
                throw runtime2.newErrnoENOENTError(filename2.toString());
            }
            if (0 != runtime2.getPosix().chmod(filename2.getAbsolutePath(), (int)mode2.getLongValue())) {
                throw runtime2.newErrnoFromLastPOSIXErrno();
            }
            ++count2;
        }
        return runtime2.newFixnum(count2);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject chown(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        int count2 = 0;
        int owner2 = -1;
        if (!args2[0].isNil()) {
            owner2 = RubyNumeric.num2int(args2[0]);
        }
        int group2 = -1;
        if (!args2[1].isNil()) {
            group2 = RubyNumeric.num2int(args2[1]);
        }
        for (int i2 = 2; i2 < args2.length; ++i2) {
            JRubyFile filename2 = RubyFile.file(args2[i2]);
            if (!filename2.exists()) {
                throw runtime2.newErrnoENOENTError(filename2.toString());
            }
            if (0 != runtime2.getPosix().chown(filename2.getAbsolutePath(), owner2, group2)) {
                throw runtime2.newErrnoFromLastPOSIXErrno();
            }
            ++count2;
        }
        return runtime2.newFixnum(count2);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject dirname(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        RubyString filename2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, arg2));
        String jfilename = filename2.asJavaString();
        return runtime2.newString(RubyFile.dirname(context, jfilename)).infectBy(filename2);
    }

    public static String dirname(ThreadContext context, String filename2) {
        char endChar;
        String result2;
        boolean startsWithDriveLetterOnWindows;
        boolean startsWithUNCOnWindows;
        int idx;
        String separator;
        char separatorChar;
        RubyClass File2 = context.runtime.getFile();
        IRubyObject sep = File2.getConstant("SEPARATOR");
        if (sep instanceof RubyString && ((RubyString)sep).size() == 1) {
            separatorChar = ((RubyString)sep).getByteList().charAt(0);
            separator = separatorChar == '/' ? "/" : String.valueOf(separatorChar);
        } else {
            separator = sep.toString();
            separatorChar = separator.isEmpty() ? (char)'\u0000' : separator.charAt(0);
        }
        String altSeparator = null;
        char altSeparatorChar = '\u0000';
        IRubyObject rbAltSeparator = File2.getConstantNoConstMissing("ALT_SEPARATOR");
        if (rbAltSeparator != null && rbAltSeparator != context.nil && !(altSeparator = rbAltSeparator.toString()).isEmpty()) {
            altSeparatorChar = altSeparator.charAt(0);
        }
        String name2 = filename2;
        if (altSeparator != null) {
            name2 = RubyFile.replace(filename2, altSeparator, separator);
        }
        boolean startsWithSeparator = false;
        if (!name2.isEmpty()) {
            boolean bl = startsWithSeparator = name2.charAt(0) == separatorChar;
        }
        if ((idx = name2.indexOf(".jar!")) != -1 && name2.startsWith(separator, idx + 5)) {
            int start2 = name2.indexOf("!" + separator) + 1;
            String path2 = RubyFile.dirname(context, name2.substring(start2));
            if (path2.equals(".") || path2.equals(separator)) {
                path2 = "";
            }
            return name2.substring(0, start2) + path2;
        }
        if (PROTOCOL_PATTERN.matcher(name2).matches()) {
            int start3 = name2.indexOf(":" + separator) + 2;
            String path3 = RubyFile.dirname(context, name2.substring(start3));
            if (path3.equals(".")) {
                path3 = "";
            }
            return name2.substring(0, start3) + path3;
        }
        int minPathLength = 1;
        boolean trimmedSlashes = false;
        boolean bl = startsWithUNCOnWindows = Platform.IS_WINDOWS && StringSupport.startsWith(name2, separatorChar, separatorChar);
        if (startsWithUNCOnWindows) {
            minPathLength = 2;
        }
        if (startsWithDriveLetterOnWindows = RubyFile.startsWithDriveLetterOnWindows(name2)) {
            minPathLength = 3;
        }
        while (name2.length() > minPathLength && name2.charAt(name2.length() - 1) == separatorChar) {
            trimmedSlashes = true;
            name2 = name2.substring(0, name2.length() - 1);
        }
        if (startsWithDriveLetterOnWindows && name2.length() == 2) {
            result2 = trimmedSlashes ? filename2.substring(0, 3) : filename2.substring(0, 2) + '.';
        } else {
            int index2 = name2.lastIndexOf(separator);
            if (index2 == -1) {
                if (startsWithDriveLetterOnWindows) {
                    return filename2.substring(0, 2) + '.';
                }
                return ".";
            }
            if (index2 == 0) {
                return filename2.substring(0, 1);
            }
            if (startsWithDriveLetterOnWindows && index2 == 2) {
                ++index2;
            }
            if (startsWithUNCOnWindows) {
                index2 = filename2.length();
                List<String> split2 = StringSupport.split(name2, separatorChar);
                int pathSectionCount = 0;
                for (int i2 = 0; i2 < split2.size(); ++i2) {
                    if (split2.get(i2).isEmpty()) continue;
                    ++pathSectionCount;
                }
                if (pathSectionCount > 2) {
                    index2 = name2.lastIndexOf(separator);
                }
            }
            result2 = filename2.substring(0, index2);
        }
        if (startsWithSeparator && result2.length() > minPathLength) {
            while (result2.length() > minPathLength && (result2.charAt(minPathLength) == separatorChar || altSeparator != null && result2.charAt(minPathLength) == altSeparatorChar)) {
                result2 = result2.substring(1, result2.length());
            }
        }
        while (result2.length() > minPathLength && ((endChar = result2.charAt(result2.length() - 1)) == separatorChar || altSeparator != null && endChar == altSeparatorChar)) {
            result2 = result2.substring(0, result2.length() - 1);
        }
        return result2;
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject extname(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        String filename2 = RubyFile.basename(context, recv2, arg2).getUnicodeValue();
        int dotIndex = filename2.lastIndexOf(46);
        if (dotIndex > 0 && dotIndex != filename2.length() - 1) {
            return RubyString.newString(context.runtime, filename2.substring(dotIndex));
        }
        return RubyString.newEmptyString(context.runtime);
    }

    @JRubyMethod(name={"expand_path"}, required=1, optional=1, meta=true)
    public static IRubyObject expand_path(ThreadContext context, IRubyObject recv2, IRubyObject ... args2) {
        return RubyFile.expandPathInternal(context, args2, true, false);
    }

    @Deprecated
    public static IRubyObject expand_path19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyFile.expand_path(context, recv2, args2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject absolute_path(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyFile.expandPathInternal(context, args2, false, false);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject realdirpath(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyFile.expandPathInternal(context, args2, false, true);
    }

    public static IRubyObject realpath(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        RubyString file2 = RubyFile.expandPathInternal(context, args2, false, true);
        if (!RubyFileTest.exist(context, file2)) {
            throw context.runtime.newErrnoENOENTError(file2.toString());
        }
        return file2;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject realpath(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        RubyString file2 = StringSupport.checkEmbeddedNulls(context.runtime, RubyFile.get_path(context, path2));
        if (!RubyFileTest.exist(context, file2 = RubyFile.expandPathInternal(context, file2, null, false, true))) {
            throw context.runtime.newErrnoENOENTError(file2.toString());
        }
        return file2;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject realpath(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject cwd) {
        RubyString file2 = StringSupport.checkEmbeddedNulls(context.runtime, RubyFile.get_path(context, path2));
        RubyString wd = StringSupport.checkEmbeddedNulls(context.runtime, RubyFile.get_path(context, cwd));
        if (!RubyFileTest.exist(context, file2 = RubyFile.expandPathInternal(context, file2, wd, false, true))) {
            throw context.runtime.newErrnoENOENTError(file2.toString());
        }
        return file2;
    }

    @JRubyMethod(name={"fnmatch", "fnmatch?"}, required=2, optional=1, meta=true)
    public static IRubyObject fnmatch(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        int flags2 = args2.length == 3 ? RubyNumeric.num2int(args2[2]) : 0;
        boolean braces_match = false;
        boolean extglob = (flags2 & 0x10) != 0;
        ByteList pattern = StringSupport.checkEmbeddedNulls(runtime2, args2[0].convertToString()).getByteList();
        ByteList path2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, args2[1])).getByteList();
        if (extglob) {
            String spattern = args2[0].asJavaString();
            ArrayList<String> patterns = Dir.braces(spattern, flags2, new ArrayList<String>());
            ArrayList<Boolean> matches = new ArrayList<Boolean>();
            for (int i2 = 0; i2 < patterns.size(); ++i2) {
                String p2 = patterns.get(i2);
                boolean match2 = RubyFile.dir_fnmatch(new ByteList(p2.getBytes()), path2, flags2);
                matches.add(match2);
            }
            braces_match = matches.contains(true);
        }
        if (braces_match || RubyFile.dir_fnmatch(pattern, path2, flags2)) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    private static boolean dir_fnmatch(ByteList pattern, ByteList path2, int flags2) {
        return Dir.fnmatch(pattern.getUnsafeBytes(), pattern.getBegin(), pattern.getBegin() + pattern.getRealSize(), path2.getUnsafeBytes(), path2.getBegin(), path2.getBegin() + path2.getRealSize(), flags2) == 0;
    }

    @JRubyMethod(name={"ftype"}, required=1, meta=true)
    public static IRubyObject ftype(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = context.runtime;
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, filename2));
        return runtime2.newFileStat(path2.getUnicodeValue(), true).ftype();
    }

    @JRubyMethod(rest=true, meta=true)
    public static RubyString join(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyFile.doJoin(context, recv2, args2);
    }

    @JRubyMethod(name={"lstat"}, required=1, meta=true)
    public static IRubyObject lstat(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = context.runtime;
        String f = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, filename2)).getUnicodeValue();
        return runtime2.newFileStat(f, true);
    }

    @JRubyMethod(name={"stat"}, required=1, meta=true)
    public static IRubyObject stat(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = context.runtime;
        String f = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, filename2)).getUnicodeValue();
        return runtime2.newFileStat(f, false);
    }

    @JRubyMethod(name={"atime"}, required=1, meta=true)
    public static IRubyObject atime(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = context.runtime;
        String f = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, filename2)).getUnicodeValue();
        return runtime2.newFileStat(f, false).atime();
    }

    @JRubyMethod(name={"ctime"}, required=1, meta=true)
    public static IRubyObject ctime(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = context.runtime;
        String f = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, filename2)).getUnicodeValue();
        return runtime2.newFileStat(f, false).ctime();
    }

    @JRubyMethod(name={"birthtime"}, required=1, meta=true)
    public static IRubyObject birthtime(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = context.runtime;
        String f = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, filename2)).getUnicodeValue();
        return runtime2.newFileStat(f, false).birthtime();
    }

    @JRubyMethod(required=1, rest=true, meta=true)
    public static IRubyObject lchmod(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        int count2 = 0;
        RubyInteger mode2 = args2[0].convertToInteger();
        for (int i2 = 1; i2 < args2.length; ++i2) {
            JRubyFile file2 = RubyFile.file(args2[i2]);
            if (0 != runtime2.getPosix().lchmod(file2.toString(), (int)mode2.getLongValue())) {
                throw runtime2.newErrnoFromLastPOSIXErrno();
            }
            ++count2;
        }
        return runtime2.newFixnum(count2);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject lchown(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        int owner2 = !args2[0].isNil() ? RubyNumeric.num2int(args2[0]) : -1;
        int group2 = !args2[1].isNil() ? RubyNumeric.num2int(args2[1]) : -1;
        int count2 = 0;
        for (int i2 = 2; i2 < args2.length; ++i2) {
            JRubyFile file2 = RubyFile.file(args2[i2]);
            if (0 != runtime2.getPosix().lchown(file2.toString(), owner2, group2)) {
                throw runtime2.newErrnoFromLastPOSIXErrno();
            }
            ++count2;
        }
        return runtime2.newFixnum(count2);
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject link(ThreadContext context, IRubyObject recv2, IRubyObject from, IRubyObject to) {
        Ruby runtime2 = context.runtime;
        String fromStr = RubyFile.file(from).toString();
        String toStr = RubyFile.file(to).toString();
        int ret = runtime2.getPosix().link(fromStr, toStr);
        if (ret != 0) {
            if (runtime2.getPosix().isNative()) {
                throw runtime2.newErrnoFromInt(runtime2.getPosix().errno(), String.format("(%s, %s)", fromStr, toStr));
            }
            throw runtime2.newErrnoEEXISTError(fromStr + " or " + toStr);
        }
        return runtime2.newFixnum(ret);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject mtime(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = context.runtime;
        String f = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, filename2)).getUnicodeValue();
        return runtime2.newFileStat(f, false).mtime();
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject rename(ThreadContext context, IRubyObject recv2, IRubyObject oldName, IRubyObject newName) {
        Ruby runtime2 = context.runtime;
        RubyString oldNameString = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, oldName));
        RubyString newNameString = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, newName));
        String newNameJavaString = newNameString.getUnicodeValue();
        String oldNameJavaString = oldNameString.getUnicodeValue();
        JRubyFile oldFile = JRubyFile.create(runtime2.getCurrentDirectory(), oldNameJavaString);
        JRubyFile newFile = JRubyFile.create(runtime2.getCurrentDirectory(), newNameJavaString);
        boolean isOldSymlink = RubyFileTest.symlink_p(recv2, oldNameString).isTrue();
        if (!oldFile.exists() && !isOldSymlink || !newFile.getParentFile().exists()) {
            throw runtime2.newErrnoENOENTError(oldNameJavaString + " or " + newNameJavaString);
        }
        JRubyFile dest = JRubyFile.create(runtime2.getCurrentDirectory(), newNameJavaString);
        if (oldFile.renameTo((File)((Object)dest))) {
            return RubyFixnum.zero(runtime2);
        }
        if (newFile.exists()) {
            runtime2.getPosix().chmod(newNameJavaString, 438);
            newFile.delete();
        }
        Path oldPath = Paths.get(oldFile.toURI());
        Path destPath = Paths.get(dest.getAbsolutePath(), new String[0]);
        try {
            Files.move(oldPath, destPath, StandardCopyOption.ATOMIC_MOVE);
            return RubyFixnum.zero(runtime2);
        }
        catch (IOException ioe) {
            throw Helpers.newIOErrorFromException(runtime2, ioe);
        }
    }

    @JRubyMethod(required=1, meta=true)
    public static RubyArray split(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        RubyString filename2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, arg2));
        return runtime2.newArray(RubyFile.dirname(context, recv2, filename2), (IRubyObject)RubyFile.basename(context, recv2, filename2));
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject symlink(ThreadContext context, IRubyObject recv2, IRubyObject from, IRubyObject to) {
        Ruby runtime2 = context.runtime;
        RubyString fromStr = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, from));
        RubyString toStr = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, to));
        String tovalue = toStr.getUnicodeValue();
        tovalue = JRubyFile.create(runtime2.getCurrentDirectory(), tovalue).getAbsolutePath();
        try {
            if (runtime2.getPosix().symlink(fromStr.getUnicodeValue(), tovalue) == -1) {
                if (runtime2.getPosix().isNative()) {
                    throw runtime2.newErrnoFromInt(runtime2.getPosix().errno(), String.format("(%s, %s)", fromStr, toStr));
                }
                throw runtime2.newErrnoEEXISTError(String.format("(%s, %s)", fromStr, toStr));
            }
        }
        catch (UnsatisfiedLinkError ule) {
            throw runtime2.newNotImplementedError("symlink() function is unimplemented on this machine");
        }
        return RubyFixnum.zero(runtime2);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject readlink(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        Ruby runtime2 = context.runtime;
        if (Platform.IS_WINDOWS) {
            throw runtime2.newNotImplementedError("readlink");
        }
        JRubyFile link2 = RubyFile.file(path2);
        try {
            String realPath = runtime2.getPosix().readlink(link2.toString());
            if (realPath == null) {
                throw runtime2.newErrnoFromLastPOSIXErrno();
            }
            return RubyString.newString(runtime2, realPath, runtime2.getEncodingService().getFileSystemEncoding());
        }
        catch (IOException e) {
            throw runtime2.newIOError(e.getMessage());
        }
    }

    public static IRubyObject truncate(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyFile.truncate19(context, recv2, arg1, arg2);
    }

    @JRubyMethod(name={"truncate"}, required=2, meta=true)
    public static IRubyObject truncate19(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        RubyString path2 = StringSupport.checkEmbeddedNulls(context.runtime, RubyFile.get_path(context, arg1));
        return RubyFile.truncateCommon(context, recv2, path2, arg2);
    }

    @JRubyMethod(meta=true, optional=1)
    public static IRubyObject umask(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int oldMask;
        Ruby runtime2 = context.runtime;
        if (args2.length == 0) {
            oldMask = PosixShim.umask(runtime2.getPosix());
        } else if (args2.length == 1) {
            int newMask = (int)args2[0].convertToInteger().getLongValue();
            oldMask = PosixShim.umask(runtime2.getPosix(), newMask);
        } else {
            throw runtime2.newArgumentError("wrong number of arguments");
        }
        return runtime2.newFixnum(oldMask);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject lutime(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        long[] atimeval = null;
        long[] mtimeval = null;
        if (args2[0] != context.nil || args2[1] != context.nil) {
            atimeval = RubyFile.extractTimespec(context, args2[0]);
            mtimeval = RubyFile.extractTimespec(context, args2[1]);
        }
        int j = args2.length;
        for (int i2 = 2; i2 < j; ++i2) {
            RubyString filename2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, args2[i2]));
            JRubyFile fileToTouch = JRubyFile.create(runtime2.getCurrentDirectory(), filename2.getUnicodeValue());
            if (!fileToTouch.exists()) {
                throw runtime2.newErrnoENOENTError(filename2.toString());
            }
            int result2 = runtime2.getPosix().lutimes(fileToTouch.getAbsolutePath(), atimeval, mtimeval);
            if (result2 != -1) continue;
            throw runtime2.newErrnoFromInt(runtime2.getPosix().errno());
        }
        return runtime2.newFixnum(args2.length - 2);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject utime(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        long[] atimespec = null;
        long[] mtimespec = null;
        if (args2[0] != context.nil || args2[1] != context.nil) {
            atimespec = RubyFile.extractTimespec(context, args2[0]);
            mtimespec = RubyFile.extractTimespec(context, args2[1]);
        }
        int j = args2.length;
        for (int i2 = 2; i2 < j; ++i2) {
            int result2;
            RubyString filename2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, args2[i2]));
            JRubyFile fileToTouch = JRubyFile.create(runtime2.getCurrentDirectory(), filename2.getUnicodeValue());
            if (!fileToTouch.exists()) {
                throw runtime2.newErrnoENOENTError(filename2.toString());
            }
            try {
                result2 = runtime2.getPosix().utimensat(0, fileToTouch.getAbsolutePath(), atimespec, mtimespec, 0);
            }
            catch (NotImplementedError re) {
                result2 = runtime2.getPosix().utimes(fileToTouch.getAbsolutePath(), atimespec, mtimespec);
                long[] atimeval = RubyFile.convertTimespecToTimeval(atimespec);
                long[] mtimeval = RubyFile.convertTimespecToTimeval(mtimespec);
                result2 = runtime2.getPosix().utimes(fileToTouch.getAbsolutePath(), atimeval, mtimeval);
            }
            if (result2 != -1) continue;
            throw runtime2.newErrnoFromInt(runtime2.getPosix().errno());
        }
        return runtime2.newFixnum(args2.length - 2);
    }

    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject delete(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubyString filename2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, args2[i2]));
            JRubyFile file2 = JRubyFile.create(runtime2.getCurrentDirectory(), filename2.getUnicodeValue());
            if (!file2.exists() && !RubyFile.isSymlink(context, file2)) {
                throw runtime2.newErrnoENOENTError(filename2.getUnicodeValue());
            }
            if (file2.isDirectory() && !RubyFile.isSymlink(context, file2)) {
                throw runtime2.newErrnoEISDirError(filename2.getUnicodeValue());
            }
            if (file2.delete()) continue;
            throw runtime2.newErrnoEACCESError(filename2.getUnicodeValue());
        }
        return runtime2.newFixnum(args2.length);
    }

    private static boolean isSymlink(ThreadContext context, JRubyFile file2) {
        return FileResource.wrap(context.runtime.getPosix(), file2).isSymLink();
    }

    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject unlink(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        POSIX posix = runtime2.getPosix();
        if (!posix.isNative() || Platform.IS_WINDOWS) {
            return RubyFile.delete(context, recv2, args2);
        }
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubyString filename2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, args2[i2]));
            JRubyFile lToDelete = JRubyFile.create(runtime2.getCurrentDirectory(), filename2.getUnicodeValue());
            if (posix.unlink((CharSequence)lToDelete.getAbsolutePath()) >= 0) continue;
            throw runtime2.newErrnoFromInt(posix.errno());
        }
        return runtime2.newFixnum(args2.length);
    }

    public static IRubyObject unlink(ThreadContext context, IRubyObject ... args2) {
        return RubyFile.unlink(context, (IRubyObject)context.runtime.getFile(), args2);
    }

    @JRubyMethod
    public IRubyObject size(ThreadContext context) {
        return RubyFixnum.newFixnum(context.runtime, this.getSize(context));
    }

    final long getSize(ThreadContext context) {
        OpenFile fptr = this.getOpenFileChecked();
        if ((fptr.getMode() & 2) != 0) {
            this.flushRaw(context, false);
        }
        return fptr.posix.size(fptr.fd());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject mkfifo(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        if (Platform.IS_WINDOWS) {
            throw context.runtime.newNotImplementedError("mkfifo");
        }
        return RubyFile.mkfifo(context, RubyFile.get_path(context, path2), 438);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject mkfifo(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject mode2) {
        if (Platform.IS_WINDOWS) {
            throw context.runtime.newNotImplementedError("mkfifo");
        }
        return RubyFile.mkfifo(context, RubyFile.get_path(context, path2), RubyNumeric.num2int(mode2));
    }

    public static IRubyObject mkfifo(ThreadContext context, RubyString path2, int mode2) {
        Ruby runtime2 = context.runtime;
        String decodedPath = JRubyFile.createResource(runtime2, path2.toString()).absolutePath();
        if (runtime2.getPosix().mkfifo(decodedPath, mode2) != 0) {
            throw runtime2.newErrnoFromInt(runtime2.getPosix().errno(), decodedPath);
        }
        return RubyFixnum.zero(runtime2);
    }

    public String getPath() {
        if (this.openFile == null) {
            return null;
        }
        return this.openFile.getPath();
    }

    private void setPath(String path2) {
        if (this.openFile == null) {
            return;
        }
        this.openFile.setPath(path2);
    }

    @Override
    public Encoding getEncoding() {
        return null;
    }

    @Override
    public void setEncoding(Encoding encoding2) {
    }

    protected IRubyObject openFile(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        RubyString filename2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, args2[0]));
        this.setPath(RubyFile.adjustRootPathOnWindows(runtime2, filename2.asJavaString(), runtime2.getCurrentDirectory()));
        Object pm = EncodingUtils.vmodeVperm(null, null);
        IRubyObject options2 = context.nil;
        switch (args2.length) {
            case 1: {
                break;
            }
            case 2: {
                IRubyObject test2 = TypeConverter.checkHashType(runtime2, args2[1]);
                if (test2 instanceof RubyHash) {
                    options2 = test2;
                    break;
                }
                EncodingUtils.vmode(pm, args2[1]);
                break;
            }
            case 3: {
                IRubyObject test2 = TypeConverter.checkHashType(runtime2, args2[2]);
                if (test2 instanceof RubyHash) {
                    options2 = test2;
                } else {
                    EncodingUtils.vperm(pm, args2[2]);
                }
                EncodingUtils.vmode(pm, args2[1]);
                break;
            }
            case 4: {
                if (!args2[3].isNil() && (options2 = TypeConverter.convertToTypeWithCheck(context, args2[3], context.runtime.getHash(), RubyFile.sites((ThreadContext)context).to_hash_checked)).isNil()) {
                    throw runtime2.newArgumentError(4, 1, 3);
                }
                EncodingUtils.vperm(pm, args2[2]);
                EncodingUtils.vmode(pm, args2[1]);
            }
        }
        int[] oflags_p = new int[]{0};
        int[] fmode_p = new int[]{0};
        IOEncodable.ConvConfig convconfig = new IOEncodable.ConvConfig();
        EncodingUtils.extractModeEncoding(context, convconfig, pm, options2, oflags_p, fmode_p);
        int perm = EncodingUtils.vperm(pm) != null && !EncodingUtils.vperm(pm).isNil() ? RubyNumeric.num2int(EncodingUtils.vperm(pm)) : 438;
        return this.fileOpenGeneric(context, filename2, oflags_p[0], fmode_p[0], convconfig, perm);
    }

    public IRubyObject fileOpenGeneric(ThreadContext context, IRubyObject filename2, int oflags, int fmode, IOEncodable convConfig, int perm) {
        if (convConfig == null) {
            convConfig = new IOEncodable.ConvConfig();
            EncodingUtils.ioExtIntToEncs(context, convConfig, null, null, fmode);
            convConfig.setEcflags(0);
            convConfig.setEcopts(context.nil);
        }
        int[] fmode_p = new int[]{fmode};
        EncodingUtils.validateEncodingBinmode(context, fmode_p, convConfig.getEcflags(), convConfig);
        OpenFile fptr = this.MakeOpenFile();
        fptr.setMode(fmode_p[0]);
        fptr.encs.copy(convConfig);
        fptr.setPath(RubyFile.adjustRootPathOnWindows(context.runtime, RubyFile.get_path(context, filename2).asJavaString(), this.getRuntime().getCurrentDirectory()));
        fptr.setFD(RubyFile.sysopen(context.runtime, fptr.getPath(), oflags, perm));
        fptr.checkTTY();
        if ((fmode_p[0] & 0x100000) != 0) {
            EncodingUtils.ioSetEncodingByBOM(context, this);
        }
        return this;
    }

    public static RubyString get_path(ThreadContext context, IRubyObject path2) {
        if (path2 instanceof RubyString) {
            return StringSupport.checkEmbeddedNulls(context.runtime, path2);
        }
        JavaSites.FileSites sites = RubyFile.sites(context);
        if (sites.respond_to_to_path.respondsTo(context, path2, path2, true)) {
            path2 = sites.to_path.call(context, path2, path2);
        }
        return RubyFile.filePathConvert(context, path2.convertToString());
    }

    private static RubyString filePathConvert(ThreadContext context, RubyString path2) {
        StringSupport.checkEmbeddedNulls(context.runtime, path2.convertToString());
        if (!Platform.IS_WINDOWS) {
            Ruby runtime2 = context.getRuntime();
            EncodingService encodingService = runtime2.getEncodingService();
            Encoding pathEncoding = path2.getEncoding();
            if (runtime2.getDefaultInternalEncoding() != null && pathEncoding != encodingService.getUSAsciiEncoding() && pathEncoding != encodingService.getAscii8bitEncoding() && pathEncoding != encodingService.getFileSystemEncoding() && !path2.isAsciiOnly()) {
                path2 = EncodingUtils.strConvEnc(context, path2, pathEncoding, encodingService.getFileSystemEncoding());
            }
        }
        return path2;
    }

    public static FileResource fileResource(ThreadContext context, IRubyObject pathOrFile) {
        Ruby runtime2 = context.runtime;
        if (pathOrFile instanceof RubyFile) {
            return JRubyFile.createResource(runtime2, ((RubyFile)pathOrFile).getPath());
        }
        if (pathOrFile instanceof RubyIO) {
            return JRubyFile.createResource(runtime2, ((RubyIO)pathOrFile).openFile.getPath());
        }
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, pathOrFile));
        return JRubyFile.createResource(runtime2, path2.toString());
    }

    public static FileResource fileResource(IRubyObject pathOrFile) {
        Ruby runtime2 = pathOrFile.getRuntime();
        if (pathOrFile instanceof RubyIO) {
            return JRubyFile.createResource(runtime2, ((RubyIO)pathOrFile).getOpenFileChecked().getPath());
        }
        ThreadContext context = runtime2.getCurrentContext();
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime2, RubyFile.get_path(context, pathOrFile));
        return JRubyFile.createResource(runtime2, path2.toString());
    }

    @Deprecated
    public static JRubyFile file(IRubyObject pathOrFile) {
        return RubyFile.fileResource(pathOrFile).unwrap(JRubyFile.class);
    }

    @Override
    public String toString() {
        return "RubyFile(" + this.openFile.getPath() + ", " + this.openFile.getMode() + ')';
    }

    private static ZipEntry getFileEntry(ZipFile jar, String path2, String prefixForNoEntry) throws IOException {
        ZipEntry entry = jar.getEntry(path2);
        if (entry == null) {
            path2 = new File(path2).getCanonicalPath().substring(prefixForNoEntry.length() + 1);
            entry = jar.getEntry(StringSupport.replaceAll(path2, "\\\\", "/").toString());
        }
        return entry;
    }

    @Deprecated
    public static ZipEntry getDirOrFileEntry(String jar, String path2) throws IOException {
        return RubyFile.getDirOrFileEntry(new JarFile(jar), path2);
    }

    @Deprecated
    public static ZipEntry getDirOrFileEntry(ZipFile jar, String path2) throws IOException {
        String dirPath = path2 + '/';
        ZipEntry entry = jar.getEntry(dirPath);
        if (entry == null) {
            if (dirPath.length() == 1) {
                return new ZipEntry(dirPath);
            }
            String prefix = new File(".").getCanonicalPath();
            entry = jar.getEntry(new File(dirPath).getCanonicalPath().substring(prefix.length() + 1).replaceAll("\\\\", "/"));
            if (entry == null) {
                Enumeration<? extends ZipEntry> entries2 = jar.entries();
                while (entries2.hasMoreElements()) {
                    String zipEntry = entries2.nextElement().getName();
                    if (!zipEntry.startsWith(dirPath)) continue;
                    return new ZipEntry(dirPath);
                }
            }
            if (entry == null) {
                entry = RubyFile.getFileEntry(jar, path2, prefix);
            }
        }
        return entry;
    }

    private static boolean isAbsolutePath(String path2) {
        return path2 != null && path2.length() > 1 && path2.charAt(0) == '/' || RubyFile.startsWithDriveLetterOnWindows(path2);
    }

    private static boolean isWindowsDriveLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean startsWithDriveLetterOnWindows(String path2) {
        return RubyFile.startsWithDriveLetterOnWindows((CharSequence)path2);
    }

    static boolean startsWithDriveLetterOnWindows(CharSequence path2) {
        return path2 != null && Platform.IS_WINDOWS && (path2.length() > 1 && path2.charAt(0) == '/' ? path2.length() > 2 && RubyFile.isWindowsDriveLetter(path2.charAt(1)) && path2.charAt(2) == ':' : path2.length() > 1 && RubyFile.isWindowsDriveLetter(path2.charAt(0)) && path2.charAt(1) == ':');
    }

    static String adjustRootPathOnWindows(Ruby runtime2, String path2, String dir) {
        if (path2 == null || !Platform.IS_WINDOWS) {
            return path2;
        }
        if (StringSupport.startsWith((CharSequence)path2, '/') && (path2.length() <= 2 || path2.charAt(2) != ':') || StringSupport.startsWith((CharSequence)path2, '\\')) {
            if (path2.length() > 1 && (path2.charAt(1) == '/' || path2.charAt(1) == '\\')) {
                return path2;
            }
            if (!RubyFile.startsWithDriveLetterOnWindows(dir)) {
                dir = runtime2.getCurrentDirectory();
            }
            if (dir.length() >= 2) {
                path2 = dir.substring(0, 2) + path2;
            }
        } else if (RubyFile.startsWithDriveLetterOnWindows(path2) && path2.length() == 2) {
            path2 = path2 + '/';
        }
        return path2;
    }

    private static long[] extractTimespec(ThreadContext context, IRubyObject value2) {
        long[] timespec = new long[2];
        if (value2 instanceof RubyFloat) {
            timespec[0] = Platform.IS_32_BIT ? (long)RubyNumeric.num2int(value2) : RubyNumeric.num2long(value2);
            double fraction = ((RubyFloat)value2).getDoubleValue() % 1.0;
            timespec[1] = (long)(fraction * 1.0E9 + 0.5);
        } else if (value2 instanceof RubyNumeric) {
            timespec[0] = Platform.IS_32_BIT ? (long)RubyNumeric.num2int(value2) : RubyNumeric.num2long(value2);
            timespec[1] = 0L;
        } else {
            RubyTime time = value2 instanceof RubyTime ? (RubyTime)value2 : (RubyTime)TypeConverter.convertToType(context, value2, context.runtime.getTime(), RubyFile.sites((ThreadContext)context).to_time_checked, true);
            timespec[0] = Platform.IS_32_BIT ? (long)RubyNumeric.num2int(time.to_i()) : RubyNumeric.num2long(time.to_i());
            timespec[1] = Platform.IS_32_BIT ? (long)RubyNumeric.num2int(time.nsec()) : RubyNumeric.num2long(time.nsec());
        }
        return timespec;
    }

    private static long[] convertTimespecToTimeval(long[] timespec) {
        if (timespec == null) {
            return null;
        }
        long[] timeval = new long[]{timespec[0], timespec[1] / 1000L};
        return timeval;
    }

    private void checkClosed(ThreadContext context) {
        this.openFile.checkClosed();
    }

    private static RubyString expandPathInternal(ThreadContext context, IRubyObject[] args2, boolean expandUser, boolean canonicalize) {
        RubyString path2 = StringSupport.checkEmbeddedNulls(context.runtime, RubyFile.get_path(context, args2[0]));
        RubyString wd = null;
        if (args2.length == 2 && args2[1] != context.nil) {
            wd = StringSupport.checkEmbeddedNulls(context.runtime, RubyFile.get_path(context, args2[1]));
        }
        return RubyFile.expandPathInternal(context, path2, wd, expandUser, canonicalize);
    }

    static RubyString expandPathInternal(ThreadContext context, RubyString path2, RubyString wd, boolean expandUser, boolean canonicalize) {
        String relativePath = path2.getUnicodeValue();
        Encoding[] enc = new Encoding[]{path2.getEncoding()};
        String cwd = wd == null ? null : wd.toString();
        String expanded = RubyFile.expandPath(context, relativePath, enc, cwd, expandUser, canonicalize);
        return RubyString.newString(context.runtime, expanded, enc[0]);
    }

    public static String expandPath(ThreadContext context, String relativePath, Encoding[] enc, String cwd, boolean expandUser, boolean canonicalize) {
        CharSequence realPath;
        String absolutePath;
        JRubyFile pathFile;
        Ruby runtime2 = context.runtime;
        Encoding fsenc = runtime2.getEncodingService().getFileSystemEncoding();
        if (Platform.IS_WINDOWS && ("NUL:".equalsIgnoreCase(relativePath) || "NUL".equalsIgnoreCase(relativePath))) {
            enc[0] = fsenc;
            return StringSupport.concat("//./", relativePath.substring(0, 3));
        }
        String preFix = "";
        if (relativePath.startsWith("file:")) {
            preFix = "file:";
            relativePath = relativePath.substring(5);
        }
        String postFix = "";
        Matcher protocol2 = PROTOCOL_PREFIX_PATTERN.matcher(relativePath);
        if (relativePath.contains(".jar!/")) {
            if (protocol2.find()) {
                preFix = protocol2.group();
                int extra = 0;
                if (relativePath.contains("file://")) {
                    extra = 2;
                    preFix = preFix + "//";
                }
                relativePath = relativePath.substring(protocol2.end() + extra);
            }
            int index2 = relativePath.indexOf("!/");
            postFix = relativePath.substring(index2);
            relativePath = relativePath.substring(0, index2);
        } else if (protocol2.find()) {
            boolean classloaderURI;
            preFix = protocol2.group();
            int offset2 = protocol2.end();
            String extra = "";
            int index3 = relativePath.indexOf("file://");
            boolean bl = classloaderURI = preFix.equals("uri:classloader:") || preFix.equals("classpath:");
            if (index3 >= 0) {
                if (relativePath.length() > (index3 += 7) && relativePath.charAt(index3) == '/') {
                    offset2 += 2;
                    extra = "//";
                } else {
                    ++offset2;
                    extra = "/";
                }
            } else if (classloaderURI && relativePath.startsWith("//", offset2)) {
                ++offset2;
            }
            relativePath = relativePath.substring(offset2);
            if (classloaderURI) {
                String fakePrefix = Platform.IS_WINDOWS ? "C:/FAKEPATH_PREFIX__" : "/FAKEPATH_PREFIX__";
                relativePath = RubyFile.canonicalizePath(fakePrefix + '/' + relativePath).substring(fakePrefix.length());
            } else {
                relativePath = RubyFile.canonicalizePath(relativePath);
            }
            if (Platform.IS_WINDOWS) {
                if (!preFix.contains("file:") && RubyFile.startsWithDriveLetterOnWindows(relativePath)) {
                    relativePath = relativePath.substring(2);
                }
                if (classloaderURI) {
                    relativePath = relativePath.replace('\\', '/');
                }
            }
            return RubyFile.concatStrings(preFix, extra, relativePath);
        }
        String[] uriParts = RubyFile.splitURI(relativePath);
        if (expandUser && StringSupport.startsWith((CharSequence)relativePath, '~')) {
            enc[0] = fsenc;
            relativePath = RubyFile.expandUserPath(context, relativePath, true);
        }
        if (uriParts != null) {
            if (uriParts[0].equals("classpath:")) {
                return RubyFile.concatStrings(preFix, relativePath, postFix);
            }
            relativePath = uriParts[1];
        }
        if (cwd != null) {
            enc[0] = fsenc;
            if (!cwd.startsWith("uri:")) {
                boolean startsWithSlashNotOnWindows;
                if (expandUser) {
                    cwd = RubyFile.expandUserPath(context, cwd, true);
                }
                String[] cwdURIParts = RubyFile.splitURI(cwd);
                if (uriParts == null && cwdURIParts != null) {
                    uriParts = cwdURIParts;
                    cwd = cwdURIParts[1];
                }
                boolean bl = startsWithSlashNotOnWindows = (cwd = RubyFile.adjustRootPathOnWindows(runtime2, cwd, null)) != null && !Platform.IS_WINDOWS && cwd.length() > 0 && cwd.charAt(0) == '/';
                if (!startsWithSlashNotOnWindows && !RubyFile.startsWithDriveLetterOnWindows(cwd)) {
                    if (cwd.length() == 0) {
                        cwd = ".";
                    }
                    cwd = JRubyFile.create(runtime2.getCurrentDirectory(), cwd).getAbsolutePath();
                }
            }
        } else {
            cwd = runtime2.getCurrentDirectory();
        }
        assert (cwd != null);
        String padSlashes = "";
        if (uriParts != null) {
            padSlashes = uriParts[0];
        } else if (!Platform.IS_WINDOWS) {
            padSlashes = relativePath.length() > 0 && relativePath.charAt(0) == '/' ? RubyFile.countSlashes(relativePath) : RubyFile.countSlashes(cwd);
        }
        if (relativePath.length() == 0) {
            pathFile = JRubyFile.create(relativePath, cwd);
        } else {
            relativePath = RubyFile.adjustRootPathOnWindows(runtime2, relativePath, cwd);
            pathFile = JRubyFile.create(cwd, relativePath);
        }
        CharSequence canonicalPath = null;
        if (Platform.IS_WINDOWS && uriParts != null && "classpath:".equals(uriParts[0]) && (absolutePath = pathFile.getAbsolutePath()).length() >= 2 && absolutePath.charAt(1) == ':') {
            canonicalPath = RubyFile.canonicalize(null, absolutePath.substring(2));
        }
        if (canonicalPath == null) {
            canonicalPath = RubyFile.canonicalize(null, pathFile.getAbsolutePath());
        }
        if (padSlashes.isEmpty()) {
            realPath = canonicalPath;
        } else {
            realPath = StringSupport.concat((CharSequence)padSlashes, canonicalPath);
            if (preFix.length() > 0 && padSlashes.startsWith("file:")) {
                realPath = realPath.toString().substring(5);
            }
        }
        if (canonicalize) {
            realPath = RubyFile.canonicalNormalized(realPath);
        }
        if (postFix.contains("..")) {
            postFix = RubyFile.adjustPostFixDotDot(postFix);
        }
        return RubyFile.concatStrings(preFix, realPath, postFix);
    }

    private static String canonicalNormalized(CharSequence realPath) {
        String path2 = realPath.toString();
        try {
            return JRubyFile.normalizeSeps(new File(path2).getCanonicalPath());
        }
        catch (IOException ioe) {
            return path2;
        }
    }

    private static String adjustPostFixDotDot(String postFix) {
        postFix = '!' + RubyFile.canonicalizePath(postFix.substring(1));
        if (Platform.IS_WINDOWS && RubyFile.startsWithDriveLetterOnWindows((postFix = postFix.replace('\\', '/')).substring(1))) {
            postFix = '!' + postFix.substring(3);
        }
        return postFix;
    }

    private static String concatStrings(String s1, CharSequence s2, String s3) {
        return new StringBuilder(s1.length() + s2.length() + s3.length()).append(s1).append(s2).append(s3).toString();
    }

    private static String canonicalizePath(String path2) {
        try {
            return new File(path2).getCanonicalPath();
        }
        catch (IOException ignore) {
            return path2;
        }
    }

    public static String[] splitURI(String path2) {
        Matcher m = URI_PREFIX.matcher(path2);
        if (m.find()) {
            if (m.group(2).length() == 0) {
                return new String[]{path2, ""};
            }
            String pathWithoutJarPrefix = m.group(1) != null ? path2.substring(4) : path2;
            try {
                URI u = new URI(pathWithoutJarPrefix);
                String pathPart = u.getPath();
                return new String[]{path2.substring(0, path2.indexOf(pathPart)), pathPart};
            }
            catch (Exception e) {
                try {
                    URL u = new URL(pathWithoutJarPrefix);
                    String pathPart = u.getPath();
                    return new String[]{path2.substring(0, path2.indexOf(pathPart)), pathPart};
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String expandUserPath(ThreadContext context, String path2) {
        return RubyFile.expandUserPath(context, path2, false);
    }

    public static String expandUserPath(ThreadContext context, String path2, boolean raiseOnRelativePath) {
        int pathLength = path2.length();
        if (StringSupport.startsWith((CharSequence)path2, '~')) {
            int userEnd = path2.indexOf(47);
            if (userEnd == -1) {
                if (pathLength == 1) {
                    path2 = RubyDir.getHomeDirectoryPath(context, RubyFile.checkHome(context)).toString();
                    if (raiseOnRelativePath && !RubyFile.isAbsolutePath(path2)) {
                        throw context.runtime.newArgumentError("non-absolute home");
                    }
                } else {
                    userEnd = pathLength;
                }
            }
            if (userEnd == 1) {
                path2 = RubyDir.getHomeDirectoryPath(context, RubyFile.checkHome(context)).toString() + path2.substring(1);
                if (raiseOnRelativePath && !RubyFile.isAbsolutePath(path2)) {
                    throw context.runtime.newArgumentError("non-absolute home");
                }
            } else if (userEnd > 1) {
                String user = path2.substring(1, userEnd);
                IRubyObject dir = RubyDir.getHomeDirectoryPath(context, user);
                if (dir.isNil()) {
                    throw context.runtime.newArgumentError("user " + user + " does not exist");
                }
                path2 = dir + (pathLength == userEnd ? "" : path2.substring(userEnd));
                if (raiseOnRelativePath && !RubyFile.isAbsolutePath(path2)) {
                    throw context.runtime.newArgumentError("non-absolute home of " + user);
                }
            }
        }
        return path2;
    }

    private static String countSlashes(String stringToCheck) {
        int slashCount = 0;
        int len = stringToCheck.length();
        if (len > 0 && stringToCheck.charAt(0) == '/' && len > 1 && stringToCheck.charAt(1) == '/') {
            ++slashCount;
            for (int i2 = 2; i2 < len && stringToCheck.charAt(i2) == '/'; ++i2) {
                ++slashCount;
            }
        }
        if (slashCount < SLASHES.length) {
            return SLASHES[slashCount];
        }
        char[] slashes = new char[slashCount];
        for (int i3 = 0; i3 < slashCount; ++i3) {
            slashes[i3] = 47;
        }
        return new String(slashes);
    }

    public static String canonicalize(String path2) {
        CharSequence canonical = RubyFile.canonicalize(null, path2);
        return canonical == null ? null : canonical.toString();
    }

    private static CharSequence canonicalize(CharSequence canonicalPath, String remaining) {
        String child;
        if (remaining == null) {
            if (canonicalPath == null) {
                return null;
            }
            if (canonicalPath.length() == 0) {
                return "/";
            }
            if (RubyFile.startsWithDriveLetterOnWindows(canonicalPath) && canonicalPath.length() == 2) {
                return RubyFile.appendSlash(canonicalPath);
            }
            return canonicalPath;
        }
        int slash = remaining.indexOf(47);
        if (slash == -1) {
            child = remaining;
            remaining = null;
        } else {
            child = remaining.substring(0, slash);
            remaining = remaining.substring(slash + 1);
        }
        CharSequence path2 = canonicalPath;
        if (child.equals(".")) {
            if (slash == -1 && canonicalPath != null && canonicalPath.length() == 0) {
                path2 = RubyFile.appendSlash(canonicalPath);
            }
        } else if (child.equals("..")) {
            if (canonicalPath == null) {
                throw new IllegalArgumentException("Cannot have .. at the start of an absolute path");
            }
            int lastDir = ((String)(canonicalPath = canonicalPath.toString())).lastIndexOf(47);
            if (lastDir == -1) {
                if (!RubyFile.startsWithDriveLetterOnWindows(canonicalPath)) {
                    path2 = "";
                }
            } else {
                path2 = canonicalPath.subSequence(0, lastDir);
            }
        } else {
            path2 = canonicalPath == null ? child : new StringBuilder(canonicalPath.length() + 1 + child.length()).append(canonicalPath).append('/').append(child);
        }
        return RubyFile.canonicalize(path2, remaining);
    }

    private static StringBuilder appendSlash(CharSequence canonicalPath) {
        return new StringBuilder(canonicalPath.length() + 1).append(canonicalPath).append('/');
    }

    private static RubyString checkHome(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        IRubyObject home2 = runtime2.getENV().fastARef(RubyString.newStringShared(runtime2, RubyDir.HOME));
        if (home2 == null || home2 == context.nil || ((RubyString)home2).size() == 0) {
            throw runtime2.newArgumentError("couldn't find HOME environment -- expanding `~'");
        }
        return (RubyString)home2;
    }

    @Override
    public <T> T toJava(Class<T> target) {
        if (target == File.class) {
            String path2 = this.getPath();
            return (T)(path2 == null ? null : new File(path2));
        }
        if (target == Path.class || target == Watchable.class) {
            String path3 = this.getPath();
            return (T)(path3 == null ? null : FileSystems.getDefault().getPath(path3, new String[0]));
        }
        return super.toJava(target);
    }

    private static RubyString doJoin(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        String separator = runtime2.getFile().getConstant("SEPARATOR").toString();
        RubyArray argsAry = RubyArray.newArrayMayCopy(runtime2, args2);
        StringBuilder buffer = new StringBuilder(24);
        boolean isTainted = RubyFile.joinImpl(buffer, separator, context, recv2, argsAry);
        RubyString fixedStr = new RubyString(runtime2, runtime2.getString(), buffer);
        fixedStr.setTaint(isTainted);
        return fixedStr;
    }

    private static boolean joinImpl(StringBuilder buffer, String separator, ThreadContext context, IRubyObject recv2, RubyArray args2) {
        boolean isTainted = false;
        for (int i2 = 0; i2 < args2.size(); ++i2) {
            boolean leadingDelimiter;
            CharSequence element;
            Object arg2 = args2.eltInternal(i2);
            if (arg2.isTaint()) {
                isTainted = true;
            }
            if (arg2 instanceof RubyString) {
                element = arg2.convertToString().getUnicodeValue();
            } else if (arg2 instanceof RubyArray) {
                if (context.runtime.isInspecting(arg2)) {
                    throw context.runtime.newArgumentError("recursive array");
                }
                element = RubyFile.joinImplInspecting(separator, context, recv2, args2, (RubyArray)arg2);
            } else {
                RubyString path2 = StringSupport.checkEmbeddedNulls(context.runtime, RubyFile.get_path(context, arg2));
                element = path2.getUnicodeValue();
            }
            int trailingDelimiterIndex = RubyFile.chomp(buffer);
            boolean trailingDelimiter = trailingDelimiterIndex != -1;
            boolean bl = leadingDelimiter = element.length() > 0 && RubyFile.isDirSeparator(element.charAt(0));
            if (i2 > 0) {
                if (leadingDelimiter) {
                    if (trailingDelimiter) {
                        buffer.delete(trailingDelimiterIndex, buffer.length());
                    }
                } else if (!trailingDelimiter) {
                    buffer.append(separator);
                }
            }
            buffer.append(element);
        }
        return isTainted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder joinImplInspecting(String separator, ThreadContext context, IRubyObject recv2, RubyArray parent, RubyArray array2) {
        Ruby runtime2 = context.runtime;
        StringBuilder buffer = new StringBuilder(24);
        if (runtime2.isInspecting(parent)) {
            RubyFile.joinImpl(buffer, separator, context, recv2, array2);
            return buffer;
        }
        try {
            runtime2.registerInspecting(parent);
            RubyFile.joinImpl(buffer, separator, context, recv2, array2);
            StringBuilder stringBuilder = buffer;
            return stringBuilder;
        }
        finally {
            runtime2.unregisterInspecting(parent);
        }
    }

    private static boolean isDirSeparator(char c) {
        return c == '/' || Platform.IS_WINDOWS && c == '\\';
    }

    private static int chomp(StringBuilder buffer) {
        boolean found = false;
        for (int lastIndex = buffer.length() - 1; lastIndex >= 0; --lastIndex) {
            if (!RubyFile.isDirSeparator(buffer.charAt(lastIndex))) {
                if (!found) break;
                return lastIndex + 1;
            }
            found = true;
        }
        return found ? 0 : -1;
    }

    private static String replace(String str, CharSequence target, CharSequence replace2) {
        if (target.length() == 1 && replace2.length() == 1) {
            return str.replace(target.charAt(0), replace2.charAt(0));
        }
        return str.replace(target, replace2);
    }

    private static IRubyObject truncateCommon(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        RubyString filename2 = arg1.convertToString();
        Ruby runtime2 = context.runtime;
        RubyInteger newLength = arg2.convertToInteger();
        File childFile = new File(filename2.getUnicodeValue());
        String filenameString = Helpers.decodeByteList(runtime2, filename2.getByteList());
        File testFile = childFile.isAbsolute() ? childFile : new File(runtime2.getCurrentDirectory(), filenameString);
        if (!testFile.exists()) {
            throw runtime2.newErrnoENOENTError(filenameString);
        }
        if (newLength.getLongValue() < 0L) {
            throw runtime2.newErrnoEINVALError(filenameString);
        }
        IRubyObject[] args2 = new IRubyObject[]{filename2, runtime2.newString("r+")};
        RubyFile file2 = (RubyFile)RubyFile.open(context, recv2, args2, Block.NULL_BLOCK);
        file2.truncate(context, newLength);
        file2.close();
        return RubyFixnum.zero(runtime2);
    }

    private static JavaSites.FileSites sites(ThreadContext context) {
        return context.sites.File;
    }

    @Deprecated
    public IRubyObject initialize19(IRubyObject[] args2, Block block) {
        return this.initialize(null, args2, block);
    }
}

