/*
 ***** BEGIN LICENSE BLOCK *****
 * Version: EPL 2.0/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Eclipse Public
 * License Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.eclipse.org/legal/epl-v20.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Copyright (C) 2013-2017 The JRuby Team (jruby@jruby.org)
 * 
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the EPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the EPL, the GPL or the LGPL.
 ***** END LICENSE BLOCK *****/
package org.jruby.ext.ripper;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          309,  378,  312,   88,   88,  135,  135,  429,  219,  693, 
          254,  254,  254,  108,  232,  280,  254,  254,  358,  489, 
          254,  311,  419,  218,  218,  422,  356,  301,  296,  296, 
          264,  467,  296,  647,  232,  675,  648,  258,  261,  292, 
          292,  712,  234,  292,  218,  764,   88,  699,  711,    8, 
          354,  711,  254,  393,  364,  305,  545,  547,  642,    8, 
          335,  339,  234,  328,  528,  661,  647,  636,  530,  218, 
           83,   83,  295,  295,  634,  627,  295,  583,  433,  647, 
          712,  647,  647,  810,  659,  582,  134,  134,  279,  635, 
          366,  260,  623,  437,  631,  647,  134,  606,  637,  830, 
          636,  354,  393,  673,  334,  575,  736,  399,    8,  647, 
          647,  583,  839,  318,  823,  260,  647,  306,  721,  689, 
          432,  516,  674,  833,  264,  958,  583,   84,  647,   75, 
          254,  134,   88,  702,   76,  647,  623,  878,  631,  575, 
          259,  434,  308,  851,  647,  376,  606,  305,  894,  835, 
          500, 1046,  674,  453,  575,  304,  399, 1030,  647,  647, 
          442,  871,  750,   87,  259,  647,  822,  582,  469,  308, 
          581,  434,  520,  521,   74,  593,  525,  414,   84,  376, 
           73,  575,  134,  281,  647,   76,  674,  292,  463,  552, 
          777,  451,  733,  440,  414,  567,  636,  441,  438,  452, 
          606,  582,  453,  435,  581,   93,   93,  136,  136,  593, 
          524,  674,  280,  636,  477,  575,  582,  281,  858,  581, 
          489,  502,  780,  804,  593,   72,  653,  377,  317,  567, 
          575,  872,  314,  252,  252,  252,   82,  740,  552,   88, 
          304,  319,  567, 1046,  567,  386,  379,  384,   93,  606, 
          511,  369,  355,  387,  370,  809,  382,  638, 1030,  638, 
          532,  377,  260,  975,  638,  814,  254,  254,  385,  712, 
          380,  582,  740,  525,  373,  350,  468,  884,  711,  711, 
          264,  813,  374,  815,  958,  647,   80,   82,  536,  503, 
          504,  746,  472,  473,  383,  647,  381,  519,   53,  567, 
           77,  642,  254,  355,  254,  254,  907,  527,  254,  424, 
          254,  259,  914,  413,  296,   88,  296,  425,   85,  642, 
          426,   88,   78,   88,  350,  292,  482,  292,  292,  431, 
          308,  993,   88,  713,   93,  847,  818,   80,  567,  518, 
          328,  717,  718,  264,  647,  771,  878,  972,  384,  385, 
          636,   77,  430,  439,  354,  260,  979,  307,  295,  726, 
          295,  983,  696,  647,  647,  454,  647,  902,  648,   85, 
          647,  648,  458,   78,  926,  647,  323,  647, 1016,  772, 
          254,  254,  254,  254,   88,  254,  254,  567,  514,  647, 
          582,  639,  582,  639,  928,  443,   84,  657,  639,  522, 
          636,  647,  393,   76,  259,  655,  588,  589,  590,  591, 
          453,  647,    8,  647,  950,  903,  905,  457,  647,  254, 
          279,  910,  912,  279,  464,  641,  583,  641,   88,  354, 
          859,  254,  641,  843,   88,  134,  632,  634,  647,  465, 
          632,   93,  292,  663,  532,  328,  606,  254,  647,   88, 
          254,  592,  635,  633,  575,  921,  399,  859,  849,   84, 
           88,   75,  323,  254,  632,  581,   76,  836,   88,  582, 
          292,  582,  623,  307,  631,  672,  575,  254,  746,  863, 
          632,  633,  453,  652,  552,  898,  292,  652, 1018,  252, 
          252,  698,  698, 1097,  632,  606,  803,  633,  710,  719, 
          292,   83,  581,  123,  712,   82,   74,  254, 1074,   88, 
          134,  633,  232,  575,  711,  281,  582,   93,  281,  812, 
           88,  552,  218,   93,  593,   93,  694,  567,  632,   96, 
           96,  499,  606,  501,   93,  581,  254,  729,  354,  573, 
          234,  282,  992,  466,  280,  633,  575,  280,  601,   97, 
          647,  469,  123,  632,  552,   80,  355,  538,  539,  292, 
          317,  532,   83,  845,  541,  606,  876,  843,   82,   77, 
          633,  848,   96,  591,  567,  799,   83,  386,  379,  384, 
          757,  759,  601, 1050,  440,  387,   93,   85,  382,  471, 
          778,   78,  865,   81,  333,  337,  746,  601,  746,  647, 
          385,  786,  380,  252,  252,  252,  252,  591,  593,  594, 
          384,  385,  458,   83,  638,  638,  538,  539,   80,  134, 
          638,  638,  591,  541,  474,   87,  383,  644,  381,  644, 
           93,  355,   77,  638,  644,   79,   93,  850,  308,  538, 
          539,  543,   73,  742,   81,  509,  541,  786,  743,  478, 
           85,   93,  862,  323,   78,  354,  931,  783,   96,  825, 
          822,  555,   93,  786,  706,  789,  556,  485,  254,   88, 
           93,  789, 1061,  676,  484,  817,  786,  561,  562,   88, 
          582,  386,  816,  293,  299,  807,   79,  300,  232,  898, 
          746, 1026,  488,  898,  808,  103,  103,  218,  218,  561, 
          562,  647,  647,  508,  954,  783,  254,  786,  789, 1013, 
         1083,   93,  532,  401,  647, 1015,  234,  403,  404,  784, 
          386,  916,   93,  512,  867,  573,   88,  790,  844,  674, 
          720,  354,  840,  793,  513,  874,  134,  877,  103,  652, 
          355,  638,  647,  563,  391,  392,  867,  769,  639,  639, 
          517,  886,  770,  529,  639,  639,  523,  746,  323,  746, 
          123,  320,  415,  647, 1025,   96,  531,  639,  537,  416, 
          421,  876,  664,  440,  656,   88,  955,  506,   88,  407, 
          408,   88,  641,  641,  677,  898,  876,  682,  641,  641, 
          685,  647,  684,   83,  746,  320,   88,  714,  692,  254, 
          686,  641,  538,  539,  127,  695,  354,  647,   88,  541, 
          320,  715,  134,  716,  546,  722,  632,  730,  751,  418, 
          725,  440,  292,   88,  103,  752,  254,  929,  440,  440, 
          753,   83,  756,  633,  933,  758,  446,   88,   88,   88, 
          760,   96,  320,  601,  573,  108,  573,   96,  762,   96, 
          763,  495,  942,  127,  766,  440,  779,  355,   96,  698, 
           73,  867,   81,  917,  108,  776,  795,  781,  591,  782, 
         1024,   93,   88,   88,  787,  639,  800,  962,  876,  108, 
          601,   93,  788,  966,  968,  320,  970,  134,  971,  802, 
          805,  252,  643,  811,   83,  786,  108,  601,  987,  662, 
          822,  117,   98,  828,   79,  591,  452,  452,  829,  641, 
           96,  320,  452,  601,  550,  831,  551,  552,  553,  554, 
          832,  834,  591,  846,  860,   81,  320,  864,   93,  252, 
          885,  103,  643,  355,  662,  308, 1010,  901,  591, 1059, 
           88,  857,  908,  909, 1054,  462, 1034,  927,  930,  521, 
          117,  645,  932,  645,   96, 1040,  935,  944,  645, 1044, 
           96,  939,  951,  476,  943,  495,  945,   79,  647,  490, 
          952,  493,  647,  647, 1090,   96,  956,   93,  462,  134, 
           93,  724,  521,   93,  644,  644,   96,  959,  960, 1049, 
          644,  644,  961,  495,   96,  965,  647,   88,   93,  967, 
          969,  647, 1062,  644,  973,  976,  978,  103,  355,  495, 
           93,  104,  980,  103,   88,  103,   88,  134,   61,   62, 
           63,   64,   88,  495,  103,   93,  550,  988,  551,  552, 
          553,  554,  982, 1023,  989,   96,  995, 1032, 1019,   93, 
           93,   93, 1063, 1065, 1066, 1067,   96, 1020, 1031,  252, 
         1039, 1094, 1047, 1051,  254,   97,  415,  786,  440,   88, 
         1060,  127,   92,  416,  417,  538,  539,  540, 1064, 1068, 
          134,  632,  541,  415,   93,   93,  103,  292, 1070,  320, 
          416,  445,  495, 1072,  647, 1075,  320,  320,  633, 1080, 
         1088, 1098,  622, 1101,  634,  647,   92,  647,  636,  127, 
          136, 1099,  116,  635,  636,  899,   95,  640,  900,  640, 
          320,  644,  636,   92,  108,  429,  118,  103,  375,  103, 
          103,  642,  320,  636,  103,  429,  103,  647,   98,  320, 
          320,  768,  775,  647,  775,  622,  138,  117, 1011,  727, 
           95,  103,   93,  515, 1087,  221,  794,  996,  320,  875, 
         1042,  116,  103,  938,  889,  320,  320,   95,  117,  880, 
          103,  622,   98,  320, 1041,  118,  775,  947,  948,  949, 
          320,  320,  853,  854,  429,  855,  622,  108,  792,   98, 
          915,  806,  415,  520,  792,  535,  521,  518,  283,  416, 
          461,  136, 1086,  521,  521,   96, 1091,  522,  861,   93, 
          415,  103,  963,  964,    0,   96,  420,  416,  475,  521, 
            0,  798,  103,    0,    0,  415,   93,   97,   93,  521, 
            0,  792,  416,  510,   93,    0,  521,  521,    0,  821, 
          824,  550,  824,  551,  552,  553,  554,  555,   17,  824, 
           59,   60,  556,    0,    0,    0,  123,  440,    0,  904, 
          906,    0,   96,    0,    0,  911,  913,    0,  446,    0, 
            0,   93,    0,    0,  520,  557,    0,   16, 1053,    0, 
         1014,    0,   97,  559,  560,  561,  562,    0,    0,  119, 
            0,    0,  300,    0,    0,  291,  291,   17,    0,  291, 
            0,  515,  300,    0,    0,  440,  904,  906,    0,  911, 
          913,   96,  440,  440,   96,    0,    0,   96,  645,  645, 
            0,  315,  317,    0,  645,  645,   16,  291,  291,  563, 
          357,  359,   96,   97,    0,  515,  293,  645,  119,  440, 
            0,   92,  618,    0,   96,    0,  647,  647,  647,    0, 
          515,  300,    0,  647, 1055,  495, 1056,    0,    0,   96, 
            0,    0, 1057,    0,    0,   99,    0,   97,    0,  116, 
          523,  103,    0,   96,   96,   96,  106,  937,    0,    0, 
          941,  103,  515,  118,   97,   95,  619,  429,  429,  429, 
          515,    0,  429,  429,  429,    0,  429,  515,  515, 1089, 
            0,    0,    0,  618,   92,    0,  429,   98,   96,   96, 
          106,    0,  522,    0,  520,  429,  429,    0,  429,  429, 
          429,  429,  429,    0,  618,    0,    0,  106,  103,    0, 
          520,    0,  415,    0,  518,    0,    0,  520,  520,  416, 
          534,  518,  518,    0,  522,  645,    0,  619,   95,  137, 
          137,  522,  522,  429,    0,    0,  521,  625,  415,  137, 
          429,  429,  116,  521,  521,  416,  797,  429,  619,    0, 
           98,    0, 1012,    0,    0,    0,   96,  103,    0,  206, 
          103,    0,    0,  103,  103,  103,  137,  137,  429,    0, 
          103,  103,  137,  137,  137,  137,    0,    0,  103,  336, 
           17,   17,   17,  103,  824,  415,   17,   17,    0,   17, 
          103,  520,  416, 1048,    0,  415,    0,    0,  520,  520, 
          429,    0,  416, 1052,    0,  103,    0,    0,  206,   16, 
           16,   16,   53,   96,    0,   16,   16,    0,   16,  103, 
          103,  103,   53,    0,    0,  137,  119,    0,    0,    0, 
           96,    0,   96,    0,  300,  300,  300,    0,   96,  300, 
          300,  300,    0,  300,    0,  291,  291,  291,  359,    0, 
          291,  618,    0,    0,  103,  103,    0,    0,    0,    0, 
           17,  291,    0,  291,  291,  300,  300,  300,  300,  300, 
          105,   53,  507,    0,  550,   96,  551,  552,  553,  554, 
          118,   17,   97,    0,    0,    0,    0,  523,    0,   16, 
          495,  103,    0,  824,  523,  523,    0,    0,  550,  515, 
          551,  552,  553,  554,  105,    0,  515,  515,  744,    0, 
           16,  300,  618,   17,  300,    0,  745,  538,  539,  543, 
            0,  105,  103,    0,  541,  106,  625,    0,    0,  522, 
          515,  520,  744,  618,    0,  300,  522,  522,  520,  520, 
          957,    0,   16,    0,    0,   97,  595,  596,  597,  598, 
          599,  621,    0,  600,  601,  602,  603,  604,  605,  606, 
          607,  608,  609,  610,  611,  612,  613,  300,    0,  614, 
          615,  616,  617,  100,  625,    0,    0,    0,  291,  103, 
          634,  625,  625,    0,  640,    0,  647,  621,  106,    0, 
          291,  640,    0,    0,    0,    0,  103,  550,  103,  551, 
          552,  553,  554,    0,  103,    0,  291,    0,  625,    0, 
          137,  137,  137,  137,    0,  137,  479,  480,  481,    0, 
          523,  483,  291,  292,  640,  640,  640,  868,    0,  291, 
            0,  744,  879,  292,    0,    0,  291,  137,    0,  102, 
            0,  103,    0,    0,  291,  291,  888,    0,  291,  538, 
          539,  544,    0,    0,    0,  206,  541,  206,  206,  206, 
          206,  206,    0,  538,  539,  739,  206,  292,    0,    0, 
          541,    0,  723,  640,   53,   53,   53,  521,  137,   53, 
           53,   53,  292,   53,  291,  521,  525,  291,    0,  206, 
          206,    0,    0,   53,    0,  291,    0,  206,  206,  206, 
          206,    0,   53,   53,  107,   53,   53,   53,   53,   53, 
            0,  137,  137,  137,  137,  137,    0,    0,  137,  137, 
          137,  137,  137,  137,  137,  137,  137,  137,  137,  137, 
          137,  137,  101,  104,  137,  137,  137,  137,  107,  105, 
          621,  291,    0,  206,  518,  137,   99,    0,  100,  538, 
          539,  767,    0,  137,   53,  107,  541,  651,  103,    0, 
            0,  660,    0,  121,  484,  484,  484,  104,    0,    0, 
            0,  484,    0,    0,    0,   53,    0,    0,  518,  524, 
           99,    0,  100,    0,  104,  622,    0,    0,  621,  137, 
          137,  137,    0,  518,  137,  621,  621,   99,    0,  100, 
          651,  621,  105,    0,    0,  526,  291,   53,  119,  137, 
          137,    0,  121,  137,  440,  707,  709,    0,    0,  336, 
            0,    0,  621,    0,    0,  518,  102,  522, 1027,  523, 
          551,  552,  553,  554,    0,    0,    0,  137,  137, 1033, 
            0, 1035,  291, 1036,  525,    0,    0, 1037,    0,  137, 
            0,    0,  137,    0, 1045,  709,    0,  523,  336,    0, 
          102,  386,  137,    0,  523,  523,  291,    0,  291,  379, 
          380,  381,  382,  383,  121,  291,  291,  102,   55,    0, 
            0,    0,    0,    0,    0,  292,  292,  292,   55,  882, 
          292,  292,  292,  401,  292,    0,    0,  403,  404,  405, 
          406,  896,    0,   92,  292,  292,  137,  525,    0,    0, 
            0,    0,  765,  292,  292,    0,  292,  292,  292,  292, 
          292,    0,   54,  525,    0,    0,  291,    0,    0,    0, 
          525,  525,   54,    0,    0,    0,    0,   55, 1092,    0, 
            0,  640,  640,   94, 1093,  120, 1095,  640,  640, 1096, 
          515,    0,    0,   93,    0,    0,  918,    0,  291,    0, 
          640,    0,  291,    0,    0,  292,    0,  120,  292,    0, 
          292,  137,  122,  107,  622, 1105,    0,  801,    0,  137, 
            0,   54,    0,    0,    0,    0,  292,    0,  640,  640, 
          517,  640,  640,  122,  120,  291,    0,    0,    0,    0, 
          516,    0,  104,  440,    0,    0,    0,  137,    0,    0, 
            0,    0,    0,  819,  619,   99,  524,  100,  292,    0, 
          121,  122,  622,  524,  524,    0,  524,    0,    0,  622, 
          622,  137,    0,  137,    0,  622,  107,  841,    0,  842, 
          137,  137,  526,    0,    0,    0,  709,  336,    0,  526, 
          526,  440,    0,  526,    0,  137,  622,  515,  440,  440, 
            0,  990,  518,    0,  522,  104,  523,  515,  991,  518, 
          518,  522,  522,  523,  523,  619,    0,    0,   99,    0, 
          100,  525,    0,    0,  291,  440,    0,    0,  525,  525, 
            0,  137,    0,  518,  977,  102,  619,  883,  981,    0, 
            0,  515,  896,    0,  991,  896,    0, 1043,    0,  896, 
            0,  291,    0,    0,    0,  515,  515,    0,  111,    0, 
          515,  137,    0,    0,    0,    0,    0,  137,    0,    0, 
          137,    0,    0,  925,    0,    0,    0,    0,  111,  618, 
           55,   55,   55,    0,  525,   55,   55,   55,  515,   55, 
            0,  525,  525,  137,  137,    0,  137,  137,  102,   55, 
          137,    0,    0,    0,    0,    0,  946,    0,   55,   55, 
            0,   55,   55,   55,   55,   55,    0,    0,  113,    0, 
            0,    0,    0,    0,   54,   54,   54,  515,  112,   54, 
           54,   54,    0,   54,  515,  515,    0,  896,  518,  896, 
          618,  896,  120,   54,  896,    0,    0,    0,  518,    0, 
            0,    0,    0,  291,    0,   54,   54,   54,   54,   54, 
           55,  618,  137,    0,    0,    0,  137,  517,    0,  122, 
          896,    0,    0,    0,  517,  517,    0,  516,    0,    0, 
            0,   55,  518, 1069,  516,  516, 1071, 1073,    0,  137, 
         1076, 1077,    0,    0,    0,  994,  518,  518,    0,  114, 
          137,  518,    0,  524,   54,    0,    0,    0,    0,  137, 
          524,  524,    0,   55,    0,    0,  137,    0,    0,    0, 
            0,    0,  336,    0,    0,   54,    0,  199,    0,  518, 
          526,    0,    0,    0,    0,    0,    0,  526,  526, 1100, 
         1102, 1103, 1104,    0,    0,    0,    0,    0,    0,    0, 
            0, 1106,    0,  137,  618,  618,  618,   54,  618,  515, 
          515,  515,  618,  618,  515,  515,  515,  618,  515,  618, 
          618,  618,  618,  618,  618,  618,  199,  618,  515,  515, 
          618,  618,  618,  618,  618,  618,  618,  515,  515,  618, 
          515,  515,  515,  515,  515,    0,  618,    0,    0,  618, 
          618,  618,  515,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  515,  515,  515,  515,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  308,    0, 
          515,  515,  515,  515,  618,  527,  515,  618,  618,  515, 
          618,  618,  515,  618,  515,  618,  515,  618,  515,  618, 
          515,  515,  515,  515,  515,  515,  515,  618,  515,  618, 
          515,    0,  618,  618,  618,  618,  618,  618,    0,    0, 
           96,  618,  515,  618,  618,    0,  618,  618,  618,  618, 
            0,  411,    0,    0,    0,  897,    0,    0,    0,  618, 
          618,  618,  515,    0,    0,  619,  619,  619,    0,  619, 
          518,  518,  518,  619,  619,  518,  518,  518,  619,  518, 
          619,  619,  619,  619,  619,  619,  619,  519,  619,  518, 
          518,  619,  619,  619,  619,  619,  619,  619,  518,  518, 
          619,  518,  518,  518,  518,  518,    0,  619,    0,    0, 
          619,  619,  619,  518,  619,  619,  619,  619,  619,  619, 
          619,  619,  619,  619,  619,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  110, 
            0,  518,  518,  518,  518,  619,  530,  518,  619,  619, 
          518,  619,  619,  518,  619,  518,  619,  518,  619,  518, 
          619,  518,  518,  518,  518,  518,  518,  518,  619,  518, 
          619,  518,    0,  619,  619,  619,  619,  619,  619,    0, 
            0,  625,  619,  518,  619,  619,  310,  619,  619,  619, 
          619,  625,    0,  199,  386,  199,  199,  199,  199,  199, 
          619,  619,  619,  518,  199,    0,    0,    0,    0,    0, 
          399,  400,    0,    0,    0,  520,    0,    0,    0,    0, 
            0,    0,    0,  520,    0,  625,  401,  199,  199,    0, 
          403,  404,  405,  406,    0,  199,  199,  199,  199,  625, 
          625,    0,  125,    0,  625,    0,  550,    0,  551,  552, 
          553,  554,  555,    0,    0,    0,  897,  556,    0,  897, 
            0,  897,    0,  897,    0,    0,    0,    0,    0,    0, 
            0,    0,  625,    0,    0,  115,  634,  634,  634,    0, 
          557,  199,  634,  634,    0,  634,  635,  635,  635,    0, 
          561,  562,  635,  635,    0,  635,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  386,  387,  388,  389,  390, 
          391,  392,  393,  394,  395,  396,    0,  397,  398,    0, 
          621,  399,  400,    0,  519,    0,    0,    0,    0,    0, 
          621,  519,  519,    0,  563,    0,    0,  401,    0,  402, 
            0,  403,  404,  405,  406,  407,  408,  409,    0,  410, 
            0,  897,    0,  897,    0,  897,  634,    0,  897,    0, 
            0,    0,    0,    0,  621,    0,  635,    0,    0,  386, 
            0,    0,    0,    0,  129,    0,    0,  634,  621,  621, 
            0,  124,    0,  621,  897,  399,  400,  635,    0,    0, 
            0,  550,    0,  551,  552,  553,  554,  555,    0,    0, 
            0,  401,  556,  402,    0,  403,  404,  405,  406,  634, 
            0,  621,    0,    0,    0,    0,    0,    0,    0,  635, 
            0,    0,    0,  310,    0,  557,  558,    0,    0,    0, 
          310,  310,  209,  559,  560,  561,  562,    0,  621,  621, 
          621,    0,  621,  625,  625,  625,  621,  621,  625,  625, 
          625,  621,  625,  621,  621,  621,  621,  621,  621,  621, 
            0,  625,  625,  625,  621,  621,  621,  621,  621,  621, 
          621,  625,  625,  621,  625,  625,  625,  625,  625,  563, 
          621,  209,    0,  621,  621,  621,  625,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  625,  625, 
          625,  625,  625,  625,  625,  625,  625,  625,  625,  625, 
          625,  625,   95,    0,  625,  625,  625,  625,  621,  194, 
          625,  621,  621,  625,  621,  621,  625,  621,  625,  621, 
          625,  621,  625,  621,  625,  625,  625,  625,  625,  625, 
          625,  621,  625,  625,  625,    0,  621,  621,  621,  621, 
          621,  621,  109,    0,    0,  621,  625,  621,  621,  518, 
          621,  621,  621,  621,    0,    0,    0,    0,  194,    0, 
            0,  113,    0,  621,  621,  621,  625,  621,  621,  621, 
            0,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  321, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,    0,  621, 
          113,    0,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,    0,  517,  621,  621,  621,  621,  621,    0,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,    0,  621,  621,  621,  621,  621, 
          621,    0,    0,  622,  621,  621,  621,  621,    0,  621, 
          621,  621,  621,  622,    0,    0,    0,    0,    0,    0, 
            0,    0,  621,  621,  621,  621,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  209,    0, 
          209,  209,  209,  209,  209,    0,    0,  622,    0,  209, 
            0,    0,    0,    0,  386,    0,    0,  114,  619,    0, 
          522,  622,  622,    0,  126,    0,  622,    0,  522,    0, 
          399,  400,  209,  209,    0,    0,    0,    0,    0,    0, 
          209,  209,  209,  209,    0,    0,  401,    0,  402,    0, 
          403,  404,  405,  406,  622,    0,  409,  128,  410,    0, 
            0,    0,    0,    0,    0,    0,  518,    0,    0,    0, 
            0,    0,    0,  518,  518,    0,    0,    0,    0,  619, 
            0,    0,    0,    0,    0,  194,  209,  194,  194,  194, 
          194,  194,    0,    0,    0,    0,  194,    0,  113,    0, 
          619,    0,  311,    0,    0,    0,  321,  523,    0,    0, 
            0,    0,  311,  321,  321,  523,    0,    0,    0,  194, 
          194,    0,    0,    0,    0,    0,    0,  194,  194,  194, 
          194,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  311,  386,  387,  388, 
          389,  390,  391,  392,  393,  394,  395,  396,    0,  517, 
          311,  311,    0,  399,  400,  311,  517,  517,    0,    0, 
            0,    0,    0,  194,    0,    0,    0,    0,    0,  401, 
            0,  402,    0,  403,  404,  405,  406,  407,  408,  409, 
            0,  410,    0,  311,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  176,    0,    0,    0,    0,    0, 
          622,  622,  622,    0,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,    0,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,    0,  622,  176,    0,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  106,    0,  622,  622,  622,  622, 
          622,  177,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,    0,  622,  622, 
          622,  622,  622,  622,    0,    0,    0,  622,  622,  622, 
          622,  625,  622,  622,  622,  622,    0,    0,    0,    0, 
          177,    0,    0,  112,    0,  622,  622,  622,  622,  620, 
          620,  620,    0,  620,  311,  311,  311,  620,  620,  311, 
          311,  311,  620,  311,  620,  620,  620,  620,  620,  620, 
          620,    0,  620,  311,  311,  620,  620,  620,  620,  620, 
          620,  620,  311,  311,  620,  311,  311,  311,  311,  311, 
            0,  620,  112,    0,  620,  620,  620,  311,  620,  620, 
          620,  620,  620,  620,  620,  620,  620,  620,  620,  311, 
          311,  311,  311,  311,  311,  311,  311,  311,  311,  311, 
          311,  311,  311,    0,  516,  311,  311,  311,  311,  620, 
            0,  311,  620,  620,  311,  620,  620,  311,  620,  311, 
          620,  311,  620,  311,  620,  311,  311,  311,  311,  311, 
          311,  311,  620,  311,  620,  311,    0,  620,  620,  620, 
          620,  620,  620,    0,    0,  626,  620,  311,  620,  620, 
            0,  620,  620,  620,  620,  626,    0,    0,    0,    0, 
            0,    0,    0,    0,  620,  620,  620,  311,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          176,    0,  176,  176,  176,  176,  176,    0,    0,  626, 
            0,  176,    0,    0,    0,    0,    0,    0,    0,  125, 
          625,  386,  525,  626,  626,    0,  391,  392,  626,    0, 
          525,    0,    0,    0,  176,  176,    0,  399,  400,    0, 
            0,    0,  176,  176,  176,  176,    0,    0,    0,    0, 
            0,    0,    0,  401,    0,  402,  626,  403,  404,  405, 
          406,  407,  408,  409,    0,  410,    0,    0,  625,    0, 
            0,    0,    0,    0,    0,  625,  625,    0,    0,    0, 
            0,  621,    0,    0,    0,    0,    0,  177,  176,  177, 
          177,  177,  177,  177,    0,    0,    0,    0,  177,    0, 
          112,    0,  625,    0,  627,    0,    0,    0,    0,  524, 
            0,    0,    0,    0,  627,    0,    0,  524,    0,    0, 
            0,  177,  177,    0,    0,    0,    0,    0,    0,  177, 
          177,  177,  177,    0,    0,    0,    0,    0,    0,    0, 
          386,  387,  388,  389,  390,  391,  392,  393,  627,  395, 
          396,    0,    0,    0,    0,    0,  399,  400,    0,    0, 
            0,  516,  627,  627,    0,    0,    0,  627,  516,  516, 
            0,    0,  401,    0,  402,  177,  403,  404,  405,  406, 
          407,  408,  409,    0,  410,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  627,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  178,    0,    0,    0, 
            0,    0,  623,  623,  623,    0,  623,  626,  626,  626, 
          623,  623,  626,  626,  626,  623,  626,  623,  623,  623, 
          623,  623,  623,  623,    0,  626,  626,  626,  623,  623, 
          623,  623,  623,  623,  623,  626,  626,  623,  626,  626, 
          626,  626,  626,    0,  623,  178,    0,  623,  623,  623, 
          626,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,  623,  626,  626,  626,  626,  626,  626,  626,  626, 
          626,  626,  626,  626,  626,  626,  105,    0,  626,  626, 
          626,  626,  623,  135,  626,  623,  623,  626,  623,  623, 
          626,  623,  626,  623,  626,  623,  626,  623,  626,  626, 
          626,  626,  626,  626,  626,  623,  626,  626,  626,    0, 
          623,  623,  623,  623,  623,  623,    0,    0,    0,  623, 
          626,  623,  623,  621,  623,  623,  623,  623,    0,    0, 
            0,    0,  135,    0,    0,  115,    0,  623,  623,  623, 
          626,  624,  624,  624,    0,  624,  627,  627,  627,  624, 
          624,  627,  627,  627,  624,  627,  624,  624,  624,  624, 
          624,  624,  624,    0,  627,  627,  627,  624,  624,  624, 
          624,  624,  624,  624,  627,  627,  624,  627,  627,  627, 
          627,  627,    0,  624,  115,    0,  624,  624,  624,  627, 
          624,  624,  624,  624,  624,  624,  624,  624,  624,  624, 
          624,  627,  627,  627,  627,  627,  627,  627,  627,  627, 
          627,  627,  627,  627,  627,    0,  519,  627,  627,  627, 
          627,  624,    0,  627,  624,  624,  627,  624,  624,  627, 
          624,  627,  624,  627,  624,  627,  624,  627,  627,  627, 
          627,  627,  627,  627,  624,  627,  627,  627,    0,  624, 
          624,  624,  624,  624,  624,    0,    0,  320,  624,  627, 
          624,  624,    0,  624,  624,  624,  624,  320,    0,    0, 
            0,    0,    0,    0,    0,    0,  624,  624,  624,  627, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  178,    0,  178,  178,  178,  178,  178,    0, 
            0,  320,    0,  178,    0,    0,    0,    0,    0,    0, 
            0,  124,  621,    0,  526,  320,  320,    0,  127,    0, 
          320,    0,  526,    0,    0,    0,  178,  178,    0,    0, 
            0,    0,    0,    0,  178,  178,  178,  178,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  320,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          621,    0,    0,    0,    0,    0,    0,  621,  621,    0, 
            0,    0,    0,  621,    0,    0,    0,    0,    0,  135, 
          178,  135,  135,  135,  135,  135,    0,    0,    0,    0, 
          135,    0,  115,    0,  621,    0,  439,    0,    0,    0, 
            0,  515,    0,    0,    0,    0,  439,    0,    0,  515, 
            0,    0,    0,  135,  135,    0,    0,    0,    0,    0, 
            0,  135,  135,  135,  135,    0,    0,    0,    0,    0, 
            0,    0,  386,  387,  388,  389,  390,  391,  392,    0, 
          439,  395,  396,    0,    0,    0,    0,    0,  399,  400, 
            0,    0,    0,  519,    0,  439,    0,    0,    0,  439, 
          519,  519,    0,    0,  401,    0,  402,  135,  403,  404, 
          405,  406,  407,  408,  409,    0,  410,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  439,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  136,    0, 
            0,    0,    0,    0,  622,  622,  622,    0,  622,  320, 
          320,  320,  622,  622,  320,  320,  320,  622,  320,  622, 
          622,  622,  622,  622,  622,  622,    0,    0,  320,  320, 
          622,  622,  622,  622,  622,  622,  622,  320,  320,  622, 
          320,  320,  320,  320,  320,    0,  622,  136,    0,  622, 
          622,  622,  320,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  320,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,  107,    0, 
          320,  320,  320,  320,  622,  545,  320,  622,  622,  320, 
          622,  622,  320,  622,  320,  622,  320,  622,  320,  622, 
          320,  320,  320,  320,  320,  320,  320,  622,  320,    0, 
          320,    0,  622,  622,  622,  622,  622,  622,    0,    0, 
            0,  622,  320,  622,  622,  622,  622,  622,  622,  622, 
            0,    0,    0,    0,  545,    0,    0,  129,    0,  622, 
          622,  622,  320,  287,  287,  287,    0,  287,  439,  439, 
          439,  287,  287,  439,  439,  439,  287,  439,  287,  287, 
          287,  287,  287,  287,  287,    0,  439,  439,  439,  287, 
          287,  287,  287,  287,  287,  287,  439,  439,  287,  439, 
          439,  439,  439,  439,    0,  287,  129,    0,  287,  287, 
          287,    0,  287,  287,  287,  287,  287,  287,  287,  287, 
          287,  287,  287,  439,  439,  439,  439,  439,  439,  439, 
          439,  439,  439,  439,  439,  439,  439,  411,  310,  439, 
          439,  439,  439,  287,    0,  439,  287,    0,  439,  287, 
          287,  439,  287,  439,  287,  439,  287,  439,  287,  439, 
          439,  439,  439,  439,  439,  439,  287,  439,  439,  439, 
            0,  287,  287,  287,  287,  287,  287,    0,    0,  647, 
          287,    0,  287,  287,    0,  287,  287,  287,  287,  647, 
            0,    0,    0,    0,    0,    0,    0,    0,  287,  287, 
          287,  439,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  136,    0,  136,  136,  136,  136, 
          136,    0,    0,  647,    0,  136,    0,    0,    0,    0, 
            0,    0,    0,  126,  622,    0,  518,    0,  647,    0, 
            0,    0,  647,    0,  518,    0,    0,    0,  136,  136, 
            0,    0,    0,    0,    0,    0,  136,  136,  136,  136, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          647,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  550,  622,  551,  552,  553,  554,  555,    0,  622, 
          622,    0,  556,    0,    0,  622,    0,    0,    0,    0, 
            0,  545,  136,  545,  545,  545,  545,  545,    0,    0, 
            0,    0,  545,    0,  129,  557,  622,    0,  327,    0, 
            0,    0,    0,  559,  560,  561,  562,    0,  327,    0, 
            0,    0,    0,    0,    0,  545,    0,    0,    0,    0, 
            0,    0,    0,  545,  545,  545,  545,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  327,    0,    0,    0,    0,    0,    0,  563, 
            0,  796,    0,    0,    0,  310,    0,  327,    0,    0, 
            0,  327,  310,  310,    0,    0,    0,    0,    0,  545, 
            0,  386,  387,  388,  389,  390,  391,  392,  393,  394, 
          395,  396,    0,  397,  398,    0,    0,  399,  400,  327, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  401,    0,  402,    0,  403,  404,  405, 
          406,  407,  408,  409,    0,  410,  287,  287,  287,    0, 
          287,  647,  647,  647,  287,  287,  647,  647,  647,  287, 
          647,  287,  287,  287,  287,  287,  287,  287,    0,  647, 
          647,  647,  287,  287,  287,  287,  287,  287,  287,  647, 
          647,  287,  647,  647,  647,  647,  647,    0,  287,    0, 
            0,  287,  287,  287,    0,  287,  287,  287,  287,  287, 
          287,  287,  287,  287,  287,  287,  647,  647,  647,  647, 
          647,  647,  647,  647,  647,  647,  647,  647,  647,  647, 
          258,    0,  647,  647,  647,  647,  287,  625,  647,  287, 
          258,  647,  287,  287,  647,  287,  647,  287,  647,  287, 
          647,  287,  647,  647,  647,  647,  647,  647,  647,  287, 
          647,  647,  647,    0,  287,  287,  287,  287,  287,  287, 
            0,  625,    0,  287,  258,  287,  287,    0,  287,  287, 
          287,  287,    0,    0,    0,    0,  625,    0,  258,  258, 
            0,  287,  287,  287,  647,  287,  287,  287,    0,  287, 
          327,  327,  327,  287,  287,  327,  327,  327,  287,  327, 
          287,  287,  287,  287,  287,  287,  287,    0,  625,  327, 
          327,  287,  287,  287,  287,  287,  287,  287,  327,  327, 
          287,  327,  327,  327,  327,  327,    0,  287,    0,    0, 
          287,  287,  287,    0,  287,  287,  287,  287,  287,  287, 
          287,  287,  287,  287,  287,  327,  327,  327,  327,  327, 
          327,  327,  327,  327,  327,  327,  327,  327,  327,    0, 
            0,  327,  327,  327,  327,  287,    0,  327,  287,    0, 
          327,  287,  287,  327,  287,  327,  287,  327,  287,  327, 
          287,  327,  327,  327,  327,  327,  327,  327,  287,  327, 
          515,  327,    0,  287,  287,  287,  287,  287,  287,    0, 
          515,    0,  287,    0,  287,  287,    0,  287,  287,  287, 
          287,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          287,  287,  287,  327,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   92,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  515, 
            0,  111,    0,  515,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  515,  258,  258,  258,    0,    0,  258,  258,  258, 
            0,  258,    0,    0,    0,    0,    0,  625,    0,    0, 
            0,  258,  258,    0,    0,    0,    0,    0,    0,    0, 
          258,  258,    0,  258,  258,  258,  258,  258,    0,    0, 
            0,    0,    0,    0,    0,  258,    0,    0,    0,  518, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  518, 
            0,    0,    0,    0,    0,  625,    0,    0,    0,    0, 
            0,    0,  625,  625,    0,    0,    0,    0,  621,  258, 
            0,    0,  258,    0,    0,  258,    0,  258,    0,    0, 
            0,    0,    0,   95,    0,    0,  625,    0,    0,  625, 
            0,    0,    0,  258,    0,  635,  629,    0,  518,  636, 
          114,    0,  518,  188,  189,  258,  190,  191,  192,  193, 
          194,  195,  196,    0,    0,  197,  198,    0,    0,    0, 
          199,  200,  201,  202,    0,  258,    0,    0,    0,    0, 
          518,    0,    0,    0,    0,    0,    0,  204,  205,    0, 
          206,  207,  208,  209,  210,  211,  212,  213,  214,  215, 
          216,    0,    0,  217,    0,    0,    0,  618,  618,  618, 
            0,  618,  515,  515,  515,  618,  618,    0,  515,  515, 
          618,  515,  618,  618,  618,  618,  618,  618,  618,    0, 
          618,    0,    0,  618,  618,  618,  618,  618,  618,  618, 
          515,  515,  618,  515,  515,  515,  515,  515,    0,  618, 
            0,    0,  618,  618,  618,    0,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  515,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,  515, 
          515,    0,    0,  515,  515,  515,  515,  618,  527,  111, 
          618,  618,  515,  618,  618,    0,  618,    0,  618,  515, 
          618,  515,  618,  515,  515,  515,  515,  515,  515,  515, 
          618,  515,  618,  515,    0,  618,  618,  618,  618,  618, 
          618,    0,  881,    0,  618,  881,  618,  618,    0,  618, 
          618,  618,  618,    0,  893,    0,    0,    0,  111,    0, 
          128,    0,  618,  618,  618,  515,  619,  619,  619,    0, 
          619,  518,  518,  518,  619,  619,    0,  518,  518,  619, 
          518,  619,  619,  619,  619,  619,  619,  619,    0,  619, 
          515,    0,  619,  619,  619,  619,  619,  619,  619,  518, 
          518,  619,  518,  518,  518,  518,  518,    0,  619,  128, 
            0,  619,  619,  619,    0,  619,  619,  619,  619,  619, 
          619,  619,  619,  619,  619,  619,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          411,  321,  518,  518,  518,  518,  619,  530,    0,  619, 
          619,  518,  619,  619,    0,  619,    0,  619,  518,  619, 
          518,  619,  518,  518,  518,  518,  518,  518,  518,  619, 
          518,  619,  518,    0,  619,  619,  619,  619,  619,  619, 
            0,    0,  625,  619,    0,  619,  619,    0,  619,  619, 
          619,  619,  625,    0,    0,    0,    0,    0,    0,    0, 
            0,  619,  619,  619,  518,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  106,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  625,    0,  125,    0,  625,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  893,    0,    0,  893,    0, 
          881,    0,  893,    0,    0,    0,  111,    0,    0,    0, 
            0,    0,    0,  625,    0,    0,    0,    0,    0,  618, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  128,    0,    0, 
            0,  621,    0,    0,    0,    0,    0,  515,    0,    0, 
            0,  621,    0,    0,  515,  515,    0,    0,    0,    0, 
          618,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          893,    0,  893,    0,  893,    0,    0,  893,    0,    0, 
            0,  618,    0,    0,    0,  105,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  321,    0, 
          621,    0,  124,  893,  621,  321,  321,    0,    0,    0, 
            0,    0,    0,    0,  386,  387,  388,  389,  390,  391, 
          392,  393,  394,  395,  396,    0,  397,  398,    0,    0, 
          399,  400,  621,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  401,    0,  402,    0, 
          403,  404,  405,  406,  407,  408,  409,    0,  410,  621, 
          621,  621,    0,  621,  625,  625,  625,  621,  621,    0, 
          625,  625,  621,  625,  621,  621,  621,  621,  621,  621, 
          621,    0,  625,    0,    0,  621,  621,  621,  621,  621, 
          621,  621,  625,  625,  621,  625,  625,  625,  625,  625, 
            0,  621,    0,    0,  621,  621,  621,    0,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  625, 
          625,  625,  625,  625,  625,  625,  625,  625,  625,  625, 
          625,  625,  625,    0,    0,  625,  625,  625,  625,  621, 
            0,  114,  621,  621,  625,  621,  621,    0,  621,    0, 
          621,  625,  621,  625,  621,  625,  625,  625,  625, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          625,  625,  625,  621,  625,  625,  625,    0,  621,  621, 
          621,  621,  621,  621,    0,    0,    0,  621,    0,  621, 
          621,    0,  621,  621,  621,  621,    0,    0,    0,    0, 
            0,  114,    0,    0,    0,  621,  621,  621,  625,  621, 
          621,  621,    0,  621,  621,  621,  621,  621,  621,    0, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,    0,  621,  518,    0,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
            0,  621,    0,    0,  621,  621,  621,    0,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,    0,    0,  621,  621,  621,  621,  621, 
            0,    0,  621,  621,  621,  621,  621,    0,  621,    0, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,    0,  621,  621,  621, 
          621,  621,  621,    0,    0,  622,  621,    0,  621,  621, 
            0,  621,  621,  621,  621,  622,    0,    0,    0,    0, 
            0,    0,    0,    0,  621,  621,  621,  621,    0,    0, 
          620,  621,    0,    0,  622,    0,    0,    0,  188,  189, 
            0,  190,  191,  192,  193,  194,  195,  196,    0,  107, 
          197,  198,    0,    0,    0,  199,  200,  201,  202,    0, 
            0,    0,    0,    0,  622,  304,  126,    0,  622,    0, 
            0,    0,  204,  205,    0,  206,  207,  208,  209,  210, 
          211,  212,  213,  214,  215,  216,    0,    0,  217,  114, 
            0,    0,    0,    0,    0,    0,  622,    0,    0,    0, 
            0,    0,  619,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  625,    0,    0,    0,    0,    0, 
          518,    0,    0,    0,  625,    0,    0,  518,  518,    0, 
            0,    0,    0,  619,    0,    0,  628,  629,    0,    0, 
          630,    0,    0,    0,  188,  189,    0,  190,  191,  192, 
          193,  194,  195,  196,  619,    0,  197,  198,  625,    0, 
            0,  199,  200,  201,  202,    0,    0,    0,    0,    0, 
            0,  304,    0,  625,    0,  125,    0,  625,  204,  205, 
            0,  206,  207,  208,  209,  210,  211,  212,  213,  214, 
          215,  216,    0,    0,  217,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  625,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  622,  622,  622,    0,  622,  622,  622,  622, 
          622,  622,    0,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,    0,  622,    0,    0,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,    0,  622,    0,    0,  622,  622,  622, 
            0,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,    0,    0,  622,  622, 
          622,  622,  622,    0,  125,  622,  622,  622,  622,  622, 
            0,  622,    0,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,    0, 
          622,  622,  622,  622,  622,  622,    0,    0,    0,  622, 
            0,  622,  622,    0,  622,  622,  622,  622,    0,    0, 
            0,    0,    0,  125,    0,    0,    0,  622,  622,  622, 
          622,  621,  621,  621,    0,  621,  625,  625,  625,  621, 
          621,    0,  625,  625,  621,  625,  621,  621,  621,  621, 
          621,  621,  621,    0,  625,  625,    0,  621,  621,  621, 
          621,  621,  621,  621,  625,  625,  621,  625,  625,  625, 
          625,  625,    0,  621,    0,    0,  621,  621,  621,    0, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  625,  625,  625,  625,  625,  625,  625,  625,  625, 
          625,  625,  625,  625,  625,    0,    0,  625,  625,  625, 
          625,  621,    0,    0,  621,  621,  625,  621,  621,    0, 
          621,    0,  621,  625,  621,  625,  621,  625,  625,  625, 
          625,  625,  625,  625,  621,  625,  625,  625,    0,  621, 
          621,  621,  621,  621,  621,    0,    0,  621,  621,    0, 
          621,  621,    0,  621,  621,  621,  621,  621,    0,    0, 
            0,    0,    0,    0,    0,    0,  621,  621,  621,  625, 
            0,    0,  669,  621,    0,    0,  670,    0,    0,    0, 
          188,  189,    0,  190,  191,  192,  193,  194,  195,  196, 
            0,  621,  197,  198,    0,    0,    0,  199,  200,  201, 
          202,    0,    0,    0,    0,    0,  621,  304,  124,    0, 
          621,    0,    0,    0,  204,  205,    0,  206,  207,  208, 
          209,  210,  211,  212,  213,  214,  215,  216,    0,    0, 
          217,  125,    0,    0,    0,    0,    0,    0,  621,    0, 
            0,    0,    0,    0,  625,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  622,    0,    0,    0, 
            0,    0,  625,    0,    0,    0,  622,    0,    0,  625, 
          625,    0,    0,    0,    0,  621,    0,    0,  635,  629, 
            0,    0,  636,    0,    0,    0,  188,  189,    0,  190, 
          191,  192,  193,  194,  195,  196,  625,    0,  197,  198, 
          622,    0,    0,  199,  200,  201,  202,    0,    0,    0, 
            0,    0,    0,  304,    0,  622,    0,  126,    0,  622, 
          204,  205,    0,  206,  207,  208,  209,  210,  211,  212, 
          213,  214,  215,  216,    0,    0,  217,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  622,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  621,  621,  621,    0,  621,  621, 
          621,  621,  621,  621,    0,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,    0,  621,    0,    0, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,    0,  621,    0,    0,  621, 
          621,  621,    0,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,    0,    0, 
          621,  621,  621,  621,  621,    0,  124,  621,  621,  621, 
          621,  621,    0,  621,    0,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,    0,  621,  621,  621,  621,  621,  621,    0,    0, 
            0,  621,    0,  621,  621,    0,  621,  621,  621,  621, 
            0,    0,    0,    0,    0,  124,    0,    0,    0,  621, 
          621,  621,  621,  622,  622,  622,    0,  622,  622,  622, 
          622,  622,  622,    0,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,    0,  622,  621,    0,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,    0,  622,    0,    0,  622,  622, 
          622,    0,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,    0,    0,  622, 
          622,  622,  622,  622,    0,    0,  622,  622,  622,  622, 
          622,    0,  622,    0,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
            0,  622,  622,  622,  622,  622,  622,    0,    0,  320, 
          622,    0,  622,  622,    0,  622,  622,  622,  622,  320, 
            0,    0,  101,    0,    0,    0,    0,    0,  622,  622, 
          622,  622,    0,    0,  687,  621,    0,    0,  688,    0, 
            0,    0,  188,  189,    0,  190,  191,  192,  193,  194, 
          195,  196,    0,  108,  197,  198,  101,    0,    0,  199, 
          200,  201,  202,    0,    0,    0,    0,    0,  320,  304, 
          127,    0,  320,  101,    0,    0,  204,  205,    0,  206, 
          207,  208,  209,  210,  211,  212,  213,  214,  215,  216, 
            0,    0,  217,  124,    0,    0,    0,    0,    0,    0, 
          320,    0,    0,  524,    0,    0,  621,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  320,    0, 
            0,    0,    0,    0,  621,    0,    0,    0,  320,    0, 
            0,  621,  621,    0,    0,    0,    0,  621,    0,    0, 
          690,  629,    0,    0,  691,    0,    0,    0,  188,  189, 
            0,  190,  191,  192,  193,  194,  195,  196,  621,    0, 
          197,  198,  320,    0,    0,  199,  200,  201,  202,    0, 
            0,    0,    0,    0,    0,  304,    0,  320,    0,  127, 
            0,  320,  204,  205,    0,  206,  207,  208,  209,  210, 
          211,  212,  213,  214,  215,  216,    0,    0,  217,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  320, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  622,  622,  622,    0, 
          622,  320,  320,  320,  622,  622,    0,  320,  320,  622, 
          320,  622,  622,  622,  622,  622,  622,  622,    0,    0, 
            0,  101,  622,  622,  622,  622,  622,  622,  622,  320, 
          320,  622,  320,  320,  320,  320,  320,    0,  622,    0, 
            0,  622,  622,  622,    0,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,  320,  320, 
          524,    0,  320,  320,  320,  320,  622,  524,  524,  622, 
          622,  320,  622,  622,  101,  622,    0,  622,  320,  622, 
          320,  622,  320,  320,  320,  320,  320,  320,  320,  622, 
          320,  647,  320,    0,  622,  622,  622,  622,  622,  622, 
            0,  647,    0,  622,    0,  622,  622,    0,  622,  622, 
          622,  622,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  622,  622,  622,  320,  622,  622,  622,    0,  622, 
          320,  320,  320,  622,  622,    0,  320,  320,  622,  320, 
          622,  622,  622,  622,  622,  622,  622,    0,    0,    0, 
          647,  622,  622,  622,  622,  622,  622,  622,  320,  320, 
          622,  320,  320,  320,  320,  320,    0,  622,    0,    0, 
          622,  622,  622,    0,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,  320,    0, 
            0,  320,  320,  320,  320,  622,    0,    0,  622,  622, 
          320,  622,  622,    0,  622,    0,  622,  320,  622,  320, 
          622,  320,  320,  320,  320,  320,  320,  320,  622,  320, 
          440,  320,    0,  622,  622,  622,  622,  622,  622,    0, 
          440,    0,  622,    0,  622,  622,    0,  622,  622,  622, 
          622,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          622,  622,  622,  320,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  440,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  440,  440, 
            0,  123,    0,  440,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  440,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          126,    0,    0,    0,    0,    0,    0,    0,  287,  287, 
          287,    0,  287,  647,  647,  647,  287,  287,  647,  647, 
          647,  287,  647,  287,  287,  287,  287,  287,  287,  287, 
            0,  647,  647,    0,  287,  287,  287,  287,  287,  287, 
          287,  647,  647,  287,  647,  647,  647,  647,  647,  126, 
          287,    0,    0,  287,  287,  287,    0,  287,  287,  287, 
          287,  287,  287,  287,  287,  287,  287,  287,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  647, 
            0,  622,    0,    0,    0,    0,  647,  647,  287,    0, 
            0,  287,    0,  647,  287,  287,    0,  287,    0,  287, 
            0,  287,    0,  287,    0,  439,    0,    0,    0,    0, 
            0,  287,    0,  647,  647,  439,  287,  287,  287,  287, 
          287,  287,    0,    0,    0,  287,    0,  287,  287,    0, 
          287,  287,  287,  287,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  287,  287,  287,  647,    0,    0,  439, 
            0,    0,  440,  440,  440,    0,    0,  440,  440,  440, 
            0,  440,    0,  439,  439,    0,    0,    0,  439,    0, 
          440,  440,  440,    0,    0,    0,    0,    0,    0,    0, 
          440,  440,    0,  440,  440,  440,  440,  440,    0,    0, 
            0,    0,    0,    0,    0,  440,  439,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  440,  440,  440, 
          440,  440,  440,  440,  440,  440,  440,  440,  440,  440, 
          440,    0,    0,  440,  440,  440,  440,    0,  521,  440, 
            0,    0,  440,    0,    0,  440,    0,  440,  521,  440, 
            0,  440,    0,  440,  440,  440,  440,  440,  440,  440, 
            0,  440,  440,  440,    0,    0,    0,  126,    0,    0, 
            0,    0,    0,    0,    0,  440,    0,    0,    0,    0, 
          622,    0,  521,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  440,  521,  521,    0,  117, 
            0,  521,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  622,  521, 
            0,    0,    0,    0,    0,  622,  622,    0,    0,    0, 
            0,  622,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  520,    0,    0,    0,    0, 
            0,    0,  622,    0,    0,  520,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  439,  439,  439, 
            0,    0,  439,  439,  439,    0,  439,    0,    0,    0, 
            0,    0,    0,    0,    0,  439,  439,  439,    0,  520, 
            0,    0,    0,    0,    0,  439,  439,    0,  439,  439, 
          439,  439,  439,  520,  520,    0,  116,    0,  520,    0, 
          439,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  439,  439,  439,  439,  439,  439,  439,  439, 
          439,  439,  439,  439,  439,  439,  520,    0,  439,  439, 
          439,  439,    0,    0,  439,    0,    0,  439,    0,    0, 
          439,    0,  439,    0,  439,  103,  439,    0,  439,  439, 
          439,  439,  439,  439,  439,    0,  439,  439,  439,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          439,    0,    0,    0,    0,    0,    0,    0,    0,  103, 
          521,  521,  521,    0,    0,  521,  521,  521,    0,  521, 
          439,    0,    0,    0,    0,    0,  103,    0,    0,  521, 
          521,    0,    0,    0,    0,    0,    0,    0,  521,  521, 
            0,  521,  521,  521,  521,  521,    0,    0,    0,    0, 
            0,    0,    0,  521,  522,    0,  526,    0,    0,    0, 
            0,    0,    0,    0,  522,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,  521,  521,  521,    0, 
            0,  521,  521,  521,  521,    0,  533,  521,    0,    0, 
          521,    0,    0,  521,    0,  521,    0,  521,  522,  521, 
            0,  521,  521,  521,  521,  521,  521,  521,    0,  521, 
            0,  521,  522,  522,    0,  118,    0,  522,    0,    0, 
            0,    0,    0,  521,    0,    0,    0,  520,  520,  520, 
            0,    0,  520,  520,  520,    0,  520,    0,    0,    0, 
            0,    0,    0,  521,    0,  522,  520,  520,    0,    0, 
            0,    0,    0,    0,    0,  520,  520,    0,  520,  520, 
          520,  520,  520,    0,    0,    0,    0,    0,    0,    0, 
          520,  523,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  523,  520,  520,  520,  520,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,    0,    0,  520,  520, 
          520,  520,    0,  532,  520,    0,    0,  520,    0,    0, 
          520,    0,  520,    0,  520,  523,  520,    0,  520,  520, 
          520,  520,  520,  520,  520,    0,  520,    0,  520,  523, 
          523,    0,  119,    0,  523,    0,    0,    0,    0,    0, 
          520,    0,    0,    0,  103,    0,   94,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          520,    0,  523,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           94,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  526,  525,    0,    0,   94,    0,    0, 
          526,  526,    0,    0,  525,    0,    0,  103,    0,    0, 
            0,    0,    0,    0,    0,    0,  522,  522,  522,    0, 
            0,  522,  522,  522,    0,  522,    0,  517,    0,    0, 
            0,    0,    0,    0,    0,  522,  522,    0,  525,    0, 
            0,    0,    0,    0,  522,  522,    0,  522,  522,  522, 
          522,  522,  525,  525,    0,  121,    0,  525,    0,  522, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  522,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,  522,  522,  525,    0,  522,  522,  522, 
          522,    0,  534,  522,    0,    0,  522,   93,    0,  522, 
            0,  522,    0,  522,    0,  522,    0,  522,  522,  522, 
          522,  522,  522,  522,   57,  522,    0,  522,    0,    0, 
            0,    0,    0,    0,   57,    0,    0,    0,    0,  522, 
            0,   93,    0,  523,  523,  523,    0,    0,  523,  523, 
          523,    0,  523,    0,    0,    0,    0,    0,   93,  522, 
            0,    0,  523,  523,    0,    0,    0,    0,    0,    0, 
            0,  523,  523,    0,  523,  523,  523,  523,  523,    0, 
            0,    0,    0,   57,    0,    0,  523,  524,  516,    0, 
            0,    0,    0,    0,    0,    0,    0,  524,  523,  523, 
          523,  523,  523,  523,  523,  523,  523,  523,  523,  523, 
          523,  523,    0,    0,  523,  523,  523,  523,    0,  535, 
          523,    0,    0,  523,    0,   94,  523,    0,  523,    0, 
          523,  524,  523,    0,  523,  523,  523,  523,  523,  523, 
          523,    0,  523,    0,  523,  524,  524,    0,  120,    0, 
          524,    0,    0,    0,    0,    0,  523,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  525,  525,  525,    0, 
            0,  525,  525,  525,  517,  525,  523,    0,  524,    0, 
            0,  517,  517,    0,    0,  525,  525,    0,   94,    0, 
            0,    0,    0,    0,  525,  525,    0,  525,  525,  525, 
          525,  525,    0,    0,    0,    0,    0,    0,    0,  525, 
          526,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          526,  525,  525,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,    0,    0,  525,  525,  525, 
          525,    0,  537,  525,    0,    0,  525,    0,    0,  525, 
            0,  525,    0,  525,  526,  525,    0,  525,  525,  525, 
          525,  525,  525,  525,    0,  525,    0,  525,  526,  526, 
            0,  122,    0,  526,    0,    0,   93,    0,    0,  525, 
            0,    0,    0,    0,    0,    0,   57,   57,   57,    0, 
            0,   57,   57,   57,    0,   57,    0,    0,    0,  525, 
            0,  526,    0,    0,    0,   57,    0,    0,    0,    0, 
            0,    0,    0,    0,   57,   57,    0,   57,   57,   57, 
           57,   57,    0,    0,    0,  516,    0,  517,    0,    0, 
            0,    0,  516,  516,    0,    0,    0,  517,    0,   93, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  524, 
          524,  524,    0,    0,  524,  524,  524,    0,  524,    0, 
            0,    0,    0,    0,    0,    0,   57,    0,  524,  524, 
            0,  517,    0,    0,    0,    0,    0,  524,  524,    0, 
          524,  524,  524,  524,  524,  517,  517,   57,  113,    0, 
          517,    0,  524,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  517,   57, 
          524,  524,  524,  524,    0,  536,  524,    0,    0,  524, 
            0,    0,  524,    0,  524,    0,  524,   96,  524,    0, 
          524,  524,  524,  524,  524,  524,  524,    0,  524,    0, 
          524,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  524,    0,    0,    0,    0,    0,    0,    0, 
            0,   96,  526,  526,  526,    0,    0,  526,  526,  526, 
            0,  526,  524,    0,    0,    0,    0,    0,   96,    0, 
            0,  526,  526,    0,    0,    0,    0,    0,    0,    0, 
          526,  526,    0,  526,  526,  526,  526,  526,    0,    0, 
            0,    0,    0,    0,    0,  526,  516,    0,  519,    0, 
            0,    0,    0,    0,    0,    0,  516,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,    0,    0,  526,  526,  526,  526,    0,  538,  526, 
            0,    0,  526,    0,    0,  526,    0,  526,    0,  526, 
          516,  526,    0,  526,  526,  526,  526,  526,  526,  526, 
            0,  526,    0,  526,  516,  516,    0,  112,    0,  516, 
            0,    0,    0,    0,    0,  526,    0,    0,    0,  517, 
          517,  517,    0,    0,  517,  517,  517,    0,  517,    0, 
            0,    0,    0,    0,    0,  526,    0,  516,  517,  517, 
            0,    0,    0,    0,    0,    0,    0,  517,  517,    0, 
          517,  517,  517,  517,  517,    0,    0,    0,    0,    0, 
            0,    0,  517,  519,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  519,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,  517,  517,  517,  517,  517,    0,    0, 
          517,  517,  517,  517,    0,  529,  517,    0,    0,  517, 
            0,    0,  517,    0,  517,    0,  517,  519,  517,    0, 
          517,  517,  517,  517,  517,  517,  517,    0,  517,    0, 
          517,  519,  519,    0,  115,    0,  519,    0,    0,    0, 
            0,    0,  517,    0,    0,    0,   96,    0,  110,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  517,    0,  519,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  110,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  519,  647,    0,    0,  110, 
            0,    0,  519,  519,    0,    0,  647,    0,    0,   96, 
            0,    0,    0,    0,    0,    0,    0,    0,  516,  516, 
          516,    0,    0,  516,  516,  516,    0,  516,    0,  310, 
            0,    0,    0,    0,    0,    0,    0,  516,  516,    0, 
          647,    0,    0,    0,    0,    0,  516,  516,    0,  516, 
          516,  516,  516,  516,  647,  647,    0,    0,    0,  647, 
            0,  516,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  516,  516,  516,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  647,    0,  516, 
          516,  516,  516,    0,  528,  516,    0,    0,  516,  109, 
            0,  516,    0,  516,    0,  516,    0,  516,    0,  516, 
          516,  516,  516,  516,  516,  516,   58,  516,    0,  516, 
            0,    0,    0,    0,    0,    0,   58,    0,    0,    0, 
            0,  516,    0,  109,    0,  519,  519,  519,    0,    0, 
          519,  519,  519,    0,  519,    0,    0,    0,    0,    0, 
          109,  516,    0,    0,  519,  519,    0,    0,    0,    0, 
            0,    0,    0,  519,  519,    0,  519,  519,  519,  519, 
          519,    0,    0,    0,    0,   58,    0,    0,  519,  310, 
          321,    0,    0,    0,    0,    0,    0,    0,    0,  310, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,    0,    0,  519,  519,  519,  519, 
            0,  531,  519,    0,    0,  519,    0,  110,  519,    0, 
          519,    0,  519,  310,  519,    0,  519,  519,  519,  519, 
          519,  519,  519,    0,  519,    0,  519,  310,  310,    0, 
          129,    0,  310,    0,    0,    0,    0,    0,  519,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  647,  647, 
          647,    0,    0,  647,  647,  647,  310,  647,  519,    0, 
          310,    0,    0,  310,  310,    0,  647,  647,  647,    0, 
          110,    0,    0,    0,    0,    0,  647,  647,    0,  647, 
          647,  647,  647,  647,    0,    0,    0,    0,    0,    0, 
            0,  647,  321,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  321,  647,  647,  647,  647,  647,  647,  647, 
          647,  647,  647,  647,  647,  647,  647,    0,    0,  647, 
          647,  647,  647,    0,    0,  647,    0,    0,  647,    0, 
            0,  647,    0,  647,    0,  647,  321,  647,    0,  647, 
          647,  647,  647,  647,  647,  647,    0,  647,  647,  647, 
          321,  321,    0,  128,    0,  321,    0,    0,  109,    0, 
            0,  647,    0,    0,    0,    0,    0,    0,   58,   58, 
           58,    0,    0,   58,   58,   58,    0,   58,    0,    0, 
            0,  647,    0,  321,    0,    0,    0,   58,    0,    0, 
            0,    0,    0,    0,    0,    0,   58,   58,    0,   58, 
           58,   58,   58,   58,    0,    0,    0,  321,    0,  463, 
            0,    0,    0,    0,  321,  321,    0,    0,    0,  463, 
            0,  109,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  310,  310,  310,    0,    0,  310,  310,  310,    0, 
          310,    0,    0,    0,    0,    0,    0,    0,   58,    0, 
          310,  310,    0,  463,    0,    0,    0,    0,    0,  310, 
          310,    0,  310,  310,  310,  310,  310,  463,  463,   58, 
            0,    0,  463,    0,  310,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  310,  310,  310,  310, 
          310,  310,  310,  310,  310,  310,  310,  310,  310,  310, 
          463,   58,  310,  310,  310,  310,    0,    0,  310,    0, 
            0,  310,    0,    0,  310,    0,  310,    0,  310,    0, 
          310,    0,  310,  310,  310,  310,  310,  310,  310,    0, 
          310,    0,  310,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  310,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  321,  321,  321,    0,    0,  321, 
          321,  321,    0,  321,  310,    0,    0,    0,    0,    0, 
            0,    0,    0,  321,  321,    0,    0,    0,    0,    0, 
            0,    0,  321,  321,    0,  321,  321,  321,  321,  321, 
            0,    0,    0,    0,    0,    0,    0,  321,  332,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  332,  321, 
          321,  321,  321,  321,  321,  321,  321,  321,  321,  321, 
          321,  321,  321,    0,    0,  321,  321,  321,  321,    0, 
            0,  321,    0,    0,  321,    0,    0,  321,    0,  321, 
            0,  321,  332,  321,    0,  321,  321,  321,  321,  321, 
          321,  321,    0,  321,    0,  321,  332,  332,    0,    0, 
            0,  332,    0,    0,    0,    0,    0,  321,    0,    0, 
            0,  463,  463,  463,    0,    0,  463,  463,  463,    0, 
          463,    0,    0,    0,    0,    0,    0,  321,    0,  332, 
          463,  463,    0,    0,    0,    0,    0,    0,    0,  463, 
          463,    0,  463,  463,  463,  463,  463,    0,    0,    0, 
            0,    0,    0,    0,  463,  260,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  260,  463,  463,  463,  463, 
          463,  463,  463,  463,  463,  463,  463,  463,  463,  463, 
            0,    0,  463,  463,  463,  463,    0,    0,  463,    0, 
            0,  463,    0,    0,  463,    0,  463,    0,  463,  260, 
          463,    0,  463,  463,  463,  463,  463,  463,  463,    0, 
          463,    0,  463,  260,  260,    0,    0,    0,  260,    0, 
            0,    0,  700,  621,  463,    0,  701,    0,    0,    0, 
          188,  189,    0,  190,  191,  192,  193,  194,  195,  196, 
            0,    0,  197,  198,  463,    0,  363,  199,  200,  201, 
          202,    0,    0,    0,    0,    0,    0,  304,    0,    0, 
            0,    0,    0,    0,  204,  205,    0,  206,  207,  208, 
          209,  210,  211,  212,  213,  214,  215,  216,  327,    0, 
          217,    0,    0,    0,    0,    0,    0,    0,  327,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          332,  332,  332,    0,    0,  332,  332,  332,    0,  332, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  332, 
          332,    0,  327,    0,    0,    0,    0,    0,  332,  332, 
            0,  332,  332,  332,  332,  332,  327,  327,    0,    0, 
            0,  327,    0,  332,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  332,  332,  332,  332,  332, 
          332,  332,  332,  332,  332,  332,  332,  332,  332,  327, 
            0,  332,  332,  332,  332,    0,    0,  332,    0,    0, 
          332,    0,    0,  332,    0,  332,    0,  332,    0,  332, 
            0,  332,  332,  332,  332,  332,  332,  332,  298,  332, 
            0,  332,    0,    0,    0,    0,    0,    0,  298,    0, 
            0,    0,    0,  332,    0,    0,    0,  260,  260,  260, 
            0,    0,  260,  260,  260,    0,  260,    0,    0,    0, 
            0,    0,    0,  332,    0,    0,  260,  260,    0,    0, 
            0,    0,  294,    0,    0,  260,  260,    0,  260,  260, 
          260,  260,  260,    0,    0,    0,    0,  298,    0,    0, 
          260,  510,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  510,  260,  260,  260,  260,  260,  260,  260,  260, 
          260,  260,  260,  363,  260,  260,    0,    0,  260,  260, 
          363,  363,    0,    0,  260,    0,    0,  260,    0,    0, 
          260,    0,  260,    0,  260,  510,  260,    0,  260,  260, 
          260,  260,  260,  260,  260,    0,  260,    0,  260,  510, 
          510,    0,    0,    0,  510,    0,    0,    0,    0,    0, 
          260,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          327,  327,  327,    0,    0,  327,  327,  327,    0,  327, 
          260,    0,  510,    0,    0,    0,    0,    0,    0,  327, 
          327,    0,    0,    0,    0,    0,    0,    0,  327,  327, 
            0,  327,  327,  327,  327,  327,    0,    0,    0,    0, 
            0,    0,    0,  327,  359,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  359,  327,  327,  327,  327,  327, 
          327,  327,  327,  327,  327,  327,  327,  327,  327,    0, 
            0,  327,  327,  327,  327,    0,    0,  327,    0,    0, 
          327,    0,    0,  327,    0,  327,    0,  327,  359,  327, 
            0,  327,  327,  327,  327,  327,  327,  327,    0,  327, 
            0,  327,    0,  359,    0,    0,    0,  359,    0,    0, 
            0,    0,    0,  327,    0,    0,    0,    0,    0,    0, 
          298,  298,  298,    0,    0,  298,  298,  298,    0,  298, 
            0,    0,    0,  327,    0,  359,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  360,    0,    0, 
            0,  298,  298,  298,  298,  298,    0,  360,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  510,  510,  510,    0,    0,  510,  510, 
          510,  360,  510,    0,    0,    0,    0,  298,    0,    0, 
          298,    0,  510,  510,    0,    0,  360,    0,    0,    0, 
          360,  510,  510,    0,  510,  510,  510,  510,  510,    0, 
            0,  298,    0,    0,    0,    0,  510,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  360,  510, 
          510,  510,  510,  510,  510,  510,  510,  510,  510,  510, 
          510,  510,    0,  298,  510,  510,  510,  510,    0,  324, 
          510,    0,    0,  510,    0,    0,  510,    0,  510,  324, 
          510,    0,  510,    0,  510,  510,  510,  510,  510,  510, 
          510,    0,  510,    0,  510,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  510,    0,    0,    0, 
            0,    0,    0,  324,    0,    0,  359,  359,  359,    0, 
            0,  359,  359,  359,    0,  359,  510,    0,  324,    0, 
            0,    0,  324,    0,    0,  359,  359,    0,    0,    0, 
            0,    0,    0,    0,  359,  359,    0,  359,  359,  359, 
          359,  359,    0,    0,    0,    0,    0,    0,    0,    0, 
          324,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  359,  359,  359,  359,  359,  359,  359,  359,  359, 
          359,  359,  359,  359,  359,    0,    0,  359,  359,  359, 
          359,    0,    0,  359,    0,    0,  359,    0,    0,  359, 
            0,  359,    0,  359,    0,  359,   45,  359,  359,  359, 
          359,  359,  359,  359,    0,  359,   45,  359,    0,  360, 
          360,  360,    0,    0,  360,  360,  360,    0,  360,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  360,  360, 
            0,    0,    0,    0,    0,    0,    0,  360,  360,  359, 
          360,  360,  360,  360,  360,    0,    0,    0,    0,    0, 
            0,    0,    0,  241,    0,   45,    0,    0,    0,    0, 
            0,    0,    0,  241,  360,  360,  360,  360,  360,  360, 
          360,  360,  360,  360,  360,  360,  360,  360,    0,    0, 
          360,  360,  360,  360,    0,    0,  360,    0,    0,  360, 
            0,    0,  360,    0,  360,    0,  360,  241,  360,    0, 
          360,  360,  360,  360,  360,  360,  360,    0,  360,    0, 
          360,  241,  241,    0,    0,    0,  241,    0,    0,    0, 
            0,  324,  324,  324,    0,    0,  324,  324,  324,    0, 
          324,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          324,  324,  360,    0,    0,    0,    0,    0,    0,  324, 
          324,    0,  324,  324,  324,  324,  324,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  324,  324,  324,  324, 
          324,  324,  324,  324,  324,  324,  324,  324,  324,  324, 
          238,    0,  324,  324,  324,  324,    0,    0,  324,    0, 
          238,  324,    0,    0,  324,    0,  324,    0,  324,    0, 
          324,    0,  324,  324,  324,  324,  324,  324,  324,    0, 
          324,    0,  324,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  238,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  238,  238, 
            0,    0,    0,  238,  324,    0,    0,    0,   45,   45, 
           45,    0,    0,    0,   45,   45,    0,   45,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   45, 
           45,   45,   45,  235,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  235,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  241,  241,  241,    0,    0, 
          241,  241,  241,    0,  241,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  241,  241,    0,  235,   45,    0, 
            0,    0,    0,  241,  241,    0,  241,  241,  241,  241, 
          241,  235,  235,    0,    0,    0,  235,    0,  241,   45, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  241,  241,  241,  241,  241,  241,  241,  241,  241, 
          241,    0,  241,  241,    0,    0,  241,  241,    0,    0, 
            0,   45,  241,    0,    0,  241,    0,    0,  241,    0, 
          241,    0,  241,    0,  241,    0,  241,  241,  241,  241, 
          241,  241,  241,    0,  241,    0,  241,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  241,    0, 
          237,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          237,    0,    0,    0,    0,    0,    0,    0,  241,    0, 
            0,    0,  238,  238,  238,    0,    0,  238,  238,  238, 
            0,  238,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  238,  238,    0,  237,    0,    0,    0,    0,    0, 
          238,  238,    0,  238,  238,  238,  238,  238,  237,  237, 
            0,    0,    0,  237,    0,  238,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  238,  238, 
          238,  238,  238,  238,  238,  238,  238,  238,    0,  238, 
          238,    0,    0,  238,  238,    0,    0,    0,    0,  238, 
            0,    0,  238,    0,    0,  238,    0,  238,    0,  238, 
            0,  238,    0,  238,  238,  238,  238,  238,  238,  238, 
            0,  238,    0,  238,    0,  235,  235,  235,    0,    0, 
          235,  235,  235,    0,  235,  238,  236,    0,    0,    0, 
            0,    0,    0,    0,  235,  235,  236,    0,    0,    0, 
            0,    0,    0,  235,  235,  238,  235,  235,  235,  235, 
          235,    0,    0,    0,    0,    0,    0,    0,  235,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          236,  235,  235,  235,  235,  235,  235,  235,  235,  235, 
          235,    0,  235,  235,  236,  236,  235,  235,    0,  236, 
            0,    0,  235,    0,    0,  235,    0,    0,  235,    0, 
          235,    0,  235,    0,  235,    0,  235,  235,  235,  235, 
          235,  235,  235,    0,  235,    0,  235,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  235,    0, 
            0,    0,    0,    0,    0,  239,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  239,    0,    0,  235,    0, 
            0,    0,  237,  237,  237,    0,    0,  237,  237,  237, 
            0,  237,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  237,  237,    0,    0,    0,    0,    0,    0,  239, 
          237,  237,    0,  237,  237,  237,  237,  237,    0,    0, 
            0,    0,    0,  239,  239,  237,    0,    0,  239,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  237,  237, 
          237,  237,  237,  237,  237,  237,  237,  237,    0,  237, 
          237,    0,    0,  237,  237,    0,    0,    0,    0,  237, 
            0,    0,  237,    0,    0,  237,    0,  237,    0,  237, 
            0,  237,    0,  237,  237,  237,  237,  237,  237,  237, 
            0,  237,  440,  237,    0,    0,    0,    0,    0,    0, 
            0,    0,  440,    0,    0,  237,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  237,    0,    0,  236,  236, 
          236,    0,    0,  236,  236,  236,  104,  236,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  236,  236,    0, 
            0,  440,    0,  123,    0,  440,  236,  236,    0,  236, 
          236,  236,  236,  236,    0,    0,    0,   36,    0,    0, 
            0,  236,    0,    0,    0,    0,    0,   36,    0,    0, 
            0,    0,    0,  440,  236,  236,  236,  236,  236,  236, 
          236,  236,  236,  236,    0,  236,  236,    0,    0,  236, 
          236,    0,    0,    0,    0,  236,    0,    0,  236,    0, 
            0,  236,    0,  236,    0,  236,    0,  236,    0,  236, 
          236,  236,  236,  236,  236,  236,   36,  236,    0,  236, 
            0,    0,    0,    0,    0,    0,    0,  239,  239,  239, 
            0,  236,  239,  239,  239,    0,  239,    0,  272,    0, 
            0,    0,    0,    0,    0,    0,  239,  239,  272,    0, 
            0,  236,    0,    0,    0,  239,  239,    0,  239,  239, 
          239,  239,  239,    0,    0,    0,    0,    0,    0,    0, 
          239,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  267,  239,  239,  239,  239,  239,  239,  239, 
          239,  239,  239,  440,  239,  239,    0,  272,  239,  239, 
            0,    0,    0,  440,  239,    0,    0,  239,    0,    0, 
          239,    0,  239,    0,  239,    0,  239,    0,  239,  239, 
          239,  239,  239,  239,  239,    0,  239,    0,  239,    0, 
            0,    0,    0,    0,    0,    0,    0,  440,    0,    0, 
          239,    0,    0,    0,  440,  440,  440,    0,    0,    0, 
          440,  440,  440,  440,  123,    0,  440,    0,    0,    0, 
          239,    0,  440,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  440,  440,    0,  440,  440,  440,  440,  440, 
            0,    0,    0,    0,  440,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  440, 
          440,  440,  440,  440,  440,  440,  440,  440,  440,  440, 
          440,  440,  440,  521,    0,  440,  440,  440,  440,   36, 
           36,   36,    0,  521,  440,   36,   36,    0,   36,    0, 
            0,  440,    0,  440,    0,  440,  440,  440,  440,  440, 
          440,  440,    0,  440,  440,  440,    0,    0,    0,    0, 
           36,   36,   36,   36,   36,    0,    0,   98,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  521,    0,  117,    0,  521,  440,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           36,  272,  272,  272,    0,  521,    0,  272,  272,    0, 
          272,    0,    0,    0,    0,    0,    0,  520,    0,    0, 
            0,   36,    0,    0,    0,    0,    0,  520,    0,  272, 
          272,    0,  272,  272,  272,  272,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   36,    0,    0,  440,  440,  440,    0, 
            0,   97,  440,  440,    0,  440,    0,    0,    0,    0, 
            0,    0,    0,    0,  440,    0,  520,    0,  116,    0, 
          520,  272,    0,    0,  440,  440,    0,  440,  440,  440, 
          440,  440,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  272,    0,    0,    0,    0,    0,  520,    0, 
            0,  440,  440,  440,  440,  440,  440,  440,  440,  440, 
          440,  440,  440,  440,  440,  522,    0,  440,  440,  440, 
          440,    0,    0,    0,  272,  522,  440,    0,    0,    0, 
            0,    0,    0,  440,    0,  440,    0,  440,  440,  440, 
          440,  440,  440,  440,    0,  440,  440,  440,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   99, 
            0,    0,    0,    0,    0,    0,  521,  521,  521,    0, 
            0,    0,  521,  521,  522,  521,  118,    0,  522,  440, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  521,  521,    0,  521,  521,  521, 
          521,  521,    0,    0,    0,    0,  522,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  521,  521,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,    0,    0,  521,  521,  521, 
          521,    0,  533,    0,    0,    0,  521,    0,    0,    0, 
            0,    0,    0,  521,    0,  521,    0,  521,  521,  521, 
          521,  521,  521,  521,    0,  521,    0,  521,    0,  520, 
          520,  520,    0,    0,    0,  520,  520,    0,  520,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  520,  520,  521, 
          520,  520,  520,  520,  520,    0,    0,    0,  523,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  523,    0, 
            0,    0,    0,    0,  520,  520,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,    0,    0, 
          520,  520,  520,  520,    0,  532,    0,    0,    0,  520, 
            0,    0,  100,    0,    0,    0,  520,    0,  520,    0, 
          520,  520,  520,  520,  520,  520,  520,  523,  520,  119, 
          520,  523,    0,    0,    0,    0,    0,  522,  522,  522, 
            0,    0,    0,  522,  522,    0,  522,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  523, 
            0,    0,  520,    0,    0,  522,  522,    0,  522,  522, 
          522,  522,  522,    0,    0,    0,  525,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  525,    0,    0,    0, 
            0,    0,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,  522,  522,  522,    0,    0,  522,  522, 
          522,  522,    0,  534,    0,    0,    0,  522,    0,    0, 
          102,    0,    0,    0,  522,    0,  522,    0,  522,  522, 
          522,  522,  522,  522,  522,  525,  522,  121,  522,  525, 
            0,    0,    0,    0,    0,    0,    0,    0,  703,  629, 
            0,    0,  704,    0,    0,    0,  188,  189,    0,  190, 
          191,  192,  193,  194,  195,  196,    0,  525,  197,  198, 
          522,    0,    0,  199,  200,  201,  202,    0,    0,  524, 
            0,    0,    0,  304,    0,    0,    0,    0,    0,  524, 
          204,  205,    0,  206,  207,  208,  209,  210,  211,  212, 
          213,  214,  215,  216,    0,    0,  217,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  101,    0,    0,    0,    0,    0,    0, 
          523,  523,  523,    0,    0,    0,  523,  523,  524,  523, 
          120,    0,  524,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  523,  523, 
            0,  523,  523,  523,  523,  523,    0,    0,    0,    0, 
          524,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  523,  523,  523,  523,  523, 
          523,  523,  523,  523,  523,  523,  523,  523,  523,  526, 
            0,  523,  523,  523,  523,    0,  535,    0,    0,  526, 
          523,    0,    0,    0,    0,    0,    0,  523,    0,  523, 
            0,  523,  523,  523,  523,  523,  523,  523,    0,  523, 
            0,  523,    0,    0,    0,    0,    0,    0,  525,  525, 
          525,    0,    0,  103,  525,  525,    0,  525,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  526,    0, 
          122,    0,  526,  523,    0,    0,  525,  525,    0,  525, 
          525,  525,  525,  525,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          526,    0,    0,  525,  525,  525,  525,  525,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,    0,    0,  525, 
          525,  525,  525,    0,  537,    0,    0,    0,  525,    0, 
            0,    0,    0,    0,    0,  525,    0,  525,    0,  525, 
          525,  525,  525,  525,  525,  525,    0,  525,    0,  525, 
            0,  524,  524,  524,    0,    0,    0,  524,  524,    0, 
          524,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  524, 
          524,  525,  524,  524,  524,  524,  524,    0,    0,    0, 
          517,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          517,    0,    0,    0,    0,    0,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,  524, 
            0,    0,  524,  524,  524,  524,    0,  536,    0,    0, 
            0,  524,    0,    0,   94,    0,    0,    0,  524,    0, 
          524,    0,  524,  524,  524,  524,  524,  524,  524,  517, 
          524,  113,  524,  517,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  526,  526,  526,    0,    0,    0,  526,  526,    0, 
          526,  517,    0,    0,  524,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  526, 
          526,    0,  526,  526,  526,  526,  526,    0,    0,    0, 
          516,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          516,    0,    0,    0,    0,    0,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
            0,    0,  526,  526,  526,  526,    0,  538,    0,    0, 
            0,  526,    0,    0,   93,    0,    0,    0,  526,    0, 
          526,    0,  526,  526,  526,  526,  526,  526,  526,  516, 
          526,  112,  526,  516,    0,    0,    0,    0,    0,    0, 
            0,    0,  731,  621,    0,    0,  732,    0,    0,    0, 
          188,  189,    0,  190,  191,  192,  193,  194,  195,  196, 
            0,  516,  197,  198,  526,    0,    0,  199,  200,  201, 
          202,    0,    0,  519,    0,    0,    0,  304,    0,    0, 
            0,    0,    0,  519,  204,  205,    0,  206,  207,  208, 
          209,  210,  211,  212,  213,  214,  215,  216,    0,    0, 
          217,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  517,  517,  517,    0,    0,   96,  517,  517, 
            0,  517,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  519,    0,  115,    0,  519,    0,    0,    0, 
          517,  517,    0,  517,  517,  517,  517,  517,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  519,    0,    0,  517,  517,  517, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,    0,    0,  517,  517,  517,  517,    0,  529,    0, 
            0,    0,  517,    0,    0,    0,    0,    0,    0,  517, 
            0,  517,    0,  517,  517,  517,  517,  517,  517,  517, 
          246,  517,    0,  517,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  516,  516,  516,    0,    0,    0,  516,  516, 
            0,  516,    0,    0,    0,  517,    0,    0,    0,    0, 
            0,    0,    0,    0,  246,    0,    0,    0,    0,    0, 
          516,  516,    0,  516,  516,  516,  516,  516,  246,  246, 
            0,    0,    0,  246,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          516,    0,    0,  516,  516,  516,  516,    0,  528,    0, 
            0,    0,  516,    0,    0,    0,    0,    0,    0,  516, 
            0,  516,    0,  516,  516,  516,  516,  516,  516,  516, 
            0,  516,    0,  516,    0,  519,  519,  519,    0,    0, 
            0,  519,  519,    0,  519,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  519,  519,  516,  519,  519,  519,  519, 
          519,    0,    0,    0,  310,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  310,    0,    0,    0,    0,    0, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,    0,    0,  519,  519,  519,  519, 
            0,  531,    0,    0,    0,  519,    0,    0,  110,    0, 
            0,    0,  519,    0,  519,    0,  519,  519,  519,  519, 
          519,  519,  519,  310,  519,  129,  519,  310,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  299,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  299,    0,    0,    0,  310,    0,    0,  519,    0, 
            0,    0,  246,  246,  246,    0,    0,  246,  246,  246, 
            0,  246,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  246,  246,    0,    0,  295,    0,    0,    0,    0, 
          246,  246,    0,  246,  246,  246,  246,  246,    0,  321, 
          299,    0,    0,    0,    0,  246,    0,    0,    0,  321, 
            0,    0,    0,    0,    0,    0,    0,  246,  246,  246, 
          246,  246,    0,    0,  246,  246,  246,  246,    0,  246, 
          246,    0,    0,  246,  246,    0,    0,    0,    0,  246, 
            0,    0,  246,  109,    0,  246,    0,  246,    0,  246, 
            0,  246,    0,  246,  246,  246,  246,    0,  321,  246, 
          128,  246,  321,  246,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  246,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          321,    0,    0,    0,    0,  246,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  233,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  233,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  310,  310,  310,    0, 
            0,    0,  310,  310,    0,  310,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  233, 
            0,    0,    0,    0,  310,  310,    0,  310,  310,  310, 
          310,  310,    0,  233,  233,    0,    0,    0,  233,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  310,  310,  310,  310,  310,  310,  310,  310,  310, 
          310,  310,  310,  310,  310,    0,    0,  310,  310,  310, 
          310,    0,    0,  299,  299,  299,  310,    0,  299,  299, 
          299,    0,  299,  310,  234,  310,    0,  310,  310,  310, 
          310,  310,  310,  310,  234,  310,    0,  310,    0,    0, 
            0,    0,    0,    0,  299,  299,  299,  299,  299,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  234,  310, 
            0,  321,  321,  321,    0,    0,    0,  321,  321,    0, 
          321,    0,  234,  234,    0,    0,    0,  234,    0,    0, 
          299,    0,    0,  299,    0,    0,    0,    0,    0,  321, 
          321,    0,  321,  321,  321,  321,  321,    0,    0,    0, 
            0,    0,    0,    0,  299,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  321,  321,  321,  321, 
          321,  321,  321,  321,  321,  321,  321,  321,  321,  321, 
            0,    0,  321,  321,  321,  321,  299,    0,    0,    0, 
            0,  321,    0,    0,    0,    0,    0,    0,  321,    0, 
          321,    0,  321,  321,  321,  321,  321,  321,  321,    0, 
          321,  297,  321,    0,    0,    0,    0,  233,  233,  233, 
            0,  297,  233,  233,  233,    0,  233,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  233,  233,    0,    0, 
            0,    0,    0,    0,  321,  233,  233,    0,  233,  233, 
          233,  233,  233,    0,    0,  292,    0,    0,    0,    0, 
          233,  310,    0,    0,    0,    0,    0,    0,    0,    0, 
          297,  310,    0,  233,  233,  233,  233,  233,  233,  233, 
          233,  233,  233,    0,  233,  233,    0,    0,  233,  233, 
            0,    0,    0,    0,  233,    0,    0,  233,    0,    0, 
          233,    0,  233,    0,    0,  310,  233,    0,    0,    0, 
          233,  233,  233,  233,  233,    0,  233,    0,  233,    0, 
          310,    0,  129,    0,  310,    0,  234,  234,  234,    0, 
          233,  234,  234,  234,    0,  234,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  234,  234,    0,    0,    0, 
          233,    0,  310,    0,  234,  234,    0,  234,  234,  234, 
          234,  234,    0,    0,    0,    0,    0,    0,    0,  234, 
          254,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          254,    0,  234,  234,  234,  234,  234,  234,  234,  234, 
          234,  234,    0,  234,  234,    0,    0,  234,  234,    0, 
            0,    0,    0,  234,    0,    0,  234,    0,    0,  234, 
            0,  234,    0,    0,  254,  234,    0,    0,    0,  234, 
          234,  234,  234,  234,    0,  234,    0,  234,  254,  254, 
            0,    0,    0,  254,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  297,  297,  297,    0,    0,    0,  297, 
          297,    0,  297,    0,    0,    0,    0,  255,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  255,    0,    0, 
            0,    0,    0,    0,  297,  297,  297,  297,  297,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  310,  310,  310,    0,    0,    0,  310, 
          310,  255,  310,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  255,  255,    0,    0,    0, 
          255,  310,  310,  297,  310,  310,  310,  310,  310,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  297,    0,    0,    0,  310,  310, 
          310,  310,  310,  310,  310,  310,  310,  310,  310,  310, 
          310,  310,    0,    0,  310,  310,  310,  310,    0,    0, 
            0,    0,    0,  310,    0,    0,  297,    0,    0,    0, 
          310,    0,  310,    0,  310,  310,  310,  310,  310,  310, 
          310,    0,  310,    0,  310,    0,    0,    0,    0,    0, 
            0,    0,  254,  254,  254,    0,    0,  254,  254,  254, 
            0,  254,    0,  244,    0,    0,    0,    0,    0,    0, 
            0,  254,  254,  244,    0,    0,  310,    0,    0,    0, 
          254,  254,    0,  254,  254,  254,  254,  254,    0,    0, 
            0,    0,    0,    0,    0,  254,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  244,  254,  254, 
          254,  254,  254,  254,  254,  254,  254,  254,    0,  254, 
          254,  244,  244,  254,  254,    0,  244,    0,    0,  254, 
            0,    0,  254,    0,    0,  254,    0,  254,    0,    0, 
            0,  254,    0,    0,    0,    0,    0,  254,  254,  254, 
            0,  254,    0,  254,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  254,    0,    0,    0,  255, 
          255,  255,    0,    0,  255,  255,  255,    0,  255,    0, 
          242,    0,    0,    0,    0,  254,    0,    0,  255,  255, 
          242,    0,    0,    0,    0,    0,    0,  255,  255,    0, 
          255,  255,  255,  255,  255,    0,    0,    0,    0,    0, 
            0,    0,  255,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  242,  255,  255,  255,  255,  255, 
          255,  255,  255,  255,  255,    0,  255,  255,  242,  242, 
          255,  255,    0,  242,    0,    0,  255,    0,    0,  255, 
            0,    0,  255,    0,  255,    0,    0,    0,  255,    0, 
            0,    0,    0,    0,  255,  255,  255,    0,  255,    0, 
          255,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  255,    0,    0,    0,    0,    0,    0,  243, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  243, 
            0,    0,  255,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  244,  244,  244,    0,    0, 
          244,  244,  244,  243,  244,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  244,  244,    0,  243,  243,    0, 
            0,    0,  243,  244,  244,    0,  244,  244,  244,  244, 
          244,    0,    0,    0,    0,    0,    0,    0,  244,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  244,  244,  244,  244,  244,  244,  244,  244,  244, 
          244,    0,  244,  244,    0,    0,    0,    0,    0,    0, 
            0,    0,  244,    0,    0,  244,  265,    0,  244,    0, 
          244,    0,    0,    0,  244,    0,  265,    0,    0,    0, 
          244,  244,  244,    0,  244,    0,  244,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  244,    0, 
            0,    0,  242,  242,  242,    0,    0,  242,  242,  242, 
          265,  242,    0,    0,    0,    0,    0,    0,  244,    0, 
            0,  242,  242,    0,  265,  265,    0,    0,    0,  265, 
          242,  242,    0,  242,  242,  242,  242,  242,    0,    0, 
            0,    0,    0,    0,    0,  242,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  242,  242, 
          242,  242,  242,  242,  242,  242,  242,  242,    0,  242, 
          242,    0,    0,    0,    0,    0,    0,    0,    0,  242, 
            0,    0,  242,    0,    0,  242,    0,  242,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  242,  242,  242, 
            0,  242,    0,  242,    0,    0,    0,    0,    0,    0, 
            0,  243,  243,  243,    0,  242,  243,  243,  243,    0, 
          243,    0,  266,    0,    0,    0,    0,    0,    0,    0, 
          243,  243,  266,    0,    0,  242,    0,    0,    0,  243, 
          243,    0,  243,  243,  243,  243,  243,    0,    0,    0, 
            0,    0,    0,    0,  243,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  266,  243,  243,  243, 
          243,  243,  243,  243,  243,  243,  243,    0,  243,  243, 
          266,  266,    0,    0,    0,  266,    0,    0,  243,    0, 
            0,  243,    0,    0,  243,    0,  243,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  243,  243,  243,    0, 
          243,    0,  243,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  243,    0,    0,    0,  265,  265, 
          265,    0,    0,  265,  265,  265,    0,  265,    0,  245, 
            0,    0,    0,    0,  243,    0,    0,  265,  265,  245, 
            0,    0,    0,    0,    0,    0,  265,  265,    0,  265, 
          265,  265,  265,  265,    0,    0,    0,    0,    0,    0, 
            0,  265,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  245,  265,  265,  265,  265,  265,  265, 
          265,  265,  265,  265,    0,  265,  265,  245,  245,    0, 
            0,    0,  245,    0,    0,  265,    0,    0,  265,    0, 
            0,  265,    0,  265,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  265,  265,    0,    0,    0,    0,  265, 
            0,    0,    0,    0,    0,    0,  247,    0,    0,    0, 
            0,  265,    0,    0,    0,    0,  247,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  265,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,    0,    0,    0,  266,  266,  266,    0,    0,  266, 
          266,  266,    0,  266,  247,  247,    0,    0,    0,  247, 
            0,    0,    0,  266,  266,    0,    0,    0,    0,    0, 
            0,    0,  266,  266,    0,  266,  266,  266,  266,  266, 
            0,    0,    0,    0,  248,    0,    0,  266,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,    0,    0,    0, 
          266,  266,  266,  266,  266,  266,  266,  266,  266,  266, 
            0,  266,  266,    0,    0,    0,    0,    0,    0,    0, 
            0,  266,    0,    0,  266,    0,    0,  266,  248,  266, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  266, 
          266,    0,  248,  248,    0,  266,    0,  248,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  266,    0,    0, 
            0,  245,  245,  245,    0,    0,  245,  245,  245,    0, 
          245,    0,  249,    0,    0,    0,    0,  266,    0,    0, 
          245,  245,  249,    0,    0,    0,    0,    0,    0,  245, 
          245,    0,  245,  245,  245,  245,  245,    0,    0,    0, 
            0,    0,    0,    0,  245,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  249,    0,    0,    0, 
            0,    0,    0,  245,  245,    0,    0,    0,  245,  245, 
          249,  249,    0,    0,    0,  249,    0,    0,  245,    0, 
            0,  245,    0,    0,  245,    0,  245,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  247,  247, 
          247,    0,  245,  247,  247,  247,    0,  247,    0,  256, 
            0,    0,    0,    0,  245,    0,    0,  247,  247,  256, 
            0,    0,    0,    0,    0,    0,  247,  247,    0,  247, 
          247,  247,  247,  247,  245,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  256,    0,    0,    0,    0,    0,    0, 
          247,  247,    0,    0,    0,  247,  247,  256,  256,    0, 
            0,    0,  256,    0,    0,  247,    0,    0,  247,    0, 
            0,  247,    0,  247,    0,    0,  248,  248,  248,    0, 
            0,  248,  248,  248,    0,  248,    0,  250,    0,  247, 
            0,    0,    0,    0,    0,  248,  248,  250,    0,    0, 
            0,  247,    0,    0,  248,  248,    0,  248,  248,  248, 
          248,  248,    0,    0,    0,    0,    0,    0,    0,  248, 
            0,  247,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  250,    0,    0,    0,    0,    0,    0,  248,  248, 
            0,    0,    0,  248,  248,  250,  250,    0,    0,    0, 
          250,    0,    0,  248,    0,    0,  248,    0,    0,  248, 
            0,  248,    0,    0,  249,  249,  249,    0,    0,  249, 
          249,  249,    0,  249,    0,  251,    0,  248,    0,    0, 
            0,    0,    0,  249,  249,  251,    0,    0,    0,  248, 
            0,    0,  249,  249,    0,  249,  249,  249,  249,  249, 
            0,    0,    0,    0,    0,    0,    0,  249,    0,  248, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  251, 
            0,    0,    0,    0,    0,    0,  249,  249,    0,    0, 
            0,  249,  249,  251,  251,    0,    0,    0,  251,    0, 
            0,  249,    0,    0,  249,    0,    0,  249,    0,  249, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  256,  256,  256,    0,  249,  256,  256,  256,    0, 
          256,    0,  257,    0,    0,    0,    0,  249,    0,    0, 
          256,  256,  257,    0,    0,    0,    0,    0,    0,  256, 
          256,    0,  256,  256,  256,  256,  256,  249,    0,    0, 
            0,    0,    0,    0,  256,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  257,    0,    0,    0, 
            0,    0,    0,  256,  256,    0,    0,    0,  256,  256, 
          257,  257,    0,    0,    0,  257,    0,    0,  256,    0, 
            0,  256,    0,    0,  256,    0,  256,    0,    0,  250, 
          250,  250,    0,    0,  250,  250,  250,    0,  250,    0, 
          231,    0,  256,    0,    0,    0,    0,    0,  250,  250, 
          231,    0,    0,    0,  256,    0,    0,  250,  250,    0, 
          250,  250,  250,  250,  250,    0,    0,    0,    0,    0, 
            0,    0,  250,    0,  256,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  231,    0,    0,    0,    0,    0, 
            0,  250,  250,    0,    0,    0,  250,  250,  231,  231, 
            0,    0,    0,  231,    0,    0,  250,    0,    0,  250, 
            0,    0,  250,    0,  250,    0,    0,  251,  251,  251, 
            0,    0,  251,  251,  251,    0,  251,    0,  232,    0, 
          250,    0,    0,    0,    0,    0,  251,  251,  232,    0, 
            0,    0,  250,    0,    0,  251,  251,    0,  251,  251, 
          251,  251,  251,    0,    0,    0,    0,    0,    0,    0, 
          251,    0,  250,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  232,    0,    0,    0,    0,    0,    0,  251, 
          251,    0,    0,    0,  251,  251,  232,  232,    0,    0, 
            0,  232,    0,    0,  251,    0,    0,  251,    0,    0, 
          251,    0,  251,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  257,  257,  257,  273,  251,  257, 
          257,  257,    0,  257,    0,    0,    0,  273,    0,    0, 
          251,    0,    0,  257,  257,    0,    0,    0,    0,    0, 
            0,    0,  257,  257,    0,  257,  257,  257,  257,  257, 
          251,    0,    0,    0,    0,    0,    0,  257,    0,    0, 
            0,  273,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  273,  273,  257,    0,    0, 
            0,  257,  257,    0,    0,    0,    0,    0,    0,    0, 
            0,  257,    0,    0,  257,    0,    0,  257,    0,  257, 
            0,    0,  231,  231,  231,    0,  259,  231,  231,  231, 
            0,  231,    0,    0,    0,  257,  259,    0,    0,    0, 
            0,  231,  231,    0,    0,    0,    0,  257,    0,    0, 
          231,  231,    0,  231,  231,  231,  231,  231,    0,    0, 
            0,    0,    0,    0,    0,  231,    0,  257,    0,    0, 
          259,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  259,  259,    0,    0,  224,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  224,  231, 
            0,    0,  231,    0,    0,  231,    0,  231,    0,    0, 
          232,  232,  232,    0,    0,  232,  232,  232,    0,  232, 
            0,    0,    0,  231,    0,    0,    0,    0,    0,  232, 
          232,    0,  224,    0,    0,  231,    0,    0,  232,  232, 
            0,  232,  232,  232,  232,  232,  224,  224,    0,    0, 
            0,    0,    0,  232,    0,  231,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  267,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  267,  232,    0,    0, 
          232,    0,    0,  232,    0,  232,    0,    0,    0,  273, 
          273,  273,    0,    0,  273,  273,  273,    0,  273,    0, 
            0,  232,    0,    0,    0,    0,    0,    0,  273,  273, 
          267,    0,    0,  232,    0,    0,    0,  273,  273,    0, 
          273,  273,  273,  273,  273,  267,    0,    0,    0,    0, 
            0,    0,  273,  232,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  272,    0,    0, 
            0,    0,    0,    0,    0,    0,  273,  272,    0,  273, 
            0,    0,  273,    0,  273,    0,    0,    0,  259,  259, 
          259,    0,    0,  259,  259,  259,    0,  259,    0,    0, 
          273,    0,    0,    0,    0,    0,    0,  259,  259,    0, 
            0,  272,  273,    0,    0,    0,  259,  259,    0,  259, 
          259,  259,  259,  259,    0,  272,  272,    0,    0,    0, 
            0,  259,  273,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,  224,  224,  294,    0,  224,  224,  224,    0,  224, 
            0,    0,    0,  294,    0,  259,    0,    0,  259,  224, 
          224,  259,    0,  259,    0,    0,    0,    0,  224,  224, 
            0,  224,  224,  224,  224,  224,    0,    0,    0,  259, 
          648,    0,    0,  224,    0,    0,    0,  294,    0,    0, 
          648,  259,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  294,    0,    0,    0,    0,    0,    0,    0, 
            0,  259,    0,    0,    0,    0,    0,  224,    0,    0, 
          224,    0,    0,  224,    0,  224,    0,    0,  267,  267, 
          267,    0,    0,  267,  267,  267,    0,  267,    0,  648, 
            0,  224,    0,    0,    0,    0,    0,  267,  267,    0, 
            0,    0,    0,  224,    0,    0,  267,  267,    0,  267, 
          267,  267,  267,  267,    0,    0,    0,    0,   61,    0, 
            0,  267,    0,  224,    0,    0,    0,    0,   61,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  267,    0,    0,  267,    0, 
            0,  267,    0,  267,    0,    0,    0,    0,    0,  272, 
          272,  272,    0,    0,  272,  272,  272,   61,  272,  267, 
           65,    0,    0,    0,    0,    0,    0,    0,  272,  272, 
           65,  267,    0,    0,    0,    0,    0,  272,  272,    0, 
          272,  272,  272,  272,    0,    0,    0,    0,    0,    0, 
            0,  267,  272,    0,    0,    0,    0,    0,    0,    0, 
            0,   63,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   63,    0,    0,    0,    0,    0,   25,    0,   65, 
            0,    0,    0,    0,    0,    0,  272,   25,    0,  272, 
            0,    0,  272,    0,  272,  294,  294,  294,    0,    0, 
          294,  294,  294,    0,  294,    0,    0,    0,    0,    0, 
          272,    0,    0,    0,  294,  294,    0,    0,    0,    0, 
           63,    0,  272,  294,  294,    0,  294,  294,  294,  294, 
          294,    0,  648,  648,  648,    0,   25,  648,  648,  648, 
            0,  648,  272,    0,    0,    0,    0,    0,    0,    0, 
            0,  648,  648,    0,    0,    0,    0,    0,    0,    0, 
          648,  648,    0,  648,  648,  648,  648,  648,    0,    0, 
            0,    0,    0,    0,    0,  294,    0,    0,  294,    0, 
          294,    0,    0,    0,    0,    0,  308,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  294,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  648,    0,    0,  648,    0,  648,    0,    0, 
           61,   61,   61,    0,    0,   61,   61,   61,  294,   61, 
            0,    0,    0,  648,    0,    0,    0,    0,    0,   61, 
           61,    0,    0,    0,    0,    0,    0,    0,   61,   61, 
            0,   61,   61,   61,   61,   61,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  648,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   65,   65,   65,    0,    0,   65,   65,   65, 
            0,   65,    0,    0,    0,    0,    0,    0,    0,    0, 
           61,   65,   65,   61,    0,    0,    0,    0,    0,    0, 
           65,   65,    0,   65,   65,   65,   65,   65,    0,    0, 
            0,   61,    0,   63,   63,   63,  130,    0,   63,   63, 
           63,    0,   63,    0,    0,    0,    0,    0,    0,   25, 
           25,   25,   63,   63,    0,   25,   25,    0,   25,    0, 
            0,   63,   63,   61,   63,   63,   63,   63,   63,    0, 
            0,    0,   65,    0,    0,   65,    0,    0,    0,    0, 
           25,   25,   25,   25,   25,  130,    0,    0,    0,    0, 
            0,    0,    0,   65,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   63,    0,    0,   63,  515,    0,    0, 
            0,    0,    0,    0,    0,   65,    0,    0,    0,   25, 
            0,    0,    0,    0,   63,    0,    0,    0,    0,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,    0, 
           25,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,   63,    0,    0,   19, 
           20,   21,  239,  240,  241,  242,  131,    0,  118,    0, 
            0,    0,   25,    0,    0,   28,    0,    0,  243,  244, 
          245,    0,  246,   35,  247,  248,  249,  250,  285,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  251,    0,  131,  131,    0,    0,   46, 
           47,    0,   48,    0,  286,    0,  287,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  288,    0,    0,    0, 
            0,   52,  289,   54,   55,   56,   57,  518,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   65,   66, 
          290,    0,  130,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,    0,    0,  130,  130,    0,  130,  130, 
          130,  130,  130,  130,  130,    0,  618,    0,    0,  130, 
          130,  130,  130,  130,  130,  130,  130,    0,  130,    0, 
            0,    0,    0,    0,  130,  130,    0,  130,  130,  130, 
          130,    0,  130,  130,  130,  130,  130,  130,    0,  130, 
          130,  130,  130,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  515,    0,    0,    0,    0,    0, 
            0,  515,  515,  130,    0,  130,  130,  618,    0,  130, 
          130,    0,  130,    0,  130,    0,    0,    0,  130,    0, 
            0,    0,    0,  130,    0,    0,  130,    0,  618,    0, 
            0,  130,  130,  130,  130,  130,  130,  625,    0,    0, 
          130,    0,  130,  130,    0,  130,  130,  130,  130,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  130,  130, 
            0,    0,  131,  131,  131,  131,  131,  131,  131,  131, 
          131,  131,  131,    0,    0,  131,  131,    0,  131,  131, 
          131,  131,  131,  131,  131,    0,  619,    0,    0,  131, 
          131,  131,  131,  131,  131,  131,  131,    0,  131,    0, 
            0,    0,    0,    0,  131,  131,    0,  131,  131,  131, 
          131,    0,  131,  131,  131,  131,  131,  131,    0,  131, 
          131,  131,  131,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  518,    0,    0,    0,    0,    0, 
            0,  518,  518,  131,    0,  131,  131,  619,    0,  131, 
          131,    0,  131,    0,  131,    0,    0,    0,  131,    0, 
            0,    0,    0,  131,    0,    0,  131,    0,  619,    0, 
            0,  131,  131,  131,  131,  131,  131,  320,    0,    0, 
          131,    0,  131,  131,    0,  131,  131,  131,  131,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  131,  131, 
            0,    0,  130,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,    0,    0,  130,  130,    0,  130,  130, 
          130,  130,  130,  130,  130,    0,  625,    0,    0,  130, 
          130,  130,  130,  130,  130,  130,  131,    0,  130,    0, 
            0,    0,    0,    0,  130,  130,    0,  130,  130,  130, 
          130,    0,  130,  130,  130,  130,  130,  130,    0,  130, 
          130,  130,  130,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  625,    0,    0,    0,    0,    0, 
            0,  625,  625,  130,    0,  131,  130,  621,    0,  130, 
          130,    0,  130,    0,  130,    0,    0,    0,  130,    0, 
            0,    0,    0,  130,    0,    0,  130,    0,  625,    0, 
            0,  130,  130,  130,  130,  130,  130,  321,    0,    0, 
          130,    0,  130,  130,    0,  130,  130,  130,  130,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  130,  130, 
            0,    0,  131,  131,  131,  131,  131,  131,  131,  131, 
          131,  131,  131,    0,    0,  131,  131,    0,  131,  131, 
          131,  131,  131,  131,  131,    0,    0,    0,    0,  131, 
          131,  131,  131,  131,  131,  131,  364,    0,  131,    0, 
            0,    0,    0,    0,  131,  131,    0,  131,  131,  131, 
          131,    0,  131,  131,  131,  131,  131,  131,    0,  131, 
          131,  131,  131,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  320,    0,    0,    0,    0,    0, 
            0,  320,  320,  131,    0,  364,  131,  622,    0,  131, 
          131,    0,  131,    0,  131,    0,    0,    0,  131,    0, 
            0,    0,    0,  131,    0,    0,  131,    0,    0,    0, 
            0,  131,  131,  131,  131,  131,  131,    0,    0,    0, 
          131,    0,  131,  131,    0,  131,  131,  131,  131,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  131,  131, 
            0,    0,  131,  131,  131,  131,  131,  131,  131,  131, 
          131,  131,  131,    0,    0,  131,  131,    0,  131,  131, 
          131,  131,  131,  131,  131,    0,    0,    0,    0,  131, 
          131,  131,  131,  131,  131,  131,  312,    0,  131,    0, 
            0,    0,    0,    0,  131,  131,    0,  131,  131,  131, 
          131,    0,  131,  131,  131,  131,  131,  131,    0,  131, 
          131,  131,  131,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  321,    0,    0,    0,    0,    0, 
            0,  321,  321,  131,    0,  312,  131,    0,    0,  131, 
          131,    0,  131,    0,  131,    0,    0,    0,  131,    0, 
            0,    0,    0,  131,    0,    0,  131,    0,    0,    0, 
            0,  131,  131,  131,  131,  131,  131,    0,    0,    0, 
          131,    0,  131,  131,    0,  131,  131,  131,  131,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  131,  131, 
            0,    0,  364,  364,  364,  364,  364,  364,  364,  364, 
          364,  364,  364,    0,  364,  364,  364,  364,  364,  364, 
          364,  364,  364,  364,  364,    0,    0,    0,    0,  364, 
          364,  364,  364,  364,  364,  364,  543,    0,  364,    0, 
            0,    0,    0,    0,  364,  364,    0,  364,  364,  364, 
          364,    0,  364,  364,  364,  364,  364,  364,    0,  364, 
          364,  364,  364,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  364,    0,  543,  364,    0,    0,  364, 
          364,    0,  364,    0,  364,    0,    0,    0,  364,    0, 
            0,    0,    0,    0,    0,    0,  364,    0,    0,    0, 
            0,  364,  364,  364,  364,  364,  364,    0,    0,    0, 
          364,    0,  364,  364,    0,  364,  364,  364,  364,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  364,  364, 
            0,    0,  312,  312,  312,  312,  312,  312,  312,  312, 
          312,  312,  312,    0,    0,  312,  312,    0,  312,  312, 
          312,  312,  312,  312,  312,    0,    0,    0,    0,  312, 
          312,  312,  312,  312,  312,  312,  647,    0,  312,    0, 
            0,    0,    0,    0,  312,  312,    0,  312,  312,  312, 
          312,    0,  312,  312,  312,  312,  312,  312,    0,  312, 
          312,  312,  312,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  312,    0,  647,  312,    0,    0,  312, 
          312,    0,  312,    0,  312,    0,    0,    0,  312,    0, 
            0,    0,    0,    0,    0,    0,  312,    0,   18,    0, 
            0,  312,  312,  312,  312,  312,  312,    0,    0,    0, 
          312,    0,  312,  312,    0,  312,  312,  312,  312,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  312,  312, 
            0,    0,  543,  543,  543,  543,  543,  543,  543,  543, 
          543,  543,  543,    0,    0,  543,  543,    0,  543,  543, 
          543,  543,  543,  543,  543,    0,  647,    0,    0,  543, 
          543,  543,  543,  543,  543,  543,    0,    0,  543,    0, 
            0,    0,    0,    0,  543,  543,    0,  543,  543,  543, 
          543,    0,  543,  543,  543,  543,  543,  543,    0,  543, 
          543,  543,  543,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  647,    0,    0,    0,    0, 
            0,    0,    0,  543,    0,    0,  543,    0,    0,  543, 
          543,    0,  543,    0,  543,    0,    0,    0,  543,    0, 
            0,    0,    0,    0,    0,    0,  543,    0,    0,    0, 
            0,  543,  543,  543,  543,  543,  543,    0,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,  543,    0,  543,  543,    0,  543,  543,  543,  543, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  543, 
          543,    0,    0,  647,  647,  647,  647,  647,  647,  647, 
          647,  647,  647,  647,    0,    0,  647,  647,    0,  647, 
          647,  647,  647,  647,  647,  647,  647,    0,    0,    0, 
          647,  647,  647,  647,  647,  647,  647,    0,    0,  647, 
            0,    0,    0,    0,    0,  647,  647,    0,  647,  647, 
          647,  647,    0,  647,  647,  647,  647,  647,  647,    0, 
          647,  647,  647,  647,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  647,    0,    0,    0,    0, 
            0,    0,    0,    0,  647,    0,    0,  647,    0,    0, 
          647,  647,    0,  647,    0,  647,    0,    0,    0,  647, 
            0,    0,    0,    0,    0,    0,    0,  647,    0,    0, 
            0,    0,  647,  647,  647,  647,  647,  647,    0,    0, 
            0,  647,    0,  647,  647,    0,  647,  647,  647,  647, 
            0,    0,    0,  647,  647,  647,  647,  647,  647,  647, 
          647,  647,  647,  647,    0,    0,    0,  647,    0,  647, 
          647,  647,  647,  647,  647,  647,  314,    0,    0,    0, 
          647,  647,  647,  647,  647,  647,  647,    0,    0,  647, 
            0,    0,    0,    0,    0,  647,  647,    0,  647,  647, 
          647,  647,    0,  647,  647,  647,  647,  647,  647,    0, 
          647,  647,  647,  647,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  647,    0,    0,  647,    0,    0, 
          647,  647,    0,  647,    0,  647,    0,    0,    0,  647, 
            0,    0,    0,    0,    0,    0,    0,  647,    0,    0, 
            0,    0,  647,  647,  647,  647,  647,  647,    0,    0, 
            0,  647,    0,  647,  647,    0,  647,  647,  647,  647, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  647, 
          647,    0,  647,  647,  647,  647,  647,  647,    0,    0, 
            0,  647,  647,    0,    0,  260,  647,    0,  647,  647, 
          647,  647,  647,  647,  647,    0,    0,    0,    0,  647, 
          647,  647,  647,  647,  647,  647,    0,    0,  647,    0, 
            0,    0,    0,    0,  647,  647,    0,  647,  647,  647, 
          647,    0,  647,  647,  647,  647,  647,  647,    0,  647, 
          647,  647,  647,    0,  259,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  647,    0,    0,  647,    0,    0,  647, 
          647,    0,  647,    0,  647,    0,    0,    0,  647,    0, 
            0,    0,    0,    0,    0,    0,  647,    0,    0,  647, 
            0,  647,  647,  647,  647,  647,  647,    0,    0,    0, 
          647,    0,  647,  647,    0,  647,  647,  647,  647,    0, 
            0,    0,    0,  316,  316,  316,  316,  316,  647,  647, 
            0,  316,  316,    0,  308,    0,  316,    0,  316,  316, 
          316,  316,  316,  316,  316,    0,    0,    0,    0,  316, 
          316,  316,  316,  316,  316,  316,    0,    0,  316,    0, 
            0,    0,    0,    0,  316,  316,    0,  316,  316,  316, 
          316,    0,  316,  316,  316,  316,  316,  316,    0,  316, 
          316,  316,  316,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  316,    0,    0,  316,    0,  314,  316, 
          316,    0,  316,    0,  316,    0,    0,    0,  316,    0, 
            0,    0,    0,    0,    0,    0,  316,    0,    0,    0, 
            0,  316,  316,  316,  316,  316,  316,    0,    0,    0, 
          316,    0,  316,  316,    0,  316,  316,  316,  316,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,  316,  316, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,  239,  240,  241,  242,    0,    0,   26,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  243,  244,  245, 
            0,  246,   35,  247,  248,  249,  250,  353,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  251,    0,    0,  131,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,   65,   66,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
          239,  240,  241,  242,    0,    0,   26,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  243,  244,  245,    0, 
          246,   35,  247,  248,  249,  250,  654,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  251,    0,    0,  131,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   65,   66,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  109,  110, 
           17,   18,    0,    0,    0,    0,  111,  112,  113,  340, 
          341,  342,  343,    0,    0,  118,    0,    0,    0,    0, 
            0,    0,  119,    0,    0,  344,  345,  346,    0,  347, 
           35,  348,  349,  350,  351,    0,   40,    0,    0,  128, 
          471,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          352,    0,    0,  131,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,   65,   66,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  109,  110,   17, 
           18,    0,    0,    0,    0,  111,  112,  113,  340,  341, 
          342,  343,    0,    0,  118,    0,    0,    0,    0,    0, 
            0,  119,    0,    0,  344,  345,  346,    0,  347,   35, 
          348,  349,  350,  351,    0,   40,    0,    0,  128,  471, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  352, 
            0,    0,  131,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,    0,    0,    4,    5, 
            6,    7,    8,    0,   65,   66,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,   29,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,    4,    5,    6, 
            7,  321,    0,   65,   66,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,   27,   28, 
            0,   30,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,    3,    4,    5,    6,    7, 
            8,    0,   65,   66,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,   29, 
           30,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   44,    0,    0,   45, 
            0,    0,   46,   47,    0,   48,    0,   49,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,  320,    4,    5,    6,    7,  321, 
            0,   65,   66,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,    0,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,  322,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,  320,    4,    5,    6,    7,  321,    0, 
           65,   66,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   44,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,   65, 
           66,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,  239,  240,  241,  242,    0,    0,  118,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  243,  244, 
          245,    0,  246,   35,  247,  248,  249,  250,  285,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  251,    0,    0,  131,    0,    0,   46, 
           47,    0,   48,    0,  286,    0,  287,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  288,    0,    0,    0, 
            0,   52,  289,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,   65,   66, 
          290,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  109,  110,   17,   18,    0,    0,    0,    0,  111, 
          112,  113,  239,  240,  241,  242,    0,    0,  118,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  243,  244, 
          245,    0,  246,   35,  247,  248,  249,  250,  285,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  251,    0,    0,  131,    0,    0,   46, 
           47,    0,   48,    0,  708,    0,  287,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  288,    0,    0,    0, 
            0,   52,  289,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    0,  287,  287,  287,    0,  287,   65,   66, 
          290,  287,  287,    0,    0,    0,  287,    0,  287,  287, 
          287,  287,  287,  287,  287,    0,    0,    0,    0,  287, 
          287,  287,  287,  287,  287,  287,    0,    0,  287,    0, 
            0,    0,    0,    0,    0,  287,    0,    0,  287,  287, 
          287,    0,  287,  287,  287,  287,  287,  287,  287,  287, 
          287,  287,  287,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  287,    0,    0,  287,    0,    0,  287, 
          287,    0,  287,    0,  287,    0,  287,    0,  287,    0, 
            0,    0,    0,    0,    0,    0,  287,    0,    0,    0, 
            0,  287,  287,  287,  287,  287,  287,    0,    0,    0, 
          287,    0,  287,  287,    0,  287,  287,  287,  287,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,  287,  287, 
          287,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  109,  110,   17,   18,    0,    0,    0,    0,  111, 
          112,  113,  239,  240,  241,  242,    0,    0,  118,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  243,  244, 
          245,    0,  246,   35,  247,  248,  249,  250,  285,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  251,    0,    0,  131,    0,    0,   46, 
           47,    0,   48,    0,  286,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  288,    0,    0,    0, 
            0,   52,  289,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,   65,   66, 
          290,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  109,  110,   17,   18,    0,    0,    0,    0,  111, 
          112,  113,  239,  240,  241,  242,    0,    0,  118,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  243,  244, 
          245,    0,  246,   35,  247,  248,  249,  250,  285,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  251,    0,    0,  131,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,  287,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  288,    0,    0,    0, 
            0,   52,  289,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,   65,   66, 
          290,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  109,  110,   17,   18,    0,    0,    0,    0,  111, 
          112,  113,  239,  240,  241,  242,    0,    0,  118,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  243,  244, 
          245,    0,  246,   35,  247,  248,  249,  250,  285,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  251,    0,    0,  131,    0,    0,   46, 
           47,    0,   48,    0,  708,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  288,    0,    0,    0, 
            0,   52,  289,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,   65,   66, 
          290,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  109,  110,   17,   18,    0,    0,    0,    0,  111, 
          112,  113,  239,  240,  241,  242,    0,    0,  118,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  243,  244, 
          245,    0,  246,   35,  247,  248,  249,  250,  285,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  251,    0,    0,  131,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  288,    0,    0,    0, 
            0,   52,  289,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    0,    4,    5,    6,    7,    8,   65,   66, 
          290,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,   27,   28,   29,   30,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    4,    5,    6,    7,    8,    0,   65,   66, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,    0,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   44,    0,    0,   45,    0,    0,   46,   47, 
            0,   48,    0,   49,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,   65,   66,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  109, 
          110,   17,   18,    0,    0,    0,    0,  111,  112,  113, 
          239,  240,  241,  242,    0,    0,  118,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  243,  244,  245,    0, 
          246,   35,  247,  248,  249,  250,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  251,    0,    0,  131,  506,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  288,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,   65,   66,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,  239, 
          240,  241,  242,    0,    0,  118,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  243,  244,  245,    0,  246, 
           35,  247,  248,  249,  250,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          251,    0,    0,  131,    0,    0,   46,   47,    0,   48, 
            0,  646,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  288,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,   65,   66,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  109,  110,   17, 
           18,    0,    0,    0,    0,  111,  112,  113,  239,  240, 
          241,  242,    0,    0,  118,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,  243,  244,  245,    0,  246,   35, 
          247,  248,  249,  250,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  251, 
            0,    0,  131,    0,    0,   46,   47,    0,   48,    0, 
          286,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  288,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,   65,   66,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  109,  110,   17,   18, 
            0,    0,    0,    0,  111,  112,  113,  239,  240,  241, 
          242,    0,    0,  118,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  243,  244,  245,    0,  246,   35,  247, 
          248,  249,  250,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  251,    0, 
            0,  131,    0,    0,   46,   47,    0,   48,    0,  646, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  288,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,   65,   66,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  109,  110,   17,   18,    0, 
            0,    0,    0,  111,  112,  113,  239,  240,  241,  242, 
            0,    0,  118,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  243,  244,  245,    0,  246,   35,  247,  248, 
          249,  250,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  251,    0,    0, 
          131,    0,    0,   46,   47,    0,   48,    0,  924,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          288,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,   65,   66,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  109,  110,   17,   18,    0,    0, 
            0,    0,  111,  112,  113,  239,  240,  241,  242,    0, 
            0,  118,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  243,  244,  245,    0,  246,   35,  247,  248,  249, 
          250,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  251,    0,    0,  131, 
            0,    0,   46,   47,    0,   48,    0,  708,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  288, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,    0,  636,  636,  636,    0,  636, 
            0,   65,   66,  636,  636,    0,    0,    0,  636,    0, 
          636,  636,  636,  636,  636,  636,  636,    0,    0,    0, 
            0,  636,  636,  636,  636,  636,  636,  636,    0,    0, 
          636,    0,    0,    0,    0,    0,    0,  636,    0,    0, 
          636,  636,  636,    0,  636,  636,  636,  636,  636,  636, 
            0,  636,  636,  636,  636,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  636,    0,    0,  636,  636, 
            0,  636,  636,    0,  636,    0,    0,    0,    0,    0, 
          636,    0,    0,    0,    0,    0,    0,    0,  636,    0, 
            0,    0,    0,  636,  636,  636,  636,  636,  636,    0, 
            0,    0,  636,    0,  636,  636,    0,  636,  636,  636, 
          636,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
          636,  636,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,  239,  240,  241,  242,    0,    0,   26, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  243, 
          244,  245,    0,  246,   35,  247,  248,  249,  250,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  251,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,   65, 
           66,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  109,  110,   17,   18,    0,    0,    0,    0,  111, 
          112,  113,  239,  240,  241,  242,    0,    0,  118,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  243,  244, 
          245,    0,  246,   35,  247,  248,  249,  250,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  251,    0,    0,  131,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  288,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,   65,   66, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,  239,  240,  241,  242,    0,    0,  118,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  243,  244,  245, 
            0,  246,   35,  247,  248,  249,  250,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  251,    0,    0,  131,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  288,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
            0,  636,  636,  636,    0,  636,    0,   65,   66,  636, 
          636,    0,    0,    0,  636,    0,  636,  636,  636,  636, 
          636,  636,  636,    0,    0,    0,    0,  636,  636,  636, 
          636,  636,  636,  636,    0,    0,  636,    0,    0,    0, 
            0,    0,    0,  636,    0,    0,  636,  636,  636,    0, 
          636,  636,  636,  636,  636,  636,    0,  636,  636,  636, 
          636,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  636,    0,    0,  636,    0,    0,  636,  636,    0, 
          636,    0,    0,    0,    0,    0,  636,    0,    0,    0, 
            0,    0,    0,    0,  636,    0,    0,    0,    0,  636, 
          636,  636,  636,  636,  636,    0,    0,    0,  636,    0, 
          636,  636,    0,  636,  636,  636,  636,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,  636,  636,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  109,  110, 
           17,   18,    0,    0,    0,    0,  111,  112,  113,  114, 
          115,  116,  117,    0,    0,  118,    0,    0,    0,    0, 
            0,    0,  119,    0,    0,  120,  121,  122,    0,  123, 
           35,  124,  125,  126,  127,    0,   40,    0,    0,  128, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  129,    0,    0,    0, 
          130,    0,    0,  131,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,   65,   66,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  109,  110,   17, 
           18,    0,    0,    0,    0,  111,  112,  113,  267,  268, 
          269,  270,    0,    0,  118,    0,    0,    0,    0,    0, 
            0,  119,    0,    0,  271,  272,  273,    0,  274,   35, 
          275,  276,  277,  278,    0,   40,    0,    0,  128,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  279, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,   65,   66,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  109,  110,   17,   18, 
            0,    0,    0,    0,  111,  112,  113,  340,  341,  342, 
          343,    0,    0,  118,    0,    0,    0,    0,    0,    0, 
          119,    0,    0,  344,  345,  346,    0,  347,   35,  348, 
          349,  350,  351,    0,   40,    0,    0,  128,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  352,    0, 
            0,  427,    0,    0,   46,   47,    0,   48,    0,  428, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,   65,   66,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  109,  110,   17,   18,    0, 
            0,    0,    0,  111,  112,  113,  114,  115,  116,  117, 
            0,    0,  118,    0,    0,    0,    0,    0,    0,  119, 
            0,    0,  120,  121,  122,    0,  123,   35,  124,  125, 
          126,  127,    0,   40,    0,    0,  128,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  130,    0,    0, 
          131,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,   65,   66,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  109,  110,   17,   18,    0,    0, 
            0,    0,  111,  112,  113,  340,  341,  342,  343,    0, 
            0,  118,    0,    0,    0,    0,    0,    0,  119,    0, 
            0,  344,  345,  346,    0,  347,   35,  348,  349,  350, 
          351,    0,   40,    0,    0,  128,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  352,    0,    0,  427, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,   65,   66,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  109,  110,   17,   18,    0,    0,    0, 
            0,  111,  112,  113,  114,  115,  116,  117,    0,    0, 
          118,    0,    0,    0,    0,    0,    0,  119,    0,    0, 
          120,  121,  122,    0,  984,   35,  124,  125,  985,  127, 
            0,   40,    0,    0,  128,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  986,    0,    0,  131,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
           65,   66,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  997,  998,  999, 1000,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,  119,    0,    0, 1001, 
         1002, 1003,    0, 1004,   35, 1005, 1006, 1007, 1008,    0, 
           40,    0,    0,  128,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0, 1009,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   65, 
           66,  139,  140,  141,  142,  143,  144,  145,  146,  147, 
          148,  149,  150,  151,  152,  153,  154,  155,  156,  157, 
          158,  159,  160,  161,  162,    0,    0,  163,  164,  165, 
          223,  224,  225,  226,  170,  171,  172,  173,  174,  175, 
          176,  177,  178,  179,  180,  181,  227,  228,  229,    0, 
          230,  186,  310,    0,  231,    0,    0,    0,  188,  189, 
            0,  190,  191,  192,  193,  194,  195,  196,    0,    0, 
          197,  198,    0,    0,    0,  199,  200,  201,  202,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  204,  205,    0,  206,  207,  208,  209,  210, 
          211,  212,  213,  214,  215,  216,    0,    0,  217,   52, 
          139,  140,  141,  142,  143,  144,  145,  146,  147,  148, 
          149,  150,  151,  152,  153,  154,  155,  156,  157,  158, 
          159,  160,  161,  162,    0,    0,  163,  164,  165,  223, 
          224,  225,  226,  170,  171,  172,  173,  174,  175,  176, 
          177,  178,  179,  180,  181,  227,  228,  229,    0,  230, 
          186,    0,    0,  231,    0,    0,    0,  188,  189,    0, 
          190,  191,  192,  193,  194,  195,  196,    0,    0,  197, 
          198,    0,    0,    0,  199,  200,  201,  202,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  204,  205,    0,  206,  207,  208,  209,  210,  211, 
          212,  213,  214,  215,  216,    0,    0,  217,   52,  139, 
          140,  141,  142,  143,  144,  145,  146,  147,  148,  149, 
          150,  151,  152,  153,  154,  155,  156,  157,  158,  159, 
          160,  161,  162,    0,    0,  163,  164,  165,  166,  167, 
          168,  169,  170,  171,  172,  173,  174,  175,  176,  177, 
          178,  179,  180,  181,  182,  183,  184,    0,  185,  186, 
          124,  125,  187,  127,    0,    0,  188,  189,    0,  190, 
          191,  192,  193,  194,  195,  196,    0,    0,  197,  198, 
            0,    0,    0,  199,  200,  201,  202,    0,    0,    0, 
            0,    0,    0,  203,    0,    0,    0,    0,    0,    0, 
          204,  205,    0,  206,  207,  208,  209,  210,  211,  212, 
          213,  214,  215,  216,    0,    0,  217,  139,  140,  141, 
          142,  143,  144,  145,  146,  147,  148,  149,  150,  151, 
          152,  153,  154,  155,  156,  157,  158,  159,  160,  161, 
          162,    0,    0,  163,  164,  165,  223,  224,  225,  226, 
          170,  171,  172,  173,  174,  175,  176,  177,  178,  179, 
          180,  181,  227,  228,  229,    0,  230,  186,  360,  361, 
          231,  362,    0,    0,  188,  189,    0,  190,  191,  192, 
          193,  194,  195,  196,    0,    0,  197,  198,    0,    0, 
            0,  199,  200,  201,  202,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  204,  205, 
            0,  206,  207,  208,  209,  210,  211,  212,  213,  214, 
          215,  216,    0,    0,  217,  139,  140,  141,  142,  143, 
          144,  145,  146,  147,  148,  149,  150,  151,  152,  153, 
          154,  155,  156,  157,  158,  159,  160,  161,  162,    0, 
            0,  163,  164,  165,  223,  224,  225,  226,  170,  171, 
          172,  173,  174,  175,  176,  177,  178,  179,  180,  181, 
          227,  228,  229,    0,  230,  186,    0,    0,  231,    0, 
            0,    0,  188,  189,    0,  190,  191,  192,  193,  194, 
          195,  196,    0,    0,  197,  198,    0,    0,    0,  199, 
          200,  201,  202,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  204,  205,    0,  206, 
          207,  208,  209,  210,  211,  212,  213,  214,  215,  216, 
          734,  629,  217,    0,  735,    0,    0,    0,  188,  189, 
            0,  190,  191,  192,  193,  194,  195,  196,    0,    0, 
          197,  198,    0,    0,    0,  199,  200,  201,  202,    0, 
            0,    0,    0,    0,    0,  304,    0,    0,    0,    0, 
            0,    0,  204,  205,    0,  206,  207,  208,  209,  210, 
          211,  212,  213,  214,  215,  216,  919,  621,  217,    0, 
          920,    0,    0,    0,  188,  189,    0,  190,  191,  192, 
          193,  194,  195,  196,    0,    0,  197,  198,    0,    0, 
            0,  199,  200,  201,  202,    0,    0,    0,    0,    0, 
            0,  304,    0,    0,    0,    0,    0,    0,  204,  205, 
            0,  206,  207,  208,  209,  210,  211,  212,  213,  214, 
          215,  216,  922,  629,  217,    0,  923,    0,    0,    0, 
          188,  189,    0,  190,  191,  192,  193,  194,  195,  196, 
            0,    0,  197,  198,    0,    0,    0,  199,  200,  201, 
          202,    0,    0,    0,    0,    0,    0,  304,    0,    0, 
            0,    0,    0,    0,  204,  205,    0,  206,  207,  208, 
          209,  210,  211,  212,  213,  214,  215,  216, 1078,  621, 
          217,    0, 1079,    0,    0,    0,  188,  189,    0,  190, 
          191,  192,  193,  194,  195,  196,    0,    0,  197,  198, 
            0,    0,    0,  199,  200,  201,  202,    0,    0,    0, 
            0,    0,    0,  304,    0,    0,    0,    0,    0,    0, 
          204,  205,    0,  206,  207,  208,  209,  210,  211,  212, 
          213,  214,  215,  216, 1081,  621,  217,    0, 1082,    0, 
            0,    0,  188,  189,    0,  190,  191,  192,  193,  194, 
          195,  196,    0,    0,  197,  198,    0,    0,    0,  199, 
          200,  201,  202,    0,    0,    0,    0,    0,    0,  304, 
            0,    0,    0,    0,    0,    0,  204,  205,    0,  206, 
          207,  208,  209,  210,  211,  212,  213,  214,  215,  216, 
         1084,  629,  217,    0, 1085,    0,    0,    0,  188,  189, 
            0,  190,  191,  192,  193,  194,  195,  196,    0,    0, 
          197,  198,    0,    0,    0,  199,  200,  201,  202,    0, 
            0,    0,    0,    0,    0,  304,    0,    0,    0,    0, 
            0,    0,  204,  205,    0,  206,  207,  208,  209,  210, 
          211,  212,  213,  214,  215,  216,    0,    0,  217, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

           26,   74,   28,    2,    3,    4,    5,  100,    6,  468, 
            9,   10,   11,    3,    7,   14,   15,   16,   51,  296, 
           19,   27,   88,    6,    7,   91,   49,  341,   15,   16, 
           11,  258,   19,   10,   27,  448,   10,   10,   11,   15, 
           16,  488,    7,   19,   27,  580,   45,  473,  485,    0, 
           49,  488,   51,   10,   52,   21,  367,  368,  424,   10, 
           47,   48,   27,   45,  335,  431,   10,   59,  339,   52, 
            2,    3,   15,   16,    0,  418,   19,   10,  105,   10, 
          527,   10,   59,  673,  430,  372,    4,    5,   10,    0, 
           53,   10,  417,  119,  419,   10,   14,   10,  423,  689, 
           59,  100,   59,  446,   47,   10,  537,   10,   59,   10, 
           10,   44,  702,   43,  683,   10,   10,   21,  508,  462, 
          105,  322,  447,  692,  105,  864,   59,   10,   59,   10, 
          129,   49,  131,  476,   10,   10,  461,  758,  463,   44, 
           59,  107,   10,  733,   59,  280,   59,  113,  772,   44, 
          307,  980,  477,   10,   59,  341,   59,  960,   59,   59, 
          130,  305,  558,   44,   59,   59,  269,   10,  271,   10, 
           10,  137,  329,  330,   10,   10,   10,  342,   61,  280, 
           61,   10,  100,   10,   59,   61,  511,   44,  254,   10, 
          587,  328,  535,  306,  359,   10,  342,  310,  128,  336, 
           10,   44,   59,  107,   44,    2,    3,    4,    5,   44, 
           44,  536,   10,  359,  280,   44,   59,   14,   32,   59, 
          497,  308,  619,  654,   59,   61,  427,  362,   10,  305, 
           59,  375,  362,    9,   10,   11,   10,  548,   59,  238, 
          341,  310,   10, 1072,   59,   10,   10,   10,   45,   59, 
          316,   32,   49,   10,   32,  668,   10,  424, 1061,  426, 
          353,  362,   10,  887,  431,  678,  265,  266,   10,  716, 
           10,  558,  583,   10,   32,   10,  261,   32,  715,  716, 
          261,  677,   32,  679, 1023,    0,   10,   61,  354,  376, 
          377,  557,  265,  266,   10,   10,   10,  324,  366,  375, 
           10,  345,  301,  100,  303,  304,  784,   44,  307,  338, 
          309,   59,  790,  282,  301,  314,  303,   44,   10,  363, 
           61,  320,   10,  322,   59,  301,  289,  303,  304,  338, 
           10,  921,  331,  490,  131,  725,  682,   61,   10,  324, 
          322,  498,  499,  324,   59,  325,  967,  882,  290,  291, 
          342,   61,   61,  129,  353,   10,  891,  341,  301,  516, 
          303,  896,  281,  263,  264,   44,  267,  780,  342,   61, 
          264,  345,  267,   61,  805,  269,   45,  271,  947,  359, 
          379,  380,  381,  382,  383,  384,  385,   59,  320,  264, 
          677,  424,  679,  426,  807,  357,  279,  430,  431,  331, 
          359,  345,  359,  279,   59,  428,  379,  380,  381,  382, 
          267,  342,  363,  342,  840,  781,  782,  310,  395,  418, 
          342,  787,  788,  345,  338,  424,  359,  426,  427,  428, 
          741,  430,  431,  710,  433,  353,  419,  363,  339,   61, 
          423,  238,  418,  433,  537,  427,  359,  446,  363,  448, 
          449,  383,  363,  419,  359,  798,  359,  768,  729,  342, 
          459,  342,  131,  462,  447,  305,  342,  694,  467,  756, 
          446,  758,  797,  341,  799,  445,  305,  476,  744,  745, 
          463,  447,  339,  426,  305,  772,  462,  430,  947,  265, 
          266,  472,  473, 1083,  477,  305,  653,  463,  485,  505, 
          476,  433,  342,   10,  951,  279,  342,  506, 1043,  508, 
          428,  477,  505,  342,  951,  342,  359,  314,  345,  676, 
          519,  342,  505,  320,  359,  322,  469,  342,  511,    2, 
            3,  307,  342,  309,  331,  375,  535,  524,  537,  372, 
          505,   14,  908,  338,  342,  511,  375,  345,   10,    2, 
           10,  271,   59,  536,  375,  279,  353,  371,  372,  535, 
          342,  654,   10,  720,  378,  375,  756,  844,  342,  279, 
          536,  728,   45,   10,  342,  641,  508,  342,  342,  342, 
          571,  572,   44,  996,   91,  342,  383,  279,  342,   59, 
          616,  279,  749,   10,   47,   48,  862,   59,  864,   59, 
          342,  627,  342,  379,  380,  381,  382,   44,  384,  385, 
          290,  291,  267,   61,  781,  782,  371,  372,  342,  537, 
          787,  788,   59,  378,  310,   44,  342,  424,  342,  426, 
          427,  428,  342,  800,  431,   10,  433,  730,   10,  371, 
          372,  373,   61,  373,   61,  314,  378,  673,  378,  279, 
          342,  448,   44,  322,  342,  654,  813,  623,  131,  268, 
          269,  312,  459,  689,  396,  631,  317,   44,  667,  668, 
          467,  637,   44,  449,  339,  681,  702,  350,  351,  678, 
          967,  317,  680,   15,   16,  666,   61,   19,  681,  976, 
          956,  957,   44,  980,  667,    2,    3,  680,  681,  350, 
          351,  263,  264,  362,  861,  671,  705,  733,  674,  936, 
         1053,  508,  805,  349,   10,  942,  681,  353,  354,  623, 
          317,  794,  519,  317,  750,  558,  725,  631,  715, 1054, 
          506,  730,  705,  637,  338,  756,  654,  758,   45,  682, 
          537,  908,   10,  394,  322,  323,  772,  373,  781,  782, 
          342,  772,  378,  363,  787,  788,  345, 1023,  427, 1025, 
          267,   10,  328,   59,   44,  238,  310,  800,   44,  335, 
          336,  961,  347,  280,   44,  774,  862,  341,  777,  357, 
          358,  780,  781,  782,  341, 1072,  976,  262,  787,  788, 
          459,   59,  264,  725, 1060,   44,  795,  342,  467,  798, 
          267,  800,  371,  372,   10,  264,  805,  267,  807,  378, 
           59,   44,  730,   44,  383,  363,  799,   44,  306,   91, 
          362,  328,  798,  822,  131,  306,  825,  808,  335,  336, 
           44,  279,   44,  799,  815,   44,   91,  836,  837,  838, 
           44,  314,   91,  305,  677,   10,  679,  320,  306,  322, 
           44,  304,  825,   59,   61,  362,  264,  654,  331,  840, 
          279,  887,  279,  795,   44,  363,  297,  338,  305,  338, 
          956,  668,  871,  872,  338,  908,   61,  868, 1068,   44, 
          342,  678,  338,  874,  875,   91,  877,  805,  879,   44, 
           44,  667,  424,  264,  342,  921,   61,  359,  897,  431, 
          269,   10,   44,  338,  279,  342,  263,  264,  338,  908, 
          383,   91,  269,  375,  306,  338,  308,  309,  310,  311, 
          338,  264,  359,  363,   32,  342,   91,   44,  725,  705, 
           32,  238,  464,  730,  466,   10,  935,   58,  375, 1025, 
          939,  738,  338,  345, 1010,   91,  967,  363,  264,   91, 
           59,  424,  264,  426,  427,  976,  339,  338,  431,  980, 
          433,  263,   44,   91,  264,  418,  264,  342,  264,  301, 
          363,  303,  268,  269, 1060,  448,   44,  774,   91,  897, 
          777,  513,   91,  780,  781,  782,  459,  342,   59,  988, 
          787,  788,   44,  446,  467,   44,  264,  996,  795,   44, 
           44,  269, 1028,  800,   44,   44,   44,  314,  805,  462, 
          807,   44,   44,  320, 1013,  322, 1015,  935,  379,  380, 
          381,  382, 1021,  476,  331,  822,  306,   61,  308,  309, 
          310,  311,  359,   44,  264,  508,  264,  363,  264,  836, 
          837,  838, 1033, 1034, 1035, 1036,  519,  264,  264,  825, 
          359, 1072,  310,  310, 1053,  508,  328, 1083,   91, 1058, 
           44,  267,   10,  335,  336,  371,  372,  373,   44,   44, 
          988, 1054,  378,  328,  871,  872,  383, 1053,   44,  328, 
          335,  336,  535,   44,   10,   44,  335,  336, 1054,  264, 
          264,  395,  341,   44,  271,  345,   44,  363,  341,  279, 
          897, 1092,   10,  271,  342,  774,   10,  363,  777,  345, 
          359,  908,   58,   61,  279,    0,   10,  424,   70,  426, 
          427,  345,  328,  345,  431,   10,  433,  264,   10,  335, 
          336,  583,  585,   59,  587,  341,    5,  279,  935,  519, 
           44,  448,  939,   91, 1056,    6,  637,  934,  328,  756, 
          978,   59,  459,  822,  772,  335,  336,   61,  267,  760, 
          467,  341,   44,  328,  976,   59,  619,  836,  837,  838, 
          335,  336,  308,  309,   59,  311,  341,  342,  631,   61, 
          793,  664,  328,   91,  637,   91,  328,   91,   14,  335, 
          336,  988, 1055,  335,  336,  668, 1061,   91,  744,  996, 
          328,  508,  871,  872,   -1,  678,   89,  335,  336,   91, 
           -1,   91,  519,   -1,   -1,  328, 1013,   44, 1015,  328, 
           -1,  674,  335,  336, 1021,   -1,  335,  336,   -1,  682, 
          683,  306,  685,  308,  309,  310,  311,  312,   10,  692, 
          376,  377,  317,   -1,   -1,   -1,  279,  280,   -1,  781, 
          782,   -1,  725,   -1,   -1,  787,  788,   -1,   91,   -1, 
           -1, 1058,   -1,   -1,   91,  340,   -1,   10,   91,   -1, 
          939,   -1,  725,  348,  349,  350,  351,   -1,   -1,   10, 
           -1,   -1,    0,   -1,   -1,   15,   16,   59,   -1,   19, 
           -1,   10,   10,   -1,   -1,  328,  828,  829,   -1,  831, 
          832,  774,  335,  336,  777,   -1,   -1,  780,  781,  782, 
           -1,   41,   42,   -1,  787,  788,   59,   47,   48,  394, 
           50,   51,  795,   10,   -1,   44,   44,  800,   59,  362, 
           -1,  279,  280,   -1,  807,   -1,  262,  263,  264,   -1, 
           59,   59,   -1,  269, 1013,  798, 1015,   -1,   -1,  822, 
           -1,   -1, 1021,   -1,   -1,   44,   -1,   44,   -1,  267, 
           91,  668,   -1,  836,  837,  838,   10,  820,   -1,   -1, 
          823,  678,   91,  267,   61,  279,  280,  262,  263,  264, 
          328,   -1,  267,  268,  269,   -1,  271,  335,  336, 1058, 
           -1,   -1,   -1,  341,  342,   -1,  281,  279,  871,  872, 
           44,   -1,   91,   -1,   91,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  362,   -1,   -1,   61,  725,   -1, 
          328,   -1,  328,   -1,  328,   -1,   -1,  335,  336,  335, 
          336,  335,  336,   -1,  328,  908,   -1,  341,  342,    4, 
            5,  335,  336,  328,   -1,   -1,  328,   91,  328,   14, 
          335,  336,  279,  335,  336,  335,  336,  342,  362,   -1, 
          342,   -1,  935,   -1,   -1,   -1,  939,  774,   -1,   10, 
          777,   -1,   -1,  780,  781,  782,   41,   42,  363,   -1, 
          787,  788,   47,   48,   49,   50,   -1,   -1,  795,   48, 
          262,  263,  264,  800,  947,  328,  268,  269,   -1,  271, 
          807,  328,  335,  336,   -1,  328,   -1,   -1,  335,  336, 
          395,   -1,  335,  336,   -1,  822,   -1,   -1,   59,  262, 
          263,  264,    0,  996,   -1,  268,  269,   -1,  271,  836, 
          837,  838,   10,   -1,   -1,  100,  267,   -1,   -1,   -1, 
         1013,   -1, 1015,   -1,  262,  263,  264,   -1, 1021,  267, 
          268,  269,   -1,  271,   -1,  285,  286,  287,  288,   -1, 
          290,  280,   -1,   -1,  871,  872,   -1,   -1,   -1,   -1, 
          342,  301,   -1,  303,  304,  293,  294,  295,  296,  297, 
           10,   59,  312,   -1,  306, 1058,  308,  309,  310,  311, 
          279,  363,  279,   -1,   -1,   -1,   -1,  328,   -1,  342, 
         1053,  908,   -1, 1056,  335,  336,   -1,   -1,  306,  328, 
          308,  309,  310,  311,   44,   -1,  335,  336,  340,   -1, 
          363,  339,  341,  395,  342,   -1,  348,  371,  372,  373, 
           -1,   61,  939,   -1,  378,  279,  280,   -1,   -1,  328, 
          359,  328,  340,  362,   -1,  363,  335,  336,  335,  336, 
          348,   -1,  395,   -1,   -1,  342,  386,  387,  388,  389, 
          390,   91,   -1,  393,  394,  395,  396,  397,  398,  399, 
          400,  401,  402,  403,  404,  405,  406,  395,   -1,  409, 
          410,  411,  412,   44,  328,   -1,   -1,   -1,  418,  996, 
          420,  335,  336,   -1,  424,   -1,  426,  341,  342,   -1, 
          430,  431,   -1,   -1,   -1,   -1, 1013,  306, 1015,  308, 
          309,  310,  311,   -1, 1021,   -1,  446,   -1,  362,   -1, 
          285,  286,  287,  288,   -1,  290,  285,  286,  287,   -1, 
           91,  290,  462,    0,  464,  465,  466,  753,   -1,  469, 
           -1,  340,  758,   10,   -1,   -1,  476,  312,   -1,   44, 
           -1, 1058,   -1,   -1,  484,  485,  772,   -1,  488,  371, 
          372,  373,   -1,   -1,   -1,  306,  378,  308,  309,  310, 
          311,  312,   -1,  371,  372,  373,  317,   44,   -1,   -1, 
          378,   -1,  512,  513,  262,  263,  264,  328,  353,  267, 
          268,  269,   59,  271,  524,  336,   91,  527,   -1,  340, 
          341,   -1,   -1,  281,   -1,  535,   -1,  348,  349,  350, 
          351,   -1,  290,  291,   10,  293,  294,  295,  296,  297, 
           -1,  386,  387,  388,  389,  390,   -1,   -1,  393,  394, 
          395,  396,  397,  398,  399,  400,  401,  402,  403,  404, 
          405,  406,   44,   10,  409,  410,  411,  412,   44,  279, 
          280,  581,   -1,  394,   10,  420,   10,   -1,   10,  371, 
          372,  373,   -1,  428,  342,   61,  378,  426,   44,   -1, 
           -1,  430,   -1,   10,  371,  372,  373,   44,   -1,   -1, 
           -1,  378,   -1,   -1,   -1,  363,   -1,   -1,   44,   91, 
           44,   -1,   44,   -1,   61,   91,   -1,   -1,  328,  464, 
          465,  466,   -1,   59,  469,  335,  336,   61,   -1,   61, 
          469,  341,  342,   -1,   -1,   91,  646,  395,  279,  484, 
          485,   -1,   59,  488,   91,  484,  485,   -1,   -1,  488, 
           -1,   -1,  362,   -1,   -1,   91,   10,   91,  306,   91, 
          308,  309,  310,  311,   -1,   -1,   -1,  512,  513,  965, 
           -1,  967,  682,  969,   91,   -1,   -1,  973,   -1,  524, 
           -1,   -1,  527,   -1,  980,  524,   -1,  328,  527,   -1, 
           44,  317,  537,   -1,  335,  336,  706,   -1,  708,  293, 
          294,  295,  296,  297,  279,  715,  716,   61,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   10,  760, 
          267,  268,  269,  349,  271,   -1,   -1,  353,  354,  355, 
          356,  772,   -1,   44,  281,  282,  581,   91,   -1,   -1, 
           -1,   -1,  581,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,    0,  328,   -1,   -1,  766,   -1,   -1,   -1, 
          335,  336,   10,   -1,   -1,   -1,   -1,   59, 1064,   -1, 
           -1,  781,  782,   44, 1070,   10, 1072,  787,  788, 1075, 
           91,   -1,   -1,   44,   -1,   -1,  796,   -1,  798,   -1, 
          800,   -1,  802,   -1,   -1,  342,   -1,  279,  345,   -1, 
          347,  646,   10,  279,  280, 1101,   -1,  646,   -1,  654, 
           -1,   59,   -1,   -1,   -1,   -1,  363,   -1,  828,  829, 
           91,  831,  832,  279,   59,  835,   -1,   -1,   -1,   -1, 
           91,   -1,  279,  280,   -1,   -1,   -1,  682,   -1,   -1, 
           -1,   -1,   -1,  682,  280,  279,  328,  279,  395,   -1, 
          267,   59,  328,  335,  336,   -1,   91,   -1,   -1,  335, 
          336,  706,   -1,  708,   -1,  341,  342,  706,   -1,  708, 
          715,  716,  328,   -1,   -1,   -1,  715,  716,   -1,  335, 
          336,  328,   -1,   91,   -1,  730,  362,    0,  335,  336, 
           -1,  901,  328,   -1,  328,  342,  328,   10,  908,  335, 
          336,  335,  336,  335,  336,  341,   -1,   -1,  342,   -1, 
          342,  328,   -1,   -1,  924,  362,   -1,   -1,  335,  336, 
           -1,  766,   -1,  359,  888,  279,  362,  766,  892,   -1, 
           -1,   44,  973,   -1,  944,  976,   -1,  978,   -1,  980, 
           -1,  951,   -1,   -1,   -1,   58,   59,   -1,   61,   -1, 
           63,  796,   -1,   -1,   -1,   -1,   -1,  802,   -1,   -1, 
          805,   -1,   -1,  802,   -1,   -1,   -1,   -1,  279,  280, 
          262,  263,  264,   -1,  328,  267,  268,  269,   91,  271, 
           -1,  335,  336,  828,  829,   -1,  831,  832,  342,  281, 
          835,   -1,   -1,   -1,   -1,   -1,  835,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,  279,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  328,  279,  267, 
          268,  269,   -1,  271,  335,  336,   -1, 1068,    0, 1070, 
          341, 1072,  267,  281, 1075,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1, 1053,   -1,  293,  294,  295,  296,  297, 
          342,  362,  897,   -1,   -1,   -1,  901,  328,   -1,  267, 
         1101,   -1,   -1,   -1,  335,  336,   -1,  328,   -1,   -1, 
           -1,  363,   44, 1037,  335,  336, 1040, 1041,   -1,  924, 
         1044, 1045,   -1,   -1,   -1,  924,   58,   59,   -1,   61, 
          935,   63,   -1,  328,  342,   -1,   -1,   -1,   -1,  944, 
          335,  336,   -1,  395,   -1,   -1,  951,   -1,   -1,   -1, 
           -1,   -1,  951,   -1,   -1,  363,   -1,   10,   -1,   91, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 1093, 
         1094, 1095, 1096,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1, 1105,   -1,  988,  257,  258,  259,  395,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   59,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   10,   -1, 
          333,  334,  335,  336,  337,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           44,  374,  375,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   63,   -1,   -1,   -1,  772,   -1,   -1,   -1,  392, 
          393,  394,  395,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   91,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   44, 
           -1,  333,  334,  335,  336,  337,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,    0,  374,  375,  376,  377,   91,  379,  380,  381, 
          382,   10,   -1,  306,  317,  308,  309,  310,  311,  312, 
          392,  393,  394,  395,  317,   -1,   -1,   -1,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   44,  349,  340,  341,   -1, 
          353,  354,  355,  356,   -1,  348,  349,  350,  351,   58, 
           59,   -1,   61,   -1,   63,   -1,  306,   -1,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,  973,  317,   -1,  976, 
           -1,  978,   -1,  980,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,  279,  262,  263,  264,   -1, 
          340,  394,  268,  269,   -1,  271,  262,  263,  264,   -1, 
          350,  351,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
            0,  333,  334,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           10,  335,  336,   -1,  394,   -1,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1, 1068,   -1, 1070,   -1, 1072,  342,   -1, 1075,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,  342,   -1,   -1,  317, 
           -1,   -1,   -1,   -1,  279,   -1,   -1,  363,   58,   59, 
           -1,   61,   -1,   63, 1101,  333,  334,  363,   -1,   -1, 
           -1,  306,   -1,  308,  309,  310,  311,  312,   -1,   -1, 
           -1,  349,  317,  351,   -1,  353,  354,  355,  356,  395, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395, 
           -1,   -1,   -1,  328,   -1,  340,  341,   -1,   -1,   -1, 
          335,  336,   10,  348,  349,  350,  351,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  394, 
          299,   59,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   44,   -1,  333,  334,  335,  336,  337,   10, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   44,   -1,   -1,  374,  375,  376,  377,   91, 
          379,  380,  381,  382,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   10,   -1,  392,  393,  394,  395,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   91, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           59,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   91,  333,  334,  335,  336,  337,   -1,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,    0,  374,  375,  376,  377,   -1,  379, 
          380,  381,  382,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  392,  393,  394,  395,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,   -1, 
          308,  309,  310,  311,  312,   -1,   -1,   44,   -1,  317, 
           -1,   -1,   -1,   -1,  317,   -1,   -1,  279,  280,   -1, 
          328,   58,   59,   -1,   61,   -1,   63,   -1,  336,   -1, 
          333,  334,  340,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,  350,  351,   -1,   -1,  349,   -1,  351,   -1, 
          353,  354,  355,  356,   91,   -1,  359,  279,  361,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,  306,  394,  308,  309,  310, 
          311,  312,   -1,   -1,   -1,   -1,  317,   -1,  267,   -1, 
          362,   -1,    0,   -1,   -1,   -1,  328,  328,   -1,   -1, 
           -1,   -1,   10,  335,  336,  336,   -1,   -1,   -1,  340, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  328, 
           58,   59,   -1,  333,  334,   63,  335,  336,   -1,   -1, 
           -1,   -1,   -1,  394,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   59,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   44,   -1,  333,  334,  335,  336, 
          337,   10,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,  375,  376, 
          377,   91,  379,  380,  381,  382,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   10,   -1,  392,  393,  394,  395,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   59,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   91,  333,  334,  335,  336,  337, 
           -1,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,    0,  374,  375,  376,  377, 
           -1,  379,  380,  381,  382,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  392,  393,  394,  395,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,  312,   -1,   -1,   44, 
           -1,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279, 
          280,  317,  328,   58,   59,   -1,  322,  323,   63,   -1, 
          336,   -1,   -1,   -1,  340,  341,   -1,  333,  334,   -1, 
           -1,   -1,  348,  349,  350,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,   91,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,  306,  394,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1, 
          267,   -1,  362,   -1,    0,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,  336,   -1,   -1, 
           -1,  340,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,  350,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,   44,  326, 
          327,   -1,   -1,   -1,   -1,   -1,  333,  334,   -1,   -1, 
           -1,  328,   58,   59,   -1,   -1,   -1,   63,  335,  336, 
           -1,   -1,  349,   -1,  351,  394,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   59,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   44,   -1,  333,  334, 
          335,  336,  337,   10,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
          375,  376,  377,   91,  379,  380,  381,  382,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   10,   -1,  392,  393,  394, 
          395,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   59,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   91,  333,  334,  335, 
          336,  337,   -1,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,    0,  374,  375, 
          376,  377,   -1,  379,  380,  381,  382,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  392,  393,  394,  395, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,   -1,  308,  309,  310,  311,  312,   -1, 
           -1,   44,   -1,  317,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,  280,   -1,  328,   58,   59,   -1,   61,   -1, 
           63,   -1,  336,   -1,   -1,   -1,  340,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,  350,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,  306, 
          394,  308,  309,  310,  311,  312,   -1,   -1,   -1,   -1, 
          317,   -1,  267,   -1,  362,   -1,    0,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   10,   -1,   -1,  336, 
           -1,   -1,   -1,  340,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           44,  326,  327,   -1,   -1,   -1,   -1,   -1,  333,  334, 
           -1,   -1,   -1,  328,   -1,   59,   -1,   -1,   -1,   63, 
          335,  336,   -1,   -1,  349,   -1,  351,  394,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   59,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   44,   -1, 
          333,  334,  335,  336,  337,   10,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,   -1, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,  375,  376,  377,   91,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   10,   -1,  392, 
          393,  394,  395,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   59,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   63,   91,  333, 
          334,  335,  336,  337,   -1,  339,  340,   -1,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,    0, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
          394,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310,  311, 
          312,   -1,   -1,   44,   -1,  317,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  279,  280,   -1,  328,   -1,   59,   -1, 
           -1,   -1,   63,   -1,  336,   -1,   -1,   -1,  340,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  306,  328,  308,  309,  310,  311,  312,   -1,  335, 
          336,   -1,  317,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,  306,  394,  308,  309,  310,  311,  312,   -1,   -1, 
           -1,   -1,  317,   -1,  267,  340,  362,   -1,    0,   -1, 
           -1,   -1,   -1,  348,  349,  350,  351,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,  350,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  394, 
           -1,  297,   -1,   -1,   -1,  328,   -1,   59,   -1,   -1, 
           -1,   63,  335,  336,   -1,   -1,   -1,   -1,   -1,  394, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
            0,   -1,  333,  334,  335,  336,  337,   10,  339,  340, 
           10,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   44,   -1,  374,   44,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,   -1,   -1,   59,   -1,   58,   59, 
           -1,  392,  393,  394,  395,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,   91,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,   -1,  339,  340,   -1, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
            0,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           10,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          392,  393,  394,  395,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,  280,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,  359,   -1,   -1,  362, 
           -1,   -1,   -1,  363,   -1,  306,  307,   -1,   59,  310, 
           61,   -1,   63,  314,  315,  375,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,  395,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  337,  338,   10, 
          340,  341,  342,  343,  344,   -1,  346,   -1,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,  760,   -1,  374,  763,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  772,   -1,   -1,   -1,   59,   -1, 
           10,   -1,  392,  393,  394,  395,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           91,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   59, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           63,   91,  333,  334,  335,  336,  337,  338,   -1,  340, 
          341,  342,  343,  344,   -1,  346,   -1,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,    0,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  392,  393,  394,  395,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  973,   -1,   -1,  976,   -1, 
          978,   -1,  980,   -1,   -1,   -1,  267,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,  280, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  267,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   10,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
         1068,   -1, 1070,   -1, 1072,   -1,   -1, 1075,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           59,   -1,   61, 1101,   63,  335,  336,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,  337, 
           -1,   10,  340,  341,  342,  343,  344,   -1,  346,   -1, 
          348,  349,  350,  351,  352,  353,  354,  355,  356, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          357,  358,  359,  360,  361,  362,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,  392,  393,  394,  395,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   91,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,  337, 
           -1,   -1,  340,  341,  342,  343,  344,   -1,  346,   -1, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,    0,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  392,  393,  394,  395,   -1,   -1, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   44, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   59,  341,   61,   -1,   63,   -1, 
           -1,   -1,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,   -1,   -1,  364,  267, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,  280,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   10,   -1,   -1,  335,  336,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,  362,   -1,  326,  327,   44,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   59,   -1,   61,   -1,   63,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,  337,   -1,   10,  340,  341,  342,  343,  344, 
           -1,  346,   -1,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,  392,  393,  394, 
          395,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   91,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  337,   -1,   -1,  340,  341,  342,  343,  344,   -1, 
          346,   -1,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,    0,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  392,  393,  394,  395, 
           -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   44,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   59,  341,   61,   -1, 
           63,   -1,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,  267,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,  280,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   10,   -1,   -1,  335, 
          336,   -1,   -1,   -1,   -1,  341,   -1,   -1,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,  362,   -1,  326,  327, 
           44,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   59,   -1,   61,   -1,   63, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,  337,   -1,   10,  340,  341,  342, 
          343,  344,   -1,  346,   -1,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,  392, 
          393,  394,  395,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   91,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,   -1,   -1,  340,  341,  342,  343, 
          344,   -1,  346,   -1,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,    0, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   10, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  392,  393, 
          394,  395,   -1,   -1,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   44,  326,  327,   44,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   59,  341, 
           61,   -1,   63,   61,   -1,   -1,  348,  349,   -1,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
           -1,   -1,  364,  267,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   91,   -1,   -1,  280,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   10,   -1, 
           -1,  335,  336,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,  362,   -1, 
          326,  327,   44,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   59,   -1,   61, 
           -1,   63,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,   -1,   -1,  364,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,  279,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
          328,   -1,  333,  334,  335,  336,  337,  335,  336,  340, 
          341,  342,  343,  344,  342,  346,   -1,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,    0,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   10,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  392,  393,  394,  395,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           59,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,   -1,   -1,  340,  341, 
          342,  343,  344,   -1,  346,   -1,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
            0,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           10,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          392,  393,  394,  395,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   59, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   91,   -1,   -1,   -1,   -1,  335,  336,  337,   -1, 
           -1,  340,   -1,  342,  343,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,  362,  363,   10,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  392,  393,  394,  395,   -1,   -1,   44, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
          280,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,    0,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   10,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,  362,  363,   -1,   -1,   -1,  267,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
          280,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  395,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   91, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  280,  281,  282,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   58,   59,   -1,   61,   -1,   63,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   91,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   10,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,  362,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          395,   -1,   -1,   -1,   -1,   -1,   61,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,  395,   -1,   91,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   44,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   58, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,  279,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          395,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,    0,   -1,   -1,   61,   -1,   -1, 
          335,  336,   -1,   -1,   10,   -1,   -1,  342,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   58,   59,   -1,   61,   -1,   63,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   91,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,   -1,  342,   10,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,    0,  361,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  375, 
           -1,   44,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   61,  395, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,  305,    0,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,  279,  345,   -1,  347,   -1, 
          349,   44,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  328,  271,  395,   -1,   91,   -1, 
           -1,  335,  336,   -1,   -1,  281,  282,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,  279,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,  395, 
           -1,   91,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,  328,   -1,    0,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   10,   -1,  342, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,  363,   61,   -1, 
           63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   91,  395, 
          333,  334,  335,  336,   -1,  338,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   10,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,  395,   -1,   -1,   -1,   -1,   -1,   61,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,  395,   -1,   91,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,  279,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  395,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,    0,   -1,   -1,   61, 
           -1,   -1,  335,  336,   -1,   -1,   10,   -1,   -1,  342, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   91,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,   -1,  342,   10, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,    0,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  375,   -1,   44,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           61,  395,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   59,   -1,   -1,  305,    0, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,   -1,   -1,  342,   -1,  279,  345,   -1, 
          347,   -1,  349,   44,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  328,  271,  395,   -1, 
           91,   -1,   -1,  335,  336,   -1,  280,  281,  282,   -1, 
          342,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,  362,  363, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,  279,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,  395,   -1,   91,   -1,   -1,   -1,  281,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,  328,   -1,    0, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   10, 
           -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,  363, 
           -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,  395,  333,  334,  335,  336,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,  395,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,  395,   -1,   91, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   44, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,  306,  307,  375,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,  395,   -1,   91,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,    0,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,    0,  361, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,  395,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
          305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   44,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          395,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   -1,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,  395,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,  293,  294,  295,  296,  297,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   44,  271,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,  281,  282,   -1,   -1,   59,   -1,   -1,   -1, 
           63,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,  395,  333,  334,  335,  336,   -1,    0, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   10, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,  395,   -1,   59,   -1, 
           -1,   -1,   63,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,    0,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   10,  363,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,  395, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,  395,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
            0,   -1,  333,  334,  335,  336,   -1,   -1,  339,   -1, 
           10,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,  395,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  293, 
          294,  295,  296,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,  342,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,  305,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,  395,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   58,   59, 
           -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,  375,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,  395,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   58,   59,  333,  334,   -1,   63, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  395,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   58,   59,  305,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,    0,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  395,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   44,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   59,   -1,   61,   -1,   63,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   91,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   59,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,  375,  267,  268,  269,   -1,  271,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   10,   -1, 
           -1,  395,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,    0,  329,  330,   -1,   59,  333,  334, 
           -1,   -1,   -1,   10,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
          375,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   59,  271,   61,   -1,   63,   -1,   -1,   -1, 
          395,   -1,  280,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,    0,   -1,  333,  334,  335,  336,  262, 
          263,  264,   -1,   10,  342,  268,  269,   -1,  271,   -1, 
           -1,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,  362,  363,   -1,   -1,   -1,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   44,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,  395,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          342,  262,  263,  264,   -1,   91,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   10,   -1,  290, 
          291,   -1,  293,  294,  295,  296,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  395,   -1,   -1,  262,  263,  264,   -1, 
           -1,   44,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  280,   -1,   59,   -1,   61,   -1, 
           63,  342,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,    0,   -1,  333,  334,  335, 
          336,   -1,   -1,   -1,  395,   10,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,  362,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   59,  271,   61,   -1,   63,  395, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,  395, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,   -1,   -1,   -1,  342, 
           -1,   -1,   44,   -1,   -1,   -1,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   59,  361,   61, 
          363,   63,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,  395,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1, 
           44,   -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   59,  361,   61,  363,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   91,  326,  327, 
          395,   -1,   -1,  331,  332,  333,  334,   -1,   -1,    0, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   10, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   59,  271, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,    0, 
           -1,  333,  334,  335,  336,   -1,  338,   -1,   -1,   10, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   44,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,  395,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,  395,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,   -1,   -1, 
           -1,  342,   -1,   -1,   44,   -1,   -1,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   59, 
          361,   61,  363,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   91,   -1,   -1,  395,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,   -1,   -1, 
           -1,  342,   -1,   -1,   44,   -1,   -1,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   59, 
          361,   61,  363,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   91,  326,  327,  395,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,    0,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   10,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   44,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,   -1, 
           -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
            0,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,  395,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,   -1, 
           -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,  395,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   44,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   59,  361,   61,  363,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   91,   -1,   -1,  395,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,    0, 
           59,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,   -1,   -1,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   44,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,   -1,   59,  359, 
           61,  361,   63,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,  395,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  262,  263,  264,  342,   -1,  267,  268, 
          269,   -1,  271,  349,    0,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   10,  361,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  395, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,  395,   -1,   -1,   -1, 
           -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,    0,  363,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   10,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  395,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
          305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   10,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   44,  351,   -1,   -1,   -1, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           59,   -1,   61,   -1,   63,   -1,  262,  263,  264,   -1, 
          375,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
          395,   -1,   91,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,   -1,   44,  351,   -1,   -1,   -1,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268, 
          269,   44,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,  290,  291,  342,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,  395,   -1,   -1,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   10,   -1,   -1,  395,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   58,   59,  333,  334,   -1,   63,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359, 
           -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
            0,   -1,   -1,   -1,   -1,  395,   -1,   -1,  281,  282, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   58,   59, 
          333,  334,   -1,   63,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,  357,  358,  359,   -1,  361,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   44,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   58,   59,   -1, 
           -1,   -1,   63,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,    0,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   10,   -1,   -1,   -1, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           44,  271,   -1,   -1,   -1,   -1,   -1,   -1,  395,   -1, 
           -1,  281,  282,   -1,   58,   59,   -1,   -1,   -1,   63, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  357,  358,  359, 
           -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  375,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   10,   -1,   -1,  395,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,   -1, 
          361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,    0, 
           -1,   -1,   -1,   -1,  395,   -1,   -1,  281,  282,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  357,  358,   -1,   -1,   -1,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   44,  347, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  357, 
          358,   -1,   58,   59,   -1,  363,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,   -1,  395,   -1,   -1, 
          281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  363,  267,  268,  269,   -1,  271,   -1,    0, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,  281,  282,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,  395,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
          324,  325,   -1,   -1,   -1,  329,  330,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,    0,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   10,   -1,   -1, 
           -1,  375,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,    0,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   10,   -1,   -1,   -1,  375, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,  395, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  363,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
          281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,  395,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
            0,   -1,  363,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           10,   -1,   -1,   -1,  375,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,  395,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,    0,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,  281,  282,   10,   -1, 
           -1,   -1,  375,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  324, 
          325,   -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,    0,  363,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   10,   -1,   -1, 
          375,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
          395,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,   -1,  262,  263,  264,   -1,    0,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,  363,   10,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,  395,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,  375,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,  395,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           44,   -1,   -1,  375,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,  395,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   10,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   44,  375,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   58,   59,   -1,   -1,   -1, 
           -1,  305,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,    0,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   10,   -1,  339,   -1,   -1,  342,  281, 
          282,  345,   -1,  347,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,  363, 
            0,   -1,   -1,  305,   -1,   -1,   -1,   44,   -1,   -1, 
           10,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   59, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,  305,   -1,  395,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   59,  271,  363, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           10,  375,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  395,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,    0,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   10,   -1,  342, 
           -1,   -1,  345,   -1,  347,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          363,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           59,   -1,  375,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  262,  263,  264,   -1,   59,  267,  268,  269, 
           -1,  271,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  395,  271, 
           -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  395,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          342,  281,  282,  345,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,  363,   -1,  262,  263,  264,   10,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  281,  282,   -1,  268,  269,   -1,  271,   -1, 
           -1,  290,  291,  395,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,  342,   -1,   -1,  345,   -1,   -1,   -1,   -1, 
          293,  294,  295,  296,  297,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,  345,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  395,   -1,   -1,   -1,  342, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1, 
          363,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  395,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   10,   -1,  292,   -1, 
           -1,   -1,  395,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   59,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   91,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
          394,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   10,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   59,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,  362,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   91,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   10,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   59,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,  362,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   91,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   10,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   59,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,  362,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   91,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   10,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   59,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   10,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   59,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   10,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   59,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   10,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   59,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,  362,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   10,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392, 
          393,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   10,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  392, 
          393,  264,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   10,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392, 
          393,   -1,  256,  257,  258,  259,  260,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   10,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,  257,  258,  259,  260,  261,  392,  393, 
           -1,  265,  266,   -1,   10,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,  342,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,  392,  393, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   44,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,  392,  393,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   44,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,  392,  393,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,   -1,   -1,  257,  258, 
          259,  260,  261,   -1,  392,  393,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,  257,  258,  259, 
          260,  261,   -1,  392,  393,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,  256,  257,  258,  259,  260, 
          261,   -1,  392,  393,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,  256,  257,  258,  259,  260,  261, 
           -1,  392,  393,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,  256,  257,  258,  259,  260,  261,   -1, 
          392,  393,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,  392, 
          393,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  392,  393, 
          394,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  392,  393, 
          394,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  392,  393, 
          394,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  392,  393, 
          394,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,   -1,   -1,  350,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  392,  393, 
          394,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  392,  393, 
          394,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   -1,  257,  258,  259,  260,  261,  392,  393, 
          394,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,  257,  258,  259,  260,  261,   -1,  392,  393, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,  392,  393,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,  341,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,  392,  393,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,  392,  393,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,  392,  393,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  392,  393,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,  392,  393,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,  392,  393,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,  341, 
           -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
          392,  393,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,  392, 
          393,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,  392,  393, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,  392,  393,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,  392,  393,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,  392,  393,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,  392,  393,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  392,  393,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,  392,  393,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,  392,  393,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
          392,  393,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392, 
          393,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  279,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,   -1,   -1,  364,  365, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,   -1,   -1,  364,  365,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,   -1,  364,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,  279,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          306,  307,  364,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  306,  307,  364,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  306,  307,  364,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  306,  307, 
          364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  306,  307,  364,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          306,  307,  364,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,   -1,   -1,  364, 
      };
   }

}
