/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jruby.RubyInstanceConfig;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.ExplicitVertexID;
import org.jruby.ir.IRManager;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.Site;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.listeners.InstructionsListener;
import org.jruby.ir.listeners.InstructionsListenerDecorator;
import org.jruby.ir.operands.Label;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class BasicBlock
implements ExplicitVertexID,
Comparable {
    private int id;
    private CFG cfg;
    private Label label;
    private List<Instr> instrs;
    private boolean isRescueEntry;

    public BasicBlock(CFG cfg, Label label2) {
        this.label = label2;
        this.cfg = cfg;
        this.id = cfg.getNextBBID();
        this.isRescueEntry = false;
        assert (label2 != null) : "label is null";
        this.initInstrs();
    }

    private void initInstrs() {
        IRManager irManager;
        InstructionsListener listener;
        this.instrs = new ArrayList<Instr>();
        if ((RubyInstanceConfig.IR_COMPILER_DEBUG || RubyInstanceConfig.IR_DEBUG_IGV != null) && (listener = (irManager = this.cfg.getManager()).getInstructionsListener()) != null) {
            this.instrs = new InstructionsListenerDecorator(this, this.instrs, listener);
        }
    }

    public int getID() {
        return this.id;
    }

    public Label getLabel() {
        return this.label;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean canRaiseExceptions() {
        for (Instr i2 : this.getInstrs()) {
            if (!i2.canRaiseException()) continue;
            return true;
        }
        return false;
    }

    public BasicBlock exceptionBB() {
        return this.cfg.getRescuerBBFor(this);
    }

    public boolean isEntryBB() {
        return this.cfg.getEntryBB() == this;
    }

    public boolean isExitBB() {
        return this.cfg.getExitBB() == this;
    }

    public void markRescueEntryBB() {
        this.isRescueEntry = true;
    }

    public boolean isRescueEntry() {
        return this.isRescueEntry;
    }

    public void replaceInstrs(List<Instr> instrs) {
        this.instrs = instrs;
    }

    public void addInstr(Instr i2) {
        this.instrs.add(i2);
    }

    public void insertInstr(Instr i2) {
        this.instrs.add(0, i2);
    }

    public void insertInstr(int index2, Instr i2) {
        this.instrs.add(index2, i2);
    }

    public List<Instr> getInstrs() {
        return this.instrs;
    }

    public Instr getLastInstr() {
        int n = this.instrs.size();
        return n == 0 ? null : this.instrs.get(n - 1);
    }

    public boolean removeInstr(Instr i2) {
        return i2 != null && this.instrs.remove(i2);
    }

    public boolean isEmpty() {
        return this.instrs.isEmpty();
    }

    public Site siteOf(long callsiteId) {
        for (Instr instr : this.instrs) {
            if (!(instr instanceof Site) || ((Site)((Object)instr)).getCallSiteId() != callsiteId) continue;
            return (Site)((Object)instr);
        }
        throw new RuntimeException("siteOf asked for non-existent callsiteId: " + callsiteId);
    }

    public BasicBlock splitAtInstruction(Site splitPoint, Label newLabel, boolean includeSplitPointInstr) {
        BasicBlock newBB = new BasicBlock(this.cfg, newLabel);
        int idx = 0;
        int numInstrs = this.instrs.size();
        boolean found = false;
        for (Instr i2 : this.instrs) {
            if (i2 instanceof Site && ((Site)((Object)i2)).getCallSiteId() == splitPoint.getCallSiteId()) {
                found = true;
            }
            if (found) {
                if (!includeSplitPointInstr && i2 instanceof Site && ((Site)((Object)i2)).getCallSiteId() == splitPoint.getCallSiteId()) continue;
                newBB.addInstr(i2);
                continue;
            }
            ++idx;
        }
        if (!found) {
            throw new RuntimeException("Cound not find split point: " + splitPoint);
        }
        for (int j = 0; j < numInstrs - idx; ++j) {
            this.instrs.remove(idx);
        }
        return newBB;
    }

    public void swallowBB(BasicBlock foodBB) {
        this.instrs.addAll(foodBB.instrs);
    }

    public BasicBlock clone(CloneInfo info, CFG newCFG) {
        BasicBlock newBB = new BasicBlock(newCFG, info.getRenamedLabel(this.label));
        boolean isClosureClone = info instanceof InlineCloneInfo && ((InlineCloneInfo)info).isClosure();
        for (Instr instr : this.instrs) {
            Instr newInstr = instr.clone(info);
            if (instr instanceof CallBase && ((CallBase)instr).inliningBlocked()) {
                ((CallBase)newInstr).blockInlining();
            }
            if (newInstr == null) continue;
            newBB.addInstr(newInstr);
            if (!isClosureClone || !(newInstr instanceof YieldInstr)) continue;
            ((InlineCloneInfo)info).recordYieldSite(newBB, (YieldInstr)newInstr);
        }
        return newBB;
    }

    public void cloneInstrs(SimpleCloneInfo ii) {
        if (!this.isEmpty()) {
            List<Instr> oldInstrs = this.instrs;
            this.initInstrs();
            for (Instr i2 : oldInstrs) {
                this.instrs.add(i2.clone(ii));
            }
        }
        this.label = ii.getRenamedLabel(this.label);
    }

    public BasicBlock cloneForInlining(InlineCloneInfo ii) {
        BasicBlock clonedBB = ii.getOrCreateRenamedBB(this);
        for (Instr i2 : this.getInstrs()) {
            Instr clonedInstr = i2.clone(ii);
            if (clonedInstr == null) continue;
            clonedBB.addInstr(clonedInstr);
            if (clonedInstr instanceof YieldInstr) {
                ii.recordYieldSite(clonedBB, (YieldInstr)clonedInstr);
                continue;
            }
            if (!(i2 instanceof NonlocalReturnInstr) || !(clonedInstr instanceof CopyInstr)) continue;
            clonedBB.addInstr(new JumpInstr(ii.getHostScope().getCFG().getExitBB().getLabel()));
        }
        return clonedBB;
    }

    public int compareTo(Object o) {
        BasicBlock other = (BasicBlock)o;
        if (this.id == other.id) {
            return 0;
        }
        if (this.id < other.id) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return "BB [" + this.id + ':' + this.label + ']';
    }

    public String toStringInstrs() {
        StringBuilder buf = new StringBuilder(this.toString());
        Collection<Edge<BasicBlock>> outs = this.cfg.getOutgoingEdges(this);
        if (!outs.isEmpty()) {
            for (Edge<BasicBlock> edge : outs) {
                buf.append(" -" + edge.getType() + "->" + edge.getDestination().getID());
            }
        }
        buf.append('\n');
        for (Instr instr : this.getInstrs()) {
            buf.append('\t').append(instr).append('\n');
        }
        return buf.toString();
    }
}

